/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.contexts;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.ModelControlException;
import com.sun.apoc.manager.Toolbox2;
import com.sun.web.ui.model.CCActionTableModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class ManagerTableModel
extends CCActionTableModel
implements RequestParticipant {
    public static final String CHILD_COLUMN = "Col";
    public static final String CHILD_STATIC_TEXT = "Text";
    public static final String CHILD_NAME_COLUMN = "NameColumn";
    public static final String CHILD_NAME_TEXT = "NameText";
    public static final String CHILD_NAME_HREF = "NameHref";
    public static final String CHILD_TYPE_COLUMN = "TypeColumn";
    public static final String CHILD_TYPE_TEXT = "TypeText";
    public static final String CHILD_ORGLOC_COLUMN = "OrgLocationColumn";
    public static final String CHILD_ORGLOC_TEXT = "OrgLocationText";
    public static final String CHILD_PROLOC_COLUMN = "ProfileLocationColumn";
    public static final String CHILD_PROLOC_TEXT = "ProfileLocationText";
    public static final String CONFIG_FILE_LOCATION = System.getProperty("file.separator") + "etc" + System.getProperty("file.separator") + "opt" + System.getProperty("file.separator") + "SUNWapmcg" + System.getProperty("file.separator");
    private RequestContext m_requestContext;
    private HashMap m_backendPropertiesMap = new HashMap();
    private HashMap m_backendFilesMap = new HashMap();
    private Properties m_backendProperties = new Properties();

    public void setRequestContext(RequestContext requestContext) {
        this.m_requestContext = requestContext;
        this.setActionValue(CHILD_NAME_COLUMN, "APOC.contexts.column.name");
        this.setActionValue(CHILD_TYPE_COLUMN, "APOC.contexts.column.type");
        this.setActionValue(CHILD_ORGLOC_COLUMN, "APOC.contexts.column.locorg");
        this.setActionValue(CHILD_PROLOC_COLUMN, "APOC.contexts.column.locpro");
        this.setMaxRows(10);
    }

    public void retrieve() throws ModelControlException {
        this.clear();
        try {
            File file = new File(CONFIG_FILE_LOCATION);
            if (file.exists()) {
                FilenameFilter filenameFilter = new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".properties");
                    }
                };
                File[] fileArray = file.listFiles(filenameFilter);
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (!file2.canRead()) continue;
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    fileInputStream.close();
                    if (properties.getProperty("Backend") == null) continue;
                    String string = properties.getProperty("Backend");
                    String string2 = properties.getProperty("PROVIDER_URL");
                    String string3 = string2.substring(0, string2.indexOf(":"));
                    String string4 = properties.getProperty("PROFILE_PROVIDER_URL");
                    String string5 = string3;
                    if (string4 == null) {
                        string4 = string2;
                    } else {
                        string4 = string4.substring(0, string4.lastIndexOf("/"));
                        string5 = string4.substring(0, string4.indexOf(":"));
                    }
                    if (string3.startsWith("file")) {
                        HashMap<String, String[]> hashMap = (HashMap<String, String[]>)RequestManager.getSession().getAttribute("AuthorizedContexts");
                        if (hashMap == null) {
                            hashMap = new HashMap<String, String[]>();
                            RequestManager.getRequestContext().getRequest().getSession(true).setAttribute("AuthorizedContexts", hashMap);
                        }
                        if (!hashMap.containsKey(string)) {
                            String[] stringArray = new String[]{"", ""};
                            hashMap.put(string, stringArray);
                        }
                    }
                    if (!string3.equals(string5)) {
                        string3 = "APOC.contexts.hybrid.text";
                    }
                    this.appendRow();
                    this.setValue(CHILD_NAME_TEXT, string);
                    this.setValue(CHILD_NAME_HREF, string);
                    this.setValue(CHILD_TYPE_TEXT, string3);
                    this.setValue(CHILD_ORGLOC_TEXT, string2);
                    this.setValue(CHILD_PROLOC_TEXT, string4);
                    this.m_backendPropertiesMap.put(string, properties);
                    this.m_backendFilesMap.put(string, fileArray[i].getAbsolutePath());
                }
            }
        }
        catch (Exception exception) {
            throw new ModelControlException((Throwable)exception);
        }
    }

    public void delete() throws ModelControlException {
        try {
            LinkedList linkedList = new LinkedList();
            int n = this.getLocation();
            for (int i = 0; i < this.getNumRows(); ++i) {
                Object object;
                if (!this.isRowSelected(i)) continue;
                this.setLocation(i);
                String string = (String)this.getValue(CHILD_NAME_TEXT);
                if (!this.m_backendPropertiesMap.isEmpty()) {
                    File file;
                    object = (String)this.m_backendFilesMap.get(string);
                    if (object != null && (file = new File((String)object)).exists()) {
                        file.delete();
                    }
                    this.m_backendPropertiesMap.remove(string);
                    this.m_backendFilesMap.remove(string);
                }
                if ((object = (HashMap)RequestManager.getSession().getAttribute("AuthorizedContexts")) != null && ((HashMap)object).containsKey(string)) {
                    ((HashMap)object).remove(string);
                }
                this.setRowSelected(false);
            }
            this.setLocation(n);
        }
        catch (Exception exception) {
            throw new ModelControlException((Throwable)exception);
        }
    }

    public void rename(String string) throws ModelControlException {
        try {
            LinkedList linkedList = new LinkedList();
            int n = this.getLocation();
            for (int i = 0; i < this.getNumRows(); ++i) {
                Object object;
                if (!this.isRowSelected(i)) continue;
                this.setLocation(i);
                String string2 = (String)this.getValue(CHILD_NAME_TEXT);
                if (!this.m_backendPropertiesMap.isEmpty()) {
                    object = (String)this.m_backendFilesMap.get(string2);
                    Properties properties = (Properties)this.m_backendPropertiesMap.get(string2);
                    properties.setProperty("Backend", string);
                    this.m_backendPropertiesMap.put(string, properties);
                    this.m_backendPropertiesMap.remove(string2);
                    this.m_backendFilesMap.put(string, object);
                    this.m_backendFilesMap.remove(string2);
                    if (object != null) {
                        File file = new File((String)object);
                        if (file.exists()) {
                            file.delete();
                        }
                        File file2 = new File((String)object);
                        FileOutputStream fileOutputStream = new FileOutputStream(file2);
                        properties.store(fileOutputStream, "");
                    }
                }
                if ((object = (HashMap)RequestManager.getSession().getAttribute("AuthorizedContexts")) != null && ((HashMap)object).containsKey(string2)) {
                    ((HashMap)object).put(string, ((HashMap)object).get(string2));
                    ((HashMap)object).remove(string2);
                }
                this.setRowSelected(false);
                break;
            }
            this.setLocation(n);
        }
        catch (Exception exception) {
            throw new ModelControlException((Throwable)exception);
        }
    }

    private void migrateConfigFile() throws ModelControlException {
        RequestContext requestContext = RequestManager.getRequestContext();
        File file = (File)requestContext.getServletContext().getAttribute("javax.servlet.context.tempdir");
        String string = file.getAbsolutePath() + System.getProperty("file.separator") + "backends.cfg";
        File file2 = new File(string);
        try {
            if (file2.exists()) {
                String string2;
                String string3;
                Serializable serializable;
                Object object;
                Enumeration<Object> enumeration;
                FileInputStream fileInputStream = new FileInputStream(string);
                this.m_backendProperties.load(fileInputStream);
                fileInputStream.close();
                Iterator iterator = Toolbox2.getLegacyBackendNames();
                ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
                while (iterator.hasNext()) {
                    enumeration = this.m_backendProperties.keys();
                    object = null;
                    serializable = new Properties();
                    string3 = (String)iterator.next();
                    while (enumeration.hasMoreElements()) {
                        string2 = (String)enumeration.nextElement();
                        if (string2.indexOf("_") != -1 || !this.m_backendProperties.get(string2).equals(string3)) continue;
                        object = string2;
                        break;
                    }
                    ((Properties)serializable).put("Backend", string3);
                    if (this.m_backendProperties.containsKey("DisplayThreshold")) {
                        ((Properties)serializable).put("DisplayThreshold", this.m_backendProperties.getProperty("DisplayThreshold"));
                    }
                    if (this.m_backendProperties.containsKey("DisplayGrace")) {
                        ((Properties)serializable).put("DisplayGrace", this.m_backendProperties.getProperty("DisplayGrace"));
                    }
                    if (this.m_backendProperties.containsKey("ShowAssignedProfiles")) {
                        ((Properties)serializable).put("ShowAssignedProfiles", this.m_backendProperties.getProperty("ShowAssignedProfiles"));
                    }
                    if (this.m_backendProperties.containsKey("SmartTurner")) {
                        ((Properties)serializable).put("SmartTurner", this.m_backendProperties.getProperty("SmartTurner"));
                    }
                    enumeration = this.m_backendProperties.keys();
                    while (enumeration.hasMoreElements()) {
                        string2 = (String)enumeration.nextElement();
                        if (string2.indexOf((String)object + "_") == -1) continue;
                        ((Properties)serializable).put(string2.substring(((String)object).length() + 1), this.m_backendProperties.getProperty(string2));
                    }
                    arrayList.add(serializable);
                }
                enumeration = arrayList.iterator();
                while (enumeration.hasNext()) {
                    object = (Properties)enumeration.next();
                    serializable = new File(CONFIG_FILE_LOCATION + "backend1.properties");
                    string3 = "backend";
                    string2 = ".properties";
                    int n = 1;
                    while (((File)serializable).exists()) {
                        serializable = new File(CONFIG_FILE_LOCATION + string3 + Integer.toString(++n) + string2);
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream((File)serializable);
                    ((Properties)object).store(fileOutputStream, "");
                }
                file2.delete();
            }
        }
        catch (Exception exception) {
            throw new ModelControlException((Throwable)exception);
        }
    }
}

