/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.entities;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.sun.apoc.manager.Toolbox2;
import com.sun.apoc.manager.contexts.ManagerTableModel;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Host;
import com.sun.apoc.spi.entities.Node;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.entities.Role;
import com.sun.apoc.spi.entities.User;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTreeModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.TreeSet;

public class NavigationModel
extends CCTreeModel {
    public static final int NODE_ROOT = 0;
    public static final int NODE_ROOT_ORG = 1;
    public static final int NODE_ROOT_DOMAIN = 2;
    public static final int NODE_SUBTREE_ROOT = 3;
    public static final String DISPLAY_THRESHOLD_KEY = "DisplayThreshold";
    public static final String DISPLAY_GRACE_KEY = "DisplayGrace";
    public static final String DISPLAY_SHOW_ASSIGNED = "ShowAssignedProfiles";
    public static final String DISPLAY_SMART_TURNER = "SmartTurner";
    private PolicyMgr m_policyManager;
    private boolean m_bFilterLeaves = false;
    private boolean m_bSparseBrowsing = true;
    private HashSet m_syncedNodesDirs = new HashSet();
    private HashSet m_syncedNodesLeaves = new HashSet();
    private int m_nIdCounter = 10;
    private int m_nDisplayThreshold = 10;
    private int m_nDisplayGrace = 15;
    private boolean m_bShowAssigned = false;
    private boolean m_bSmartTurner = false;
    private LinkedList m_dirtyNodeIds = new LinkedList();

    public NavigationModel() throws ModelControlException {
        this.initTree(null, null);
        PolicyMgr policyMgr = Toolbox2.getPolicyManager();
        if (policyMgr != null) {
            try {
                String string = (String)policyMgr.getEnvironment().get("PolicyManagerName");
                File file = new File(ManagerTableModel.CONFIG_FILE_LOCATION);
                if (file.exists()) {
                    FilenameFilter filenameFilter = new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            return string.endsWith(".properties");
                        }
                    };
                    File[] fileArray = file.listFiles(filenameFilter);
                    for (int i = 0; i < fileArray.length; ++i) {
                        String string2;
                        File file2 = fileArray[i];
                        if (!file2.canRead()) continue;
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        Properties properties = new Properties();
                        properties.load(fileInputStream);
                        fileInputStream.close();
                        if (properties.getProperty("Backend") == null || !(string2 = properties.getProperty("Backend")).equals(string)) continue;
                        try {
                            if (properties.containsKey(DISPLAY_THRESHOLD_KEY)) {
                                this.m_nDisplayThreshold = Integer.parseInt(properties.getProperty(DISPLAY_THRESHOLD_KEY));
                            }
                            if (properties.containsKey(DISPLAY_GRACE_KEY)) {
                                this.m_nDisplayGrace = Integer.parseInt(properties.getProperty(DISPLAY_GRACE_KEY));
                            }
                            if (properties.containsKey(DISPLAY_SHOW_ASSIGNED)) {
                                this.m_bShowAssigned = Boolean.valueOf(properties.getProperty(DISPLAY_SHOW_ASSIGNED));
                            }
                            if (!properties.containsKey(DISPLAY_SMART_TURNER)) continue;
                            this.m_bSmartTurner = Boolean.valueOf(properties.getProperty(DISPLAY_SMART_TURNER));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            CCDebug.trace3((String)numberFormatException.toString());
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new ModelControlException((Throwable)exception);
            }
        }
    }

    public void initTree(String string, String string2) throws ModelControlException {
        try {
            HashMap hashMap = (HashMap)RequestManager.getSession().getAttribute("SyncEnvironment");
            String string3 = hashMap == null ? null : (String)hashMap.get("LeftContextName");
            String string4 = hashMap == null ? null : (String)hashMap.get("RightContextName");
            PolicyMgr policyMgr = (PolicyMgr)RequestManager.getRequest().getSession(false).getAttribute("TargetPolicyMgr");
            String string5 = null;
            if (policyMgr != null) {
                string5 = (String)policyMgr.getEnvironment().get("PolicyManagerName");
            }
            this.m_policyManager = string != null && string.equals(string3) ? (PolicyMgr)hashMap.get("LeftContext") : (string != null && string.equals(string4) ? (PolicyMgr)hashMap.get("RightContext") : (string != null && string.equals(string5) ? (PolicyMgr)RequestManager.getRequest().getSession(false).getAttribute("TargetPolicyMgr") : Toolbox2.getPolicyManager()));
            if (this.m_policyManager == null) {
                return;
            }
            this.m_syncedNodesDirs.clear();
            this.m_syncedNodesLeaves.clear();
            this.removeAllNodes();
            this.setType("1");
            CCNavNode cCNavNode = null;
            if (string2 == null || string2.length() == 0 || this.m_policyManager.getRootDomain().getId().equals(string2)) {
                cCNavNode = new CCNavNode(2);
                cCNavNode.setLabel(Toolbox2.getI18n("APOC.navigation.domains"));
                cCNavNode.setStatus(Toolbox2.getI18n("APOC.navigation.domains.help"));
                cCNavNode.setTooltip(Toolbox2.getI18n("APOC.navigation.domains.help"));
                cCNavNode.setValue(this.m_policyManager.getRootDomain().getId());
                cCNavNode.setValue("ENTITY", (Object)this.m_policyManager.getRootDomain());
                this.addNode((CCNavNodeInterface)cCNavNode);
                this.setSelectedNode(2);
            }
            if (string2 == null || string2.length() == 0 || this.m_policyManager.getRootOrganization().getId().equals(string2)) {
                cCNavNode = new CCNavNode(1);
                cCNavNode.setLabel(Toolbox2.getI18n("APOC.navigation.organizations"));
                cCNavNode.setStatus(Toolbox2.getI18n("APOC.navigation.organizations.help"));
                cCNavNode.setTooltip(Toolbox2.getI18n("APOC.navigation.organizations.help"));
                cCNavNode.setValue(this.m_policyManager.getRootOrganization().getId());
                cCNavNode.setValue("ENTITY", (Object)this.m_policyManager.getRootOrganization());
                this.addNode((CCNavNodeInterface)cCNavNode);
                if (this.m_policyManager.getRootOrganization().getId().equals(string2)) {
                    this.setSelectedNode(1);
                }
            }
            if (string2 != null && string2.length() > 0 && !this.m_policyManager.getRootDomain().getId().equals(string2) && !this.m_policyManager.getRootOrganization().getId().equals(string2)) {
                cCNavNode = new CCNavNode(3);
                cCNavNode.setLabel(this.m_policyManager.getEntity(string2).getDisplayName());
                cCNavNode.setValue(this.m_policyManager.getEntity(string2).getId());
                cCNavNode.setValue("ENTITY", (Object)this.m_policyManager.getEntity(string2));
                this.addNode((CCNavNodeInterface)cCNavNode);
                this.setSelectedNode(3);
            }
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
    }

    public void expandRoot() throws ModelControlException {
        this.retrieve(1);
        this.retrieve(2);
        this.getNodeById(1).setExpanded(true);
        this.getNodeById(2).setExpanded(true);
    }

    public void setSparseBrowsing(boolean bl) {
        this.m_bSparseBrowsing = bl;
    }

    public void setAssignedState(Entity entity, boolean bl) {
        CCNavNodeInterface cCNavNodeInterface = this.findChildByValue(this.getNodeById(1), entity.getId(), true);
        if (cCNavNodeInterface == null) {
            cCNavNodeInterface = this.findChildByValue(this.getNodeById(2), entity.getId(), true);
        }
        if (cCNavNodeInterface != null && (Boolean)cCNavNodeInterface.getValue("ASSIGNED") != bl) {
            this.setTypeSpecifics(cCNavNodeInterface, entity, bl && this.m_bShowAssigned);
            if (cCNavNodeInterface.getVisible()) {
                this.m_dirtyNodeIds.add(new Integer(cCNavNodeInterface.getId()));
            }
        }
    }

    public boolean getAssignedState(int n) {
        return this.m_bShowAssigned ? (Boolean)this.getNodeById(n).getValue("ASSIGNED") : false;
    }

    public Iterator getDirtyNodeIds() {
        return this.m_dirtyNodeIds.iterator();
    }

    public void clearDirtyNodeIds() {
        this.m_dirtyNodeIds.clear();
    }

    public boolean isLeavesFiltered() {
        return this.m_bFilterLeaves;
    }

    public void filterLeaves(boolean bl) {
        this.m_bFilterLeaves = bl;
    }

    public String getViewedNode() {
        return this.getSelectedNode().getValue();
    }

    public Object getStoredValue(int n) {
        return this.getNodeById(n).getValue("ENTITY");
    }

    public String getStoredEntityId(int n) {
        Entity entity = (Entity)this.getNodeById(n).getValue("ENTITY");
        return entity.getId();
    }

    public CCNavNodeInterface getNode(Entity entity) {
        CCNavNodeInterface cCNavNodeInterface = this.getNodeById(1);
        if (Toolbox2.isDomainSubtype(entity.getId())) {
            cCNavNodeInterface = this.getNodeById(2);
        }
        CCNavNodeInterface cCNavNodeInterface2 = this.findChildByValue(cCNavNodeInterface, entity.getId(), true);
        return cCNavNodeInterface2;
    }

    public String getNodeType(CCNavNodeInterface cCNavNodeInterface) {
        String string = "";
        Entity entity = (Entity)cCNavNodeInterface.getValue("ENTITY");
        if (entity != null) {
            if (entity instanceof Organization || entity instanceof User || entity instanceof Role) {
                string = "ORG";
            } else if (entity instanceof Domain || entity instanceof Host) {
                string = "DOMAIN";
            }
        }
        return string;
    }

    public void setTypeSpecifics(CCNavNodeInterface cCNavNodeInterface, Entity entity, boolean bl) {
        if (cCNavNodeInterface.getVisible()) {
            String string = "";
            String string2 = "";
            if (entity instanceof Organization) {
                if (bl) {
                    string = "../images/orgAssigned.gif";
                    string2 = Toolbox2.getI18n("APOC.navigation.organization.with");
                } else {
                    string = "../images/org.gif";
                    string2 = Toolbox2.getI18n("APOC.navigation.organization");
                }
            } else if (entity instanceof User) {
                if (bl) {
                    string = "../images/userAssigned.gif";
                    string2 = Toolbox2.getI18n("APOC.navigation.user.with");
                } else {
                    string = "../images/user.gif";
                    string2 = Toolbox2.getI18n("APOC.navigation.user");
                }
            } else if (entity instanceof Role) {
                if (bl) {
                    string = "../images/roleAssigned.gif";
                    string2 = Toolbox2.getI18n("APOC.navigation.role.with");
                } else {
                    string = "../images/role.gif";
                    string2 = Toolbox2.getI18n("APOC.navigation.role");
                }
            } else if (entity instanceof Domain) {
                if (bl) {
                    string = "../images/domainAssigned.gif";
                    string2 = Toolbox2.getI18n("APOC.navigation.domain.with");
                } else {
                    string = "../images/domain.gif";
                    string2 = Toolbox2.getI18n("APOC.navigation.domain");
                }
            } else if (entity instanceof Host) {
                if (bl) {
                    string = "../images/hostAssigned.gif";
                    string2 = Toolbox2.getI18n("APOC.navigation.host.with");
                } else {
                    string = "../images/host.gif";
                    string2 = Toolbox2.getI18n("APOC.navigation.host");
                }
            }
            cCNavNodeInterface.setValue("ASSIGNED", (Object)new Boolean(bl));
            cCNavNodeInterface.setImage(string);
            cCNavNodeInterface.setTooltip(string2);
        }
    }

    public int retrieve(boolean bl) throws ModelControlException {
        try {
            if (bl != this.m_bFilterLeaves) {
                this.m_bFilterLeaves = bl;
                Iterator iterator = this.getNodes().iterator();
                while (iterator.hasNext()) {
                    CCNavNodeInterface cCNavNodeInterface = (CCNavNodeInterface)iterator.next();
                    if (!this.m_bFilterLeaves) {
                        this.addLeaves(cCNavNodeInterface);
                        continue;
                    }
                    this.removeLeaves(cCNavNodeInterface);
                }
            }
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
        return this.getSelectedNode().getId();
    }

    public int retrieve(String string) throws ModelControlException {
        CCNavNodeInterface cCNavNodeInterface;
        CCNavNodeInterface cCNavNodeInterface2 = cCNavNodeInterface = Toolbox2.isDomainSubtype(string) ? this.getNodeById(2) : this.getNodeById(1);
        if (cCNavNodeInterface == null) {
            cCNavNodeInterface = this.getNodeById(3);
        }
        CCNavNodeInterface cCNavNodeInterface3 = null;
        try {
            ListIterator listIterator = Toolbox2.getParentPath(string);
            Entity entity = null;
            if (listIterator.hasNext()) {
                entity = (Entity)listIterator.next();
            }
            while (listIterator.hasNext()) {
                entity = (Entity)listIterator.next();
                if (cCNavNodeInterface.getNumChildren() == 0) {
                    this.retrieve(cCNavNodeInterface.getId());
                }
                if ((cCNavNodeInterface3 = this.findChildByValue(cCNavNodeInterface, entity.getId(), false)) == null) {
                    cCNavNodeInterface = this.addChild(cCNavNodeInterface, entity);
                    continue;
                }
                cCNavNodeInterface = cCNavNodeInterface3;
            }
            if (cCNavNodeInterface.getNumChildren() == 0) {
                this.retrieve(cCNavNodeInterface.getId());
            }
            cCNavNodeInterface = (cCNavNodeInterface3 = this.findChildByValue(cCNavNodeInterface, string, false)) == null ? this.addChild(cCNavNodeInterface, this.m_policyManager.getEntity(string)) : cCNavNodeInterface3;
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
        return cCNavNodeInterface.getId();
    }

    public void retrieve(int n) throws ModelControlException {
        CCNavNodeInterface cCNavNodeInterface = this.getNodeById(n);
        if (this.m_bFilterLeaves && this.m_syncedNodesDirs.contains(cCNavNodeInterface)) {
            return;
        }
        if (!this.m_bFilterLeaves && this.m_syncedNodesDirs.contains(cCNavNodeInterface) && this.m_syncedNodesLeaves.contains(cCNavNodeInterface)) {
            return;
        }
        try {
            Object object = null;
            object = n == 1 ? this.m_policyManager.getRootOrganization() : (n == 2 ? this.m_policyManager.getRootDomain() : this.m_policyManager.getEntity(cCNavNodeInterface.getValue()));
            if (object instanceof User || object instanceof Host) {
                return;
            }
            if (object instanceof Node && !((Node)object).hasChildren()) {
                return;
            }
            this.addChildren(cCNavNodeInterface, ((Node)object).getChildren());
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
        this.m_syncedNodesDirs.add(cCNavNodeInterface);
        if (!this.m_bFilterLeaves) {
            this.m_syncedNodesLeaves.add(cCNavNodeInterface);
        }
    }

    private void addLeaves(CCNavNodeInterface cCNavNodeInterface) throws SPIException {
        Iterator iterator = cCNavNodeInterface.getChildren().iterator();
        while (iterator.hasNext()) {
            this.addLeaves((CCNavNodeInterface)iterator.next());
        }
        if (!this.m_syncedNodesLeaves.contains(cCNavNodeInterface)) {
            Entity entity = (Entity)cCNavNodeInterface.getValue("ENTITY");
            this.addChildren(cCNavNodeInterface, ((Node)entity).getChildren());
            this.m_syncedNodesLeaves.add(cCNavNodeInterface);
        }
    }

    private void addChildren(CCNavNodeInterface cCNavNodeInterface, Iterator iterator) throws SPIException {
        CCNavNodeInterface cCNavNodeInterface2;
        TreeSet treeSet = new TreeSet(new EntityComparator());
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        boolean bl = false;
        int n = 0;
        LinkedList<Entity> linkedList = new LinkedList<Entity>();
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if ((this.m_bFilterLeaves || this.m_syncedNodesLeaves.contains(cCNavNodeInterface)) && !(entity instanceof Node) || this.findChildByValue(cCNavNodeInterface, entity.getId(), false) != null) continue;
            linkedList.add(entity);
            if (!this.m_bSparseBrowsing || ++n + cCNavNodeInterface.getNumChildren() <= this.m_nDisplayGrace) continue;
            bl = true;
            n = this.m_nDisplayThreshold - cCNavNodeInterface.getNumChildren();
            break;
        }
        if (n > 0) {
            cCNavNodeInterface.setAcceptsChildren(true);
        }
        for (int i = 0; i < n; ++i) {
            cCNavNodeInterface2 = this.createChild((Entity)linkedList.get(i));
            cCNavNodeInterface2.setParent(cCNavNodeInterface);
        }
        if (bl) {
            String string = Toolbox2.getI18n("APOC.navigation.ellipsis");
            cCNavNodeInterface2 = new CCNavNode(this.m_nIdCounter++);
            cCNavNodeInterface2.setLabel(string);
            cCNavNodeInterface2.setStatus(string);
            cCNavNodeInterface2.setAcceptsChildren(false);
            cCNavNodeInterface2.setValue("ellipsis");
            cCNavNodeInterface2.setValue("ASSIGNED", (Object)new Boolean(false));
            cCNavNodeInterface2.setImage("../images/search.gif");
            cCNavNodeInterface2.setTooltip(Toolbox2.getI18n("APOC.navigation.openfind"));
            cCNavNodeInterface2.setParent(cCNavNodeInterface);
            cCNavNodeInterface2.setOnClick("var newWindow = window.open('/apoc/manager/EntitiesFindIndex?EntitiesFindIndex.FindHref=" + cCNavNodeInterface2.getId() + "&EntitiesFindIndex.FindModel=" + this.getName() + "', 'findWindow', 'height=800,width=500,top='+((screen.height-800)/2)+',left='+((screen.width-500)/2)+',scrollbars,resizable'); newWindow.focus(); return false;");
            this.m_syncedNodesLeaves.add(cCNavNodeInterface2);
        }
    }

    private CCNavNodeInterface addChild(CCNavNodeInterface cCNavNodeInterface, Entity entity) throws SPIException {
        CCNavNodeInterface cCNavNodeInterface2 = this.createChild(entity);
        List list = cCNavNodeInterface.getChildren();
        LinkedList linkedList = new LinkedList(list);
        Iterator iterator = linkedList.iterator();
        EntityComparator entityComparator = new EntityComparator();
        CCNavNodeInterface cCNavNodeInterface3 = null;
        Entity entity2 = null;
        cCNavNodeInterface.setAcceptsChildren(true);
        while (iterator.hasNext()) {
            cCNavNodeInterface3 = (CCNavNodeInterface)iterator.next();
            entity2 = (Entity)cCNavNodeInterface3.getValue("ENTITY");
            if (cCNavNodeInterface2.getParent() == null && (entity2 == null || entityComparator.compare(entity, entity2) < 0)) {
                cCNavNodeInterface2.setParent(cCNavNodeInterface);
            }
            cCNavNodeInterface3.setParent(cCNavNodeInterface);
        }
        return cCNavNodeInterface2;
    }

    private CCNavNodeInterface createChild(Entity entity) throws SPIException {
        Object object;
        Iterator iterator;
        boolean bl;
        String string = entity.getDisplayName();
        CCNavNode cCNavNode = new CCNavNode(this.m_nIdCounter++);
        boolean bl2 = bl = !this.m_bSmartTurner;
        if (entity instanceof User || entity instanceof Host) {
            bl = false;
        } else if (this.m_bSmartTurner && (iterator = ((Node)entity).getChildren()).hasNext()) {
            if (this.m_bFilterLeaves) {
                while (iterator.hasNext()) {
                    object = (Entity)iterator.next();
                    if (!(object instanceof Node)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
        }
        if (entity instanceof User) {
            string = string + " [" + ((User)entity).getUserId() + "]";
        }
        cCNavNode.setLabel(string);
        cCNavNode.setStatus(string);
        cCNavNode.setAcceptsChildren(bl);
        cCNavNode.setValue("ENTITY", (Object)entity);
        cCNavNode.setValue(entity.getId());
        boolean bl3 = false;
        if (this.m_bShowAssigned) {
            object = entity.getAssignedProfiles();
            bl3 = object.hasNext();
        }
        this.setTypeSpecifics((CCNavNodeInterface)cCNavNode, entity, bl3);
        return cCNavNode;
    }

    private void removeLeaves(CCNavNodeInterface cCNavNodeInterface) throws SPIException {
        Iterator iterator = cCNavNodeInterface.getChildren().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            CCNavNodeInterface cCNavNodeInterface2 = (CCNavNodeInterface)iterator.next();
            Entity entity = (Entity)cCNavNodeInterface2.getValue("ENTITY");
            if (entity instanceof Node) {
                this.removeLeaves(cCNavNodeInterface2);
                continue;
            }
            if (cCNavNodeInterface2.equals(this.getSelectedNode())) {
                this.setSelectedNode(cCNavNodeInterface);
            }
            iterator.remove();
            bl = true;
            if (cCNavNodeInterface.getNumChildren() != 0) continue;
            cCNavNodeInterface.setAcceptsChildren(false);
        }
        if (bl) {
            this.m_syncedNodesLeaves.remove(cCNavNodeInterface);
        }
    }

    private CCNavNodeInterface findChildByValue(CCNavNodeInterface cCNavNodeInterface, String string, boolean bl) {
        Iterator iterator = cCNavNodeInterface.getChildren().iterator();
        while (iterator.hasNext()) {
            CCNavNodeInterface cCNavNodeInterface2 = (CCNavNodeInterface)iterator.next();
            if (cCNavNodeInterface2.getValue().equals(string)) {
                return cCNavNodeInterface2;
            }
            if (!bl || (cCNavNodeInterface2 = this.findChildByValue(cCNavNodeInterface2, string, bl)) == null) continue;
            return cCNavNodeInterface2;
        }
        return null;
    }

    private int getPriority(Object object) {
        if (object instanceof Domain) {
            return 1;
        }
        if (object instanceof Organization) {
            return 2;
        }
        if (object instanceof Role) {
            return 3;
        }
        if (object instanceof Host) {
            return 4;
        }
        if (object instanceof User) {
            return 5;
        }
        return 99;
    }

    class EntityComparator
    implements Comparator {
        EntityComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = -1;
            try {
                int n2 = NavigationModel.this.getPriority(object);
                int n3 = NavigationModel.this.getPriority(object2);
                n = n2 < n3 ? -1 : (n2 == n3 ? ((Entity)object).getDisplayName().compareTo(((Entity)object2).getDisplayName()) : 1);
            }
            catch (SPIException sPIException) {
                throw new RuntimeException(sPIException);
            }
            return n;
        }
    }
}

