/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.entities;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.ModelControlException;
import com.sun.apoc.manager.Toolbox2;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Node;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.entities.Role;
import com.sun.apoc.spi.entities.User;
import com.sun.apoc.spi.ldap.entities.LdapNode;
import com.sun.apoc.spi.ldap.environment.LdapEnvironmentMgr;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class SearchTableModel
extends CCActionTableModel
implements RequestParticipant {
    public static final String CHILD_NAME_TEXT = "NameText";
    public static final String CHILD_NAME_HREF = "NameHref";
    public static final String CHILD_NAME_COLUMN = "NameColumn";
    public static final String CHILD_VIEW_ACTION = "ViewAction";
    public static final String CHILD_USERID_COLUMN = "UserIdColumn";
    public static final String CHILD_USERID_TEXT = "UserIdText";
    public static final String CHILD_TYPE_TEXT = "TypeText";
    public static final String CHILD_TYPE_COLUMN = "TypeColumn";
    public static final String CHILD_PATH_TEXT = "PathText";
    public static final String CHILD_PATH_COLUMN = "PathColumn";
    public static final String CHILD_FILTER_MENU = "FilterMenu";
    private int m_nSearchLimit = 200;
    private PolicyMgr m_policyManager = null;
    private String m_sEntityType = "";

    public void setRequestContext(RequestContext requestContext) {
        this.setActionValue(CHILD_NAME_COLUMN, "APOC.navigation.name");
        this.setActionValue(CHILD_TYPE_COLUMN, "APOC.navigation.type");
        this.setActionValue(CHILD_PATH_COLUMN, "APOC.search.path");
        this.setActionValue(CHILD_USERID_COLUMN, "APOC.search.userid");
    }

    public void retrieve(String string, String string2, String string3, String string4, boolean bl, String string5) throws ModelControlException {
        this.clear();
        this.m_sEntityType = string2;
        if (string3.length() == 0) {
            string3 = "*";
        }
        if (!(string3 = this.stripQuotes(string3)).startsWith("*")) {
            string3 = "*" + string3;
        }
        if (!string3.endsWith("*")) {
            string3 = string3 + "*";
        }
        if (string4 != null && string4.length() > 0 && !string4.equals("defval")) {
            int n = Integer.parseInt(string4);
            this.setMaxRows(n);
        }
        try {
            PolicyMgr policyMgr = Toolbox2.getPolicyManager();
            if (string5 != null && string5.length() > 0) {
                policyMgr = Toolbox2.createPolicyManager(string5, null, null, false);
            }
            LdapEnvironmentMgr ldapEnvironmentMgr = new LdapEnvironmentMgr(policyMgr.getEnvironment());
            this.m_nSearchLimit = ldapEnvironmentMgr.getSearchResultSizeLimit();
            LinkedList linkedList = new LinkedList();
            Iterator iterator = linkedList.iterator();
            Object object = policyMgr.getEntity(string);
            if (bl) {
                object = string2.equals("DOMAIN") || string2.equals("HOST") ? policyMgr.getRootDomain() : policyMgr.getRootOrganization();
            }
            if (object == null) {
                object = policyMgr.getRootDomain();
            }
            if (string2.equals("ORG") && object instanceof Organization) {
                iterator = ((Organization)object).findSubOrganizations(string3, true);
                this.addToModel(iterator, false);
            } else if (string2.equals("DOMAIN") && object instanceof Domain) {
                iterator = ((Domain)object).findSubDomains(string3, true);
                this.addToModel(iterator, false);
            } else if (string2.equals("HOST") && object instanceof Domain) {
                iterator = ((Domain)object).findHosts(string3, true);
                this.addToModel(iterator, false);
            } else if (string2.equals("ROLE") && (object instanceof Role || object instanceof Organization)) {
                if (object instanceof LdapNode) {
                    iterator = ((LdapNode)object).findRoles(string3, true);
                }
                this.addToModel(iterator, false);
            } else if (string2.equals("USERID") && object instanceof Organization) {
                iterator = ((Organization)object).findUsers(string3, true);
                this.addToModel(iterator, false);
                if (!string3.equals("*")) {
                    this.searchUsers((Entity)object, string3);
                }
            } else if (string2.equals("ALL") && object instanceof Domain) {
                iterator = ((Domain)object).findSubDomains(string3, true);
                this.addToModel(iterator, false);
                iterator = ((Domain)object).findHosts(string3, true);
                this.addToModel(iterator, false);
            } else if (string2.equals("ALL")) {
                if (bl) {
                    object = policyMgr.getRootDomain();
                    iterator = ((Node)object).findEntities(string3, true);
                    this.addToModel(iterator, false);
                    object = policyMgr.getRootOrganization();
                }
                if (object instanceof Node && this.m_nSearchLimit > this.getSize()) {
                    iterator = ((Node)object).findEntities(string3, true);
                    this.addToModel(iterator, bl);
                    if (object instanceof Organization && !string3.equals("*") && this.m_nSearchLimit > this.getSize()) {
                        this.searchUsers((Entity)object, string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new ModelControlException((Throwable)exception);
        }
    }

    private void searchUsers(Entity entity, String string) throws SPIException, ModelControlException {
        LinkedList<User> linkedList = new LinkedList<User>();
        Iterator iterator = linkedList.iterator();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 2) {
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = stringTokenizer.nextToken().trim();
            if (this.m_nSearchLimit > this.getSize()) {
                User user;
                Iterator iterator2 = ((Organization)entity).findUsers("(givenname=" + string3 + ")", true);
                Iterator iterator3 = ((Organization)entity).findUsers("(sn=" + string2 + ")", true);
                HashSet<String> hashSet = new HashSet<String>();
                while (iterator2.hasNext()) {
                    user = (User)iterator2.next();
                    hashSet.add(user.getUserId());
                }
                while (iterator3.hasNext()) {
                    user = (User)iterator3.next();
                    if (!hashSet.contains(user.getUserId())) continue;
                    linkedList.add(user);
                }
                this.addToModel(linkedList.iterator(), true);
            }
            if (this.m_nSearchLimit > this.getSize()) {
                iterator = ((Organization)entity).findUsers("(cn=" + string3 + " " + string2 + ")", true);
                this.addToModel(iterator, true);
            }
        } else {
            if (this.m_nSearchLimit > this.getSize()) {
                iterator = ((Organization)entity).findUsers("(givenname=" + string + ")", true);
                this.addToModel(iterator, true);
            }
            if (this.m_nSearchLimit > this.getSize()) {
                iterator = ((Organization)entity).findUsers("(sn=" + string + ")", true);
                this.addToModel(iterator, true);
            }
            if (this.m_nSearchLimit > this.getSize()) {
                iterator = ((Organization)entity).findUsers("(cn=" + string + ")", true);
                this.addToModel(iterator, true);
            }
        }
    }

    private void addToModel(Iterator iterator, boolean bl) throws SPIException, ModelControlException {
        while (iterator.hasNext() && this.m_nSearchLimit > this.getSize()) {
            boolean bl2 = false;
            Entity entity = (Entity)iterator.next();
            String string = entity.getId();
            if (bl) {
                int n = this.getLocation();
                for (int i = 0; i < this.getNumRows(); ++i) {
                    this.setLocation(i);
                    String string2 = (String)this.getValue(CHILD_VIEW_ACTION);
                    if (!string.equals(string2)) continue;
                    bl2 = true;
                    break;
                }
                this.setLocation(n);
            }
            if (bl2) continue;
            this.appendRow();
            String string3 = "-";
            String string4 = entity.getDisplayName();
            if (entity instanceof User) {
                string3 = ((User)entity).getUserId();
                if (!this.m_sEntityType.equals("USERID")) {
                    string4 = string4 + " [" + string3 + "]";
                }
            }
            this.setValue(CHILD_NAME_TEXT, string4);
            this.setValue(CHILD_VIEW_ACTION, string);
            this.setValue(CHILD_USERID_TEXT, string3);
            this.setValue(CHILD_TYPE_TEXT, Toolbox2.getEntityTypeResource(entity));
            this.setValue(CHILD_PATH_TEXT, Toolbox2.getParentagePath(entity, true, false, "/", this.m_policyManager));
        }
    }

    private String stripQuotes(String string) {
        if ((string = string.trim()).length() >= 2) {
            if (string.substring(0, 1).equals("\"") && string.substring(string.length() - 1).equals("\"")) {
                string = string.substring(1, string.length() - 1);
            } else if (string.substring(0, 1).equals("'") && string.substring(string.length() - 1).equals("'")) {
                string = string.substring(1, string.length() - 1);
            }
        }
        return string;
    }
}

