/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.model.policytemplate;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestParticipant;
import com.sun.apoc.manager.Toolbox;
import com.sun.apoc.manager.resource.ResourceRepository;
import com.sun.apoc.policy.cfgtree.ConfigNode;
import com.sun.apoc.policy.common.EntityId;
import com.sun.apoc.policy.common.EntityType;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.templates.parsing.TemplateCategory;
import com.sun.apoc.templates.parsing.TemplatePage;
import com.sun.apoc.templates.parsing.TemplateProperty;
import com.sun.apoc.templates.parsing.TemplateRepository;
import com.sun.apoc.templates.parsing.TemplateSection;
import com.sun.apoc.templates.parsing.TemplateSet;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PolicyNavigationModel
extends CCActionTableModel
implements RequestParticipant {
    public static final String CATEGORY_NAME = "CategoryName";
    public static final String CATEGORY_HREF = "CategoryHref";
    public static final String CATEGORY_DESCR = "CategoryDescription";
    public static final String ATTR_READONLY = "Readonly";
    private TemplateRepository m_templateRepository = TemplateRepository.getDefaultRepository();
    private TemplatePage m_selectedCategory = null;

    public PolicyNavigationModel() {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/ContentAreaPoliciesNavigation.xml");
        this.setActionValue("NameColumn", "APOC.policies.nameCol");
        this.setActionValue("DescriptionColumn", "APOC.policies.commentCol");
    }

    public void setRequestContext(RequestContext requestContext) {
        this.update();
    }

    public void update() {
        String string = PolicyNavigationModel.getTemplatePath(RequestManager.getRequestContext());
        this.m_selectedCategory = this.m_templateRepository.getPage(string, PolicyNavigationModel.getScope());
        this.getRowList().clear();
        if (this.m_selectedCategory != null && this.m_selectedCategory.hasSubCategories()) {
            HashMap hashMap = this.m_selectedCategory.getSubCategories();
            Iterator iterator = hashMap.values().iterator();
            ResourceRepository resourceRepository = ResourceRepository.getDefaultRepository();
            while (iterator.hasNext()) {
                TemplateCategory templateCategory = (TemplateCategory)iterator.next();
                if (!templateCategory.isInScope(PolicyNavigationModel.getScope())) continue;
                this.appendRow();
                String string2 = resourceRepository.getMessage(templateCategory.getResourceId(), templateCategory.getResourceBundle(), RequestManager.getRequest());
                String string3 = "";
                if (templateCategory.getDescriptionId() != null) {
                    string3 = resourceRepository.getMessage(templateCategory.getDescriptionId(), templateCategory.getResourceBundle(), RequestManager.getRequest());
                }
                this.setValue(CATEGORY_DESCR, string3);
                this.setValue(CATEGORY_NAME, string2);
                this.setValue(CATEGORY_HREF, string + "/" + templateCategory.getDefaultName());
            }
        }
    }

    public TemplatePage getSelectedPolicyTemplate() {
        return this.m_selectedCategory;
    }

    public static String getTemplatePath(RequestContext requestContext) {
        String string = Toolbox.getParameter("ContentArea.PageletView.ContentAreaPolicies.CategoryHref");
        String string2 = Toolbox.getParameter("ContentArea.PolicyTemplateSelection");
        String string3 = "/";
        string3 = string.length() > 0 ? string : string2;
        int n = string3.indexOf("|");
        if (n != -1) {
            String string4 = string3.substring(0, n + 1);
            String string5 = string4.substring(0, string4.lastIndexOf("/"));
            String string6 = string3.substring(n + 1);
            TemplatePage templatePage = TemplateRepository.getDefaultRepository().getPage(string4, PolicyNavigationModel.getScope());
            if (templatePage != null) {
                String string7 = templatePage.getDataPath() + "/" + string6;
                try {
                    if (Toolbox.getPolicyManager().getNode(string7, Toolbox.getPolicyGroupId()) == null) {
                        string3 = string5;
                    }
                }
                catch (RegistryException registryException) {
                    string3 = string5;
                }
            } else {
                string3 = "/";
            }
        } else {
            string3 = TemplateRepository.getDefaultRepository().getPage(string3, PolicyNavigationModel.getScope()).getPath();
        }
        return string3;
    }

    public void clearTemplateCategory() throws RegistryException {
        LinkedList linkedList = new LinkedList();
        this.clearTemplateCategory((TemplateCategory)this.getSelectedPolicyTemplate(), PolicyNavigationModel.getScope(), linkedList);
        ConfigNode[] configNodeArray = new ConfigNode[]{};
        configNodeArray = linkedList.toArray(configNodeArray);
        Toolbox.getPolicyManager().updateNodes(configNodeArray, Toolbox.getPolicyGroupId());
    }

    protected void clearTemplateCategory(TemplateCategory templateCategory, byte by, List list) throws RegistryException {
        if (templateCategory.isInScope(by) && templateCategory.getSubCategories() != null) {
            Iterator iterator = templateCategory.getSubCategories().values().iterator();
            while (iterator.hasNext()) {
                TemplateCategory templateCategory2 = (TemplateCategory)iterator.next();
                this.clearTemplateCategory(templateCategory2, by, list);
                if (!(templateCategory2 instanceof TemplatePage)) continue;
                this.clearTemplatePage((TemplatePage)templateCategory2, by, list);
            }
        }
    }

    protected void clearTemplatePage(TemplatePage templatePage, byte by, List list) throws RegistryException {
        if (templatePage.isInScope(by) && templatePage.getSections() != null) {
            Iterator iterator = templatePage.getSections().iterator();
            while (iterator.hasNext()) {
                TemplateSection templateSection = (TemplateSection)iterator.next();
                if (templateSection instanceof TemplateSet) {
                    this.clearTemplateSet((TemplateSet)templateSection, by, list);
                    continue;
                }
                this.clearTemplateSection(templateSection, by, list);
            }
        }
    }

    protected void clearTemplateSet(TemplateSet templateSet, byte by, List list) throws RegistryException {
        if (templateSet.isInScope(by)) {
            String string = templateSet.getDataPath();
            ConfigNode configNode = Toolbox.getPolicyManager().getNode(string, Toolbox.getPolicyGroupId());
            if (configNode != null && !configNode.isReadOnly()) {
                configNode.clear();
                list.add(configNode);
            }
        }
    }

    protected void clearTemplateSection(TemplateSection templateSection, byte by, List list) throws RegistryException {
        if (templateSection.isInScope(by) && templateSection.getProperties() != null) {
            Iterator iterator = templateSection.getProperties().iterator();
            while (iterator.hasNext()) {
                TemplateProperty templateProperty = (TemplateProperty)iterator.next();
                if (!templateProperty.isInScope(by)) continue;
                String string = templateProperty.getDataPath();
                ConfigNode configNode = Toolbox.getPolicyManager().getNode(string, Toolbox.getPolicyGroupId());
                if (configNode == null || configNode.isReadOnly()) continue;
                configNode.clear();
                list.add(configNode);
            }
        }
    }

    public static byte getScope() {
        String string = Toolbox.getEntity();
        if (string != null) {
            if (Toolbox.isDomainSubtype(string)) {
                return 2;
            }
            if (string.indexOf("Applicability:HOST") != -1) {
                return 2;
            }
        }
        return 1;
    }

    public static boolean isReadOnlyPage() {
        boolean bl = false;
        Boolean bl2 = (Boolean)RequestManager.getRequest().getAttribute(ATTR_READONLY);
        if (bl2 == null) {
            String string = Toolbox.getEntity();
            if (string != null && EntityId.getTypeFromString((String)string) == EntityType.ROLE) {
                bl = true;
            } else {
                try {
                    bl = !Toolbox.getPolicyManager().isPolicyGroupWritable(Toolbox.getPolicyGroupId());
                }
                catch (RegistryException registryException) {
                    CCDebug.trace1((String)"Error using policymgr", (Throwable)registryException);
                }
            }
            RequestManager.getRequest().setAttribute(ATTR_READONLY, (Object)new Boolean(bl));
            return bl;
        }
        return bl2;
    }
}

