/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.model.policytemplate;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.sun.apoc.manager.Toolbox;
import com.sun.apoc.manager.model.policytemplate.PolicyNavigationModel;
import com.sun.apoc.manager.model.policytemplate.PolicySectionModel;
import com.sun.apoc.manager.model.policytemplate.PropertyStatusModel;
import com.sun.apoc.manager.resource.ResourceRepository;
import com.sun.apoc.policy.cfgtree.ConfigNode;
import com.sun.apoc.policy.cfgtree.ConfigNodeImpl;
import com.sun.apoc.policy.cfgtree.NodeType;
import com.sun.apoc.policy.cfgtree.PropertyNode;
import com.sun.apoc.policy.common.PolicySetId;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.pmgr.PolicyMgr;
import com.sun.apoc.templates.parsing.TemplateProperty;
import com.sun.apoc.templates.parsing.TemplateRepository;
import com.sun.apoc.templates.parsing.TemplateSection;
import com.sun.apoc.templates.parsing.TemplateSet;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PolicySetModel
extends CCActionTableModel
implements PropertyStatusModel {
    public static final String ENTRY_NAME = "PropertyName";
    public static final String ENTRY_HREF = "SubPageHref";
    private TemplateRepository m_templateRepository = TemplateRepository.getDefaultRepository();
    private TemplateSet m_templateSet = null;
    private ResourceRepository m_resources = null;

    public PolicySetModel(TemplateSection templateSection) {
        this.m_templateSet = (TemplateSet)templateSection;
        byte by = PolicyNavigationModel.getScope();
        if (this.m_templateSet.getPage().hasVisibleContent(by)) {
            this.setDocument(RequestManager.getRequestContext().getServletContext(), "/jsp/ContentAreaPoliciesSet.xml");
        } else {
            this.setDocument(RequestManager.getRequestContext().getServletContext(), "/jsp/ContentAreaPoliciesSimpleSet.xml");
        }
        this.m_resources = ResourceRepository.getDefaultRepository();
        String string = this.m_resources.getMessage(templateSection.getResourceId(), templateSection.getResourceBundle(), RequestManager.getRequest());
        this.setTitle(string);
        this.setActionValue("NewButton", "APOC.policies.new.button");
        this.setActionValue("DeleteButton", "APOC.policies.delete.button");
        this.setActionValue("NameColumn", "APOC.policies.nameCol");
        this.setActionValue("StateColumn", "APOC.policies.status");
        this.setActionValue("DescriptionColumn", "APOC.policies.commentCol");
        this.setSelectionType("multiple");
        this.update();
    }

    public void update() {
        try {
            this.getRowList().clear();
            PolicyMgr policyMgr = (PolicyMgr)RequestManager.getRequest().getSession().getAttribute("PolicyManager");
            StringBuffer stringBuffer = new StringBuffer(PolicyNavigationModel.getTemplatePath(RequestManager.getRequestContext()));
            stringBuffer.append("/");
            stringBuffer.append("SET_");
            stringBuffer.append(this.m_templateSet.getDefaultName());
            stringBuffer.append("|");
            ConfigNode configNode = this.getConfigNode(this.m_templateSet.getDataPath());
            if (configNode != null && configNode.hasChildren()) {
                Iterator iterator = configNode.getChildren();
                while (iterator.hasNext()) {
                    ConfigNode configNode2 = (ConfigNode)iterator.next();
                    String string = ((ConfigNodeImpl)configNode2).getAttributes(0);
                    if (string.indexOf("oor:op") == -1) continue;
                    this.appendRow();
                    this.setValue(ENTRY_NAME, configNode2.getName());
                    this.setValue(ENTRY_HREF, stringBuffer.toString() + configNode2.getName());
                    this.setConfigNode(configNode2);
                }
            }
            this.beforeFirst();
            this.setMaxRows(this.getRowIndex() + 1);
        }
        catch (RegistryException registryException) {
            CCDebug.trace1((String)"Error using policy manager!", (Throwable)registryException);
        }
        catch (ModelControlException modelControlException) {
            CCDebug.trace1((String)"Error initializing the model!", (Throwable)modelControlException);
        }
    }

    public List addEntry(String string) throws RegistryException {
        LinkedList<ConfigNode> linkedList = new LinkedList<ConfigNode>();
        ConfigNode configNode = this.createStaticHierarchyNode(this.m_templateSet.getDataPath());
        linkedList.add(configNode);
        ConfigNode configNode2 = this.createDynamicHierarchyNode(configNode.getPath() + "/" + string);
        linkedList.add(configNode2);
        this.addRequiredProperties(this.m_templateSet.getDataPath(), string, linkedList);
        return linkedList;
    }

    protected void addRequiredProperties(String string, String string2, List list) throws RegistryException {
        Iterator iterator = this.m_templateSet.getPage().getSections().iterator();
        while (iterator.hasNext()) {
            TemplateSection templateSection = (TemplateSection)iterator.next();
            Iterator iterator2 = templateSection.getProperties().iterator();
            while (iterator2.hasNext()) {
                TemplateProperty templateProperty = (TemplateProperty)iterator2.next();
                if (!templateProperty.isAutoStored()) continue;
                String string3 = this.getAbsolutePath(string, string2, templateProperty.getDataPath());
                String string4 = templateProperty.getDefaultValue();
                int n = string4.indexOf("$queriedId");
                string4 = string4.substring(0, n) + string2 + string4.substring(n + "$queriedId".length());
                PolicySetId policySetId = Toolbox.getPolicyGroupId();
                PropertyNode propertyNode = PolicySectionModel.createConfigNode(string3);
                PolicySectionModel.setDataType(templateProperty, propertyNode);
                propertyNode.getValue().setNewContents(string4);
                list.add(propertyNode);
            }
        }
    }

    protected String getAbsolutePath(String string, String string2, String string3) {
        String string4 = string3;
        if (string3.startsWith("./")) {
            string4 = string + string3.substring(1);
            int n = string4.indexOf("$queriedId");
            string4 = string4.substring(0, n) + string2 + string4.substring(n + "$queriedId".length());
        }
        return string4;
    }

    public ConfigNode removeEntry(int n) throws RegistryException, ModelControlException {
        this.setLocation(n);
        ConfigNode configNode = this.getConfigNode();
        configNode.delete();
        return configNode;
    }

    public void storeChanges(List list) throws RegistryException {
        ConfigNode[] configNodeArray = new ConfigNode[]{};
        configNodeArray = list.toArray(configNodeArray);
        Toolbox.getPolicyManager().updateNodes(configNodeArray, Toolbox.getPolicyGroupId());
        this.update();
    }

    public ConfigNode getConfigNode() {
        return (ConfigNode)this.getValue("CONFIG_NODE");
    }

    public void setConfigNode(ConfigNode configNode) {
        this.setValue("CONFIG_NODE", configNode);
    }

    public void setValues(String string, Object[] objectArray) {
        if (string.indexOf("PropertyStatusValue") == -1) {
            super.setValues(string, objectArray);
        }
    }

    protected ConfigNode createStaticHierarchyNode(String string) throws RegistryException {
        PolicySetId policySetId = Toolbox.getPolicyGroupId();
        return Toolbox.getPolicyManager().createNode(string, NodeType.HIERARCHY, policySetId, false);
    }

    protected ConfigNode createDynamicHierarchyNode(String string) throws RegistryException {
        PolicySetId policySetId = Toolbox.getPolicyGroupId();
        return Toolbox.getPolicyManager().createNode(string, NodeType.HIERARCHY, policySetId, true);
    }

    protected ConfigNode getConfigNode(String string) throws RegistryException {
        PolicySetId policySetId = Toolbox.getPolicyGroupId();
        return Toolbox.getPolicyManager().getNode(string, policySetId);
    }
}

