/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.model.policytemplate;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.sun.apoc.manager.Toolbox;
import com.sun.apoc.manager.model.policytemplate.PolicyNavigationModel;
import com.sun.apoc.manager.model.policytemplate.PolicySectionModel;
import com.sun.apoc.manager.model.policytemplate.PolicySetModel;
import com.sun.apoc.manager.resource.ResourceRepository;
import com.sun.apoc.policy.cfgtree.ConfigNode;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.pmgr.PolicyMgr;
import com.sun.apoc.templates.parsing.TemplatePage;
import com.sun.apoc.templates.parsing.TemplateRepository;
import com.sun.apoc.templates.parsing.TemplateSection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class PolicyTemplateModel
extends DefaultModel
implements RequestParticipant {
    public static final String TEMPLATE_SECTION = "TemplateSection";
    public static final String TEMPLATE_SECTION_NAME = "TemplateSectionName";
    public static final String SECTION_MODEL = "TemplateSectionModel";
    private TemplatePage m_page = null;
    private String m_setIndex = null;
    private Vector choosers = new Vector(0);
    private Vector handlers = new Vector(0);

    public TemplatePage getPage() {
        return this.m_page;
    }

    public String getSetIndex() {
        return this.m_setIndex;
    }

    public boolean hasSections() {
        if (this.m_page.getSections() == null) {
            return false;
        }
        return this.m_page.getSections().size() > 0;
    }

    public void setRequestContext(RequestContext requestContext) {
        TemplateRepository templateRepository = TemplateRepository.getDefaultRepository();
        String string = PolicyNavigationModel.getTemplatePath(requestContext);
        int n = string.indexOf("|");
        if (n != -1) {
            this.m_setIndex = string.substring(n + 1);
        }
        this.getRowList().clear();
        this.m_page = templateRepository.getPage(string, PolicyNavigationModel.getScope());
        if (this.m_page != null && this.m_page.getSections() != null) {
            Iterator iterator = this.m_page.getSections().iterator();
            while (iterator.hasNext()) {
                TemplateSection templateSection = (TemplateSection)iterator.next();
                if (!templateSection.isInScope(PolicyNavigationModel.getScope())) continue;
                this.appendRow();
                ResourceRepository resourceRepository = ResourceRepository.getDefaultRepository();
                String string2 = resourceRepository.getMessage(templateSection.getResourceId(), templateSection.getResourceBundle(), RequestManager.getRequest());
                this.setValue(TEMPLATE_SECTION, templateSection);
                this.setValue(TEMPLATE_SECTION_NAME, string2);
            }
        }
    }

    public void updateSections() {
        for (int i = 0; i < this.getNumRows(); ++i) {
            this.setRowIndex(i);
            Object object = this.getValue(SECTION_MODEL);
            if (object instanceof PolicySetModel) continue;
            PolicySectionModel policySectionModel = (PolicySectionModel)object;
            policySectionModel.update();
        }
    }

    public void updateSectionsElements() {
        for (int i = 0; i < this.getNumRows(); ++i) {
            int n;
            this.setRowIndex(i);
            Object object = this.getValue(SECTION_MODEL);
            if (object instanceof PolicySetModel) continue;
            PolicySectionModel policySectionModel = (PolicySectionModel)object;
            for (n = 0; n < policySectionModel.getChoosers().size(); ++n) {
                this.choosers.add(policySectionModel.getChoosers().elementAt(n));
            }
            for (n = 0; n < policySectionModel.getHandlers().size(); ++n) {
                this.handlers.add(policySectionModel.getHandlers().elementAt(n));
            }
            policySectionModel.resetChoosers();
            policySectionModel.resetHandlers();
        }
    }

    public List getSectionChanges() throws RegistryException {
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < this.getNumRows(); ++i) {
            this.setRowIndex(i);
            Object object = this.getValue(SECTION_MODEL);
            if (object instanceof PolicySetModel) continue;
            PolicySectionModel policySectionModel = (PolicySectionModel)object;
            linkedList.addAll(policySectionModel.getPropertiesChanges());
        }
        return linkedList;
    }

    public void storeSectionChanges() throws RegistryException {
        List list = this.getSectionChanges();
        ConfigNode[] configNodeArray = new ConfigNode[]{};
        configNodeArray = list.toArray(configNodeArray);
        Toolbox.getPolicyManager().updateNodes(configNodeArray, Toolbox.getPolicyGroupId());
    }

    protected PolicyMgr getPolicyMgr() {
        return (PolicyMgr)RequestManager.getRequestContext().getRequest().getSession().getAttribute("PolicyManager");
    }

    public Vector getChoosers() {
        return (Vector)this.choosers.clone();
    }

    public Vector getHandlers() {
        return (Vector)this.handlers.clone();
    }

    public void resetChoosers() {
        this.choosers.clear();
    }

    public void resetHandlers() {
        this.handlers.clear();
    }
}

