/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.report;

import com.sun.apoc.manager.Toolbox2;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.cfgtree.PolicyTree;
import com.sun.apoc.spi.cfgtree.policynode.PolicyNode;
import com.sun.apoc.spi.cfgtree.policynode.PolicyNodeImpl;
import com.sun.apoc.spi.cfgtree.property.Property;
import com.sun.apoc.spi.cfgtree.readwrite.ReadWritePolicyTreeFactoryImpl;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.web.ui.common.CCDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class PolicyMgrReportHelper {
    public static final String SEPARATOR = "/";
    public static final String PENDING = "pending_";
    public static final String DISABLED = "disabled_";
    public static final String PENDING_DISABLED = "pending_disabled_";
    private Profile m_profile = null;
    private LinkedList m_entityList = new LinkedList();
    private LinkedList m_groupList = new LinkedList();
    private HashMap m_reportingTreeCache = new HashMap();
    private HashMap m_definedProps = new HashMap();
    private HashMap m_policyIterators = new HashMap();

    public PolicyMgrReportHelper() {
    }

    public PolicyMgrReportHelper(Profile profile) {
        this.initialize();
        try {
            this.m_profile = profile;
            this.m_groupList.add(this.m_profile);
            this.getPolicyIterators();
        }
        catch (SPIException sPIException) {
            CCDebug.trace3((String)sPIException.toString());
        }
    }

    public PolicyMgrReportHelper(Entity entity) {
        this.initialize();
        try {
            Iterator iterator = entity.getLayeredProfiles();
            while (iterator.hasNext()) {
                this.m_groupList.add(0, iterator.next());
            }
            this.getPolicyIterators();
        }
        catch (SPIException sPIException) {
            CCDebug.trace3((String)("Error getting layered profiles for PolicyMgrReportHelper! " + sPIException.toString()));
        }
    }

    public PolicyMgrReportHelper(Entity entity, Entity entity2) {
        this.initialize();
        try {
            Iterator iterator = entity.getLayeredProfiles();
            Iterator iterator2 = entity2.getLayeredProfiles();
            while (iterator2.hasNext()) {
                this.m_groupList.add(0, iterator2.next());
            }
            while (iterator.hasNext()) {
                this.m_groupList.add(0, iterator.next());
            }
            this.getPolicyIterators();
        }
        catch (SPIException sPIException) {
            CCDebug.trace3((String)("Error getting layered profiles for PolicyMgrReportHelper! " + sPIException.toString()));
        }
    }

    public LinkedList getPolicyGroupList() {
        return this.m_groupList;
    }

    public void getPolicyIterators() throws SPIException {
        Profile profile = null;
        Iterator iterator = this.m_groupList.iterator();
        while (iterator.hasNext()) {
            profile = (Profile)iterator.next();
            Iterator iterator2 = profile.getPolicies();
            while (iterator2.hasNext()) {
                ArrayList arrayList;
                Policy policy = (Policy)iterator2.next();
                String string = policy.getId();
                if (this.m_policyIterators.containsKey(string)) {
                    arrayList = (ArrayList)this.m_policyIterators.get(string);
                    arrayList.add(0, policy);
                    this.m_policyIterators.put(string, arrayList);
                    continue;
                }
                arrayList = new ArrayList();
                arrayList.add(policy);
                this.m_policyIterators.put(string, arrayList);
            }
        }
    }

    public void initialize() {
        this.m_reportingTreeCache.clear();
        this.m_entityList.clear();
        this.m_groupList.clear();
        this.m_definedProps.clear();
        this.m_policyIterators.clear();
    }

    public boolean equalProperties(Property property, Property property2) throws SPIException {
        if (property == null || property2 == null) {
            return false;
        }
        if (property.isProtected() != property2.isProtected()) {
            return false;
        }
        return !(property.getValue() == null ? property2.getValue() != null : !property.getValue().equals(property2.getValue()));
    }

    public PolicyTree getTree(Iterator iterator, String string) throws SPIException {
        PolicyTree policyTree = null;
        if (this.m_reportingTreeCache.containsKey(string)) {
            policyTree = (PolicyTree)this.m_reportingTreeCache.get(string);
        } else {
            Iterator iterator2 = this.getPolicyIterator(string);
            if (iterator2.hasNext()) {
                ReadWritePolicyTreeFactoryImpl readWritePolicyTreeFactoryImpl = new ReadWritePolicyTreeFactoryImpl();
                policyTree = readWritePolicyTreeFactoryImpl.getPolicyTree(iterator2);
            }
            this.m_reportingTreeCache.put(string, policyTree);
        }
        return policyTree;
    }

    public Property getReportProperty(String string) throws SPIException {
        PolicyNode policyNode;
        Property property = null;
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        String string3 = string.substring(0, string.indexOf(47));
        PolicyTree policyTree = this.getTree(this.m_groupList.iterator(), string3);
        String string4 = string.substring(0, string.lastIndexOf(47) + 1);
        if (policyTree != null && (policyNode = policyTree.getNode(string4)) != null) {
            property = policyNode.getProperty(string2);
        }
        return property;
    }

    public HashMap getAllDefinedProperties() throws SPIException {
        Iterator iterator = this.m_policyIterators.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PolicyTree policyTree = this.getTree(this.m_groupList.iterator(), string);
            this.recursiveGetProperties(policyTree, "");
        }
        return this.m_definedProps;
    }

    public void recursiveGetProperties(PolicyTree policyTree, String string) throws SPIException {
        int n;
        String string2;
        PolicyNode policyNode = null;
        if (string.length() == 0) {
            policyNode = policyTree.getRootNode();
        } else {
            string2 = policyTree.getRootNode().getAbsolutePath() + string + SEPARATOR;
            policyNode = policyTree.getNode(string2);
        }
        string2 = Toolbox2.encode(SEPARATOR);
        String[] stringArray = policyNode.getPropertyNames();
        String[] stringArray2 = policyNode.getChildrenNames();
        if (stringArray != null && stringArray.length != 0) {
            for (n = 0; n < stringArray.length; ++n) {
                String string3 = policyTree.getRootNode().getAbsolutePath() + string + SEPARATOR + stringArray[n].replaceAll(SEPARATOR, string2);
                this.m_definedProps.put(string3, policyNode.getProperty(stringArray[n]));
            }
        }
        if (stringArray2 != null && stringArray2.length != 0) {
            for (n = 0; n < stringArray2.length; ++n) {
                this.recursiveGetProperties(policyTree, string + SEPARATOR + stringArray2[n].replaceAll(SEPARATOR, string2));
            }
        }
    }

    public boolean isASetNode(String string) throws SPIException {
        String string2;
        boolean bl = false;
        PolicyNode policyNode = this.getReportPolicyNode(string);
        if (policyNode != null && (string2 = ((PolicyNodeImpl)policyNode).getAttributes(0)).indexOf("oor:op") != -1) {
            bl = true;
        }
        return bl;
    }

    public PolicyNode getReportPolicyNode(String string) throws SPIException {
        PolicyNode policyNode = null;
        String string2 = string.substring(0, string.lastIndexOf(47) + 1);
        String string3 = string.substring(0, string.indexOf(47));
        PolicyTree policyTree = this.getTree(this.m_groupList.iterator(), string3);
        if (policyTree != null) {
            policyNode = policyTree.getNode(string2);
        }
        return policyNode;
    }

    public Profile getReportProfile(String string) {
        Profile profile = null;
        Iterator iterator = this.m_groupList.iterator();
        while (iterator.hasNext()) {
            Profile profile2 = (Profile)iterator.next();
            if (!profile2.getId().equals(string)) continue;
            profile = profile2;
            break;
        }
        return profile;
    }

    private Iterator getPolicyIterator(String string) {
        ArrayList arrayList = (ArrayList)this.m_policyIterators.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList.iterator();
    }
}

