/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.resource;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.servlet.http.HttpServletRequest;

public class ResourceRepository {
    public static final String CACHED_BUNDLE = "CachedResourceBundle";
    public static final String PROPS_SUFFIX = ".properties";
    public static final String JAR_SUFFIX = ".jar";
    public static final String RES_DIRNAME = "/res/";
    public static final String CLASSES_DIRNAME = "/classes/";
    private static ResourceRepository m_defaultRepository = null;
    private HashMap m_resourceBundles = null;

    public static ResourceRepository getDefaultRepository() {
        if (m_defaultRepository == null) {
            m_defaultRepository = new ResourceRepository();
        }
        return m_defaultRepository;
    }

    protected ResourceRepository() {
        CCDebug.initTrace();
        this.m_resourceBundles = new HashMap();
    }

    public void addResource(File file) {
        if (file.exists()) {
            try {
                CCDebug.trace3((String)("Examine resources of file " + file.getName()));
                if (file.getName().endsWith(PROPS_SUFFIX)) {
                    String string = file.getPath();
                    if (string.indexOf(CLASSES_DIRNAME) != -1) {
                        string = string.substring(string.indexOf(CLASSES_DIRNAME) + CLASSES_DIRNAME.length());
                        this.m_resourceBundles.put(string, file);
                    } else if (string.indexOf(RES_DIRNAME) != -1) {
                        string = string.substring(string.indexOf(RES_DIRNAME) + RES_DIRNAME.length());
                        this.m_resourceBundles.put(string, file);
                    }
                } else if (file.getName().endsWith(JAR_SUFFIX)) {
                    JarFile jarFile = new JarFile(file);
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        if (!zipEntry.getName().endsWith(PROPS_SUFFIX)) continue;
                        this.m_resourceBundles.put(zipEntry.getName(), jarFile);
                    }
                }
            }
            catch (IOException iOException) {
                CCDebug.trace1((String)("Could not load " + file.getName()), (Throwable)iOException);
            }
        }
    }

    public ResourceBundle getBundle(String string) {
        HttpServletRequest httpServletRequest = RequestManager.getRequest();
        ResourceBundle resourceBundle = null;
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(CACHED_BUNDLE);
        nonSyncStringBuffer.append(string);
        resourceBundle = (ResourceBundle)httpServletRequest.getAttribute(nonSyncStringBuffer.toString());
        if (resourceBundle == null) {
            ArrayList arrayList = Collections.list(httpServletRequest.getLocales());
            arrayList.add(new Locale(""));
            arrayList.add(new Locale("en"));
            arrayList.add(new Locale("en", "US"));
            for (int i = 0; i < arrayList.size(); ++i) {
                Locale locale = (Locale)arrayList.get(i);
                resourceBundle = this.getBundle(string, locale);
                if (resourceBundle == null) continue;
                httpServletRequest.setAttribute(nonSyncStringBuffer.toString(), (Object)resourceBundle);
                break;
            }
        }
        return resourceBundle;
    }

    private static String getSuffix(String string, String string2, String string3) {
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        String string4 = "_";
        if (string.length() > 0) {
            nonSyncStringBuffer.append(string4 + string);
        }
        if (string2.length() > 0) {
            nonSyncStringBuffer.append(string4 + string2);
        }
        if (string3.length() > 0) {
            nonSyncStringBuffer.append(string4 + string3);
        }
        return nonSyncStringBuffer.toString();
    }

    public ResourceBundle getBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        if (string != null) {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (locale.getLanguage().length() > 0 && locale.getCountry().length() > 0 && locale.getVariant().length() > 0) {
                arrayList.add(ResourceRepository.getSuffix(locale.getLanguage(), locale.getCountry(), locale.getVariant()));
            }
            if (locale.getLanguage().length() > 0 && locale.getCountry().length() > 0) {
                arrayList.add(ResourceRepository.getSuffix(locale.getLanguage(), locale.getCountry(), ""));
            }
            if (locale.getLanguage().length() > 0) {
                arrayList.add(ResourceRepository.getSuffix(locale.getLanguage(), "", ""));
            }
            arrayList.add("");
            for (int i = 0; i < arrayList.size() && (resourceBundle = this.loadBundle(string2 = new NonSyncStringBuffer(string).append(arrayList.get(i)).toString())) == null; ++i) {
            }
        }
        return resourceBundle;
    }

    public ResourceBundle loadBundle(String string) {
        PropertyResourceBundle propertyResourceBundle = null;
        String string2 = string.replace('.', '/');
        Object v = this.m_resourceBundles.get(string2 = string2 + PROPS_SUFFIX);
        if (v != null) {
            try {
                InputStream inputStream = null;
                if (v instanceof JarFile) {
                    JarFile jarFile = (JarFile)v;
                    inputStream = jarFile.getInputStream(new ZipEntry(string2));
                } else {
                    inputStream = new FileInputStream((File)v);
                }
                propertyResourceBundle = new PropertyResourceBundle(inputStream);
            }
            catch (IOException iOException) {
                CCDebug.trace1((String)("Could not load " + string), (Throwable)iOException);
            }
        }
        return propertyResourceBundle;
    }

    public String getMessage(String string, String string2, Locale locale) {
        String string3 = null;
        ResourceBundle resourceBundle = this.getBundle(string2, locale);
        if (resourceBundle != null) {
            try {
                string3 = resourceBundle.getString(string);
                return string3;
            }
            catch (MissingResourceException missingResourceException) {
                CCDebug.trace3((String)("Could not retrieve resource for key: " + string));
            }
        }
        return string;
    }

    public String getMessage(String string, String string2) {
        String string3 = this.getValidMessage(string, string2);
        if (string3 != null) {
            return string3;
        }
        return string;
    }

    public String getValidMessage(String string, String string2) {
        String string3 = null;
        ResourceBundle resourceBundle = this.getBundle(string2);
        if (resourceBundle != null) {
            try {
                string3 = resourceBundle.getString(string);
                return string3;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getValidMessage(String string, String string2, HttpServletRequest httpServletRequest) {
        return this.getValidMessage(string, string2);
    }

    public String getMessage(String string, String string2, HttpServletRequest httpServletRequest) {
        return this.getMessage(string, string2);
    }
}

