/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.pmgr;

import com.sun.apoc.policy.cfgtree.ConfigDataManager;
import com.sun.apoc.policy.cfgtree.ConfigNode;
import com.sun.apoc.policy.cfgtree.NodeType;
import com.sun.apoc.policy.common.EntityId;
import com.sun.apoc.policy.common.EntityType;
import com.sun.apoc.policy.common.PolicyGroupIdImpl;
import com.sun.apoc.policy.common.PolicyGroupUse;
import com.sun.apoc.policy.common.PolicyId;
import com.sun.apoc.policy.common.PolicySetId;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.datastore.DataStore;
import com.sun.apoc.policy.organization.Organization;
import com.sun.apoc.policy.pmgr.ClientContext;
import com.sun.apoc.policy.util.BootstrapData;
import com.sun.apoc.policy.util.ImporterExporter;
import com.sun.apoc.policy.util.ZipImporterExporter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class PolicyMgr {
    private ClientContext mContext;
    private Organization mOrganization;
    private DataStore mDataStore;
    private BootstrapData mBootstrapData;
    private ConfigDataManager mConfigDataManager;
    private Locale mConfigDataLocale;
    public static final String DEFAULT_LOCALE_NAME = "default";
    private Hashtable mLocaleTable;
    private static final String MODULE = "PolicyMgr";
    public static final int FORMAT_ZIP = 1;

    protected PolicyMgr(BootstrapData bootstrapData, DataStore dataStore, Organization organization, String string, String string2) throws RegistryException {
        if (bootstrapData == null || dataStore == null || organization == null) {
            throw new RegistryException("The application cannot be initialized.", "error.application.initialize", MODULE, 0);
        }
        this.mBootstrapData = bootstrapData;
        this.mDataStore = dataStore;
        this.mOrganization = organization;
        this.openContext(string, string2);
        try {
            this.mConfigDataManager = new ConfigDataManager(this.mDataStore, this.mOrganization);
            this.mConfigDataManager.setConfigDataLocaleName(DEFAULT_LOCALE_NAME);
        }
        catch (RegistryException registryException) {
            throw new RegistryException("The application cannot be initialized: " + registryException.getMessage(), "error.application.initialize", MODULE, 0);
        }
        this.mDataStore.setConfigDataManager(this.mConfigDataManager);
    }

    public ClientContext getCurrentContext() throws RegistryException {
        this.checkContext();
        return this.mContext;
    }

    public EntityId getCurrentEntityId() throws RegistryException {
        this.checkContext();
        return this.mContext.getEntityId();
    }

    private void openContext(String string, String string2) throws RegistryException {
        this.mContext = ClientContext.getContext(this.mBootstrapData, string);
        if (string != null) {
            ClientContext clientContext = ClientContext.getContext(this.mBootstrapData, null);
            this.mContext.authenticate(string, string2, this.mOrganization, clientContext);
            clientContext.close();
        }
    }

    public void closeContext() throws RegistryException {
        this.mContext.close();
        this.mContext = null;
    }

    public void resizeNodeCache(int n) {
        this.mConfigDataManager.setMaximumCacheEntries(n);
    }

    public void flushNodeCache() {
        this.mConfigDataManager.flushNodeCache();
    }

    public Locale getConfigurationDataLocale() {
        return this.mConfigDataLocale;
    }

    public void setConfigurationDataLocale(Locale locale) throws RegistryException {
        if (locale == null) {
            this.mConfigDataManager.setConfigDataLocaleName(DEFAULT_LOCALE_NAME);
            this.mConfigDataLocale = null;
            return;
        }
        this.mConfigDataLocale = locale;
        String string = locale.getDisplayName();
        if (string == null) {
            throw new RegistryException("The locale is not supported", "error.locale.support", MODULE, 0);
        }
        this.mConfigDataManager.setConfigDataLocaleName(string);
    }

    public synchronized ConfigNode getNode(String string, PolicySetId policySetId) throws RegistryException {
        this.checkContext();
        return this.mConfigDataManager.getNode(string, (PolicyGroupIdImpl)policySetId, this.mContext);
    }

    public synchronized ConfigNode getNode(String string, PolicySetId policySetId, PolicySetId policySetId2) throws RegistryException {
        this.checkContext();
        return this.mConfigDataManager.getNode(string, (PolicyGroupIdImpl)policySetId, (PolicyGroupIdImpl)policySetId2, this.mContext);
    }

    public synchronized void updateNodes(ConfigNode[] configNodeArray, PolicySetId policySetId) throws RegistryException {
        this.checkContext();
        this.mConfigDataManager.updateNodes(configNodeArray, (PolicyGroupIdImpl)policySetId, this.mContext);
    }

    public EntityId getEntityParent(EntityId entityId, EntityType entityType) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getEntityParent(entityId, entityType, this.mContext);
    }

    public EntityId[] getRolesEntityIsAMemberOf(EntityId entityId) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getRolesEntityIsAMemberOf(entityId, this.mContext);
    }

    public EntityId[] getEntityChildren(EntityId entityId, EntityType entityType) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getEntityChildren(entityId, entityType, this.mContext);
    }

    public EntityId[] getRoleMembers(EntityId entityId, EntityType entityType) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getRoleMembers(entityId, entityType, this.mContext);
    }

    public boolean hasEntityChildren(EntityId entityId, EntityType entityType) throws RegistryException {
        this.checkContext();
        return this.mOrganization.hasEntityChildren(entityId, entityType, this.mContext);
    }

    public boolean hasMembers(EntityId entityId, EntityType entityType) throws RegistryException {
        this.checkContext();
        return this.mOrganization.hasMembers(entityId, entityType, this.mContext);
    }

    public EntityId getRootEntityId(EntityType entityType) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getRootEntityId(entityType, this.mContext);
    }

    public EntityId findUserEntityId(String string) throws RegistryException {
        this.checkContext();
        return this.mOrganization.findUserEntityId(string, this.mContext);
    }

    public EntityId findHostEntityId(String string) throws RegistryException {
        this.checkContext();
        return this.mOrganization.findHostEntityId(string, this.mContext);
    }

    public EntityId[] findEntitiesByName(EntityId entityId, EntityType entityType, String string, boolean bl) throws RegistryException {
        this.checkContext();
        return this.mOrganization.findEntitiesByName(entityId, entityType, string, bl, this.mContext);
    }

    public EntityId[] findEntitiesByFilter(EntityId entityId, EntityType entityType, String string, boolean bl) throws RegistryException {
        this.checkContext();
        return this.mOrganization.findEntitiesByFilter(entityId, entityType, string, bl, this.mContext);
    }

    public EntityId[] getParentPath(EntityId entityId) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getAllParentsInPath(entityId, this.mContext);
    }

    public EntityId[] getLayerPath(EntityId entityId) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getLayerPath(entityId, this.mContext);
    }

    public PolicySetId[] getPolicyGroups(PolicyGroupUse policyGroupUse) throws RegistryException {
        this.checkContext();
        return this.mDataStore.getPolicyGroups(policyGroupUse, this.mContext);
    }

    public PolicySetId createPolicyGroup(String string, PolicyGroupUse policyGroupUse, int n) throws RegistryException {
        return this.mDataStore.createPolicyGroup(string, policyGroupUse, n, this.mContext);
    }

    public PolicySetId createPolicyGroup(EntityId entityId, String string, PolicyGroupUse policyGroupUse, int n) throws RegistryException {
        this.checkContext();
        return this.mDataStore.createPolicyGroup(entityId, string, policyGroupUse, n, this.mContext);
    }

    public void deletePolicyGroups(PolicySetId[] policySetIdArray) throws RegistryException {
        this.checkContext();
        this.mDataStore.deletePolicyGroups(policySetIdArray, this.mContext);
    }

    public void renamePolicyGroup(PolicySetId policySetId, String string) throws RegistryException {
        this.checkContext();
        this.mDataStore.renamePolicyGroup((PolicyGroupIdImpl)policySetId, string, this.mContext);
    }

    public PolicySetId[] getPolicyGroupsAssignedToEntity(EntityId entityId) throws RegistryException {
        return this.getPolicyGroupsAssignedToEntity(entityId, PolicyGroupUse.ALL);
    }

    public PolicySetId[] getPolicyGroupsAssignedToEntity(EntityId entityId, PolicyGroupUse policyGroupUse) throws RegistryException {
        this.checkContext();
        return this.mDataStore.getPolicyGroupsAssignedToEntity(entityId, policyGroupUse, this.mContext);
    }

    public void assignPolicyGroupsToEntity(EntityId entityId, PolicySetId[] policySetIdArray) throws RegistryException {
        this.checkContext();
        this.mDataStore.assignPolicyGroupsToEntity(entityId, policySetIdArray, this.mContext);
    }

    public void unassignPolicyGroupsFromEntity(EntityId entityId, PolicySetId[] policySetIdArray) throws RegistryException {
        this.checkContext();
        this.mDataStore.unassignPolicyGroupsFromEntity(entityId, policySetIdArray, this.mContext);
    }

    public EntityId[] getEntitiesForPolicyGroup(PolicySetId policySetId) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getEntitiesForPolicyGroup((PolicyGroupIdImpl)policySetId, this.mContext);
    }

    public void setPolicyGroupPriorities(PolicySetId[] policySetIdArray) throws RegistryException {
        this.checkContext();
        this.mDataStore.setPolicyGroupPriorities(policySetIdArray, false, this.mContext);
    }

    public PolicySetId findPolicyGroup(String string, EntityId entityId, PolicyGroupUse policyGroupUse) throws RegistryException {
        this.checkContext();
        return this.mDataStore.findPolicyGroup(string, entityId, policyGroupUse, this.mContext);
    }

    public PolicySetId findPolicyGroup(String string, PolicyGroupUse policyGroupUse) throws RegistryException {
        return this.findPolicyGroup(string, null, policyGroupUse);
    }

    public PolicySetId[] getLayeredPolicySetIds(EntityId entityId) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getLayeredPolicySetIds(entityId, this.mContext);
    }

    public PolicyId[][] getLayeredPolicies(EntityId entityId, String[] stringArray, boolean bl) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getLayeredPolicies(entityId, stringArray, bl, this.mContext);
    }

    public PolicyId[] getPolicies(PolicySetId policySetId, String[] stringArray, boolean bl) throws RegistryException {
        this.checkContext();
        return this.mDataStore.getPolicyIds(policySetId, stringArray, bl, this.mContext);
    }

    public PolicyId[] getPolicies(PolicySetId[] policySetIdArray, String string, boolean bl) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getPolicies(string, policySetIdArray, bl, this.mContext);
    }

    public String[] getComponentList(EntityId entityId) throws RegistryException {
        return this.mDataStore.getComponentList(this.getLayeredPolicySetIds(entityId), this.mContext);
    }

    public String[] getComponentList(PolicySetId[] policySetIdArray) throws RegistryException {
        this.checkContext();
        return this.mDataStore.getComponentList(policySetIdArray, this.mContext);
    }

    public String[] getComponentList() throws RegistryException {
        return this.mDataStore.getComponentList(this.getLayeredPolicySetIds(this.mContext.getEntityId()), this.mContext);
    }

    public ConfigNode createNode(String string, NodeType nodeType, PolicySetId policySetId, boolean bl) throws RegistryException {
        this.checkContext();
        return this.mConfigDataManager.createNode(string, nodeType, (PolicyGroupIdImpl)policySetId, bl, this.mContext);
    }

    public PolicySetId getPolicyGroupId(String string) throws RegistryException {
        this.checkContext();
        return this.mDataStore.getPolicyGroupId(string, this.mContext);
    }

    public PolicySetId getPolicyGroupId(EntityId entityId, PolicyGroupUse policyGroupUse) throws RegistryException {
        this.checkContext();
        return this.mDataStore.getPolicyGroupId(entityId, policyGroupUse, this.mContext);
    }

    public PolicySetId getPolicyGroupId(String string, EntityId entityId, PolicyGroupUse policyGroupUse, int n) throws RegistryException {
        this.checkContext();
        return this.mDataStore.getPolicyGroupId(string, entityId, policyGroupUse, n, this.mContext);
    }

    public EntityId getEntityId(String string) throws RegistryException {
        return EntityId.getEntityId(string);
    }

    public EntityId getEntityIdFromLocation(String string) throws RegistryException {
        this.checkContext();
        return this.mOrganization.getEntityIdFromLocation(string, this.mContext);
    }

    private Locale createLocaleObjectFromLocaleName(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        Locale locale = null;
        switch (stringTokenizer.countTokens()) {
            case 1: {
                locale = new Locale(string);
                break;
            }
            case 2: {
                locale = new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken());
                break;
            }
            case 3: {
                locale = new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
            }
        }
        return locale;
    }

    private void checkContext() throws RegistryException {
        if (this.mContext == null) {
            throw new RegistryException("No context has been established.", "error.occurred", MODULE, 0);
        }
    }

    private ImporterExporter getImpExp(int n) throws RegistryException {
        switch (n) {
            case 1: {
                return new ZipImporterExporter(this.mDataStore);
            }
        }
        throw new RegistryException("Unknown import/export format", "error.export.policygroup", MODULE, 0);
    }

    public void exportPolicyGroup(PolicySetId policySetId, OutputStream outputStream) throws RegistryException {
        this.exportPolicyGroup((PolicyGroupIdImpl)policySetId, outputStream, 1);
    }

    public void exportPolicyGroup(PolicySetId policySetId, OutputStream outputStream, int n) throws RegistryException {
        if (policySetId == null || outputStream == null) {
            throw new RegistryException("Invalid parameters for method that exports a policy group.", "error.occurred", MODULE, 0);
        }
        ImporterExporter importerExporter = this.getImpExp(n);
        importerExporter.exportPolicyGroup((PolicyGroupIdImpl)policySetId, outputStream, this.mContext);
    }

    public void importPolicyGroup(PolicySetId policySetId, InputStream inputStream) throws RegistryException {
        this.importPolicyGroup((PolicyGroupIdImpl)policySetId, inputStream, 1);
    }

    public void importPolicyGroup(PolicySetId policySetId, InputStream inputStream, int n) throws RegistryException {
        if (policySetId == null || inputStream == null) {
            throw new RegistryException("Invalid parameters for method that imports a policy group.", "error.occurred", MODULE, 0);
        }
        ImporterExporter importerExporter = this.getImpExp(n);
        importerExporter.importPolicyGroup((PolicyGroupIdImpl)policySetId, inputStream, this.mContext);
    }

    public String getDatastoreType() {
        return this.mBootstrapData.getDataStoreType();
    }

    public String getDatastoreHostInfo() {
        String string = this.mBootstrapData.getServer();
        int n = this.mBootstrapData.getPort();
        if (string != null) {
            return string + ":" + n;
        }
        return null;
    }

    public boolean isEntityWritable(EntityId entityId) throws RegistryException {
        return this.mDataStore.isEntityWritable(entityId, this.mContext);
    }

    public boolean isPolicyGroupWritable(PolicySetId policySetId) throws RegistryException {
        if (policySetId == null) {
            return false;
        }
        return this.isEntityWritable(policySetId.getContainerId());
    }
}

