/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class LDAPDN {
    public static boolean equals(String dn1, String dn2) {
        return LDAPDN.normalize(dn1).equals(LDAPDN.normalize(dn2));
    }

    public static String escapeRDN(String rdn) {
        RDN name = new RDN(rdn);
        String[] val = name.getValues();
        if (val == null) {
            return rdn;
        }
        StringBuffer[] buffer = new StringBuffer[val.length];
        StringBuffer retbuf = new StringBuffer();
        String[] types = name.getTypes();
        int j = 0;
        while (j < val.length) {
            buffer[j] = new StringBuffer(val[j]);
            int i = 0;
            while (i < buffer[j].length()) {
                if (LDAPDN.isEscape(buffer[j].charAt(i))) {
                    buffer[j].insert(i, '\\');
                    ++i;
                }
                ++i;
            }
            retbuf.append(String.valueOf(retbuf.length() > 0 ? " + " : "") + types[j] + "=" + new String(buffer[j]));
            ++j;
        }
        return new String(retbuf);
    }

    public static String[] explodeDN(String dn, boolean noTypes) {
        DN name = new DN(dn);
        return name.explodeDN(noTypes);
    }

    public static String[] explodeRDN(String rdn, boolean noTypes) {
        RDN name = new RDN(rdn);
        if (noTypes) {
            return name.getValues();
        }
        String[] str = new String[]{name.toString()};
        return str;
    }

    private static boolean isEscape(char c) {
        int i = 0;
        while (i < DN.ESCAPED_CHAR.length) {
            if (c == DN.ESCAPED_CHAR[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String normalize(String dn) {
        return new DN(dn).toString();
    }

    public static String unEscapeRDN(String rdn) {
        RDN name = new RDN(rdn);
        String[] vals = name.getValues();
        if (vals == null || vals.length < 1) {
            return rdn;
        }
        StringBuffer buffer = new StringBuffer(vals[0]);
        StringBuffer copy = new StringBuffer();
        int i = 0;
        while (i < buffer.length()) {
            char c;
            if ((c = buffer.charAt(i++)) != '\\') {
                copy.append(c);
                continue;
            }
            if (i >= buffer.length()) continue;
            copy.append(buffer.charAt(i++));
        }
        return String.valueOf(name.getTypes()[0]) + "=" + new String(copy);
    }
}

