/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPExtendedResponse;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPAddResponse;
import netscape.ldap.client.opers.JDAPBindResponse;
import netscape.ldap.client.opers.JDAPCompareResponse;
import netscape.ldap.client.opers.JDAPDeleteResponse;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNResponse;
import netscape.ldap.client.opers.JDAPModifyResponse;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPSearchResponse;
import netscape.ldap.client.opers.JDAPSearchResult;
import netscape.ldap.client.opers.JDAPSearchResultReference;

public class LDAPMessage
implements Serializable {
    static final long serialVersionUID = -1364094245850026720L;
    public static final int BIND_REQUEST = 0;
    public static final int BIND_RESPONSE = 1;
    public static final int UNBIND_REQUEST = 2;
    public static final int SEARCH_REQUEST = 3;
    public static final int SEARCH_RESPONSE = 4;
    public static final int SEARCH_RESULT = 5;
    public static final int MODIFY_REQUEST = 6;
    public static final int MODIFY_RESPONSE = 7;
    public static final int ADD_REQUEST = 8;
    public static final int ADD_RESPONSE = 9;
    public static final int DEL_REQUEST = 10;
    public static final int DEL_RESPONSE = 11;
    public static final int MODIFY_RDN_REQUEST = 12;
    public static final int MODIFY_RDN_RESPONSE = 13;
    public static final int COMPARE_REQUEST = 14;
    public static final int COMPARE_RESPONSE = 15;
    public static final int ABANDON_REQUEST = 16;
    public static final int SEARCH_RESULT_REFERENCE = 19;
    public static final int EXTENDED_REQUEST = 23;
    public static final int EXTENDED_RESPONSE = 24;
    private int m_msgid;
    private JDAPProtocolOp m_protocolOp = null;
    private LDAPControl[] m_controls = null;

    LDAPMessage(int msgid, JDAPProtocolOp op) {
        this.m_msgid = msgid;
        this.m_protocolOp = op;
    }

    LDAPMessage(int msgid, JDAPProtocolOp op, LDAPControl[] controls) {
        this.m_msgid = msgid;
        this.m_protocolOp = op;
        this.m_controls = controls;
    }

    public LDAPControl[] getControls() {
        return this.m_controls;
    }

    public int getMessageID() {
        return this.m_msgid;
    }

    JDAPProtocolOp getProtocolOp() {
        return this.m_protocolOp;
    }

    public int getType() {
        return this.m_protocolOp.getType();
    }

    static LDAPMessage parseMessage(BERElement element) throws IOException {
        JDAPProtocolOp l_protocolOp = null;
        LDAPControl[] l_controls = null;
        if (element.getType() != 48) {
            throw new IOException("SEQUENCE in jdap message expected");
        }
        BERSequence seq = (BERSequence)element;
        BERInteger msgid = (BERInteger)seq.elementAt(0);
        int l_msgid = msgid.getValue();
        BERElement protocolOp = seq.elementAt(1);
        if (protocolOp.getType() != -1) {
            throw new IOException("TAG in protocol operation is expected");
        }
        BERTag tag = (BERTag)protocolOp;
        switch (tag.getTag() & 0x1F) {
            case 1: {
                l_protocolOp = new JDAPBindResponse(protocolOp);
                break;
            }
            case 4: {
                l_protocolOp = new JDAPSearchResponse(protocolOp);
                break;
            }
            case 3: 
            case 5: {
                l_protocolOp = new JDAPSearchResult(protocolOp);
                break;
            }
            case 7: {
                l_protocolOp = new JDAPModifyResponse(protocolOp);
                break;
            }
            case 9: {
                l_protocolOp = new JDAPAddResponse(protocolOp);
                break;
            }
            case 11: {
                l_protocolOp = new JDAPDeleteResponse(protocolOp);
                break;
            }
            case 13: {
                l_protocolOp = new JDAPModifyRDNResponse(protocolOp);
                break;
            }
            case 15: {
                l_protocolOp = new JDAPCompareResponse(protocolOp);
                break;
            }
            case 19: {
                l_protocolOp = new JDAPSearchResultReference(protocolOp);
                break;
            }
            case 24: {
                l_protocolOp = new JDAPExtendedResponse(protocolOp);
                break;
            }
            default: {
                throw new IOException("Unknown protocol operation");
            }
        }
        if (seq.size() >= 3 && (tag = (BERTag)seq.elementAt(2)).getTag() == 160) {
            BERSequence controls = (BERSequence)tag.getValue();
            l_controls = new LDAPControl[controls.size()];
            int i = 0;
            while (i < controls.size()) {
                l_controls[i] = LDAPControl.parseControl(controls.elementAt(i));
                ++i;
            }
        }
        if (l_protocolOp instanceof JDAPSearchResponse) {
            return new LDAPSearchResult(l_msgid, (JDAPSearchResponse)l_protocolOp, l_controls);
        }
        if (l_protocolOp instanceof JDAPSearchResultReference) {
            return new LDAPSearchResultReference(l_msgid, (JDAPSearchResultReference)l_protocolOp, l_controls);
        }
        if (l_protocolOp instanceof JDAPExtendedResponse) {
            return new LDAPExtendedResponse(l_msgid, (JDAPExtendedResponse)l_protocolOp, l_controls);
        }
        return new LDAPResponse(l_msgid, l_protocolOp, l_controls);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[LDAPMessage] ");
        sb.append(this.m_msgid);
        sb.append(" ");
        sb.append(this.m_protocolOp.toString());
        int i = 0;
        while (this.m_controls != null && i < this.m_controls.length) {
            sb.append(" ");
            sb.append(this.m_controls[i].toString());
            ++i;
        }
        return sb.toString();
    }

    StringBuffer toTraceString() {
        StringBuffer sb = new StringBuffer(" op=");
        sb.append(this.m_msgid);
        sb.append(" ");
        sb.append(this.m_protocolOp.toString());
        int i = 0;
        while (this.m_controls != null && i < this.m_controls.length) {
            sb.append(" ");
            sb.append(this.m_controls[i].toString());
            ++i;
        }
        return sb;
    }

    void write(OutputStream s) throws IOException {
        BERSequence seq = new BERSequence();
        BERInteger i = new BERInteger(this.m_msgid);
        seq.addElement(i);
        BERElement e = this.m_protocolOp.getBERElement();
        if (e == null) {
            throw new IOException("Bad BER element");
        }
        seq.addElement(e);
        if (this.m_controls != null) {
            BERSequence c = new BERSequence();
            int j = 0;
            while (j < this.m_controls.length) {
                c.addElement(this.m_controls[j].getBERElement());
                ++j;
            }
            BERTag t = new BERTag(160, c, true);
            seq.addElement(t);
        }
        seq.write(s);
    }
}

