/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDITContentRuleSchema;
import netscape.ldap.LDAPDITStructureRuleSchema;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMatchingRuleSchema;
import netscape.ldap.LDAPNameFormSchema;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSyntaxSchema;

public class LDAPSchema
implements Serializable {
    static final long serialVersionUID = -3911737419783579398L;
    private Hashtable objectClasses = new Hashtable();
    private Hashtable attributes = new Hashtable();
    private Hashtable matchingRules = new Hashtable();
    private Hashtable syntaxes = new Hashtable();
    private Hashtable structureRulesByName = new Hashtable();
    private Hashtable structureRulesById = new Hashtable();
    private Hashtable contentRules = new Hashtable();
    private Hashtable nameForms = new Hashtable();

    public LDAPSchema() {
    }

    public LDAPSchema(LDAPEntry entry) {
        this.initialize(entry);
    }

    public void addAttribute(LDAPAttributeSchema attrSchema) {
        this.attributes.put(attrSchema.getName().toLowerCase(), attrSchema);
    }

    public void addDITContentRule(LDAPDITContentRuleSchema rule) {
        String name = rule.getName().toLowerCase();
        this.contentRules.put(name, rule);
    }

    public void addDITStructureRule(LDAPDITStructureRuleSchema rule) {
        String name = rule.getName().toLowerCase();
        this.structureRulesByName.put(name, rule);
        this.structureRulesById.put(new Integer(rule.getRuleID()), rule);
    }

    public void addMatchingRule(LDAPMatchingRuleSchema matchSchema) {
        this.matchingRules.put(matchSchema.getName().toLowerCase(), matchSchema);
    }

    public void addNameForm(LDAPNameFormSchema nameForm) {
        String name = nameForm.getName().toLowerCase();
        this.nameForms.put(name, nameForm);
    }

    public void addObjectClass(LDAPObjectClassSchema objectSchema) {
        this.objectClasses.put(objectSchema.getName().toLowerCase(), objectSchema);
    }

    public void addSyntax(LDAPSyntaxSchema syntaxSchema) {
        String name = syntaxSchema.getName().toLowerCase();
        if (name.length() < 1) {
            name = syntaxSchema.getOID();
        }
        this.syntaxes.put(name, syntaxSchema);
    }

    public void fetchSchema(LDAPConnection ld) throws LDAPException {
        this.fetchSchema(ld, "");
    }

    public void fetchSchema(LDAPConnection ld, String dn) throws LDAPException {
        String entryName = LDAPSchema.getSchemaDN(ld, dn);
        LDAPEntry entry = LDAPSchema.readSchema(ld, entryName);
        this.initialize(entry);
    }

    public LDAPAttributeSchema getAttribute(String name) {
        return (LDAPAttributeSchema)this.attributes.get(name.toLowerCase());
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Enumeration getAttributes() {
        return this.attributes.elements();
    }

    public LDAPDITContentRuleSchema getDITContentRule(String name) {
        return (LDAPDITContentRuleSchema)this.contentRules.get(name.toLowerCase());
    }

    public Enumeration getDITContentRuleNames() {
        return this.contentRules.keys();
    }

    public Enumeration getDITContentRules() {
        return this.contentRules.elements();
    }

    public LDAPDITStructureRuleSchema getDITStructureRule(int ID) {
        return (LDAPDITStructureRuleSchema)this.structureRulesById.get(new Integer(ID));
    }

    public LDAPDITStructureRuleSchema getDITStructureRule(String name) {
        return (LDAPDITStructureRuleSchema)this.structureRulesByName.get(name.toLowerCase());
    }

    public Enumeration getDITStructureRuleNames() {
        return this.structureRulesByName.keys();
    }

    public Enumeration getDITStructureRules() {
        return this.structureRulesByName.elements();
    }

    public LDAPMatchingRuleSchema getMatchingRule(String name) {
        return (LDAPMatchingRuleSchema)this.matchingRules.get(name.toLowerCase());
    }

    public Enumeration getMatchingRuleNames() {
        return this.matchingRules.keys();
    }

    public Enumeration getMatchingRules() {
        return this.matchingRules.elements();
    }

    public LDAPNameFormSchema getNameForm(String name) {
        return (LDAPNameFormSchema)this.nameForms.get(name.toLowerCase());
    }

    public Enumeration getNameFormNames() {
        return this.nameForms.keys();
    }

    public Enumeration getNameForms() {
        return this.nameForms.elements();
    }

    public LDAPObjectClassSchema getObjectClass(String name) {
        return (LDAPObjectClassSchema)this.objectClasses.get(name.toLowerCase());
    }

    public Enumeration getObjectClassNames() {
        return this.objectClasses.keys();
    }

    public Enumeration getObjectClasses() {
        return this.objectClasses.elements();
    }

    static String getSchemaDN(LDAPConnection ld, String dn) throws LDAPException {
        Enumeration en;
        if (ld == null || !ld.isConnected()) {
            throw new LDAPException("No connection", 80);
        }
        String[] attrs = new String[]{"subschemasubentry"};
        LDAPEntry entry = ld.read(dn, attrs);
        if (entry == null) {
            throw new LDAPException("", 32);
        }
        LDAPAttribute attr = entry.getAttribute(attrs[0]);
        String entryName = "cn=schema";
        if (attr != null && (en = attr.getStringValues()).hasMoreElements()) {
            entryName = (String)en.nextElement();
        }
        return entryName;
    }

    public LDAPSyntaxSchema getSyntax(String name) {
        return (LDAPSyntaxSchema)this.syntaxes.get(name.toLowerCase());
    }

    public Enumeration getSyntaxNames() {
        return this.syntaxes.keys();
    }

    public Enumeration getSyntaxes() {
        return this.syntaxes.elements();
    }

    protected void initialize(LDAPEntry entry) {
        LDAPMatchingRuleSchema sch;
        LDAPSchemaElement sch2;
        Enumeration en;
        LDAPAttribute attr = entry.getAttribute("objectclasses");
        if (attr != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPObjectClassSchema((String)en.nextElement());
                this.addObjectClass((LDAPObjectClassSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("attributetypes")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPAttributeSchema((String)en.nextElement());
                this.addAttribute((LDAPAttributeSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("ldapsyntaxes")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPSyntaxSchema((String)en.nextElement());
                this.addSyntax((LDAPSyntaxSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("ldapditstructurerules")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPDITStructureRuleSchema((String)en.nextElement());
                this.addDITStructureRule((LDAPDITStructureRuleSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("ldapditcontentrules")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPDITContentRuleSchema((String)en.nextElement());
                this.addDITContentRule((LDAPDITContentRuleSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("nameforms")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPNameFormSchema((String)en.nextElement());
                this.addNameForm((LDAPNameFormSchema)sch2);
            }
        }
        Hashtable<String, String> h = new Hashtable<String, String>();
        attr = entry.getAttribute("matchingruleuse");
        if (attr != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                String use = (String)en.nextElement();
                sch = new LDAPMatchingRuleSchema(null, use);
                h.put(sch.getOID(), use);
            }
        }
        if ((attr = entry.getAttribute("matchingrules")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                String raw = (String)en.nextElement();
                sch = new LDAPMatchingRuleSchema(raw, null);
                String use = (String)h.get(sch.getOID());
                if (use != null) {
                    sch = new LDAPMatchingRuleSchema(raw, use);
                }
                this.addMatchingRule(sch);
            }
        }
    }

    static boolean isAttributeSyntaxStandardsCompliant(LDAPConnection ld) throws LDAPException {
        Enumeration en;
        String[] attrs;
        String schemaBug = (String)ld.getProperty("com.netscape.ldap.schema.quoting");
        if (schemaBug != null) {
            return schemaBug.equalsIgnoreCase("standard");
        }
        boolean compliant = true;
        String entryName = LDAPSchema.getSchemaDN(ld, "");
        LDAPEntry entry = ld.read(entryName, attrs = new String[]{"attributetypes"});
        LDAPAttribute attr = entry.getAttribute("attributetypes");
        if (attr != null && (en = attr.getStringValues()).hasMoreElements()) {
            compliant = LDAPSchema.isSyntaxQuoted((String)en.nextElement()) ^ true;
        }
        ld.setProperty("com.netscape.ldap.schema.quoting", compliant ? "standard" : "NetscapeBug");
        return compliant;
    }

    static boolean isSyntaxQuoted(String raw) {
        int ind = raw.indexOf(" SYNTAX ");
        if (ind >= 0) {
            int l = raw.length() - (ind += 8);
            char[] ch = new char[l];
            raw.getChars(ind, raw.length(), ch, 0);
            ind = 0;
            while (ind < ch.length && ch[ind] == ' ') {
                ++ind;
            }
            if (ind < ch.length) {
                return ch[ind] == '\'';
            }
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: netscape.ldap.LDAPSchema HOST PORT");
            System.exit(1);
        }
        int port = Integer.parseInt(args[1]);
        LDAPConnection ld = new LDAPConnection();
        try {
            ld.connect(args[0], port);
            LDAPSchema schema = new LDAPSchema();
            schema.fetchSchema(ld);
            ld.disconnect();
            System.out.println("Object classes: ");
            LDAPSchema.printEnum(schema.getObjectClasses());
            System.out.println("\nAttributes: ");
            LDAPSchema.printEnum(schema.getAttributes());
            System.out.println("\nMatching rules: ");
            LDAPSchema.printEnum(schema.getMatchingRules());
            System.out.println("\nSyntaxes: ");
            LDAPSchema.printEnum(schema.getSyntaxes());
            System.exit(0);
        }
        catch (LDAPException e) {
            System.err.println(e);
        }
    }

    private static void printEnum(Enumeration en) {
        while (en.hasMoreElements()) {
            LDAPSchemaElement s = (LDAPSchemaElement)en.nextElement();
            System.out.println("  " + s);
        }
    }

    private static LDAPEntry readSchema(LDAPConnection ld, String dn) throws LDAPException {
        return LDAPSchema.readSchema(ld, dn, new String[]{"*", "ldapSyntaxes", "matchingRules", "attributeTypes", "objectClasses"});
    }

    private static LDAPEntry readSchema(LDAPConnection ld, String dn, String[] attrs) throws LDAPException {
        LDAPSearchResults results = ld.search(dn, 0, "objectclass=subschema", attrs, false);
        if (!results.hasMoreElements()) {
            throw new LDAPException("Cannot read schema", 50);
        }
        return results.next();
    }

    public String toString() {
        String s = "Object classes:\n";
        Enumeration en = this.getObjectClasses();
        while (en.hasMoreElements()) {
            s = String.valueOf(s) + en.nextElement().toString();
            s = String.valueOf(s) + '\n';
        }
        s = String.valueOf(s) + "Attributes:\n";
        en = this.getAttributes();
        while (en.hasMoreElements()) {
            s = String.valueOf(s) + en.nextElement().toString();
            s = String.valueOf(s) + '\n';
        }
        s = String.valueOf(s) + "Matching rules:\n";
        en = this.getMatchingRules();
        while (en.hasMoreElements()) {
            s = String.valueOf(s) + en.nextElement().toString();
            s = String.valueOf(s) + '\n';
        }
        s = String.valueOf(s) + "Syntaxes:\n";
        en = this.getSyntaxes();
        while (en.hasMoreElements()) {
            s = String.valueOf(s) + en.nextElement().toString();
            s = String.valueOf(s) + '\n';
        }
        return s;
    }
}

