/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.util.RDN;

public final class DN
implements Serializable {
    private Vector m_rdns = new Vector();
    public static int RFC = 0;
    public static int OSF = 1;
    private int m_dnType = RFC;
    static final long serialVersionUID = -8867457218975952548L;
    public static final char[] ESCAPED_CHAR = new char[]{',', '+', '\"', '\\', '<', '>', ';'};

    public DN() {
    }

    public DN(String dn) {
        String neutralDN = this.neutralizeEscapes(dn);
        if (neutralDN == null) {
            return;
        }
        if (neutralDN.indexOf(44) != -1 || neutralDN.indexOf(59) != -1) {
            this.parseRDNs(neutralDN, dn, ",;");
        } else if (dn.indexOf(47) != -1) {
            this.m_dnType = OSF;
            StringTokenizer st = new StringTokenizer(dn, "/");
            Vector<RDN> rdns = new Vector<RDN>();
            while (st.hasMoreTokens()) {
                String rdn = st.nextToken();
                if (RDN.isRDN(rdn)) {
                    rdns.addElement(new RDN(rdn));
                    continue;
                }
                return;
            }
            int i = rdns.size() - 1;
            while (i >= 0) {
                this.m_rdns.addElement(rdns.elementAt(i));
                --i;
            }
        } else if (RDN.isRDN(dn)) {
            this.m_rdns.addElement(new RDN(dn));
        }
    }

    public void addRDN(RDN rdn) {
        if (this.m_dnType == RFC) {
            this.addRDNToFront(rdn);
        } else {
            this.addRDNToBack(rdn);
        }
    }

    public void addRDNToBack(RDN rdn) {
        this.m_rdns.addElement(rdn);
    }

    public void addRDNToFront(RDN rdn) {
        this.m_rdns.insertElementAt(rdn, 0);
    }

    public boolean contains(DN dn) {
        return this.isDescendantOf(dn);
    }

    public int countRDNs() {
        return this.m_rdns.size();
    }

    public boolean equals(DN dn) {
        return dn.toRFCString().toUpperCase().equals(this.toRFCString().toUpperCase());
    }

    public String[] explodeDN(boolean noTypes) {
        if (this.m_rdns.size() == 0) {
            return null;
        }
        String[] str = new String[this.m_rdns.size()];
        int i = 0;
        while (i < this.m_rdns.size()) {
            str[i] = noTypes ? ((RDN)this.m_rdns.elementAt(i)).getValue() : ((RDN)this.m_rdns.elementAt(i)).toString();
            ++i;
        }
        return str;
    }

    public int getDNType() {
        return this.m_dnType;
    }

    public DN getParent() {
        DN newdn = new DN();
        int i = this.m_rdns.size() - 1;
        while (i > 0) {
            newdn.addRDN((RDN)this.m_rdns.elementAt(i));
            --i;
        }
        return newdn;
    }

    public Vector getRDNs() {
        return this.m_rdns;
    }

    public static boolean isDN(String dn) {
        if (dn.equals("")) {
            return true;
        }
        DN newdn = new DN(dn);
        return newdn.countRDNs() > 0;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isDescendantOf(DN dn) {
        rdns1 = dn.m_rdns;
        rdns2 = this.m_rdns;
        i = rdns1.size() - 1;
        j = rdns2.size() - 1;
        if (j >= i && !this.equals(dn)) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            rdn1 = (RDN)rdns1.elementAt(i);
            rdn2 = (RDN)rdns2.elementAt(j);
            if (!rdn2.equals(rdn1)) {
                return false;
            }
            --i;
            --j;
lbl13:
            // 2 sources

            ** while (i >= 0 && j >= 0)
        }
lbl14:
        // 1 sources

        return true;
    }

    public boolean isRFC() {
        return this.m_dnType == RFC;
    }

    private String neutralizeEscapes(String dn) {
        String neutralDN = RDN.neutralizeEscapes(dn);
        if (neutralDN == null) {
            return null;
        }
        String dn2 = neutralDN.trim();
        if (dn2.length() == 0) {
            return neutralDN;
        }
        if (dn2.charAt(0) == ';' || dn2.charAt(0) == ',') {
            return null;
        }
        int lastIdx = dn2.length() - 1;
        if (dn2.charAt(lastIdx) == ';' || dn2.charAt(lastIdx) == ',') {
            return null;
        }
        return neutralDN;
    }

    private void parseRDNs(String neutralDN, String dn, String sep) {
        int startIdx = 0;
        int endIdx = 0;
        RDN rdn = null;
        StringTokenizer tok = new StringTokenizer(neutralDN, sep);
        while (tok.hasMoreElements()) {
            String neutralRDN = tok.nextToken();
            endIdx = startIdx + neutralRDN.length();
            rdn = new RDN(dn.substring(startIdx, endIdx));
            if (rdn.getTypes() == null) {
                this.m_rdns.removeAllElements();
                return;
            }
            this.m_rdns.addElement(rdn);
            startIdx = endIdx + 1;
        }
    }

    public void setDNType(int type) {
        this.m_dnType = type;
    }

    public String toOSFString() {
        String dn = "";
        int i = 0;
        while (i < this.m_rdns.size()) {
            if (i != 0) {
                dn = "/" + dn;
            }
            RDN rdn = (RDN)this.m_rdns.elementAt(i);
            dn = String.valueOf(rdn.toString()) + dn;
            ++i;
        }
        return dn;
    }

    public String toRFCString() {
        String dn = "";
        int i = 0;
        while (i < this.m_rdns.size()) {
            if (i != 0) {
                dn = String.valueOf(dn) + ",";
            }
            dn = String.valueOf(dn) + ((RDN)this.m_rdns.elementAt(i)).toString();
            ++i;
        }
        return dn;
    }

    public String toString() {
        if (this.m_dnType == RFC) {
            return this.toRFCString();
        }
        return this.toOSFString();
    }
}

