/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.templates.parsing;

import com.sun.apoc.manager.resource.ResourceRepository;
import com.sun.apoc.templates.parsing.NarratedElement;
import com.sun.apoc.templates.parsing.TemplateActionHandler;
import com.sun.apoc.templates.parsing.TemplateCategory;
import com.sun.apoc.templates.parsing.TemplatePage;
import com.sun.apoc.templates.parsing.TemplateProperty;
import com.sun.apoc.templates.parsing.TemplateSection;
import com.sun.apoc.templates.parsing.TemplateSet;
import com.sun.apoc.templates.parsing.TemplateXMLHandler;
import com.sun.web.ui.common.CCDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TemplateRepository {
    public static final String TEMPLATE_PATH_SEPARATOR = "/";
    public static final String SET_PREFIX = "SET_";
    public static final String SET_INDEX_SEPARATOR = "|";
    public static final String DEFAULT_PACKAGE_DIR = "/packages";
    public static final String DEFAULT_TEMPLATE_DIR = File.separator + "templates" + File.separator;
    public static final String TEMPLATE_EXTENSION = ".xml";
    public static final String JAR_EXTENSION = ".jar";
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final String ROOT_CATEGORY_NAME = "Policies";
    private static TemplateRepository m_defaultRepository = null;
    private static Thread m_initializerThread = null;
    private File m_templatesDir = null;
    private File m_DTDLocation = null;
    private boolean m_bInitialized = false;
    private SAXParser m_parser = null;
    private TemplateCategory m_templateRoot = null;

    public static TemplateRepository getDefaultRepository() {
        if (m_defaultRepository == null) {
            m_defaultRepository = new TemplateRepository();
        }
        return m_defaultRepository;
    }

    protected TemplateRepository() {
        CCDebug.initTrace();
    }

    public HashMap getTopLevelCategories() {
        this.isInitialized();
        return this.m_templateRoot.getSubCategories();
    }

    public TemplateCategory getCategory(String string) {
        return this.getCategory(string, (byte)3);
    }

    public TemplateCategory getCategory(String string, byte by) {
        this.isInitialized();
        StringTokenizer stringTokenizer = new StringTokenizer(string, TEMPLATE_PATH_SEPARATOR);
        TemplateCategory templateCategory = this.m_templateRoot;
        TemplateCategory templateCategory2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.startsWith(SET_PREFIX)) {
                templateCategory2 = templateCategory.getSubCategory(string2);
            } else {
                TemplatePage templatePage = (TemplatePage)templateCategory;
                TemplateSet templateSet = (TemplateSet)templatePage.getSection(string2.substring(SET_PREFIX.length(), string2.indexOf(SET_INDEX_SEPARATOR)));
                templateCategory2 = templateSet.getPage();
            }
            if (templateCategory2 != null && templateCategory2.isInScope(by)) {
                templateCategory = templateCategory2;
                continue;
            }
            CCDebug.trace1((String)("Category " + string + " not found!"));
            break;
        }
        return templateCategory;
    }

    public TemplatePage getPage(String string) {
        return (TemplatePage)this.getCategory(string);
    }

    public TemplatePage getPage(String string, byte by) {
        return (TemplatePage)this.getCategory(string, by);
    }

    public void initialize() {
        CCDebug.trace2((String)"Initializing template repository.");
        this.m_templateRoot = new TemplatePage(ROOT_CATEGORY_NAME, null, "APOC.policies.root", null, null);
        try {
            this.m_parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            CCDebug.trace1((String)"Error could not initialize template parser!", (Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            CCDebug.trace1((String)"Error could not initialize template parser!", (Throwable)sAXException);
        }
        m_initializerThread = new Thread(){

            public void run() {
                TemplateRepository.this.examineDirectory(TemplateRepository.this.getTemplatesDir());
                TemplateRepository.this.m_parser = null;
                TemplateRepository.this.m_bInitialized = true;
            }
        };
        m_initializerThread.start();
    }

    public boolean isInitialized() {
        try {
            m_initializerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.m_bInitialized;
    }

    public void update() {
        CCDebug.trace2((String)"Update template repository.");
        this.m_bInitialized = false;
        this.initialize();
    }

    public void setTemplatesDir(String string) {
        CCDebug.trace3((String)("Setting templates directory to " + string + "!"));
        this.m_templatesDir = new File(string);
    }

    public void setTemplateDir(File file) {
        CCDebug.trace3((String)("Setting templates directory to " + file.getName() + "!"));
        this.m_templatesDir = file;
    }

    public void setDTDLocation(String string) {
        CCDebug.trace3((String)("Setting DTD location to " + string + "!"));
        this.m_DTDLocation = new File(string);
    }

    public void setDTDLocation(File file) {
        CCDebug.trace3((String)("Setting DTD location to " + file.getName() + "!"));
        this.m_DTDLocation = file;
    }

    public File getTemplatesDir() {
        if (this.m_templatesDir == null) {
            this.setTemplatesDir(DEFAULT_PACKAGE_DIR);
            CCDebug.trace3((String)"No templates directory specified. Using default location (/packages).");
        }
        if (!this.m_templatesDir.exists()) {
            CCDebug.trace1((String)"Templates directory not found. Assuming fresh start. Creating templates directory.");
            this.m_templatesDir.mkdir();
        }
        return this.m_templatesDir;
    }

    protected void examineDirectory(File file) {
        CCDebug.trace3((String)("Examine directory " + file.getAbsolutePath()));
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.examineDirectory(fileArray[i]);
                continue;
            }
            if (fileArray[i].getName().endsWith(TEMPLATE_EXTENSION)) {
                CCDebug.trace2((String)("Found template " + fileArray[i].getName()));
                this.parseTemplate(fileArray[i]);
                continue;
            }
            if (!fileArray[i].getName().endsWith(JAR_EXTENSION) && !fileArray[i].getName().endsWith(PROPERTIES_EXTENSION)) continue;
            CCDebug.trace2((String)("Found resource file " + fileArray[i].getName()));
            ResourceRepository.getDefaultRepository().addResource(fileArray[i]);
        }
    }

    protected void parseTemplate(File file) {
        try {
            CCDebug.trace3((String)("Start parsing of " + file.getName()));
            this.m_parser.parse(file, (DefaultHandler)new TemplateHandler(this.m_templateRoot, this.getTemplatePackageName(file)));
        }
        catch (IOException iOException) {
            CCDebug.trace1((String)("Error opening template " + file.getName() + "!"), (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            CCDebug.trace1((String)("Error parsing template " + file.getName() + "!"), (Throwable)sAXException);
        }
    }

    protected String getTemplatePackageName(File file) {
        String string = file.getAbsolutePath();
        int n = string.indexOf(DEFAULT_TEMPLATE_DIR);
        if (n == -1) {
            return null;
        }
        if ((n = (string = string.substring(0, n)).lastIndexOf(File.separator)) == -1) {
            return null;
        }
        string = string.substring(n + 1);
        return string.toString();
    }

    protected void getContent(StringBuffer stringBuffer, TemplateCategory templateCategory, int n) {
        if (templateCategory.hasSubCategories()) {
            Set set = templateCategory.getSubCategories().keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("       ");
                }
                TemplateCategory templateCategory2 = templateCategory.getSubCategory(string);
                stringBuffer.append(templateCategory2.getDefaultName());
                stringBuffer.append(" (");
                stringBuffer.append(templateCategory2.getResourceId());
                stringBuffer.append(", ");
                stringBuffer.append(templateCategory2.getResourceBundle());
                stringBuffer.append(") ");
                stringBuffer.append("\r\n");
                this.getContent(stringBuffer, templateCategory.getSubCategory(string), n + 1);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\r\n");
        this.getContent(stringBuffer, this.m_templateRoot, 0);
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    class TemplateHandler
    extends DefaultHandler {
        public static final String CATEGORY_TAG = "category";
        public static final String PAGE_TAG = "page";
        public static final String SECTION_TAG = "section";
        public static final String SET_TAG = "set";
        public static final String PROPERTY_TAG = "property";
        public static final String RES_IMPORT_TAG = "resImport";
        public static final String HELP_IMPORT_TAG = "helpImport";
        public static final String INLINE_HELP_TAG = "inlineHelp";
        public static final String ENUMERATION_TAG = "enumeration";
        public static final String VALUE_TAG = "value";
        public static final String VISUAL_TAG = "visual";
        public static final String CHECKBOX_TAG = "checkBox";
        public static final String CHOOSER_TAG = "chooser";
        public static final String RES_ID_ATTR = "apt:resId";
        public static final String LABEL_ATTR = "apt:label";
        public static final String NAME_ATTR = "apt:name";
        public static final String PACKAGE_ATTR = "apt:packagePath";
        public static final String FILE_ATTR = "apt:filePath";
        public static final String VISUAL_TYPE_ATTR = "apt:visualType";
        public static final String VISUAL_TYPE_ATTR2 = "apt:type";
        public static final String DATA_PATH_ATTR = "apt:dataPath";
        public static final String VALUE_ATTR = "oor:value";
        public static final String SEPARATOR_ATTR = "oor:separator";
        public static final String TYPE_ATTR = "oor:type";
        public static final String SCOPE_ATTR = "apt:scope";
        public static final String STORE_ATTR = "apt:storeDefault";
        public static final String INLINE_HELP_ATTR = "apt:inlineHelp";
        public static final String ONLINE_HELP_ATTR = "apt:onlineHelp";
        public static final String LABEL_POST_ATTR = "apt:labelPost";
        public static final String NIL_ATTR = "xsi:nil";
        public static final String EXTRA_HTML_ATTR = "apt:extraHtml";
        public static final String CHOOSER_PATH_ATTR = "apt:dataPath";
        public static final String EXTENDS_CHOOSER_ATTR = "apt:extendsChooser";
        public static final String LABEL_POPUP_ATTR = "apt:labelPopup";
        public static final String XML_HANDLER_TAG = "xmlHandler";
        public static final String ACTION_HANDLER_TAG = "actionHandler";
        public static final String EVENT_TAG = "event";
        public static final String ACTION_TAG = "action";
        public static final String WHEN_TAG = "when";
        public static final String OTHERWISE_TAG = "otherwise";
        public static final String COMMAND_TAG = "command";
        public static final String XML_HANDLER_ATTR = "apt:xmlHandler";
        public static final String ACTION_HANDLER_ATTR = "apt:actionHandler";
        public static final String HANDLER_TYPE_ATTR = "apt:type";
        public static final String TEST_ATTR = "apt:test";
        public static final String CLASS_ATTR = "apt:class";
        public static final String TEMPLATE_SYSTEM_ID = "policytemplate.dtd";
        private String m_packageName = null;
        private String m_resourceBundle = null;
        private String m_helpFile = null;
        private StringBuffer m_buffer = new StringBuffer();
        private LinkedList m_context = new LinkedList();

        public TemplateHandler(TemplateCategory templateCategory, String string) {
            this.m_context.add(templateCategory);
            this.m_packageName = string;
        }

        protected Object getCurrentContext() {
            return this.m_context.getLast();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals(CATEGORY_TAG)) {
                String string4 = attributes.getValue(NAME_ATTR);
                TemplateCategory templateCategory = (TemplateCategory)this.getCurrentContext();
                TemplateCategory templateCategory2 = templateCategory.getSubCategory(string4);
                if (templateCategory2 == null) {
                    String string5 = attributes.getValue(RES_ID_ATTR);
                    if (string5 == null) {
                        string5 = attributes.getValue(LABEL_ATTR);
                    }
                    templateCategory2 = new TemplatePage(string4, attributes.getValue(SCOPE_ATTR), string5, this.m_resourceBundle, templateCategory);
                    templateCategory2.setDescriptionId(attributes.getValue(INLINE_HELP_ATTR));
                    templateCategory.addSubCategory(templateCategory2);
                }
                this.m_context.add(templateCategory2);
            } else if (string3.equals(PAGE_TAG)) {
                String string6 = attributes.getValue(NAME_ATTR);
                if (this.getCurrentContext() instanceof TemplateSet) {
                    TemplateSet templateSet = (TemplateSet)this.getCurrentContext();
                    String string7 = attributes.getValue(RES_ID_ATTR);
                    if (string7 == null) {
                        string7 = attributes.getValue(LABEL_ATTR);
                    }
                    if (attributes.getValue(ONLINE_HELP_ATTR) != null) {
                        this.m_helpFile = attributes.getValue(ONLINE_HELP_ATTR);
                    }
                    TemplatePage templatePage = new TemplatePage(string6, attributes.getValue(SCOPE_ATTR), string7, this.m_resourceBundle, this.m_helpFile, null, this.m_packageName);
                    templatePage.setDataPath(templateSet.getDataPath());
                    templatePage.setDescriptionId(attributes.getValue(INLINE_HELP_ATTR));
                    templateSet.setPage(templatePage);
                    this.m_context.add(templatePage);
                } else {
                    TemplateCategory templateCategory = (TemplateCategory)this.getCurrentContext();
                    TemplateCategory templateCategory3 = templateCategory.getSubCategory(string6);
                    if (templateCategory3 == null) {
                        String string8 = attributes.getValue(RES_ID_ATTR);
                        if (string8 == null) {
                            string8 = attributes.getValue(LABEL_ATTR);
                        }
                        if (attributes.getValue(ONLINE_HELP_ATTR) != null) {
                            this.m_helpFile = attributes.getValue(ONLINE_HELP_ATTR);
                        }
                        templateCategory3 = new TemplatePage(string6, attributes.getValue(SCOPE_ATTR), string8, this.m_resourceBundle, this.m_helpFile, templateCategory, this.m_packageName);
                        templateCategory3.setDescriptionId(attributes.getValue(INLINE_HELP_ATTR));
                        templateCategory.addSubCategory(templateCategory3);
                    }
                    this.m_context.add(templateCategory3);
                }
            } else if (string3.equals(SECTION_TAG)) {
                String string9 = attributes.getValue(RES_ID_ATTR);
                if (string9 == null) {
                    string9 = attributes.getValue(LABEL_ATTR);
                }
                TemplateSection templateSection = new TemplateSection(attributes.getValue(NAME_ATTR), attributes.getValue(SCOPE_ATTR), string9, this.m_resourceBundle);
                TemplatePage templatePage = (TemplatePage)this.getCurrentContext();
                templatePage.addSection(templateSection);
                this.m_context.add(templateSection);
            } else if (string3.equals(XML_HANDLER_TAG)) {
                String string10 = attributes.getValue(NAME_ATTR);
                TemplateXMLHandler templateXMLHandler = new TemplateXMLHandler(string10);
                TemplatePage templatePage = (TemplatePage)this.getCurrentContext();
                templatePage.addXMLHandler(templateXMLHandler);
                this.m_context.add(templateXMLHandler);
            } else if (string3.equals(ACTION_HANDLER_TAG)) {
                String string11 = attributes.getValue(NAME_ATTR);
                String string12 = attributes.getValue(CLASS_ATTR);
                String string13 = this.m_packageName;
                TemplateActionHandler templateActionHandler = new TemplateActionHandler(string11, string12, string13);
                TemplatePage templatePage = (TemplatePage)this.getCurrentContext();
                templatePage.addActionHandler(templateActionHandler);
                this.m_context.add(templateActionHandler);
            } else if (string3.equals(SET_TAG)) {
                String string14 = attributes.getValue(RES_ID_ATTR);
                if (string14 == null) {
                    string14 = attributes.getValue(LABEL_ATTR);
                }
                TemplateSet templateSet = new TemplateSet(attributes.getValue(NAME_ATTR), attributes.getValue(SCOPE_ATTR), string14, this.m_resourceBundle, attributes.getValue("apt:dataPath"), attributes.getValue(LABEL_POPUP_ATTR));
                TemplatePage templatePage = (TemplatePage)this.getCurrentContext();
                templatePage.addSection(templateSet);
                this.m_context.add(templateSet);
            } else if (string3.equals(PROPERTY_TAG)) {
                String string15 = attributes.getValue(RES_ID_ATTR);
                if (string15 == null) {
                    string15 = attributes.getValue(LABEL_ATTR);
                }
                TemplateProperty templateProperty = new TemplateProperty(attributes.getValue(NAME_ATTR), attributes.getValue(SCOPE_ATTR), string15, this.m_resourceBundle, attributes.getValue("apt:dataPath"), attributes.getValue(VISUAL_TYPE_ATTR), attributes.getValue(TYPE_ATTR), attributes.getValue(STORE_ATTR), attributes.getValue(XML_HANDLER_ATTR), attributes.getValue(ACTION_HANDLER_ATTR), attributes.getValue(EXTRA_HTML_ATTR));
                templateProperty.setDescriptionId(attributes.getValue(INLINE_HELP_ATTR));
                TemplateSection templateSection = (TemplateSection)this.getCurrentContext();
                templateSection.addProperty(templateProperty);
                this.m_context.add(templateProperty);
            } else if (string3.equals(VISUAL_TAG)) {
                TemplateProperty templateProperty = (TemplateProperty)this.getCurrentContext();
                templateProperty.setVisualType(attributes.getValue("apt:type"));
            } else if (string3.equals(CHECKBOX_TAG)) {
                TemplateProperty templateProperty = (TemplateProperty)this.getCurrentContext();
                templateProperty.setVisualType(CHECKBOX_TAG);
                String string16 = attributes.getValue(LABEL_POST_ATTR);
                templateProperty.setLabelPost(string16);
            } else if (string3.equals(CHOOSER_TAG)) {
                TemplateProperty templateProperty = (TemplateProperty)this.getCurrentContext();
                templateProperty.setVisualType(CHOOSER_TAG);
                templateProperty.setExtendsChooser(attributes.getValue(EXTENDS_CHOOSER_ATTR));
                templateProperty.setChooserPath(attributes.getValue("apt:dataPath"));
                templateProperty.setLabelPopup(attributes.getValue(LABEL_POPUP_ATTR));
            } else if (string3.equals(RES_IMPORT_TAG)) {
                this.m_resourceBundle = attributes.getValue(PACKAGE_ATTR);
            } else if (string3.equals(HELP_IMPORT_TAG)) {
                this.m_helpFile = attributes.getValue(FILE_ATTR);
            } else if (string3.equals(INLINE_HELP_TAG)) {
                NarratedElement narratedElement = (NarratedElement)this.getCurrentContext();
                narratedElement.setDescriptionId(attributes.getValue(RES_ID_ATTR));
            } else if (string3.equals(ENUMERATION_TAG)) {
                TemplateProperty templateProperty = (TemplateProperty)this.getCurrentContext();
                String string17 = attributes.getValue(RES_ID_ATTR);
                if (string17 == null) {
                    string17 = attributes.getValue(LABEL_ATTR);
                }
                templateProperty.addConstraint(attributes.getValue(VALUE_ATTR), string17);
            } else if (string3.equals(VALUE_TAG)) {
                TemplateProperty templateProperty = (TemplateProperty)this.getCurrentContext();
                String string18 = attributes.getValue(SEPARATOR_ATTR);
                templateProperty.setSeparator(string18);
                templateProperty.setDefaultNilValue(attributes.getValue(NIL_ATTR));
                this.m_buffer.setLength(0);
            } else if (string3.equals(ACTION_TAG)) {
                this.m_context.add(ACTION_TAG);
            } else if (string3.equals(EVENT_TAG)) {
                TemplateXMLHandler templateXMLHandler = (TemplateXMLHandler)this.getCurrentContext();
                templateXMLHandler.addType(attributes.getValue("apt:type"));
            } else if (string3.equals(WHEN_TAG)) {
                TemplateXMLHandler templateXMLHandler = (TemplateXMLHandler)this.m_context.get(this.m_context.size() - 2);
                templateXMLHandler.addTest(attributes.getValue(TEST_ATTR));
                templateXMLHandler.addNewCommandList();
                this.m_context.add(WHEN_TAG);
            } else if (string3.equals(OTHERWISE_TAG)) {
                this.m_context.add(OTHERWISE_TAG);
            } else if (string3.equals(COMMAND_TAG)) {
                this.m_buffer.setLength(0);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.m_buffer.append(cArray, n, n2);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals(PROPERTY_TAG) || string3.equals(SET_TAG) || string3.equals(SECTION_TAG) || string3.equals(OTHERWISE_TAG) || string3.equals(WHEN_TAG) || string3.equals(ACTION_TAG) || string3.equals(XML_HANDLER_TAG) || string3.equals(ACTION_HANDLER_TAG) || string3.equals(PAGE_TAG) || string3.equals(CATEGORY_TAG)) {
                this.m_context.removeLast();
            } else if (string3.equals(VALUE_TAG)) {
                TemplateProperty templateProperty = (TemplateProperty)this.getCurrentContext();
                if (!templateProperty.hasDefaultNilValue()) {
                    templateProperty.setDefaultValue(this.m_buffer.toString());
                }
                this.m_buffer.setLength(0);
            } else if (string3.equals(COMMAND_TAG)) {
                if (((String)this.getCurrentContext()).equals(ACTION_TAG)) {
                    TemplateXMLHandler templateXMLHandler = (TemplateXMLHandler)this.m_context.get(this.m_context.size() - 2);
                    templateXMLHandler.addCommand(this.m_buffer.toString());
                    this.m_buffer.setLength(0);
                } else if (((String)this.getCurrentContext()).equals(WHEN_TAG)) {
                    TemplateXMLHandler templateXMLHandler = (TemplateXMLHandler)this.m_context.get(this.m_context.size() - 3);
                    templateXMLHandler.addWhenCommand(this.m_buffer.toString());
                    this.m_buffer.setLength(0);
                } else if (((String)this.getCurrentContext()).equals(OTHERWISE_TAG)) {
                    TemplateXMLHandler templateXMLHandler = (TemplateXMLHandler)this.m_context.get(this.m_context.size() - 3);
                    templateXMLHandler.addOtherwiseCommand(this.m_buffer.toString());
                    this.m_buffer.setLength(0);
                }
            }
        }

        public InputSource resolveEntity(String string, String string2) {
            if (string2.endsWith(TEMPLATE_SYSTEM_ID) && TemplateRepository.this.m_DTDLocation != null) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(TemplateRepository.this.m_DTDLocation);
                    return new InputSource(fileInputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    CCDebug.trace1((String)"Could not find DTD!", (Throwable)fileNotFoundException);
                    return null;
                }
            }
            return null;
        }
    }
}

