#ifndef Exceptions_hpp
#define Exceptions_hpp

namespace apoc { namespace legacy {

struct Exception
{
    std::string mMessage ;
    Exception(const std::string& aMessage) : mMessage(aMessage) {}
} ;

struct NullPointerException : public Exception
{
    NullPointerException(const std::string& aMessage) : Exception(aMessage) {}
} ;

struct InvalidArgumentException : public Exception
{
    int mArgNumber ;
    InvalidArgumentException(const std::string& aMessage, int aArgNumber) 
    : Exception(aMessage), mArgNumber(aArgNumber)
    {}
} ;

} } // apoc.legacy

#endif // Exceptions_hpp
