<%@ page info="ContentAreaPolicies" language="java" %> 
<%--
 ******************************************************************************* 
 * $RCSfile: ContentAreaPolicies.jsp,v $
 *
 * Description: This file contains the Content Area Policies 
 *
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * Use of this product is subject to license terms.
 *
 *******************************************************************************
 * Source Code Control System - Header
 *
 * $Header: /sgnome/cvsroots/jds/apoc/web/manager/jsp/ContentAreaPolicies.jsp,v 1.14 2005/09/05 12:20:49 tpf Exp $
 *******************************************************************************
--%> 
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%> 
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>
<%@taglib uri="/WEB-INF/apoc.tld" prefix="apoc"%>

<jato:pagelet>
<jato:containerView name="ContentAreaPolicies">
<cc:breadcrumbs name="PolicyBreadcrumb" bundleID="apocBundle"/>

<!-- Alert message -->
<jato:content name="DisplayAlert">
    <div class="content-layout">
        <BR>
        <cc:alertinline name="Alert" bundleID="apocBundle"/>
        <BR>
        <!-- 
            <cc:text name="StackTrace"/>
        -->
    </div>
</jato:content>

<!-- Page Title -->
<cc:pagetitle name="PoliciesPageTitle" bundleID="apocBundle"
    pageTitleText="APOC.policies.title"
    showPageTitleSeparator="true"
    pageTitleHelpMessage="APOC.policies.introtext"
    showPageButtonsTop="false"
    showPageButtonsBottom="false">

<!-- Jump Links section -->
<apoc:jumpLinks name="JumpLinksSection"/>

<!-- Report and Clear buttons -->
<script type="text/javascript">
var reportTooltip='<cc:text name="TooltipReport" />';
</script>
<div class="content-layout">
    <cc:button
      name="ReportButton"
      bundleID="apocBundle" 
      defaultValue="APOC.policies.createrep.button"
      type="secondary"
      onMouseOver="javascript:window.status=''+reportTooltip+''"
      onMouseOut="window.status=''"/>
                  
    <cc:button
      name="ClearButton"
      bundleID="apocBundle" 
      defaultValue="APOC.policies.clear.button"
      type="secondary"/>
</div>  
<br/>


<!-- Policies Navigation Table -->
<jato:content name="PoliciesNavigationArea">
<a name="Policies"/>
<cc:actiontable
    name="PoliciesNavigationTable"
    bundleID="apocBundle"
    title="APOC.policies.title"
    summary="APOC.policies.tableSummary"
    selectionType="no select" 
    showAdvancedSortIcon="false"
    showLowerActions="false"
    showPaginationControls="false"
    showPaginationIcon="false"
    showSelectionIcons="false"
    maxRows="20"
    page="1"/>
</jato:content>    
    

<!-- Policy Template Content -->
<script type="text/javascript">
function getOtherId() {
    var tab = parent.navigation.document.NavigationAreaForm['NavigationArea.Tab'].value;

    if (tab == '2' || tab == '3') {
        otherId = parent.navigation.document.NavigationAreaForm['NavigationArea.HostTreeViewedId'].value;
    } else if (tab == '5' || tab == '6') {
        otherId = parent.navigation.document.NavigationAreaForm['NavigationArea.UserTreeViewedId'].value;
    } else {
        otherId = 'error';
    }
    return otherId;
}


function getViewedId() {
    var fromNavViewedId = parent.navigation.document.NavigationAreaForm['NavigationArea.ViewedEntityId'].value;
    return fromNavViewedId;
}


function requestUserInput(buttonTag) {
    var returnValue = prompt('<cc:text name="PropertyDialog" bundleID="apocBundle" defaultValue="APOC.policies.name.question"/>','');
    if (returnValue=='' || returnValue==null) return false;
    var f=document.ContentAreaForm;
    f.elements['UserInput'].value = returnValue;
    return true;
}

function requestSetPropertyName(buttonTag, alertText) {
    var returnValue = prompt(alertText,'');
    if (returnValue=='' || returnValue==null) return false;
    var f=document.ContentAreaForm;
    f.elements['UserInput'].value = returnValue;
    return true;
}

function viewEntity(entity) {
    if (parent.navigation.document!=null) {
        var f=parent.navigation.document.NavigationAreaForm;
        if (f!=null) {
            f.action="../manager/NavigationArea?NavigationArea.DefaultHref='default'&&NameHref=" + entity + "&";
            f.submit();
        }
    }
    return false;
}

function submitCurrentSelection(hrefTag) {
    var f=document.ContentAreaForm;
    var selection = f.elements['ContentArea.PolicyTemplateSelection'];
    selection.value = unescape(hrefTag.href.substring(hrefTag.href.indexOf('=')+1, hrefTag.href.length));
    f.action="/apoc/manager/ContentArea?ContentArea.DefaultHref='default'"
    f.submit();
    return false;
}

function handleActionMenu(menu) {
    var f = document.ContentAreaForm;
    var sectionId = menu.name.substring(0, menu.name.indexOf('ActionMenu'));
    var checkboxId = sectionId + 'PoliciesSectionTable.SelectionCheckbox';
    var checkbox = null;
    var numOfSettings = getNumberOfSettingsInSection(sectionId) ;
    for(var row = 0; row < numOfSettings; row++) {
        checkbox = f.elements[checkboxId + row] ;
        if ((checkbox != null) && (checkbox.checked == true)) {
            performAction(sectionId, row, menu.selectedIndex);
            checkbox.checked = false;                
        }
    }
    menu.selectedIndex = 0;
}

function getNumberOfSettingsInSection(sectionId) {
    var f = document.ContentAreaForm;
    var middle = 'PoliciesSectionTiledView[';
    var end = '].DefaultValue';
    var numOfSettings = 0;
    for(var i = 0; (defaultValue = f.elements[sectionId + middle + i + end]) != null; i++) {
        numOfSettings = i + 1;
    }
    return numOfSettings ;
}

function performAction(sectionId, index, action) {
    var f = document.ContentAreaForm;
    var id = null;
    if (index != -1) {
        id = sectionId + 'PoliciesSectionTiledView[' + index + '].';
    } else {
        id = sectionId;
    }
    
    var actionField = f.elements[id + 'PropertyStatusValue'];
    var property = f.elements[id + 'PropertyValue'];
    var defaultSetting = f.elements[id + 'DefaultValue'];
    var previousSetting = f.elements[id + 'PreviousValue'];
    var actionValue = 0;
    if (actionField.value.length > 0) {
        actionValue = parseInt(actionField.value);
    }
    
    switch(action) {
        case 1:
            displayProtectedIcon(id);
            actionValue = actionValue & 12;
            actionField.value = actionValue | 2;
            break;
        case 2:
            displayUnprotectedIcon(id);
            actionValue = actionValue & 12;
            actionField.value = actionValue | 1;
            break;
        case 3:
            if ((defaultSetting.value.indexOf("_UNDEFINED_") == -1) 
                   && (defaultSetting.value.indexOf("_NIL_") == -1)) {                   
                displayNewValue(property, defaultSetting.value);
            } else {
                displayNewValue(property, '');
            }
            displayUnprotectedIcon(id);
            displayUndefinedIcon(id);
            xmlHandlerFunctions();
            actionField.value = 4;
            break;
        case 4:
            if (defaultSetting.value.indexOf("_UNDEFINED_") == -1) {
                displayDefinedIcon(id);
                if (defaultSetting.value.indexOf("_NIL_") == -1) {
                    displayNewValue(property, defaultSetting.value);
                } else {
                    displayNewValue(property, '');
                }
                actionField.value = actionValue | 8;
            }
            xmlHandlerFunctions();
            break;
        case 5:
            displayDefinedIcon(id);
            var newSetting = getValue(property) ;
            if ((previousSetting.value == newSetting) &&
               (defaultSetting.value == newSetting)) {
                displayUndefinedIcon(id);
            }
            // reset pending clear and apply default action
            actionField.value = actionValue & 3; 
            break;        
    }
}


function displayProtectedIcon(id) {
    var imageId = id + 'PropertyStatus2';
    document.images[imageId].src='../images/icon_protected_here.png';
}

function displayUnprotectedIcon(id) {
    var imageId = id + 'PropertyStatus2';
    document.images[imageId].src='../images/icon_empty.png';
}

function displayDefinedIcon(id) {
    var imageId = id + 'PropertyStatus';
    document.images[imageId].src='../images/icon_set_here.png';
    document.images[imageId].alt='';
}

function displayUndefinedIcon(id) {
    var imageId = id + 'PropertyStatus';
    document.images[imageId].src='../images/icon_empty.png';
}


function getValue(inputElement) {
    if (inputElement.type=='checkbox') {
        if (inputElement.checked==true) {
            return 'true';
        } else {
            return 'false';
        }
    } else if (inputElement.options!=null) {
        return inputElement.options[inputElement.selectedIndex].value
    } else if (inputElement.length!=null) {
        for (z=0; z<inputElement.length; z++) {
            if (inputElement[z].checked==true) {
                return inputElement[z].value;
            }
        }
    } else {
        return inputElement.value;
    }
}


function displayNewValue(inputElement, newValue) {
    if (inputElement.type=='checkbox') {
        //inputElement.value=newValue;
        if (newValue=='true') {
            inputElement.checked='checked';
        } else {
            inputElement.checked='';
        }
    } else if (inputElement.options!=null) {
        for (z=0; z<inputElement.options.length; z++) {
            if (inputElement.options[z].value==newValue) {
                inputElement.selectedIndex=z;
            }
        }
    } else if (inputElement.length!=null) {
        for (z=0; z<inputElement.length; z++) {
            if (inputElement[z].value==newValue) {
                inputElement[z].checked='checked';
            } else {
                inputElement[z].checked='';
            }
        }
    } else {
        inputElement.value=newValue;
        //Special handling for colorChoosers - need to update colorsquare and dropdown
        if (document.getElementById("colorsquare"+escape(inputElement.name)) != null) {
            updateColorChooserExtras(escape(inputElement.name), newValue);
        }        
        // special handling for list boxes (see bug #b5006410#)
        displayListItems(inputElement.name, newValue);
    }
}

function displayListItems(valueFieldId, newValue) {
    var f=document.ContentAreaForm;
    var listBox = f.elements['List' + valueFieldId];
    var separator = f.elements['Separator' + valueFieldId];
    if (listBox != null) {
        listBox.length = 0;
        valueArray = newValue.split(separator.value);
        valueArray.sort();
        for(var i = 0; i < valueArray.length; i++) {
            listBox[i] = new Option(valueArray[i], valueArray[i]);
        }        
    }
}


function addNewListItem(valueFieldId, separator) {
    if (requestUserInput(null) != true) return;
    var f = document.ContentAreaForm;
    var newEntry = f.elements['UserInput'].value
    var selection = f.elements['List' + valueFieldId];
    for(var i = selection.length; i > 0; i--) {
        selection[i] = new Option(selection.options[i-1].value, selection.options[i-1].value);
    }
    selection[0]  = new Option(newEntry, newEntry);
    selection.selectedIndex = 0;
    
    var hidden = f.elements[valueFieldId];
    var buffer = newEntry;
    var text = hidden.value;
    if (text.length > 0) {
        buffer = buffer + separator + text;
    }
    hidden.value = buffer;
}


function removeListItem(valueFieldId, separator) {
    var f=document.ContentAreaForm;
    var selection = f.elements['List' + valueFieldId];
    if (selection.selectedIndex != -1) {
        var hidden = f.elements[valueFieldId];
        for(var i=0; i < selection.length; i++) {
            if (selection[i].selected == true) {
                selection[i] = null;
                i = i - 1;
            }
        }
        selection.selectedIndex = -1;
        var buffer = '';
        for(var i = 0; i < selection.length; i++) {
            buffer = buffer + selection.options[i].value;
            if (i < selection.length -1) {
                buffer = buffer + separator;
            }
        }
        hidden.value = buffer;
    }
}

var chooserName = null ;
var chooserID = null ;
var colorFieldName = null ;


function setChooserName(buttonName) {
    chooserName = buttonName ;
    return true ;
}


function setChooserID(id) {
    chooserID = id;
    return true ;
}


function getChooserID() {
    return chooserID ;
}

function getChooserName() {
    return chooserName ;
}

function setColorChooserName(buttonName) {
    var cutStringPoint = buttonName.lastIndexOf(".");
    colorFieldName = buttonName.substring(0, cutStringPoint).concat(".ColorNameDropDown") ;
    return true ;
}

function getColorChooserName() {
    return colorFieldName ;
}


function updateChoosers(optionsArray) {
    var f = document.ContentAreaForm ;
    var cutStringPoint = chooserName.lastIndexOf(".") ;
    chooserBtnName = chooserName.substring(cutStringPoint + 1, chooserName.length) ;
    //Runs through all elements in content area and checks if they are chooser buttons of 
    //of the correct type(i.e of the type that clicked the 'Edit' button) - 
    //then uses the chooser button name to create the drop-down menu name
    for(var i=0; i < f.elements.length; i++) {
        cutStringPoint = f.elements[i].name.lastIndexOf(".") ;
        elementName = f.elements[i].name.substring(cutStringPoint + 1, f.elements[i].name.length) ;
        if(elementName == chooserBtnName) {
            var cutStringPoint = f.elements[i].name.lastIndexOf(".");
            var dropDownMenuName = f.elements[i].name.substring(0, cutStringPoint).concat(".PropertyValue") ;
            var selectedListIndex = f[dropDownMenuName].selectedIndex ;
            var selectedListName = f[dropDownMenuName].options[selectedListIndex].text ;
            f[dropDownMenuName].options.length = 0 ;
            //Adds new options to drop-down menu
            for(var j=0; j < optionsArray.length; j++){
                f[dropDownMenuName].options[j] = new Option(optionsArray[j], optionsArray[j]) ;
                if(selectedListName.match(f[dropDownMenuName].options[j].text)) {
                    selectedListIndex = j ;
                }
            }
            //Resets the selected index to its correct value after adding option
            f[dropDownMenuName].options[selectedListIndex].selected=true;
        }
    }    
}

function updateColorChoosers(colorNames, colorValues) {
    var colorNamesLength = 0;
    var contentDocForm = document.ContentAreaForm ;
    var localizedNoName = parent.top.masthead.EditColorWindow.localizedNoName ;

    //Runs through all elements in content area and checks if they are colorchoosers buttons
    //then uses the colorchooser button name to create the drop-down menu name
    for(var i=0; i < contentDocForm.elements.length; i++) {
        if(contentDocForm.elements[i].name.search("ColorNameDropDown") != -1) {
            var dropDownMenuName = contentDocForm.elements[i].name;
            var selectedColorIndex = contentDocForm[dropDownMenuName].selectedIndex;
            var selectedColorName = contentDocForm[dropDownMenuName].options[selectedColorIndex].text;
            //Adds default options to drop-down menu
            contentDocForm[dropDownMenuName].options[0] = new Option(localizedNoName, "");
            if(selectedColorName==contentDocForm[dropDownMenuName].options[0].text) {
                selectedColorIndex = 0 ;
            }
            for(var j=0; j < colorNames.length; j++){
                contentDocForm[dropDownMenuName].options[j+1] = new Option(colorNames[j], colorValues[j]);
                if(selectedColorName==contentDocForm[dropDownMenuName].options[j+1].text) {
                    selectedColorIndex = j+1 ;
                }
            }
            //Resets the selected index to its correct value after adding option
            contentDocForm[dropDownMenuName].options[selectedColorIndex].selected=true;
            contentDocForm[dropDownMenuName].options.length=colorNames.length + 1;
        }
    }
}

function compareCaseInsensitive(a, b) {
    var anew = a.toLowerCase();
    var bnew = b.toLowerCase();
    if (anew < bnew) return -1;
    if (anew > bnew) return 1;
    return 0;
}

function setFromDropDown(prop) {
    var dropdown = document.getElementById("colorNameDropDown"+prop);
    var index = dropdown.selectedIndex;
    var value = dropdown.options[index].value;
    document.getElementById("newColor"+prop).value=value;
    document.getElementById("colorsquare"+prop).style.backgroundColor=value;
    document.ContentAreaForm[unescape(prop)].onchange();
}

function checkValidHexValue(field, qualName){
    var hex = document.ContentAreaForm[field].value;
    var hexNoHash;
    if (hex.substring(0,1)=="#") {
        hexNoHash = hex.substring(1);
    } else {
        hexNoHash = hex;
        hex = "#" + hex;
        document.ContentAreaForm[field].value = hex;
    }
    if (hexNoHash.length>6){
        alert('The hex value is invalid please enter a valid value');
        document.ContentAreaForm[field].value="#";
    } else {
        hexNoHash = hexNoHash.toLowerCase();
        hexchars="0123456789abcdef";
        out=0;
        for (a=hexNoHash.length-1;a>=0;a--)  {
            var aChar = hexNoHash.charAt(a);
            aChar = aChar.toLowerCase();
            index = hexchars.indexOf(aChar);
            if (index==-1)
                out = -1;
        }
        if (out==-1) {
            alert('The hex value is invalid please enter a valid value');
            document.ContentAreaForm[field].value="#";
        } else {
              updateColorChooserExtras(qualName, hex)
        }
    }
}

function updateColorChooserExtras(qualName, hexValue) {
        document.getElementById("colorsquare"+qualName).style.backgroundColor=hexValue;
        var dropDown = document.getElementById("colorNameDropDown"+qualName);
        document.getElementById("colorNameDropDown"+qualName).selectedIndex=0;

        for(i=0; i < dropDown.length; i++) {
            if(hexValue.toLowerCase() == dropDown.options[i].value) {
                document.getElementById("colorNameDropDown"+qualName).selectedIndex=i;
                break;
            }
        }
}

function updateDisabledFields() {
    var prefix1 = "ContentArea.PageletView.ContentAreaPolicies.PolicyTemplateContent." ;
    var prefix1Length =  prefix1.length ;
    var prefix2 = ".PoliciesSectionTiledView[" ;
    var prefix2Length = prefix2.length ;
    var prefix3 = "].PropertyValue" ;
    var disabledValues = "" ;
    for(var i = 0; i < document.ContentAreaForm.elements.length; i++) {
        var element = document.ContentAreaForm.elements[i] ;

        if(element.disabled == true) {
            if((element.name.indexOf(prefix2) != -1) && (element.name.indexOf(prefix3) != -1)) {
                var sectionName = element.name.substring(prefix1Length, element.name.indexOf(prefix2)) ;
                var index = element.name.substring(prefix1Length + sectionName.length + prefix2Length, element.name.indexOf(prefix3)) ;
                var value = element.value ;

                // Need to handle checkboxes differently since checkbox.value always returns true, 
                // its necessary to check the .checked value of a checkbox 
                if(element.type == "checkbox" && element.checked != true) {
                    value = "false" ;
                }

                // Need to deal with radiobuttons individually and see if they are checked 
                if(element.type == "radio") {
                    if(element.checked == true) {
                        value = element.value ;
                        disabledValues = disabledValues + sectionName + "|" + index + "|" + value + "|" ;
                    }   
                } else {
                    disabledValues = disabledValues + sectionName + "|" + index + "|" + value + "|" ;
                }
            }
        }
    }
    document.getElementById("disabledFieldValues").value = disabledValues ;
}

<%--
This is a fix for JATO + Netscape 4.7x:
Only Netscape 4.7x submits the SearchButton as hidden field.
JATO interprets this as command field which is hit before the actually intended
     NameHref command field
FIX: I change the name of the submit button so that JATO does not match this
     against the seach command field has no match here and NameHref is found
--%>
    document.ContentAreaForm['ContentArea.PageletView.ContentAreaPolicies.ReportButton'].name="Report";
    var clearButton = document.ContentAreaForm['ContentArea.PageletView.ContentAreaPolicies.ClearButton'];
    if (clearButton != null) clearButton.name="ClearAll";
    var saveButton = document.ContentAreaForm['ContentArea.PageletView.ContentAreaPolicies.SaveButton'];
    if (saveButton != null) saveButton.name="SaveProp";
    var resetButton = document.ContentAreaForm['ContentArea.PageletView.ContentAreaPolicies.ResetButton'];
    if (resetButton != null) resetButton.name="ResetProp";
</script>
<apoc:policytemplate name="PolicyTemplateContent"/>
<input type="hidden" name="UserInput" value=""/>
<script type="text/javascript">
//  BEGIN <---- Script and functions used for XMLHandlers ---->
<cc:text name="XmlHandlerText" />
//  END      <---- Script and functions used for XMLHandlers ---->
</script>
<cc:hidden name="ProtectedChoosers" elementId="protectedChoosers"/>
<cc:hidden name="ProtectedChoosersType" elementId="protectedChoosersType"/>
<cc:hidden name="DisabledFieldsValues" elementId="disabledFieldValues" />
</cc:pagetitle>
</jato:containerView>
</jato:pagelet>
