/*
 *******************************************************************************
 * $RCSfile: ConfigFile.hpp,v $
 *
 * Description: 
 *
 * Last change: $Date: 2005/11/09 13:37:11 $ $Revision: 1.5 $
 *
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved. Use of this 
 * product is subject to license terms. 
 *
 *******************************************************************************
 * Source Code Control System - Header
 *
 * $Header: /sgnome/cvsroots/misc/legacy/source/plugins/mime/ConfigFile.hpp,v 1.5 2005/11/09 13:37:11 rf96881 Exp $
 *******************************************************************************
 */
#ifndef ConfigFile_hpp
#define ConfigFile_hpp

#include <iostream>
#include <fstream>
#include <string>
#include <list>

#include <TreeInterfaces.hpp>

#include "Error.hpp"


namespace apoc { namespace legacy { namespace plugins {namespace mimeplugin {
    class ConfigFile 
    {
    public:
	ConfigFile( const std::string& aPath, const std::string& aFilename );
	//	~ConfigFile();
	void parse( ITreeHandler& aHandler );
// 	void ConfigFile::reportErrors() const ;
	const std::string& getFileName() const { return mFileName ; }
	
	
    protected:
	
    private:
	void parseKeyApps( ITreeHandler& aHandler );
	void parseGlobs( ITreeHandler& aHandler );
	void issueWarning(const char *aMsg) const ;
	enum stateMachine  {
	    STATE_INIT,
	    STATE_ON_NAME,
	    STATE_ON_ATTR,
	    STATE_ON_KEY,
	    STATE_ON_VALUE,
	    STATE_ON_VALUE_LIST
	};
	std::string mFileName;                // file name to parse
	std::string mPath;                    // path of the file to parse
	std::string mFQFile;                  // Fully qualified name 
	                                      // of the file to parse
	std::ifstream mInputStream;           // io stream for the file
	//	std::list<apoc::legacy::mimeplugin::Error *>  mErrorList;	      // list with parse errors
	int mLine;
	int mColumn;
	bool mKeyFile;
	bool mAppFile;
	bool mGlobFile;
    };
}}}}
#endif // ConfigFile_hpp
