#ifndef Logger_hpp
#define Logger_hpp

#include <string>

namespace apoc { namespace legacy {

/**
  * Class providing a logging facility based on syslog.
  */
class Logger
{
    public :
        // Possible log levels.
        enum LogLevel
        {
            LogLevel_Emergency,
            LogLevel_Alert,
            LogLevel_Critical,
            LogLevel_Error,
            LogLevel_Warning,
            LogLevel_Notice,
            LogLevel_Info,
            LogLevel_Debug
        } ;

        /**
          * Sets up the default logger for an application.
          */
        static void initialise(const std::string& aIdentifier) ;
        /**
          * Destroys the default logger for the application.
          */
        static void uninitialise(void) ;
        /**
          * Logs a formatted message at a specified level.
          */
        static void log(LogLevel aLevel, const char *aMessage, ...) ;
        // Utility methods to log a message at various levels.
        static void emergency(const char *aMessage, ...) ;
        static void alert(const char *aMessage, ...) ;
        static void critical(const char *aMessage, ...) ;
        static void error(const char *aMessage, ...) ;
        static void warning(const char *aMessage, ...) ;
        static void notice(const char *aMessage, ...) ;
        static void info(const char *aMessage, ...) ;
        static void debug(const char *aMessage, ...) ;
    protected :
    private :
        // Whether messages should go to stderr.
        bool mUseStderr ;
        // Level of the stderr logger.
        LogLevel mLevel ;

        // Default logger.
        static Logger *sDefault ;

        Logger(const std::string& aIdentifier) ;
        ~Logger(void) ;
        void output(LogLevel aLevel, const char *aMessage, 
                    va_list aArguments) const ;

        static void vlog(LogLevel aLevel, const char *aMessage, 
                         va_list aArguments) ;
} ;

} } //  apoc.legacy

#endif // Logger_hpp
