/*
 *******************************************************************************
 * $RCSfile: MimeData.hpp,v $
 *
 * Description: 
 *
 * Last change: $Date: 2005/11/09 13:37:11 $ $Revision: 1.4 $
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved. Use of this 
 * product is subject to license terms. 
 *
 *******************************************************************************
 * Source Code Control System - Header
 *
 * $Header: /sgnome/cvsroots/misc/legacy/source/plugins/mime/MimeData.hpp,v 1.4 2005/11/09 13:37:11 rf96881 Exp $
 *******************************************************************************
 */

#ifndef MimeData_hpp
#define MimeData_hpp

#include <string>
#include <list>
#include <map>

#include <TreeInterfaces.hpp>

#include "ConfigFile.hpp"

namespace apoc { namespace legacy {namespace plugins { namespace mimeplugin {
    class MimeData:public apoc::legacy::IUpdateLayer
    {
    public:
	// Named constructors
	static MimeData * defaultKeys( const std::string& aDir );
	static MimeData * defaultApps( const std::string& aDir );
	static MimeData * userKeys( const std::string& aDir );
	static MimeData * userApps( const std::string& aDir );
	static MimeData * defaultMimes( const std::string& aDir );
	static MimeData * userMimes( const std::string& aDir );
	
	void read( apoc::legacy::ITreeHandler& aHandler ) const;
	virtual ~MimeData();
    protected:
    private:
	MimeData( const std::string& aDir, const bool aDefltFiles, 
		  const bool aAppFiles, const bool aGlob );
	//MimeData(const MimeData &);
	bool mDefault;
	bool mApp;
	bool mGlob;
	std::string mDirectory;
	mutable std::map<std::string, ConfigFile *> mCfgFiles;
	
	void expandDir( std::string& aDir );
	void readListFiles();
	void statGlobFile();
    };
}}}} // apoc.legacy.plugins.mimeplugin
#endif
