#ifndef PolicyAccess_hpp
#define PolicyAccess_hpp

#include <map>
#include <set>

#include "TreeInterfaces.hpp"
#include "NodePath.hpp"
#include "PapiConnection.hpp"

namespace apoc { namespace legacy {

class PolicyLayer : public IUpdateLayer
{
    public :
        PolicyLayer(const NodePath& aPath, const PapiLayer& aLayer) ;
        virtual ~PolicyLayer(void) ;

        virtual void read(ITreeHandler& aHandler) const ;
    protected :
    private :
        NodePath mPath ;
        PapiLayer mLayer ;
} ;

class IPolicyListener 
{
    public :
        virtual void onComponentAdd(const std::string& aComponent) const = 0 ;
        virtual void onComponentRemove(
                                    const std::string& aComponent) const = 0 ;
        virtual void onComponentModify(
                                    const std::string& aComponent) const = 0 ;
} ;

class PolicyAccess 
{
    public :
        PolicyAccess(void) ;
        explicit PolicyAccess(const std::string& aEntity) ;
        ~PolicyAccess(void) ;

        void getPolicyLayers(const NodePath& aPath, 
                             std::vector<PolicyLayer>& aLayers) const ;
        void addListener(const NodePath& aPath, IPolicyListener *aListener) ;
        void removeListener(const NodePath& aPath, IPolicyListener *aListener) ;
        void processEvent(const PAPIEvent& aEvent) const ;
    protected :
    private :
        PapiConnection *mConnection ;
        struct Listeners
        {
            PAPIListenerId mId ;
            std::set<IPolicyListener *> mListeners ;
        } ;
        typedef std::map<std::string, Listeners> ListenerList ;
        ListenerList mListeners ;
} ;
    
} } // apoc.legacy

#endif // PolicyAccess_hpp
