/*
 * Copyright 2001-2002,2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _UTERRNO_H
#define _UTERRNO_H

#pragma ident	"@(#)uterrno.h	1.7	05/05/03 SMI"

#ifdef _SCCSID
static char *_SCCSid_UTERRNO_H = "@(#)uterrno.h	1.7	05/05/03 SMI";
#endif	/* defined _SCCSID */

/*
 * Generic error codes.
 */

#ifdef __cplusplus
extern "C" {
#endif	/* defined __cplusplus */

#define UT_TRUE		          1
#define UT_FALSE	          0
#define UT_SUCCESS	          0
#define UT_UNKNOWN	          2
#define UT_ERROR	          -1	  /* generic error */
#define UT_NO_CHANGE	          -2	  /* no change was made */
#define UT_AUTH_FAILED	          -3	  /* authentication failed  */
#define UT_NOTFOUND	          -4	  /* entry not found */
#define UT_NOPERM	          -5	  /* no permission */
#define UT_INVARGS	          -6	  /* invalid argument passed */
#define UT_EXISTS	          -7	  /* entry already exists */
#define	UT_DTUINUSE	          -8	  /* DTU already in use */
#define	UT_NOTOKENENTRY	          -9	  /* no token entry found */
#define UT_NOMEM	          -10	  /* not enough memory */
#define	UT_DUPCID	          -11
#define UT_SERVER_NOT_REACHABLE	  -12
#define UT_SOCKET_OPENING_FAILED  -13
#define UT_SOCKET_WRITE_FAILED	  -14
#define UT_AUTH_TIMEOUT		  -15
#define UT_FILEERR	          -16	  /* file access error */
#define UT_INVSEQ	          -17	  /* invalid call sequence */
#define UT_NOMORE	          -18	  /* no more data */
#define UT_NOENT	          -19	  /* no such file or directory */
#define	UT_UTAFAILED	          -20	  /* failed to open connection to DB */

#define UT_DETACHED	          -22	  /* session detached */
#define UT_NOSESSION              -23	  /* not currently in a Sun Ray session */
#define UT_TIMEOUT		  -24	  /* operation timed out */
#define UT_NETPROBLEM		  -25	  /* failed to contact remote service */
#define UT_CONFIGERR		  -26	  /* configuration error */
#define UT_ENOBUFS		  -27	  /* no buffer space available */
#define UT_DBMFAILED		  -28     /* failed to open DBM files */
#define UT_DSREFERRAL		  -29     /* got referral from DS */
#define UT_OPENFAILED		  -30	  /* open failed */
#define UT_REJECT		  -31	  /* rejected by peer */
#define UT_DISCONNECT		  -32	  /* connection disconnected */
#define UT_SYNCTIMEOUT		  -33	  /* timeout waiting for replication */

#ifdef __cplusplus
}
#endif	/* defined __cplusplus */

#endif	/* defined _UTERRNO_H */
