/*
 * Decompiled with CFR 0.152.
 */
package admin.multihead.utmhconfig;

import admin.multihead.utmhconfig.BindTerminals;
import admin.multihead.utmhconfig.DiscoverTerminals;
import admin.multihead.utmhconfig.IdentifyButton;
import admin.multihead.utmhconfig.MultiheadListModel;
import auth.admin.Admin;
import auth.admin.UTDtuGroup;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;

public class CreateConfig
extends JFrame {
    public static JFrame jf;
    private JPanel createGroupsPanel;
    private JLabel createGroupsTitleLabel;
    private JPanel createGroupsWizardPanel;
    private JPanel createSizeCardPanel;
    private JTextArea createSizeHelpText;
    private JPanel createSizePanel;
    private JLabel groupNameLabel;
    private JTextField groupNameTextField;
    private JLabel colsLabel;
    private JTextField colsTextField;
    private JLabel rowsLabel;
    private JTextField rowsTextField;
    private JPanel sizeButtonsPanel;
    private JPanel jPanel2;
    private JButton createSizeCancelButton;
    private JButton queryOKButton;
    private JPanel identifyTerminalsCardPanel;
    private JTextArea createIdentifyHelpText;
    private JPanel layoutPanel;
    private JPanel terminalLayoutPanel;
    private JScrollPane terminalsScrollPane;
    private JPanel terminalsPanel;
    private JPanel terminalsLayoutControlPanel;
    private JLabel smartCardIcon;
    private JPanel identifyButtonsPanel;
    private JPanel jPanel4;
    private JButton cancelButton;
    private JButton finishButton;
    public static ResourceBundle i18nBundle;
    private String groupName = null;
    private int rows = 0;
    private int cols = 0;
    private IdentifyButton[] buttons = new IdentifyButton[16];
    private DiscoverTerminals discoverer = null;
    private BindTerminals binder = null;
    private Admin uta = null;
    private MultiheadListModel listModel = null;
    private static final int rowOffset = 130;
    private static final int colOffset = 225;
    private String imageRoot = System.getProperty("UTImageRoot");

    public CreateConfig() {
        this(ResourceBundle.getBundle("MHConfig"), null, null);
    }

    public CreateConfig(ResourceBundle resourceBundle, Admin admin, MultiheadListModel multiheadListModel) {
        this.uta = admin;
        this.createConfigCommon(resourceBundle);
        this.listModel = multiheadListModel;
    }

    public void createConfigCommon(ResourceBundle resourceBundle) {
        if (this.imageRoot == null) {
            this.imageRoot = ".";
        }
        i18nBundle = resourceBundle;
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.createGroupsPanel = new JPanel();
        this.createGroupsTitleLabel = new JLabel();
        this.createGroupsWizardPanel = new JPanel();
        this.createSizeCardPanel = new JPanel();
        this.createSizeHelpText = new JTextArea();
        this.createSizePanel = new JPanel();
        this.groupNameLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.colsLabel = new JLabel();
        this.colsTextField = new JTextField();
        this.rowsLabel = new JLabel();
        this.rowsTextField = new JTextField();
        this.sizeButtonsPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.createSizeCancelButton = new JButton();
        this.queryOKButton = new JButton();
        this.identifyTerminalsCardPanel = new JPanel();
        this.createIdentifyHelpText = new JTextArea();
        this.layoutPanel = new JPanel();
        this.terminalLayoutPanel = new JPanel();
        this.terminalsScrollPane = new JScrollPane();
        this.terminalsPanel = new JPanel();
        this.terminalsLayoutControlPanel = new JPanel();
        this.smartCardIcon = new JLabel();
        this.identifyButtonsPanel = new JPanel();
        this.jPanel4 = new JPanel();
        this.cancelButton = new JButton();
        this.finishButton = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.setBackground(Color.white);
        this.setTitle(i18nBundle.getString("Title.Bar"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CreateConfig.this.exitForm(windowEvent);
            }
        });
        this.createGroupsPanel.setLayout(new GridBagLayout());
        this.createGroupsPanel.setBackground(Color.white);
        this.createGroupsPanel.setAlignmentX(0.0f);
        this.createGroupsTitleLabel.setOpaque(true);
        this.createGroupsTitleLabel.setBackground(new Color(255, 255, 204));
        this.createGroupsTitleLabel.setAlignmentY(1.0f);
        this.createGroupsTitleLabel.setAlignmentX(0.5f);
        this.createGroupsTitleLabel.setBorder(new EtchedBorder());
        this.createGroupsTitleLabel.setText(i18nBundle.getString("QueryRC.Title"));
        this.createGroupsTitleLabel.setForeground(Color.black);
        this.createGroupsTitleLabel.setHorizontalAlignment(0);
        this.createGroupsTitleLabel.setFont(new Font("Serif", 0, 18));
        this.createGroupsTitleLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.createGroupsPanel.add((Component)this.createGroupsTitleLabel, gridBagConstraints);
        this.createGroupsWizardPanel.setLayout(new CardLayout());
        this.createGroupsWizardPanel.setMaximumSize(new Dimension(32768, 32768));
        this.createGroupsWizardPanel.setBackground(Color.red);
        this.createGroupsWizardPanel.setAlignmentY(0.0f);
        this.createSizeCardPanel.setLayout(new GridBagLayout());
        this.createSizeCardPanel.setOpaque(false);
        this.createSizeHelpText.setLineWrap(true);
        this.createSizeHelpText.setPreferredSize(new Dimension(200, 175));
        this.createSizeHelpText.setWrapStyleWord(true);
        this.createSizeHelpText.setBackground(new Color(255, 255, 204));
        this.createSizeHelpText.setBorder(new EtchedBorder());
        this.createSizeHelpText.setMinimumSize(this.createSizeHelpText.getPreferredSize());
        this.createSizeHelpText.setText(i18nBundle.getString("Help.CreateWizard.Size"));
        this.createSizeHelpText.setEditable(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 2;
        gridBagConstraints2.fill = 3;
        this.createSizeCardPanel.add((Component)this.createSizeHelpText, gridBagConstraints2);
        this.createSizePanel.setLayout(new GridBagLayout());
        this.createSizePanel.setBackground(Color.white);
        Font font = new Font("SansSerif", 1, 10);
        this.groupNameLabel.setPreferredSize(new Dimension(105, this.getFontMetrics(font).getHeight()));
        this.groupNameLabel.setMaximumSize(this.groupNameLabel.getPreferredSize());
        this.groupNameLabel.setAlignmentY(0.0f);
        this.groupNameLabel.setMinimumSize(this.groupNameLabel.getPreferredSize());
        this.groupNameLabel.setText(i18nBundle.getString("QueryRC.Name"));
        this.groupNameLabel.setForeground(Color.black);
        this.groupNameLabel.setHorizontalAlignment(4);
        this.groupNameLabel.setFont(font);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 4;
        this.createSizePanel.add((Component)this.groupNameLabel, gridBagConstraints3);
        this.groupNameTextField.setPreferredSize(new Dimension(100, 15));
        this.groupNameTextField.setMaximumSize(new Dimension(100, 15));
        this.groupNameTextField.setBackground(Color.lightGray);
        this.groupNameTextField.setAlignmentY(0.0f);
        this.groupNameTextField.setBorder(new BevelBorder(1));
        this.groupNameTextField.setAlignmentX(0.0f);
        this.groupNameTextField.setMinimumSize(new Dimension(10, 10));
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 7;
        gridBagConstraints3.gridy = 4;
        gridBagConstraints3.gridwidth = 0;
        this.createSizePanel.add((Component)this.groupNameTextField, gridBagConstraints3);
        this.colsLabel.setPreferredSize(this.groupNameLabel.getPreferredSize());
        this.colsLabel.setMaximumSize(this.groupNameLabel.getPreferredSize());
        this.colsLabel.setAlignmentY(0.0f);
        this.colsLabel.setMinimumSize(this.groupNameLabel.getPreferredSize());
        this.colsLabel.setText(i18nBundle.getString("QueryRC.Cols"));
        this.colsLabel.setForeground(Color.black);
        this.colsLabel.setHorizontalAlignment(4);
        this.colsLabel.setFont(font);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 5;
        this.createSizePanel.add((Component)this.colsLabel, gridBagConstraints3);
        this.colsTextField.setPreferredSize(new Dimension(100, 15));
        this.colsTextField.setMaximumSize(new Dimension(100, 15));
        this.colsTextField.setBackground(Color.lightGray);
        this.colsTextField.setAlignmentY(0.0f);
        this.colsTextField.setBorder(new BevelBorder(1));
        this.colsTextField.setAlignmentX(0.0f);
        this.colsTextField.setMinimumSize(new Dimension(10, 10));
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 7;
        gridBagConstraints3.gridy = 5;
        gridBagConstraints3.gridwidth = 0;
        this.createSizePanel.add((Component)this.colsTextField, gridBagConstraints3);
        this.rowsLabel.setPreferredSize(this.groupNameLabel.getPreferredSize());
        this.rowsLabel.setMaximumSize(this.groupNameLabel.getPreferredSize());
        this.rowsLabel.setAlignmentY(0.0f);
        this.rowsLabel.setMinimumSize(this.groupNameLabel.getPreferredSize());
        this.rowsLabel.setText(i18nBundle.getString("QueryRC.Rows"));
        this.rowsLabel.setForeground(Color.black);
        this.rowsLabel.setHorizontalAlignment(4);
        this.rowsLabel.setFont(font);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 6;
        this.createSizePanel.add((Component)this.rowsLabel, gridBagConstraints3);
        this.rowsTextField.setPreferredSize(new Dimension(100, 15));
        this.rowsTextField.setMaximumSize(new Dimension(100, 15));
        this.rowsTextField.setBackground(Color.lightGray);
        this.rowsTextField.setAlignmentY(0.0f);
        this.rowsTextField.setBorder(new BevelBorder(1));
        this.rowsTextField.setAlignmentX(0.0f);
        this.rowsTextField.setMinimumSize(new Dimension(10, 10));
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 7;
        gridBagConstraints3.gridy = 6;
        gridBagConstraints3.gridwidth = 0;
        this.createSizePanel.add((Component)this.rowsTextField, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.weighty = 0.1;
        this.createSizeCardPanel.add((Component)this.createSizePanel, gridBagConstraints2);
        this.sizeButtonsPanel.setLayout(new BoxLayout(this.sizeButtonsPanel, 0));
        this.sizeButtonsPanel.setBackground(Color.white);
        this.jPanel2.setOpaque(false);
        this.sizeButtonsPanel.add(this.jPanel2);
        this.createSizeCancelButton.setBackground(Color.lightGray);
        this.createSizeCancelButton.setBorder(new BevelBorder(0));
        this.createSizeCancelButton.setText(i18nBundle.getString("Cancel"));
        this.createSizeCancelButton.setHorizontalAlignment(4);
        this.createSizeCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateConfig.this.createCancelled(actionEvent);
            }
        });
        this.sizeButtonsPanel.add(this.createSizeCancelButton);
        this.queryOKButton.setMargin(new Insets(100, 100, 0, 0));
        this.queryOKButton.setBackground(Color.lightGray);
        this.queryOKButton.setBorder(new BevelBorder(0));
        this.queryOKButton.setAlignmentX(0.5f);
        this.queryOKButton.setText(i18nBundle.getString("OK"));
        this.queryOKButton.setHorizontalAlignment(4);
        this.queryOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateConfig.this.queryOKButtonActionPerformed(actionEvent);
            }
        });
        this.sizeButtonsPanel.add(this.queryOKButton);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 2;
        this.createSizeCardPanel.add((Component)this.sizeButtonsPanel, gridBagConstraints2);
        this.createGroupsWizardPanel.add((Component)this.createSizeCardPanel, "createSizeCard");
        this.identifyTerminalsCardPanel.setLayout(new GridBagLayout());
        this.identifyTerminalsCardPanel.setMaximumSize(new Dimension(65535, 65535));
        this.identifyTerminalsCardPanel.setBackground(Color.white);
        this.createIdentifyHelpText.setLineWrap(true);
        this.createIdentifyHelpText.setPreferredSize(this.createSizeHelpText.getPreferredSize());
        this.createIdentifyHelpText.setWrapStyleWord(true);
        this.createIdentifyHelpText.setBackground(new Color(255, 255, 204));
        this.createIdentifyHelpText.setBorder(new EtchedBorder());
        this.createIdentifyHelpText.setMinimumSize(this.createSizeHelpText.getPreferredSize());
        this.createIdentifyHelpText.setText(i18nBundle.getString("Help.CreateWizard.Identify"));
        this.createIdentifyHelpText.setEditable(false);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridheight = 2;
        gridBagConstraints4.fill = 3;
        this.identifyTerminalsCardPanel.add((Component)this.createIdentifyHelpText, gridBagConstraints4);
        this.layoutPanel.setLayout(new GridBagLayout());
        this.layoutPanel.setOpaque(false);
        this.layoutPanel.setBackground(Color.white);
        this.terminalLayoutPanel.setLayout(new BoxLayout(this.terminalLayoutPanel, 0));
        this.terminalLayoutPanel.setOpaque(false);
        this.terminalLayoutPanel.setBackground(Color.white);
        this.terminalsScrollPane.setBackground(Color.white);
        this.terminalsPanel.setBackground(Color.white);
        this.terminalsScrollPane.setViewportView(this.terminalsPanel);
        this.terminalLayoutPanel.add(this.terminalsScrollPane);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.weighty = 0.1;
        this.layoutPanel.add((Component)this.terminalLayoutPanel, gridBagConstraints5);
        this.terminalsLayoutControlPanel.setBackground(Color.white);
        this.smartCardIcon.setIcon(new ImageIcon(this.imageRoot.concat("/smartcard.gif")));
        this.smartCardIcon.setText("IEEE802.123456789abc");
        this.smartCardIcon.setForeground(Color.black);
        this.smartCardIcon.setHorizontalTextPosition(2);
        this.terminalsLayoutControlPanel.add(this.smartCardIcon);
        gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 0.1;
        this.layoutPanel.add((Component)this.terminalsLayoutControlPanel, gridBagConstraints5);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.weightx = 0.1;
        gridBagConstraints4.weighty = 0.1;
        this.identifyTerminalsCardPanel.add((Component)this.layoutPanel, gridBagConstraints4);
        this.identifyButtonsPanel.setLayout(new BoxLayout(this.identifyButtonsPanel, 0));
        this.identifyButtonsPanel.setOpaque(false);
        this.identifyButtonsPanel.setBackground(Color.white);
        this.jPanel4.setOpaque(false);
        this.identifyButtonsPanel.add(this.jPanel4);
        this.cancelButton.setBackground(Color.lightGray);
        this.cancelButton.setBorder(new BevelBorder(0));
        this.cancelButton.setText(i18nBundle.getString("Cancel"));
        this.cancelButton.setHorizontalAlignment(4);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateConfig.this.createCancelled(actionEvent);
            }
        });
        this.identifyButtonsPanel.add(this.cancelButton);
        this.finishButton.setBackground(Color.lightGray);
        this.finishButton.setBorder(new BevelBorder(0));
        this.finishButton.setText(i18nBundle.getString("Finish"));
        this.finishButton.setHorizontalAlignment(4);
        this.finishButton.setEnabled(false);
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateConfig.this.wizardDone(actionEvent);
            }
        });
        this.identifyButtonsPanel.add(this.finishButton);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.fill = 2;
        this.identifyTerminalsCardPanel.add((Component)this.identifyButtonsPanel, gridBagConstraints4);
        this.createGroupsWizardPanel.add((Component)this.identifyTerminalsCardPanel, "identifyTerminalsCard");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.createGroupsPanel.add((Component)this.createGroupsWizardPanel, gridBagConstraints);
        this.getContentPane().add(this.createGroupsPanel);
    }

    private void wizardDone(ActionEvent actionEvent) {
        if (this.binder.isDiscoveryCompleted()) {
            UTDtuGroup uTDtuGroup = new UTDtuGroup();
            int n = this.binder.getNextToBind();
            int n2 = this.drawButtons(n);
            uTDtuGroup.setDtuGroupID(this.groupNameTextField.getText());
            uTDtuGroup.setDtuGroupType("MULTIHEAD");
            uTDtuGroup.setPrivateData("geometry=".concat(this.cols + "x" + this.rows));
            uTDtuGroup.setPrimaryIdx(this.binder.getPrimaryIdx());
            uTDtuGroup.setNDtus(n2);
            uTDtuGroup.setDtuCIDs(this.binder.getTerminals());
            int n3 = this.uta.doAddDtuGrp(uTDtuGroup, 0);
            if (n3 != 0) {
                String string;
                switch (n3) {
                    case -1: {
                        string = "Add.Error.ERROR";
                        break;
                    }
                    case -2: {
                        string = "Add.Error.NO_CHANGE";
                        break;
                    }
                    case -3: {
                        string = "Add.Error.AUTH_FAILED";
                        break;
                    }
                    case -4: {
                        string = "Add.Error.NOTFOUND";
                        break;
                    }
                    case -6: {
                        string = "Add.Error.INVARGS";
                        break;
                    }
                    case -7: {
                        string = "Add.Error.EXISTS";
                        break;
                    }
                    case -8: {
                        string = "Add.Error.DTUINUSE";
                        break;
                    }
                    default: {
                        string = "Add.Error.Other";
                    }
                }
                JOptionPane.showMessageDialog(this, i18nBundle.getString(string), i18nBundle.getString("Add.Error.Title"), 0);
            }
            this.uta.syncGroup("MULTIHEAD", new String[0]);
            if (this.listModel != null) {
                this.listModel.update();
            }
            this.setVisible(false);
        }
    }

    private void createCancelled(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void queryOKButtonActionPerformed(ActionEvent actionEvent) {
        if (this.verifyQueryData()) {
            try {
                this.doIdentification();
            }
            catch (IllegalStateException illegalStateException) {
                this.setVisible(false);
                JOptionPane.showMessageDialog(this, illegalStateException.getMessage(), i18nBundle.getString("QueryRC.Bad.Title"), 0);
            }
        }
    }

    private void exitForm(WindowEvent windowEvent) {
    }

    private void doIdentification() {
        this.terminalsPanel.setLayout(new GridBagLayout());
        for (int i = 0; i < this.rows; ++i) {
            int n = 0;
            while (n < this.cols) {
                IdentifyButton identifyButton;
                this.buttons[i * this.cols + n] = identifyButton = new IdentifyButton(i18nBundle, this.imageRoot, i, n, this.cols);
                identifyButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        CreateConfig.this.identifyButtonAction(actionEvent);
                    }
                });
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = n++;
                gridBagConstraints.gridy = i;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.terminalsPanel.add((Component)identifyButton, gridBagConstraints);
            }
        }
        this.setSize(this.getPreferredSize().width + this.terminalsScrollPane.getVerticalScrollBar().getPreferredSize().width + 1, this.getPreferredSize().height + this.terminalsScrollPane.getHorizontalScrollBar().getPreferredSize().height + 1);
        ((CardLayout)this.createGroupsWizardPanel.getLayout()).show(this.createGroupsWizardPanel, "identifyTerminalsCard");
        try {
            this.discoverer = new DiscoverTerminals(i18nBundle, this.rows * this.cols);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            iOException.printStackTrace();
        }
        this.discoverer.addDiscoveryListener(new Runnable(){

            public void run() {
                CreateConfig.this.discoveryMade();
            }
        });
        this.binder = this.discoverer.getBinder();
        this.discoverer.start();
    }

    private void inputError(String string) {
        JOptionPane.showMessageDialog(this, i18nBundle.getString(string), i18nBundle.getString("QueryRC.Bad.Title"), 0);
    }

    private boolean verifyQueryData() {
        boolean bl = false;
        String[] stringArray = new String[1];
        try {
            this.groupName = this.groupNameTextField.getText();
            bl = this.uta.isValidGroupName(this.groupName, stringArray);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!bl) {
            this.inputError(stringArray[0]);
            return false;
        }
        bl = false;
        try {
            this.rows = Integer.parseInt(this.rowsTextField.getText());
            bl = 0 < this.rows && this.rows <= 16;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!bl) {
            this.inputError("QueryRC.Bad.Rows");
            return false;
        }
        bl = false;
        try {
            this.cols = Integer.parseInt(this.colsTextField.getText());
            bl = 0 < this.cols && this.cols <= 16;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!bl) {
            this.inputError("QueryRC.Bad.Cols");
            return false;
        }
        if (this.rows * this.cols <= 1) {
            this.inputError("QueryRC.Bad.Few");
            return false;
        }
        if (16 < this.rows * this.cols) {
            this.inputError("QueryRC.Bad.Many");
            return false;
        }
        return true;
    }

    private void identifyButtonAction(ActionEvent actionEvent) {
        int n = ((IdentifyButton)actionEvent.getSource()).getRow();
        int n2 = ((IdentifyButton)actionEvent.getSource()).getCol();
        int n3 = n * this.cols + n2;
        this.binder.setNextToBind(n3);
        this.drawButtons(n3);
    }

    private void discoveryMade() {
        this.drawButtons(this.binder.getNextToBind());
        if (this.binder.isDiscoveryCompleted()) {
            this.createIdentifyHelpText.setText(i18nBundle.getString("Help.CreateWizard.Done"));
            this.finishButton.setEnabled(true);
        }
    }

    private int drawButtons(int n) {
        String[] stringArray = this.binder.getTerminals();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == n) {
                this.buttons[i].setNext(this.binder.getPendingTerminalID());
                continue;
            }
            if (stringArray[i] == null) {
                this.buttons[i].setUnassigned();
                continue;
            }
            this.buttons[i].setAssigned(stringArray[i]);
        }
        if (!this.binder.isDiscoveryCompleted()) {
            this.smartCardIcon.setText(this.binder.getCurrentTerminalID());
        } else {
            this.smartCardIcon.setText("");
            this.smartCardIcon.setIcon(null);
        }
        return stringArray.length;
    }

    public static void main(String[] stringArray) {
        new CreateConfig().show();
    }

    static {
        i18nBundle = null;
    }
}

