/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.SmartCardIDException;
import auth.utauthd.SmartCardWordException;
import auth.utauthd.SmartCardWordsImpl;
import auth.utauthd.Terminal;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SmartCardID {
    private static final String SCCS_ID = "@(#)SmartCardID.java\t1.25\t06/03/10 SMI";
    private Terminal term;
    private int tagCtr = 0;
    private String msgTag;
    private String expectedMsgTag = null;
    private boolean needMsgTags = false;
    private Hashtable tokenInfo;
    private Vector terminalTokens;
    private int state;
    private static final int STATE_DEBUG = 0;
    private static final int STATE_INIT = 1;
    private static final int STATE_ERROR = 2;
    private static final int STATE_TIMEOUT = 3;
    private static final int STATE_SEND_APDU = 10;
    private static final int STATE_XCHANGE_APDU = 11;
    private static final int STATE_SETPROTO = 12;
    private static final int STATE_SEND_PTS = 13;
    private static final int STATE_RECEIVE_APDU = 20;
    private static final int STATE_RECEIVE_APDU_NO_DATA = 21;
    private static final int STATE_SETPROTO_DONE = 30;
    private static final int STATE_PTS_DONE = 31;
    private static final int STATE_PROCESS = 40;
    private static final int STATE_FINISHED = 41;
    private static final int STATE_TOKEN_REMOVED = 42;
    private static final int STATE_WAITFOR_TOKEN = 43;
    private static final int STATE_CARD_RESET = 100;
    private static final int STATE_CARD_RESET_DONE = 101;
    private int mStime = 0;
    private int mSticks = 0;
    private String ti_INFO_REQ = "infoReq";
    private String ir_EVENT_MSG = "event";
    private String ir_INSERT_EVENT = "insert";
    private String ir_REMOVE_EVENT = "remove";
    private String ir_TOKEN_TYPE = "type";
    private String ir_TOKEN_ID = "id";
    private String ir_TOKEN_ATR = "atr";
    private String ir_TOKEN_ATR_HIST_START = "atr.hs";
    private String ir_TOKEN_ATR_HIST_LEN = "atr.hist_len";
    private String ir_UNKNOWN_TOKEN = "unknown";
    private String ir_UNKNOWN_ID = "unknown";
    public static final String ir_PSEUDO_TOKEN = "pseudo";
    private String tc_SMARTCARD = "controlSmartCard";
    private String ai_APDU_INF = "apduInf";
    private String ai_HEAD = "head";
    private String ai_RLEN = "rlen";
    private String ai_TDATA = "tdata";
    private String ai_HASH_BITMASK = "hash_bitmask";
    private String ai_SYNC = "sync";
    private String ai_NORETRY = "noretry";
    private String ai_LED = "led";
    private String ai_CARD_RESET_INF = "cardReset";
    private String ai_SETPROTO = "cardProto";
    private String ai_SEND_PTS = "cardPTS";
    private String ti_INFO_SMARTCARD = "infoSmartCard";
    private String isc_APDU_RESULT = "apdu_result";
    private String isc_APDU_RESULT_ERROR = "0";
    private String isc_APDU_RESULT_OK = "1";
    private String isc_REC_LEN = "rec_len";
    private String isc_REC_DATA = "rec_data";
    private String isc_HASH_RESULT = "hash_result";
    private String isc_PROC_BYTE = "proc_byte";
    private String isc_STATUS = "status";
    private String isc_RESET_RESULT = "reset_result";
    private String isc_RESET_RESULT_ERROR = "0";
    private String isc_RESET_RESULT_OK = "1";
    private String isc_RESET_ATR = this.ir_TOKEN_ATR;
    private String isc_RESET_ATR_HIST_START = this.ir_TOKEN_ATR_HIST_START;
    private String isc_RESET_ATR_HIST_LEN = this.ir_TOKEN_ATR_HIST_LEN;
    private String isc_SETPROTO_RESULT = "cardProto_result";
    private String isc_SETPROTO_ERROR = "0";
    private String isc_SETPROTO_OK = "1";
    private String isc_SEND_PTS_RESULT = "cardPTS_result";
    private String isc_SEND_PTS_RESULT_ERROR = "0";
    private String isc_SEND_PTS_RESULT_OK = "1";
    private Vector configFiles;
    private int configFileIndex;
    private int configFileTokenIndex;
    private int labelsIndex = 0;
    private int firstConfigFileTokenIndex = 1;
    private static final int noExceptionHandlerIndex = -1;
    private int exceptionHandlerIndex = -1;
    private static final int noLabelIndex = -1;
    private Hashtable labels;
    private String configTokensSource = null;
    private SmartCardWordsImpl scwi;
    static final String WIpropPrefix = "_WI_";
    static final String TokenID = "_WI_TokenID.ID";
    static final String TokenType = "_WI_TokenID.name";
    static final String Xchange_APDU = "_WI_Xchange_APDU.APDU";
    static final String Xchange_APDU_rlen = "_WI_Xchange_APDU.rlen";
    static final String Xchange_APDU_bitmask = "_WI_Xchange_APDU.bitmask";
    static final String Display_Message = "_WI_Display_Message";
    static final String Debug_Set = "_WI_Debug_Set";
    static final String Jump_Label = "_WI_Jump_Label";
    static final String CardProtocol = "_WI_cardProtocol";
    static final String CardPTS = "_WI_cardPTS";
    Properties ATRprops;
    static final String ATR_prop_prefix = "atr.";
    static final String ATR_data_prop = "atr.atr";
    static final String ATR_history_prop = "atr.history";
    static final String DEBUG_prop_prefix = "debug.";
    static final String DEBUG_words = "debug.words";
    static final String DEBUG_msg = "debug.msg";
    static final String DTU_prop_prefix = "dtu.";

    public SmartCardID(Terminal terminal, Vector vector, Vector vector2, String string) {
        this.term = terminal;
        this.state = 43;
        this.ATRprops = new Properties();
        this.labels = new Hashtable();
        this.tokenInfo = new Hashtable();
        this.configFiles = vector;
        this.configFileIndex = 0;
        this.configFileTokenIndex = this.firstConfigFileTokenIndex;
        this.terminalTokens = vector2;
        this.msgTag = string;
        this.scwi = new SmartCardWordsImpl(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(String string, Hashtable hashtable) throws SmartCardIDException {
        boolean bl;
        Object object;
        Object object2;
        String string2;
        String string3;
        if (string.equals(this.ti_INFO_REQ)) {
            string3 = (String)hashtable.get(this.ir_EVENT_MSG);
            if (string3.equals(this.ir_INSERT_EVENT)) {
                string2 = (String)hashtable.get(this.ir_TOKEN_TYPE);
                if (string2 == null) {
                    throw new SmartCardIDException("No token type received for message: [" + string + "] " + "event: [" + string3 + "]");
                }
                if (this.terminalTokens.contains(string2.toLowerCase())) {
                    this.state = 1;
                    return true;
                }
                this.tokenInfo.clear();
                object2 = hashtable.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    this.tokenInfo.put(object, hashtable.get(object));
                }
                this.setupATRprops(string, string3, hashtable);
                this.state = 1;
            } else {
                if (!string3.equals(this.ir_REMOVE_EVENT)) {
                    this.state = 43;
                    throw new SmartCardIDException("Unknown event: [" + string3 + "] " + "for message: [" + string + "] " + "from terminal");
                }
                this.state = 42;
            }
        } else {
            if (!string.equals(this.ti_INFO_SMARTCARD)) {
                throw new SmartCardIDException("Unknown message: [" + string + "] " + "from terminal");
            }
            string2 = this.expectedMsgTag;
            this.expectedMsgTag = null;
            string3 = (String)hashtable.get("tag");
            if (string2 == null) {
                if (string3 != null) throw new SmartCardIDException("Message: [" + this.ti_INFO_SMARTCARD + "] " + "message tag: [" + string3 + "] " + "not expected");
                string3 = "(no message tag received)";
                throw new SmartCardIDException("Message: [" + this.ti_INFO_SMARTCARD + "] " + "message tag: [" + string3 + "] " + "not expected");
            }
            if (string3 != null) {
                if (!string3.equals(string2)) {
                    throw new SmartCardIDException("Message: [" + this.ti_INFO_SMARTCARD + "] " + "has wrong message tag. " + "Expected: [" + string2 + "] " + "Received: [" + string3 + "] ");
                }
            } else if (this.needMsgTags) {
                throw new SmartCardIDException("Message: [" + this.ti_INFO_SMARTCARD + "] " + "does not have a message tag");
            }
        }
        boolean bl2 = false;
        block21: do {
            bl = false;
            switch (this.state) {
                case 1: {
                    this.configFileIndex = 0;
                    this.configFileTokenIndex = this.firstConfigFileTokenIndex;
                    this.scwi.clear();
                    this.exceptionHandlerIndex = -1;
                    this.loadLabels(this.configFileIndex);
                    this.state = 40;
                    break;
                }
                case 40: {
                    bl2 = this.processMsg(hashtable);
                    if (!bl2) continue block21;
                    this.state = 41;
                    break;
                }
                case 20: 
                case 21: {
                    object2 = (String)hashtable.get(this.isc_APDU_RESULT);
                    if (object2 == null) {
                        throw new SmartCardIDException("Missing APDU operation result");
                    }
                    object = (String)hashtable.get(this.isc_PROC_BYTE);
                    if (object == null) {
                        throw new SmartCardIDException("Missing APDU Procedure Byte");
                    }
                    String string4 = (String)hashtable.get(this.isc_STATUS);
                    if (string4 == null) {
                        throw new SmartCardIDException("Missing APDU Status");
                    }
                    String string5 = (String)hashtable.get(this.isc_REC_LEN);
                    if (string5 == null) {
                        throw new SmartCardIDException("Missing APDU Receive Length");
                    }
                    boolean bl3 = false;
                    try {
                        if (Integer.parseInt(string5, 16) > 0) {
                            bl3 = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SmartCardIDException("APDU Receive Length format error: [" + string5 + "]");
                    }
                    boolean bl4 = false;
                    if (((String)object2).equals(this.isc_APDU_RESULT_OK)) {
                        boolean bl5 = false;
                        bl4 = true;
                        if (bl3) {
                            String string6 = (String)hashtable.get(this.isc_REC_DATA);
                            String string7 = (String)hashtable.get(this.isc_HASH_RESULT);
                            if (string6 == null) {
                                throw new SmartCardIDException("Missing APDU data");
                            }
                            bl5 = true;
                            this.scwi.pushHex(string6);
                            if (string7 != null) {
                                this.scwi.pushHex(string7);
                                hashtable.remove(string7);
                            }
                        }
                        if (this.state != 21) {
                            this.scwi.push(bl5);
                        }
                    }
                    this.scwi.pushHex((String)object);
                    this.scwi.pushHex(string4);
                    this.scwi.push(bl4);
                    this.state = 40;
                    break;
                }
                case 11: {
                    object2 = new Hashtable();
                    this.stuffAPDU((Hashtable)object2, hashtable);
                    object = (String)hashtable.get(Xchange_APDU_bitmask);
                    if (object != null) {
                        ((Hashtable)object2).put(this.ai_HASH_BITMASK, object);
                        hashtable.remove(Xchange_APDU_bitmask);
                    }
                    ((Hashtable)object2).put("command", this.ai_APDU_INF);
                    if (!this.write(this.tc_SMARTCARD, (Hashtable)object2, this.getUniqueTag())) {
                        this.state = 2;
                        throw new SmartCardIDException("Error sending message to terminal");
                    }
                    this.state = 20;
                    bl = true;
                    break;
                }
                case 10: {
                    object2 = new Hashtable();
                    this.stuffAPDU((Hashtable)object2, hashtable);
                    ((Hashtable)object2).put("command", this.ai_APDU_INF);
                    if (!this.write(this.tc_SMARTCARD, (Hashtable)object2, this.getUniqueTag())) {
                        throw new SmartCardIDException("Error sending message to terminal");
                    }
                    this.state = 21;
                    bl = true;
                    break;
                }
                case 12: {
                    object2 = (String)hashtable.get(CardProtocol);
                    object = new Hashtable<String, Object>();
                    ((Hashtable)object).put("protocol", object2);
                    ((Hashtable)object).put("command", this.ai_SETPROTO);
                    if (!this.write(this.tc_SMARTCARD, (Hashtable)object, this.getUniqueTag())) {
                        throw new SmartCardIDException("Error sending card_proto message to terminal");
                    }
                    this.state = 30;
                    bl = true;
                    break;
                }
                case 30: {
                    object2 = (String)hashtable.get(this.isc_SETPROTO_RESULT);
                    if (object2 == null) {
                        throw new SmartCardIDException("Missing cardProto operation result");
                    }
                    if (((String)object2).equals(this.isc_SETPROTO_OK)) {
                        this.scwi.push(true);
                    } else {
                        this.scwi.push(false);
                    }
                    this.state = 40;
                    break;
                }
                case 13: {
                    object2 = (String)hashtable.get(CardPTS);
                    object = new Hashtable();
                    ((Hashtable)object).put("pts", object2);
                    ((Hashtable)object).put("command", this.ai_SEND_PTS);
                    if (!this.write(this.tc_SMARTCARD, (Hashtable)object, this.getUniqueTag())) {
                        throw new SmartCardIDException("Error sending pts message to terminal");
                    }
                    this.state = 31;
                    bl = true;
                    break;
                }
                case 31: {
                    object2 = (String)hashtable.get(this.isc_SEND_PTS_RESULT);
                    if (object2 == null) {
                        throw new SmartCardIDException("Missing cardPTS operation result");
                    }
                    if (((String)object2).equals(this.isc_SEND_PTS_RESULT_OK)) {
                        this.scwi.push(true);
                    } else {
                        this.scwi.push(false);
                    }
                    this.state = 40;
                    break;
                }
                case 2: {
                    this.state = 1;
                    throw new SmartCardIDException("Error while communicating with terminal");
                }
                case 3: {
                    this.state = 1;
                    throw new SmartCardIDException("Timeout while waiting for terminal response");
                }
                case 41: {
                    object2 = this.tokenInfo.keys();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        hashtable.put(object, this.tokenInfo.get(object));
                    }
                    hashtable.put(this.ir_TOKEN_TYPE, hashtable.get(TokenType));
                    hashtable.put(this.ir_TOKEN_ID, hashtable.get(TokenID));
                    return true;
                }
                case 42: {
                    this.state = 43;
                    bl2 = true;
                    break;
                }
                case 43: {
                    return true;
                }
                case 100: {
                    object = new Hashtable<String, String>();
                    ((Hashtable)object).put("command", this.ai_CARD_RESET_INF);
                    if (!this.write(this.tc_SMARTCARD, (Hashtable)object, this.getUniqueTag())) {
                        this.state = 2;
                        throw new SmartCardIDException("Error sending message to terminal");
                    }
                    this.state = 101;
                    bl = true;
                    break;
                }
                case 101: {
                    String string5;
                    object = (String)hashtable.get(this.isc_RESET_RESULT);
                    if (object == null) {
                        throw new SmartCardIDException("Missing cardReset operation result");
                    }
                    boolean bl6 = false;
                    if (((String)object).equals(this.isc_RESET_RESULT_OK)) {
                        string5 = (String)hashtable.get(this.isc_RESET_ATR);
                        if (object == null) {
                            throw new SmartCardIDException("Missing ATR from cardReset");
                        }
                        String string8 = (String)hashtable.get(this.isc_RESET_ATR_HIST_START);
                        if (object == null) {
                            throw new SmartCardIDException("Missing ATR history start from cardReset");
                        }
                        bl6 = true;
                        this.scwi.pushHex(string5);
                        this.setupATRprops(this.ti_INFO_SMARTCARD, this.ai_CARD_RESET_INF, hashtable);
                    }
                    this.scwi.push(bl6);
                    this.state = 40;
                    break;
                }
                default: {
                    this.state = 1;
                    throw new SmartCardIDException("Invalid state: " + this.state);
                }
            }
        } while (!bl);
        return bl2;
    }

    public boolean processMsg(Hashtable hashtable) {
        while (this.configFileIndex < this.configFiles.size()) {
            Vector vector = (Vector)this.configFiles.get(this.configFileIndex);
            int n = vector.size();
            block19: while (this.configFileTokenIndex < n) {
                String string;
                String string2;
                String string3;
                String string4 = (String)vector.get(this.configFileTokenIndex++);
                try {
                    int n2 = this.scwi.wordImpl(string4, hashtable);
                    switch (n2) {
                        case 0: {
                            continue block19;
                        }
                        case 10: {
                            this.state = 10;
                            return false;
                        }
                        case 11: {
                            this.state = 11;
                            return false;
                        }
                        case 20: {
                            this.state = 41;
                            return true;
                        }
                        case 21: {
                            this.configFileTokenIndex = n;
                            continue block19;
                        }
                        case 30: {
                            System.out.print((String)hashtable.get(Display_Message));
                            continue block19;
                        }
                        case 31: {
                            Log.notice((String)((String)hashtable.get(Display_Message)));
                            continue block19;
                        }
                        case 32: {
                            continue block19;
                        }
                        case 40: 
                        case 50: {
                            int n3 = this.labelIndex((String)hashtable.get(Jump_Label), n);
                            if (n3 == -1) {
                                n3 = n;
                            }
                            if (n2 == 40) {
                                this.configFileTokenIndex = n3;
                                continue block19;
                            }
                            this.exceptionHandlerIndex = n3;
                            continue block19;
                        }
                        case 100: {
                            this.state = 100;
                            return false;
                        }
                        case 12: {
                            this.state = 12;
                            return false;
                        }
                        case 13: {
                            this.state = 13;
                            return false;
                        }
                    }
                    Log.configError((String)("SmartCardID:processMsg: wordImpl unknown return code: " + n2));
                    this.configFileTokenIndex = n;
                }
                catch (EmptyStackException emptyStackException) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    this.configFileTokenIndex = this.adjustConfigTokenIndex(n, stringBuffer);
                    string3 = "SmartCardID:processMsg: EmptyStackException";
                    string2 = emptyStackException.getMessage();
                    if (string2 != null) {
                        string3 = string3 + ": " + string2;
                    }
                    string = string3 + stringBuffer.toString();
                    Log.configError((String)string);
                    this.scwi.push(string3);
                    this.scwi.push("EmptyStackException");
                    System.out.println(string);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    this.configFileTokenIndex = this.adjustConfigTokenIndex(n, stringBuffer);
                    string3 = "SmartCardID:processMsg: NumberFormatException";
                    string2 = numberFormatException.getMessage();
                    if (string2 != null) {
                        string3 = string3 + ": " + string2;
                    }
                    string = string3 + stringBuffer.toString();
                    Log.configError((String)string);
                    this.scwi.push(string3);
                    this.scwi.push("NumberFormatException");
                    System.out.println(string);
                }
                catch (SmartCardWordException smartCardWordException) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    this.configFileTokenIndex = this.adjustConfigTokenIndex(n, stringBuffer);
                    string3 = smartCardWordException.getMessage() + stringBuffer.toString();
                    Log.configError((String)string3);
                    this.scwi.push(smartCardWordException.getMessage());
                    this.scwi.push("SmartCardWordException");
                    System.out.println(string3);
                }
            }
            this.loadLabels(++this.configFileIndex);
            this.configFileTokenIndex = this.firstConfigFileTokenIndex;
            this.scwi.clear();
            this.exceptionHandlerIndex = -1;
        }
        hashtable.put(TokenType, this.ir_UNKNOWN_TOKEN);
        hashtable.put(TokenID, this.ir_UNKNOWN_ID);
        this.state = 41;
        return true;
    }

    private void stuffAPDU(Hashtable hashtable, Hashtable hashtable2) {
        String string = (String)hashtable2.get(Xchange_APDU);
        String string2 = (String)hashtable2.get(Xchange_APDU_rlen);
        int n = string.length();
        hashtable.put(this.ai_HEAD, string.substring(0, Math.min(8, n)));
        if (n >= 10) {
            hashtable.put(this.ai_TDATA, string.substring(10));
        }
        if (string2 != null) {
            hashtable.put(this.ai_RLEN, string2);
        }
    }

    private void setupATRprops(String string, String string2, Hashtable hashtable) throws SmartCardIDException {
        this.ATRprops.clear();
        String string3 = (String)hashtable.get(this.ir_TOKEN_ATR);
        if (string3 == null) {
            throw new SmartCardIDException("No ATR received for message: [" + string + "] " + "event: [" + string2 + "]");
        }
        this.ATRprops.setProperty(ATR_data_prop, this.scwi.getHexFromString(string3));
        int n = 0;
        String string4 = (String)hashtable.get(this.ir_TOKEN_ATR_HIST_START);
        if (string4 != null) {
            try {
                int n2 = Integer.parseInt(string4, 16) * 2;
                String string5 = (String)hashtable.get(this.ir_TOKEN_ATR_HIST_LEN);
                if (string5 == null && (string5 = string3.substring(3, 4)) == null) {
                    n = string3.length() - n2;
                }
                if (string5 != null) {
                    try {
                        n = Integer.parseInt(string5, 16) * 2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = string3.length() - n2;
                        Log.unexpectedError((String)("SmartCardID: invalid ATR history length: [" + string5 + "]"));
                    }
                }
                if (n2 + n <= string3.length()) {
                    this.ATRprops.setProperty(ATR_history_prop, this.scwi.getHexFromString(string3.substring(n2, n2 + n)));
                } else {
                    Log.unexpectedError((String)("SmartCardID: invalid ATR history start: " + n2 + "history length: " + n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.unexpectedError((String)("SmartCardID: invalid ATR history start: [" + string4 + "]"));
            }
        }
    }

    private void loadLabels(int n) {
        this.configTokensSource = null;
        if (this.configFiles.isEmpty()) {
            return;
        }
        if (this.configFileIndex >= this.configFiles.size()) {
            return;
        }
        Hashtable hashtable = (Hashtable)((Vector)this.configFiles.get(n)).get(this.labelsIndex);
        this.labels.clear();
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.labels.put(string, (String)hashtable.get(string));
        }
        this.configTokensSource = (String)this.labels.get("ConfigTokensSourceKey");
    }

    private int labelIndex(String string, int n) {
        int n2 = -1;
        String string2 = (String)this.labels.get(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
                if (n2 > n) {
                    Log.configError((String)("SmartCardID:processMsg: label: [" + string + "] " + "has invalid offset: " + n2));
                    n2 = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.configError((String)("SmartCardID:processMsg: label: [" + string + "] " + "is not a valid label"));
                n2 = -1;
            }
        } else {
            Log.configError((String)("SmartCardID:processMsg: unknown label: [" + string + "]"));
            n2 = -1;
        }
        return n2;
    }

    private int adjustConfigTokenIndex(int n, StringBuffer stringBuffer) {
        int n2 = n;
        if (this.exceptionHandlerIndex != -1) {
            n2 = this.exceptionHandlerIndex;
            stringBuffer.append(" (caught)");
            this.exceptionHandlerIndex = -1;
        }
        return n2;
    }

    public void tick() {
        this.mStime += this.mSticks;
    }

    public void setTickTime(int n) {
        this.mSticks = n;
    }

    private synchronized String getUniqueTag() {
        this.expectedMsgTag = this.msgTag + ":" + Integer.toHexString(this.tagCtr++);
        return this.expectedMsgTag;
    }

    private boolean write(String string, Hashtable hashtable, String string2) {
        hashtable.put("tag", string2);
        return this.term.write(string, hashtable);
    }
}

