/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.Poller;
import auth.utauthd.WatchIOListener;
import auth.utauthd.WatchIORequest;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class WatchIO
implements Runnable,
WatchIOListener {
    public static final short INPUT = 1;
    private static final int FIRSTLIMIT = 32;
    private static final int INCREMENT = 1024;
    private WatchIORequest[] mapping = new WatchIORequest[32];
    private Poller mux;
    private int[] fds = new int[32];
    private short[] revents = new short[32];
    private TreeSet timeSortedList = new TreeSet();
    private static WatchIO watcher;
    private static Thread thread;
    private Object inhibitUpdatesLock = new Object();
    private boolean inhibitUpdates = false;
    private Object updatesPendingLock = new Object();
    private int updatesPending = 0;
    FileInputStream alertInStream;
    FileOutputStream alertOutStream;
    FileDescriptor pipeIn;
    int pipeInFDN;

    private WatchIO() {
        for (int i = 0; i < this.mapping.length; ++i) {
            this.mapping[i] = null;
            this.fds[i] = 0;
            this.revents[i] = 0;
        }
        try {
            this.mux = new Poller();
        }
        catch (Exception exception) {
            Log.unexpectedError((String)"Cannot initializer Poller object");
            System.exit(1);
        }
        int[] nArray = WatchIO.pipe();
        Class<?> clazz = null;
        Field field = null;
        try {
            clazz = Class.forName("java.io.FileDescriptor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.unexpectedError((String)("program error: " + classNotFoundException));
            System.exit(1);
        }
        try {
            field = clazz.getDeclaredField("fd");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.unexpectedError((String)("program error: " + noSuchFieldException));
            System.exit(1);
        }
        field.setAccessible(true);
        FileDescriptor fileDescriptor = new FileDescriptor();
        try {
            field.set(fileDescriptor, new Integer(nArray[1]));
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.unexpectedError((String)("program error: " + illegalAccessException));
        }
        this.alertOutStream = new FileOutputStream(fileDescriptor);
        this.pipeIn = new FileDescriptor();
        this.pipeInFDN = nArray[0];
        try {
            field.set(this.pipeIn, new Integer(this.pipeInFDN));
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.unexpectedError((String)("program error: " + illegalAccessException));
        }
        this.alertInStream = new FileInputStream(this.pipeIn);
        try {
            this.doAdd(new WatchIORequest(this.alertInStream.getFD(), 1, this, false, "alert"));
        }
        catch (Exception exception) {
            Log.unexpectedError((String)exception.toString());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doAdd(WatchIORequest watchIORequest) {
        int n;
        try {
            n = this.mux.add(watchIORequest.getFdObj(), watchIORequest.mask);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("WatchIO.doAdd: cannot add wl socket to mux: " + exception));
            n = -1;
            System.exit(1);
        }
        if (this.mapping.length < n + 1) {
            int n2 = n + 1023 & 0xFFFFFC00;
            WatchIORequest[] watchIORequestArray = new WatchIORequest[n2];
            for (int i = 0; i < this.mapping.length; ++i) {
                watchIORequestArray[i] = this.mapping[i];
                this.mapping[i] = null;
            }
            this.mapping = watchIORequestArray;
        }
        if (watchIORequest == null) {
            Log.unexpectedError((String)"add null WatchIORequest!");
            System.exit(1);
        }
        this.mapping[n] = watchIORequest;
        if (watchIORequest.resetExpiryTime()) {
            WatchIORequest watchIORequest2 = watchIORequest;
            synchronized (watchIORequest2) {
                watchIORequest.busy = true;
                this.timeSortedList.add(watchIORequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doRemove(WatchIORequest watchIORequest) {
        int n;
        if (watchIORequest == null) {
            Log.unexpectedError((String)"WatchIO.doRemove(null)");
            return;
        }
        if (watchIORequest.isActiveAlarm()) {
            WatchIORequest watchIORequest2 = watchIORequest;
            synchronized (watchIORequest2) {
                watchIORequest.busy = false;
                this.timeSortedList.remove(watchIORequest);
            }
        }
        if ((n = watchIORequest.getFd()) == -1) {
            Log.unexpectedError((String)("WatchIO.doRemove: cannot get fd for " + watchIORequest));
            return;
        }
        WatchIORequest watchIORequest3 = this.mapping[n];
        FileDescriptor fileDescriptor = watchIORequest.getFdObj();
        if (watchIORequest3 != null && watchIORequest3.getFdObj() == fileDescriptor && watchIORequest3 == watchIORequest) {
            try {
                this.mux.remove(fileDescriptor);
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("WatchIO.doRemove: " + exception));
                System.exit(1);
            }
            this.mapping[n] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        WatchIORequest watchIORequest = null;
        try {
            while (true) {
                WatchIORequest watchIORequest2 = null;
                Object object = this.inhibitUpdatesLock;
                synchronized (object) {
                    this.inhibitUpdates = false;
                    this.inhibitUpdatesLock.notifyAll();
                }
                object = this.updatesPendingLock;
                synchronized (object) {
                    while (this.updatesPending > 0) {
                        try {
                            this.updatesPendingLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.unexpectedError((String)"updatesPendingLock intr");
                        }
                    }
                }
                object = this.inhibitUpdatesLock;
                synchronized (object) {
                    this.inhibitUpdates = true;
                    this.inhibitUpdatesLock.notifyAll();
                }
                watchIORequest = null;
                try {
                    watchIORequest = (WatchIORequest)this.timeSortedList.first();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                long l2 = -1L;
                if (watchIORequest != null) {
                    l2 = watchIORequest.getExpiryTime() - System.currentTimeMillis();
                    if (l2 <= 0L) {
                        l2 = 1L;
                    }
                    watchIORequest = null;
                }
                try {
                    n = this.mux.waitMultiple(this.fds, this.revents, l2);
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("WatchIO.run: program error: " + exception));
                    System.exit(1);
                }
                l = System.currentTimeMillis();
                for (n2 = 0; n2 < n; ++n2) {
                    if (this.fds[n2] == -1) continue;
                    if (this.revents[n2] == 0) {
                        Log.unexpectedError((String)"WatchIO.run: revents=0");
                    }
                    if ((watchIORequest2 = this.mapping[this.fds[n2]]) == null) continue;
                    if (watchIORequest2.isAutoRemove()) {
                        this.doRemove(watchIORequest2);
                    }
                    if (watchIORequest2.isExpired(l)) {
                        int n3 = n2;
                        this.revents[n3] = (short)(this.revents[n3] | 0x1000);
                        WatchIORequest watchIORequest3 = watchIORequest2;
                        synchronized (watchIORequest3) {
                            watchIORequest2.busy = false;
                            this.timeSortedList.remove(watchIORequest2);
                        }
                    }
                    if (watchIORequest2.listener.watchIOEvent(this.revents[n2], watchIORequest2.arg)) {
                        if (!watchIORequest2.isAutoRemove()) continue;
                        watchIORequest2.resetExpiryTime();
                        watcher.doAdd(watchIORequest2);
                        continue;
                    }
                    if (watchIORequest2.isAutoRemove()) continue;
                    this.doRemove(watchIORequest2);
                }
                while (true) {
                    try {
                        watchIORequest2 = (WatchIORequest)this.timeSortedList.first();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        watchIORequest2 = null;
                    }
                    if (watchIORequest2 == null || !watchIORequest2.isExpired(l)) break;
                    if (watchIORequest2.isAutoRemove()) {
                        this.doRemove(watchIORequest2);
                    }
                    if (watchIORequest2.listener.watchIOEvent((short)4096, watchIORequest2.arg)) {
                        if (!watchIORequest2.isAutoRemove()) continue;
                        watchIORequest2.resetExpiryTime();
                        watcher.doAdd(watchIORequest2);
                        continue;
                    }
                    if (watchIORequest2.isAutoRemove()) continue;
                    this.doRemove(watchIORequest2);
                }
                watchIORequest2 = null;
            }
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("WatchIO.run():" + exception));
            return;
        }
    }

    private void printQueue(String string, int n) {
        System.out.println(string + "WatchIO queue: " + (n <= 0 ? "empty" : "(" + n + ")"));
        for (int i = 0; i < n; ++i) {
            System.out.print(string + "    " + i + ": ");
            int n2 = this.fds[i];
            System.out.print(n2 + ", ");
            if (n2 >= 0) {
                System.out.println(this.mapping[n2]);
                continue;
            }
            System.out.println("invalid");
        }
        System.out.println("");
    }

    public static void add(WatchIORequest watchIORequest) {
        watcher.addRemove(watchIORequest, true);
    }

    public static void remove(WatchIORequest watchIORequest) {
        watcher.addRemove(watchIORequest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemove(WatchIORequest watchIORequest, boolean bl) {
        if (Thread.currentThread() == thread) {
            if (bl) {
                watcher.doAdd(watchIORequest);
            } else {
                watcher.doRemove(watchIORequest);
            }
            return;
        }
        Object object = this.updatesPendingLock;
        synchronized (object) {
            if (this.updatesPending++ == 0) {
                try {
                    this.alert();
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)"WatchIO.addRemove: alert");
                }
            }
        }
        object = this.inhibitUpdatesLock;
        synchronized (object) {
            while (this.inhibitUpdates) {
                try {
                    this.inhibitUpdatesLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.unexpectedError((String)"WatchIO.addRemove: inhibitUpdatesLock intr");
                }
                if (!this.inhibitUpdates) continue;
                Log.unexpectedError((String)"WatchIO.addRemove: still waiting for inhibitUpdatesLock");
            }
            if (bl) {
                this.doAdd(watchIORequest);
            } else {
                this.doRemove(watchIORequest);
            }
        }
        object = this.updatesPendingLock;
        synchronized (object) {
            if (--this.updatesPending < 0) {
                Log.unexpectedError((String)"WatchIO.addRemove: program error");
            }
            if (this.updatesPending == 0) {
                this.updatesPendingLock.notifyAll();
            }
        }
    }

    public boolean watchIOEvent(short s, Object object) {
        try {
            WatchIO.clearAlert(this.pipeInFDN);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("clearAlert(): " + exception));
            System.exit(1);
        }
        return true;
    }

    private void alert() {
        try {
            this.alertOutStream.write(0);
            this.alertOutStream.flush();
        }
        catch (IOException iOException) {
            Log.unexpectedError((String)("WatchIO.alert: " + iOException));
        }
    }

    private static native int[] pipe();

    private static native void clearAlert(int var0) throws IOException;

    static {
        System.loadLibrary("watchio");
        if (watcher == null) {
            watcher = new WatchIO();
            thread = new Thread((Runnable)watcher, "WatchIO");
            thread.start();
        }
    }
}

