/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.sunray;

import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.terminal.sunray.CardNotPresentException;
import com.sun.opencard.terminal.sunray.SunRayCardTerminalFactory;
import com.sun.opencard.terminal.sunray.SunRayDeferredEventHandler;
import com.sun.opencard.terminal.sunray.SunRayReaderHandle;
import com.sun.opencard.terminal.sunray.TerminalUnavailableException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.TerminalInitException;
import opencard.core.util.HexString;

public class SunRayCardTerminal
extends CardTerminal
implements Runnable {
    private static final String SCCS_ID = "@(#)SunRayCardTerminal.java\t1.30 02/12/03 SMI";
    private String sessionID;
    private String Xdisplay;
    private String filterKey;
    private String readerName;
    private SunRayReaderHandle readerHandle;
    private static final long rootUID = 0L;
    private Vector sessionListeners = new Vector();
    private static final String sessionManagerHost = "localhost";
    private static final int sessionManagerPort = 7007;
    private Thread sessionMgrPoller = null;
    private boolean sessionMgrPollerRun = true;
    private int sessionMgrPollerTerminateMult = 2;
    private int sessionManagerReadTimeout = 30000;
    private int sessionManagerRestartTimeout = 5000;
    private int sessionManagerReopenTimeout = 5000;
    static final int CARD_NO_EVENT = 0;
    static final int CARD_INSERTED_EVENT = 1;
    static final int CARD_REMOVED_EVENT = 2;
    private int lastCardEvent = 0;
    private Object lastCardEventLock = new Object();
    private static final String[] lastCardEventS = new String[]{"CARD_NO_EVENT", "CARD_INSERTED_EVENT", "CARD_REMOVED_EVENT"};
    private boolean displayedFeatureList = false;
    private static final String[] features = new String[]{"display", "true", "keyboard", "true", "leds", "1", "led.0", "green", "removable", "true", "SPEM", "true"};
    private Properties termProps;
    public CardID cardID = null;

    public SunRayCardTerminal(String string, String string2, String string3) throws CardTerminalException {
        super(string, string2, string3);
        throw new CardTerminalException("<wrong constructor>");
    }

    public SunRayCardTerminal(Properties properties) throws CardTerminalException {
        super(properties.getProperty("readerName"), properties.getProperty("modelName"), properties.getProperty("deviceAddress"));
        this.debug("<init>", properties.toString());
        this.termProps = properties;
        this.sessionID = properties.getProperty("sessionID");
        this.Xdisplay = properties.getProperty("Xdisplay");
        this.filterKey = properties.getProperty("filterKey");
        this.readerName = properties.getProperty("readerName");
        this.readerHandle = new SunRayReaderHandle(this.readerName);
        this.addSlots(1);
    }

    public void open() throws CardTerminalException {
        this.debugRN("open", "");
    }

    public void close() throws CardTerminalException {
        this.debugRN("close", "");
        this.cardID = null;
    }

    public boolean isCardPresent(int n) throws CardTerminalException {
        if (n != 0) {
            throw new CardTerminalException("invalid slot: [" + n + "]");
        }
        boolean bl = false;
        if (this.readerHandle.isAllocated()) {
            int n2 = this.readerHandle.getCardState();
            this.debugRN("isCardPresent", "state: [" + n2 + "] " + " CARD_PRESENT: [" + 1 + "]");
            if ((n2 & 1) != 0) {
                bl = true;
            }
        }
        this.debugRN("isCardPresent", "returning: [" + (bl ? "true" : "false") + "] " + "lastCardEvent: [" + lastCardEventS[this.lastCardEvent] + "]");
        return bl;
    }

    public boolean isCardPresent() throws CardTerminalException {
        return this.isCardPresent(0);
    }

    public Properties internalFeatures(Properties properties) {
        String string = new String();
        int n = 0;
        while (true) {
            if (n >= features.length) break;
            properties.put(features[n], features[n + 1]);
            string = string + features[n] + " ";
            if (!this.displayedFeatureList) {
                this.debugRN("internalFeatures", "added feature: [" + features[n] + "] = " + "[" + features[n + 1] + "]");
            }
            n += 2;
        }
        properties.put("Xdisplay", this.Xdisplay);
        string = string + "Xdisplay";
        properties.put("featureList", string);
        this.displayedFeatureList = true;
        return properties;
    }

    public CardID getCardID(int n) throws CardTerminalException {
        return this.getCardID(n, -1);
    }

    public CardID getCardID(int n, int n2) throws CardTerminalException {
        if (this.cardID == null) {
            this.cardID = this.internalReset(n, n2);
        }
        return this.cardID;
    }

    public synchronized CardID internalReset(int n, int n2) throws CardTerminalException {
        if (!this.isCardPresent(n)) {
            throw new CardTerminalException("No card in reader: [" + this.readerName + "]");
        }
        byte[] byArray = this.resetCard(n, n2);
        if (byArray != null) {
            return new CardID(this.getSlot(n), byArray);
        }
        return new CardID(this.getSlot(n), byArray);
    }

    private byte[] resetCard(int n, int n2) throws CardTerminalException {
        if (n != 0) {
            throw new CardTerminalException("invalid slot: [" + n + "]");
        }
        byte[] byArray = null;
        this.cardID = null;
        this.debugRN("resetCard", "readerHandle is: [" + (this.readerHandle.isAllocated() ? "" : "de") + "allocated]");
        if (this.readerHandle.isAllocated()) {
            this.readerHandle.resetCard(n2);
            byArray = this.readerHandle.getATR(n2);
            this.debugRN("resetCard", "ATR: [" + HexString.hexify((byte[])byArray) + "]");
        }
        return byArray;
    }

    protected ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        if (n != 0) {
            throw new CardTerminalException("invalid slot: [" + n + "]");
        }
        if (!this.readerHandle.isAllocated()) {
            throw new CardTerminalException("reader not allocated");
        }
        byte[] byArray = this.readerHandle.exchange_APDU(commandAPDU.getBuffer(), n2);
        return new ResponseAPDU(byArray);
    }

    public String getFilterKey() {
        this.debugRN("getFilterKey", "filterKey: [" + this.filterKey + "]");
        return this.filterKey;
    }

    public boolean isClientAuthorized(long l) {
        long l2 = 0L;
        boolean bl = l == l2;
        try {
            l2 = SunRayCardTerminalFactory.getUIDfromXdisplay(this.Xdisplay);
            if (!bl) {
                bl = l == l2;
            }
        }
        catch (CardTerminalException cardTerminalException) {
            this.debugRN("isClientAuthorized/CardTerminalException", "[" + cardTerminalException.getMessage() + "]");
        }
        this.debugRN("isClientAuthorized", "authorized: [" + (bl ? "true" : "false") + "] " + "client UID: [" + l + "] " + "owner UID: [" + l2 + "]");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cardRemoved(int n) {
        this.debugRN("cardRemoved", "lastCardEvent: [" + lastCardEventS[this.lastCardEvent] + "]");
        Object object = this.lastCardEventLock;
        synchronized (object) {
            if (this.lastCardEvent != 2) {
                this.lastCardEvent = 2;
                super.cardRemoved(n);
                this.cardID = null;
                this.debugRN("cardRemoved", "slot: [" + n + "]");
            }
        }
    }

    public void cardRemovedCallback() {
        this.postCallbackEvent(2, null);
    }

    public void cardRemoved() {
        if (this.readerHandle.isAllocated()) {
            try {
                SunRayCardTerminalFactory.deallocateReader(this.readerHandle);
            }
            catch (CardTerminalException cardTerminalException) {
                this.debugRN("cardRemoved/CardTerminalException", "[" + cardTerminalException.getMessage() + "]");
            }
            this.debugRN("cardRemoved", "termID: [" + this.readerHandle.getTermID() + "]");
        }
        this.cardRemoved(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cardInserted(int n) {
        this.debugRN("cardInserted", "lastCardEvent: [" + lastCardEventS[this.lastCardEvent] + "]");
        Object object = this.lastCardEventLock;
        synchronized (object) {
            if (this.lastCardEvent != 1) {
                this.lastCardEvent = 1;
                super.cardInserted(n);
                this.debugRN("cardInserted", "slot: [" + n + "]");
            }
        }
    }

    public void cardInsertedCallback(String string) {
        this.postCallbackEvent(1, string);
    }

    public void cardInserted(String string) throws TerminalInitException, CardNotPresentException, TerminalUnavailableException {
        if (!this.readerHandle.isAllocated()) {
            SunRayCardTerminalFactory.allocateReader(string, this.readerHandle);
        }
        this.cardInserted(0);
    }

    public void sessionCreated(Properties properties) {
        if (this.sessionMgrPoller == null) {
            this.sessionMgrPoller = new Thread(this);
            this.sessionMgrPoller.setDaemon(true);
            this.sessionMgrPoller.start();
        }
    }

    public void sessionDestroyed(Properties properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(SunRayCardTerminalFactory sunRayCardTerminalFactory) {
        Vector vector = this.sessionListeners;
        synchronized (vector) {
            this.sessionListeners.add(sunRayCardTerminalFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(SunRayCardTerminalFactory sunRayCardTerminalFactory) {
        Vector vector = this.sessionListeners;
        synchronized (vector) {
            this.sessionListeners.remove(sunRayCardTerminalFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callSessionListener(Properties properties) {
        Vector vector = this.sessionListeners;
        synchronized (vector) {
            Enumeration enumeration = this.sessionListeners.elements();
            while (enumeration.hasMoreElements()) {
                SunRayCardTerminalFactory sunRayCardTerminalFactory = (SunRayCardTerminalFactory)enumeration.nextElement();
                sunRayCardTerminalFactory.sessionEvent(properties);
            }
        }
    }

    public void stopSMthread() {
        this.sessionMgrPollerRun = false;
        if (this.sessionMgrPoller == null) {
            return;
        }
        try {
            this.wait(this.sessionMgrPollerTerminateMult * this.sessionManagerReadTimeout);
        }
        catch (InterruptedException interruptedException) {
            this.debugRN("stopSMthread/InterruptedException", "[" + interruptedException.getMessage() + "]");
        }
    }

    public void run() {
        while (this.sessionMgrPollerRun) {
            try {
                this.debugRN("<run>/start", "opening connection to session manager on: [localhost:7007]");
                Socket socket = new Socket(sessionManagerHost, 7007);
                socket.setSoTimeout(this.sessionManagerReadTimeout);
                this.debugRN("<run>/socket_open", "trying to join session: [" + this.sessionID + "]");
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "8859_1"));
                String string = "join " + this.sessionID;
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                bufferedWriter.flush();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "8859_1"));
                boolean bl = false;
                while (true) {
                    try {
                        String string2;
                        while ((string2 = bufferedReader.readLine()) != null) {
                            this.debugRN("<run>/sessionmgr", "session manager says: [" + string2 + "]");
                            if (!bl) {
                                if (string2.startsWith("OK/join")) {
                                    bl = true;
                                    this.debugRN("<run>/join", "joined session");
                                    continue;
                                }
                                this.debugRN("<run>/join", "error joining session: [" + string2 + "]");
                                break;
                            }
                            Properties properties = this.termProps;
                            if (string2.startsWith("disconnect")) {
                                properties.setProperty("event", "SessionDisconnect");
                                this.callSessionListener(properties);
                                this.cardRemoved();
                                continue;
                            }
                            if (string2.startsWith("connect")) {
                                String string3 = null;
                                try {
                                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                                    stringTokenizer.nextToken();
                                    string3 = stringTokenizer.nextToken();
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    this.debugRN("<run>/connect/NoSuchElementException", "malformed session manager response");
                                }
                                if (string3 == null) {
                                    this.debugRN("<run>/connect", "no termIP from session manager");
                                    continue;
                                }
                                properties.setProperty("event", "SessionConnect");
                                this.callSessionListener(properties);
                                try {
                                    this.cardInserted(string3);
                                    continue;
                                }
                                catch (CardNotPresentException cardNotPresentException) {
                                    this.debugRN("<run>/connect/CardNotPresentException (ignored)", "[" + cardNotPresentException.getMessage() + "]");
                                    continue;
                                }
                                catch (TerminalInitException terminalInitException) {
                                    this.debugRN("<run>/connect/TerminalInitException", "[" + terminalInitException.getMessage() + "]");
                                    socket.close();
                                    this.cardRemoved();
                                    properties.setProperty("event", "SessionExit");
                                    this.callSessionListener(properties);
                                    this.wakeupSMwaiters();
                                    return;
                                }
                                catch (TerminalUnavailableException terminalUnavailableException) {
                                    this.debugRN("<run>/connect/TerminalUnavailableException (restart SM connection)", "[" + terminalUnavailableException.getMessage() + "]");
                                    socket.close();
                                    socket = null;
                                    continue;
                                }
                            }
                            if (string2.startsWith("die")) {
                                socket.close();
                                this.cardRemoved();
                                properties.setProperty("event", "SessionExit");
                                this.callSessionListener(properties);
                                try {
                                    SunRayCardTerminalFactory.deallocateReader(this.readerHandle);
                                }
                                catch (CardTerminalException cardTerminalException) {
                                    this.debugRN("<run>/die/CardTerminalException", "[" + cardTerminalException.getMessage() + "]");
                                }
                                this.wakeupSMwaiters();
                                return;
                            }
                            this.debugRN("<run>/bad_sessionmgr_msg", "unknown response from session manager: [" + string2 + "]");
                        }
                        socket.close();
                        socket = null;
                        this.debugRN("<run>/EOF on socket", "closing connection to session manager");
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        if (socket != null) continue;
                    }
                    break;
                }
                this.localSleep(this.sessionManagerRestartTimeout);
            }
            catch (IOException iOException) {
                this.debugRN("<run>/IOException", "[" + iOException.getMessage() + "]");
            }
            this.localSleep(this.sessionManagerReopenTimeout);
        }
        this.wakeupSMwaiters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupSMwaiters() {
        this.debugRN("wakeupSMwaiters", "Session Manager monitor thread has terminated");
        this.sessionMgrPoller = null;
        SunRayCardTerminal sunRayCardTerminal = this;
        synchronized (sunRayCardTerminal) {
            this.notifyAll();
        }
    }

    private void localSleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            this.debug("localSleep", "Fitfull Sleep!");
            interruptedException.printStackTrace();
        }
    }

    private void postCallbackEvent(int n, String string) {
        SunRayDeferredEventHandler sunRayDeferredEventHandler = new SunRayDeferredEventHandler(this, n, string);
        Thread thread = new Thread(sunRayDeferredEventHandler);
        thread.setDaemon(true);
        thread.start();
    }

    private void debugRN(String string, String string2) {
        this.debug(string + "(" + this.readerName + ")", string2);
    }

    private void debug(String string, String string2) {
        try {
            OCFDebug.debugln((String)("SunRayCardTerminal: <" + string + "> " + string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getReaderName() {
        return this.readerName;
    }
}

