/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.sunray;

import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.terminal.sunray.CardNotPresentException;
import com.sun.opencard.terminal.sunray.SunRayCardTerminal;
import com.sun.opencard.terminal.sunray.TerminalUnavailableException;
import opencard.core.terminal.TerminalInitException;

public class SunRayDeferredEventHandler
implements Runnable {
    private static final String SCCS_ID = "@(#)SunRayDeferredEventHandler.java\t1.1 02/12/03 SMI";
    private SunRayCardTerminal cardTerminal;
    private int event;
    private String termIP;
    private String readerName;

    public SunRayDeferredEventHandler(SunRayCardTerminal sunRayCardTerminal, int n, String string) {
        this.cardTerminal = sunRayCardTerminal;
        this.event = n;
        this.termIP = string;
        this.readerName = this.cardTerminal.getReaderName();
    }

    public void run() {
        switch (this.event) {
            case 2: {
                this.debug("<run>/CARD_REMOVED_EVENT", "<nothing more to say>");
                this.cardTerminal.cardRemoved(0);
                break;
            }
            case 1: {
                this.debug("<run>/CARD_INSERTED_EVENT", "termIP = [" + this.termIP + "]");
                try {
                    this.cardTerminal.cardInserted(this.termIP);
                }
                catch (TerminalInitException terminalInitException) {
                    this.debugRN("cardInsertedCallback/TerminalInitException", "termIP: [" + this.termIP + "] [" + terminalInitException.getMessage() + "]");
                }
                catch (CardNotPresentException cardNotPresentException) {
                    this.debugRN("cardInsertedCallback/CardNotPresentException", "termIP: [" + this.termIP + "] [" + cardNotPresentException.getMessage() + "]");
                }
                catch (TerminalUnavailableException terminalUnavailableException) {
                    this.debugRN("cardInsertedCallback/TerminalUnavailableException", "termIP: [" + this.termIP + "] [" + terminalUnavailableException.getMessage() + "]");
                }
                break;
            }
            default: {
                this.debug("<run>", "(unknown event: " + this.event + ")");
            }
        }
    }

    private void debugRN(String string, String string2) {
        this.debug(string + "(" + this.readerName + ")", string2);
    }

    private void debug(String string, String string2) {
        try {
            OCFDebug.debugln((String)("SunRayDeferredEventHandler: <" + string + "> " + string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

