/*
 * Decompiled with CFR 0.152.
 */
package auth.sdk;

import auth.sdk.DTUInfo;
import auth.sdk.Token;
import auth.sdk.Utils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class AuthCallback {
    private static final String SCCS_ID = "@(#)AuthCallback.java\t1.3 02/10/10 SMI";
    private static final String LOCALHOST = "127.0.0.1";
    private static final String AUTHCALLBACK_SERVICE = "utauthd-cb";
    private static final String AUTHCALLBACK_PROTOCOL = "tcp";
    private static final int AUTHCALLBACK_PORT = 7010;
    private static final String STATUS_REQ = "status";
    private static final byte[] CRLF = "\r\n".getBytes();
    private String authHost;
    private InetAddress authIP;
    private int authCallbackPort;

    public AuthCallback(String string, int n) throws UnknownHostException {
        if (n == 0 && (n = Utils.getPortForService(AUTHCALLBACK_SERVICE, AUTHCALLBACK_PROTOCOL)) == 0) {
            n = 7010;
        }
        this.authIP = InetAddress.getByName(string);
        this.authCallbackPort = n;
        this.authHost = string;
    }

    public AuthCallback(String string) throws UnknownHostException {
        this(string, 0);
    }

    public AuthCallback() throws UnknownHostException {
        this(LOCALHOST);
    }

    private InputStream submit(String[] stringArray) throws IOException {
        Socket socket = new Socket(this.authIP, this.authCallbackPort);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
        for (int i = 0; i < stringArray.length; ++i) {
            byte[] byArray = stringArray[i].getBytes();
            bufferedOutputStream.write(byArray, 0, byArray.length);
            bufferedOutputStream.write(CRLF, 0, CRLF.length);
        }
        bufferedOutputStream.flush();
        return socket.getInputStream();
    }

    private InputStream submit(String string) throws IOException {
        String[] stringArray = new String[]{string};
        return this.submit(stringArray);
    }

    public DTUInfo[] status(Token token) throws IOException {
        InputStream inputStream = this.submit("status tokenName=" + token.getName());
        DTUInfo[] dTUInfoArray = DTUInfo.buildArray(inputStream);
        inputStream.close();
        return dTUInfoArray;
    }

    public DTUInfo[] status() throws IOException {
        InputStream inputStream = this.submit(STATUS_REQ);
        DTUInfo[] dTUInfoArray = DTUInfo.buildArray(inputStream);
        inputStream.close();
        return dTUInfoArray;
    }
}

