/*
 * Decompiled with CFR 0.152.
 */
package auth.module.Registeredxlation;

import auth.sdk.AccessControl;
import auth.sdk.Authentication;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import auth.sdk.LogicalToken;
import auth.sdk.RawToken;
import java.util.Hashtable;

public class RegisteredxlationClient
implements AuthenticationClient {
    private AccessControl access;
    private String localName;
    private RawToken rawToken;
    private Authentication module;
    private LogicalToken ltoken;
    private String sessionType = null;
    private String allowSession = null;
    private String denySession = null;
    private String options = null;
    private String startCmd = null;

    RegisteredxlationClient(AccessControl access, Authentication module, String rawTokenName, RawToken rtoken, LogicalToken ltoken, String allowSession, String denySession, String options) {
        this.access = access;
        this.module = module;
        this.localName = rawTokenName;
        this.rawToken = rtoken;
        this.ltoken = ltoken;
        this.allowSession = allowSession;
        this.denySession = denySession;
        this.options = options;
        if (this.options != null) {
            this.options = this.options.trim();
            if (this.options.length() == 0) {
                this.options = null;
            }
        }
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getGlobalName() {
        if (this.ltoken != null) {
            return this.ltoken.id;
        }
        return null;
    }

    public String getModuleName() {
        return this.module.getName();
    }

    public String getSessionManagerId() {
        if (this.ltoken != null && this.ltoken.serverName != null) {
            return this.ltoken.serverName + ":" + this.ltoken.serverPort;
        }
        return this.access.getDefaultSessionHost() + ":" + this.access.getDefaultSessionPort();
    }

    public String getServiceInitCommand() {
        if (this.options != null) {
            return this.startCmd + " -- " + this.options.trim();
        }
        return this.startCmd;
    }

    public boolean connReq(Hashtable param) {
        String cause = null;
        Log.debug((String)("RegisteredxlationClient.connReq::checking enabled : " + this.rawToken.enabled()));
        Log.debug((String)("RegisteredxlationClient.connReq::rawToken : " + this.rawToken));
        Log.debug((String)("RegisteredxlationClient.connReq::logicalToken : " + this.ltoken));
        if (!this.rawToken.enabled()) {
            this.sessionType = this.denySession;
            cause = "raw token is not enabled";
            this.ltoken.id = new String("bogus" + this.rawToken.id);
            Log.notice((String)cause);
        } else if (this.ltoken.sessionType == null) {
            this.sessionType = this.denySession;
            cause = "no session type in logical token record";
            Log.notice((String)cause);
        } else if (this.ltoken.sessionType.equals("default")) {
            this.sessionType = this.allowSession;
            cause = "default session";
        } else {
            this.sessionType = this.ltoken.sessionType;
            cause = "session type specified in logical token record";
        }
        this.startCmd = this.access.getServiceStartCommand(this.sessionType);
        if (this.startCmd == null && !this.sessionType.equals(this.denySession)) {
            cause = "session type \"" + this.sessionType + "\" is not valid";
            this.sessionType = this.denySession;
            this.startCmd = this.access.getServiceStartCommand(this.sessionType);
        }
        if (this.sessionType == null || this.startCmd == null) {
            Hashtable<String, String> arg = new Hashtable<String, String>(3);
            arg.put("access", "denied");
            if (this.startCmd == null) {
                arg.put("cause", "invalidSessionType:" + this.ltoken.sessionType);
            } else {
                arg.put("cause", "noSessionType");
            }
            this.access.send("discInf", arg);
            return false;
        }
        return this.access.connect(this.ltoken.sessionType);
    }

    public boolean message(String command, Hashtable param) {
        if (command.equals("infoReq")) {
            String event = (String)param.get("event");
            String type = (String)param.get("type");
            if (event != null && event.equals("remove")) {
                this.access.disconnect("token removed: " + this.localName + ":" + this.ltoken.id);
                return false;
            }
            if (event != null && event.equals("insert")) {
                Log.notice((String)"RegisteredxlationClient: Why am I seeing \"insert\"? Goodbye.");
                this.access.disconnect("token removed: " + this.localName + ":" + this.ltoken.id);
                return false;
            }
            Log.notice((String)("RegisteredxlationClient message: ignored event=" + (event == null ? "(null)" : event)));
            return true;
        }
        if (command.equals("discReq")) {
            Log.debug((String)"RegisteredxlationClient.message: disconnecting");
            this.access.disconnect("discReq-or-terminated");
            return false;
        }
        Log.notice((String)("RegisteredxlationClient message: ignored " + command));
        return true;
    }

    public void close() {
        Log.notice((String)"RegisteredxlationClient close");
    }
}

