/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.RenderingUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

abstract class RowColumnRenderer
extends AbstractRenderer {
    private static final String TABLE_ELEMENT = "table";
    private static final String CAPTION_ELEMENT = "td";
    private static final String ROW_ELEMENT = "tr";
    private static final String CELL_ELEMENT = "td";
    protected static final int TABLE_STYLE = 0;
    protected static final int CAPTION_STYLE = 1;
    protected static final int ROWEVEN_STYLE = 2;
    protected static final int ROWODD_STYLE = 3;
    protected static final int CELLEVEN_STYLE = 4;
    protected static final int CELLODD_STYLE = 5;

    protected void renderRowColumnLayout(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, int rows, int columns) throws IOException {
        writer.startElement(TABLE_ELEMENT, component);
        this.writeStyleAttribute(component, writer, null);
        String styles = RenderingUtilities.getStyleClasses(context, component, this.getRowColumnStyle(theme, 0));
        if (styles != null) {
            writer.writeAttribute("class", (Object)styles, null);
        }
        RowColumnRenderer.addStringAttributes(context, component, writer, I18N_ATTRIBUTES);
        this.renderRows(context, component, theme, writer, rows, columns);
        writer.endElement(TABLE_ELEMENT);
    }

    private void renderRows(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, int rows, int columns) throws IOException {
        int row = 0;
        writer.startElement(ROW_ELEMENT, component);
        writer.writeAttribute("class", (Object)this.getRowColumnStyle(theme, 3), null);
        writer.startElement("td", component);
        String style = this.getRowColumnStyle(theme, 1);
        if (style != null) {
            writer.writeAttribute("class", (Object)style, null);
        }
        this.renderCaption(context, component, theme, writer);
        writer.endElement("td");
        int itemN = 0;
        for (row = 1; row <= rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                writer.startElement("td", component);
                String styles = this.getRowColumnStyle(theme, (column & 1) == 0 ? 4 : 5);
                if (styles != null) {
                    writer.writeAttribute("class", (Object)styles, null);
                }
                this.renderCellContent(context, component, theme, writer, itemN);
                ++itemN;
                writer.endElement("td");
            }
            writer.endElement(ROW_ELEMENT);
            if (row + 1 > rows) continue;
            writer.startElement(ROW_ELEMENT, component);
            String styles = this.getRowColumnStyle(theme, (row & 1) == 0 ? 3 : 2);
            if (styles != null) {
                writer.writeAttribute("class", (Object)styles, null);
            }
            writer.startElement("td", component);
            writer.endElement("td");
        }
        if (rows == 0) {
            writer.endElement(ROW_ELEMENT);
        }
    }

    protected abstract void renderCellContent(FacesContext var1, UIComponent var2, Theme var3, ResponseWriter var4, int var5) throws IOException;

    protected abstract void renderCaption(FacesContext var1, UIComponent var2, Theme var3, ResponseWriter var4) throws IOException;

    protected abstract String getRowColumnStyle(Theme var1, int var2);

    private void writeStyleAttribute(UIComponent component, ResponseWriter writer, String style) throws IOException {
        StringBuffer styleBuf = new StringBuffer();
        String compStyle = (String)component.getAttributes().get("style");
        if (compStyle != null) {
            styleBuf.append(compStyle);
        }
        if (style != null) {
            if (styleBuf.length() != 0) {
                styleBuf.append(" ");
            }
            styleBuf.append(style);
        }
        if (styleBuf.length() != 0) {
            writer.writeAttribute("style", (Object)styleBuf.toString(), null);
        }
    }
}

