/*
 * Decompiled with CFR 0.152.
 */
package auth.sdk;

import auth.sdk.InvalidSessionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class SessionCred {
    private static final String SCCS_ID = "@(#)SessionCred.java\t1.3 04/04/05 SMI";
    private static final String SESSCMD = "/etc/opt/SUNWut/basedir/lib/utxprop -s";
    private String rawSessionInfo = null;
    private String hostname = null;
    private int port = 0;
    private String sessionID = null;

    public SessionCred() throws InvalidSessionException {
        this.parseCred(this.discoverCred());
    }

    private String discoverCred() throws InvalidSessionException {
        Process process = null;
        String string = null;
        InvalidSessionException invalidSessionException = null;
        try {
            process = Runtime.getRuntime().exec(SESSCMD);
        }
        catch (IOException iOException) {
            invalidSessionException = new InvalidSessionException(iOException.getMessage());
        }
        if (process != null) {
            BufferedReader bufferedReader;
            block13: {
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                        if (stringTokenizer.countTokens() < 3) continue;
                        string = string2;
                        break;
                    }
                }
                catch (IOException iOException) {
                    if (string != null || invalidSessionException != null) break block13;
                    invalidSessionException = new InvalidSessionException(iOException.getMessage());
                }
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            while (true) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        if (string == null) {
            if (invalidSessionException == null) {
                invalidSessionException = new InvalidSessionException("Session ID property not found");
            }
            throw invalidSessionException;
        }
        return string;
    }

    private void parseCred(String string) throws InvalidSessionException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() < 3) {
            throw new InvalidSessionException("Improper session information format");
        }
        this.rawSessionInfo = string;
        this.hostname = stringTokenizer.nextToken();
        this.port = Integer.decode(stringTokenizer.nextToken());
        this.sessionID = stringTokenizer.nextToken();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getID() {
        return this.sessionID;
    }

    public String getCred() {
        return this.rawSessionInfo;
    }
}

