/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console;

import com.sun.ut.console.Configuration;
import com.sun.ut.console.Context;
import com.sun.ut.console.MastheadNotification;
import com.sun.ut.console.StatusMessage;
import com.sun.ut.service.AdminContext;
import com.sun.ut.service.AdminContextMockup;
import com.sun.ut.service.AuditService;
import com.sun.ut.service.Provider;
import java.util.Hashtable;
import java.util.logging.Logger;

public class BaseHandler {
    public static final String ADMIN_CONTEXT = "AdminContext";
    private AdminContext ctx = this.retrieveAdminContext();

    public AdminContext getAdminContext() {
        return this.ctx;
    }

    public Provider getProvider() {
        return this.ctx.getProvider();
    }

    public Logger getLogger() {
        return this.ctx.getLogger();
    }

    public AuditService getAuditService() {
        return this.ctx.getAuditService();
    }

    public StatusMessage getStatusMessage() {
        return StatusMessage.getStatusMessage();
    }

    public MastheadNotification getNotification() {
        return MastheadNotification.getNotification();
    }

    private AdminContext retrieveAdminContext() {
        AdminContext context = (AdminContext)Context.getSessionAttribute(ADMIN_CONTEXT);
        if (context == null || !context.isInitialized()) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            Configuration config = new Configuration();
            env.put("LogLevel", config.getLogLevel());
            try {
                if (context == null || context instanceof AdminContextMockup) {
                    AdminContext newContext;
                    context = newContext = new AdminContext(env);
                } else {
                    context.init();
                }
            }
            catch (Throwable ex) {
                StatusMessage status = this.getStatusMessage();
                if (!status.isVisible()) {
                    Object[] details = new String[]{"libutwebadmin.so"};
                    status.error("alert_library_summary", "alert_library_details", details, "alert_exception_link", "_blank", "../misc/Error.jsp", true);
                    Context.setSessionAttribute("ConsoleError", ex);
                }
                if (context == null || context instanceof AdminContext) {
                    context = new AdminContextMockup(env);
                }
                context.init();
            }
            Context.setSessionAttribute(ADMIN_CONTEXT, context);
        }
        return context;
    }
}

