/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.login;

import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.I18N;
import com.sun.ut.console.login.ClientSniffer;
import com.sun.ut.console.login.LoginChallenge;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.authentication.AuthenticationMessage;
import com.sun.ut.service.authentication.LoginModule;
import com.sun.ut.service.authentication.PamMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LoginHandler
extends BaseHandler {
    public static final String UNSUPPORTED_BROWSER_PAGE = "UnsupportedBrowser.jsp";
    public static final int MAX_NUMBER_LOGIN_STEPS = 4;
    private LoginModule loginModule;
    private List loginChallenges;
    private int browserStep;

    public LoginHandler() {
        ClientSniffer sniffer = new ClientSniffer();
        if (sniffer.isNav4()) {
            try {
                FacesContext ctx = FacesContext.getCurrentInstance();
                ctx.getExternalContext().redirect(UNSUPPORTED_BROWSER_PAGE);
                ctx.responseComplete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.loginModule = this.getAdminContext().getLoginModule();
        this.resetLoginModule();
    }

    protected void resetLoginModule() {
        try {
            this.browserStep = 0;
            AuthenticationMessage authMsg = null;
            this.loginChallenges = new ArrayList();
            this.loginModule.init();
            authMsg = this.loginModule.login(null);
            if (authMsg.isData()) {
                PamMessage pam = new PamMessage(authMsg.getData());
                this.loginChallenges.add(new LoginChallenge(0, pam.getMessage(), pam.getType()));
            }
            this.loginModule.abort();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.getStatusMessage().error("login_alert_reset", "");
        }
    }

    public String getServerName() {
        return this.getAdminContext().getHostName();
    }

    public String getUserName() {
        return this.getAdminContext().getUserName();
    }

    public String proceed() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpSession session = (HttpSession)context.getExternalContext().getSession(false);
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        String result = "";
        AuthenticationMessage authMsg = null;
        try {
            if (this.getCurrentStep() == 0) {
                this.loginModule.init();
                authMsg = this.loginModule.login(null);
            } else if (!this.loginModule.isAlive()) {
                this.getStatusMessage().error("login_alert_timeout_summary", "Login timed out - start again.");
                this.resetLoginModule();
                return "error";
            }
            if (this.getCurrentStep() != this.browserStep) {
                this.getStatusMessage().warning("login_alert_sync_summary", "login_alert_sync_details");
                this.loginModule.abort();
                this.resetLoginModule();
                return "error";
            }
            LoginChallenge challenge = (LoginChallenge)this.loginChallenges.get(this.getCurrentStep());
            authMsg = this.loginModule.login(challenge.getInput());
            if (authMsg.isData()) {
                PamMessage pam = new PamMessage(authMsg.getData());
                this.loginChallenges.add(new LoginChallenge(this.loginChallenges.size(), pam.getMessage(), pam.getType()));
                result = "proceed";
            } else if (authMsg.isDisconnect() && authMsg.getData() != null) {
                PamMessage pam = new PamMessage(authMsg.getData());
                if (pam.isSuccess()) {
                    String userName = pam.getMessage();
                    String clientId = request.getRemoteHost();
                    Date startTime = new Date();
                    if (this.getAdminContext().getProvider().hasAdminPrivileges(userName)) {
                        session.setAttribute("security-subject", (Object)userName);
                        Hashtable env = this.getAdminContext().getEnvironment();
                        env.put("Username", userName);
                        env.put("Client ID", clientId);
                        env.put("Start Time", startTime);
                        Object[] args = new String[]{userName, clientId};
                        this.getAuditService().publishEvent("authentication_success", args);
                        result = "success";
                        this.loginModule.commit();
                        this.loginChallenges = new ArrayList();
                    } else {
                        Object[] details = new String[]{userName};
                        this.getStatusMessage().error("login_alert_account_invalid_summary", "login_alert_account_invalid_details", details);
                        Object[] args = new String[]{request.getRemoteHost(), userName};
                        this.getAuditService().publishEvent("authorization_failed", args);
                        result = "error";
                        this.loginModule.commit();
                        this.resetLoginModule();
                    }
                } else {
                    Object[] args = new String[]{request.getRemoteHost()};
                    this.getStatusMessage().error("login_alert_auth_summary", "login_alert_auth_details");
                    this.getAuditService().publishEvent("authentication_failure", args);
                    result = "error";
                    this.loginModule.commit();
                    this.resetLoginModule();
                }
            }
        }
        catch (ServiceException ex) {
            this.getStatusMessage().error("login_alert_auth_summary", ex);
            result = "error";
            this.resetLoginModule();
        }
        catch (Exception ex) {
            this.getStatusMessage().error("error_internal", "");
            result = "error";
            this.resetLoginModule();
        }
        return result;
    }

    public String abort() {
        try {
            this.loginModule.abort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logout();
        return "abort";
    }

    public String logout() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpSession session = (HttpSession)context.getExternalContext().getSession(false);
        if (session != null) {
            session.setAttribute("invalid session", (Object)new Date());
            session.invalidate();
        }
        try {
            String redirectURI = context.getExternalContext().getRequestContextPath();
            context.getExternalContext().redirect(redirectURI);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "success";
    }

    public String getLogoutMessage() {
        StringBuffer buffer = new StringBuffer();
        String confirm = I18N.getResource("logout.confirm");
        buffer.append("javascript: if (!confirm(\"").append(confirm).append("\")) { return false;};");
        return buffer.toString();
    }

    public List getLoginChallenges() {
        return this.loginChallenges;
    }

    public int getCurrentStep() {
        return this.loginChallenges.size() - 1;
    }

    public void setCurrentStep(int current) {
        this.browserStep = current;
    }

    public int getRecentStepStart() {
        if (this.getCurrentStep() < 4) {
            return 0;
        }
        return this.getCurrentStep() - 4;
    }

    public boolean isAutoComplete() {
        if (this.getCurrentStep() >= 0) {
            LoginChallenge challenge = (LoginChallenge)this.loginChallenges.get(this.getCurrentStep());
            return challenge.isPromptEchoOn();
        }
        return false;
    }
}

