/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.server;

import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.I18N;
import com.sun.ut.console.server.DiskSpaceInfo;
import com.sun.ut.service.Host;
import com.sun.ut.service.Provider;
import com.sun.ut.service.ServiceException;
import java.util.ArrayList;

public class CachedHost {
    private Host host;
    private Provider provider;
    private ObjectListDataProvider diskSpaceProvider;
    private int totalDtus;
    private int totalUserSessions;
    private int totalDisconnectedUserSessions;
    private int totalGreeterSessions;
    private int totalDisconnectedGreeterSessions;
    private long restartTime;

    public CachedHost(Host host, Provider provider) {
        this.host = host;
        this.provider = provider;
        this.init();
    }

    private void init() {
        this.totalDtus = this.provider.getCurrentDTUsNumber(this.host.getName());
        try {
            int[] sessions = this.provider.getSessionNumbers(this.host.getName());
            if (sessions != null) {
                this.totalUserSessions = sessions[0];
                this.totalDisconnectedUserSessions = sessions[1];
                this.totalGreeterSessions = sessions[2];
                this.totalDisconnectedGreeterSessions = sessions[3];
            }
            ArrayList<DiskSpaceInfo> list = new ArrayList<DiskSpaceInfo>();
            long[] info = this.provider.getDiskSpace("/");
            list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_root"), info[2], info[1], info[0]));
            info = this.provider.getDiskSpace("/tmp");
            list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_tmp"), info[2], info[1], info[0]));
            info = this.provider.getSwapSpace();
            list.add(new DiskSpaceInfo(I18N.getResource("serverDetails_swap"), info[2], info[1], info[0]));
            this.diskSpaceProvider = new ObjectListDataProvider(list);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public Host getHost() {
        return this.host;
    }

    public ObjectListDataProvider getDiskSpaceInfo() {
        return this.diskSpaceProvider;
    }

    public int getTotalDtus() {
        return this.totalDtus;
    }

    public int getTotalUserSessions() {
        return this.totalUserSessions;
    }

    public int getTotalDisconnectedUserSessions() {
        return this.totalDisconnectedUserSessions;
    }

    public int getTotalGreeterSessions() {
        return this.totalGreeterSessions;
    }

    public int getTotalDisconnectedGreeterSessions() {
        return this.totalDisconnectedGreeterSessions;
    }

    public String getName() {
        return this.host.getName();
    }

    public long getRestartTime() {
        return this.restartTime;
    }

    public void setRestartTime(long restartTime) {
        this.restartTime = restartTime;
    }
}

