/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.tokens;

import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.service.DesktopUnit;
import com.sun.ut.service.ServiceException;
import com.sun.web.ui.model.Option;
import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class NewTokenHandler
extends BaseHandler {
    private static final String LOGICAL_TOKEN_PREFIX = "user.";
    private String userName;
    private String description;
    private String tokenId;
    private String tokenReader;
    private boolean isReadFromReader;
    private boolean isTokenReaders;
    private boolean enabled;
    private Option[] sessionTypeOptions;
    private String sessionType = "default";
    private boolean checkedKioskInstalled;
    private boolean isKioskInstalled;

    public NewTokenHandler() {
        this.getAvailableTokenReaders();
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(new Option((Object)"default", I18N.getResource("tokens_session_type_default")));
        options.add(new Option((Object)"kiosk", I18N.getResource("tokens_session_type_kiosk")));
        options.add(new Option((Object)"regular", I18N.getResource("tokens_session_type_regular")));
        this.sessionTypeOptions = new Option[options.size()];
        this.sessionTypeOptions = options.toArray(this.sessionTypeOptions);
        this.isReadFromReader = true;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenReader(String tokenReader) {
        Context.setSessionAttribute("selectedReaderId", tokenReader);
        this.tokenReader = tokenReader;
    }

    public boolean getIsReadFromReader() {
        return this.isReadFromReader;
    }

    public void setIsReadFromReader(boolean newIsReadFromReader) {
        this.isReadFromReader = newIsReadFromReader;
    }

    public String getTokenReader() {
        String sessionReader = (String)Context.getSessionAttribute("selectedReaderId");
        if (sessionReader != null) {
            this.tokenReader = sessionReader;
        }
        return this.tokenReader;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTokenReaders() {
        return this.isTokenReaders;
    }

    public Option[] getAvailableTokenReaders() {
        ArrayList<Option> list = new ArrayList<Option>();
        Iterator it = null;
        try {
            it = this.getProvider().getTokenReaders().iterator();
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error(se);
        }
        while (it != null && it.hasNext()) {
            DesktopUnit reader = (DesktopUnit)it.next();
            StringBuffer buffer = new StringBuffer(reader.getId());
            if (reader.getLocation() != null && reader.getLocation().length() > 0) {
                buffer.append(" (");
                buffer.append(reader.getLocation());
                buffer.append(")");
            }
            list.add(new Option((Object)reader.getId(), buffer.toString()));
        }
        if (list.size() > 0) {
            this.isTokenReaders = true;
        }
        Option[] tokenReaders = new Option[list.size()];
        return list.toArray(tokenReaders);
    }

    public void getToken() {
        String action;
        String token;
        UIViewRoot uivroot = FacesContext.getCurrentInstance().getViewRoot();
        UIInput dropDown = (UIInput)uivroot.findComponent("f1:t1:a1:s1:p2:i1");
        String[] selectedReaders = (String[])dropDown.getSubmittedValue();
        String selectedReader = null;
        if (selectedReaders != null && selectedReaders.length > 0) {
            selectedReader = selectedReaders[0];
        }
        if ((token = this.getTokenFromReader(selectedReader)) != null && token.length() > 0) {
            this.setTokenId(token);
            UIInput textField = (UIInput)uivroot.findComponent("f1:t1:a1:s1:p2:i2_editable_required");
            textField.setSubmittedValue((Object)this.getTokenId());
        }
        if ((action = (String)Context.getSessionAttribute("action")) != null) {
            Context.setRequestAttribute(action, "yes");
        }
    }

    public String getTokenFromReader(String selectedReader) {
        String token;
        block9: {
            token = null;
            if (selectedReader != null) {
                DesktopUnit reader = null;
                try {
                    reader = this.getProvider().getDTU(selectedReader, true);
                }
                catch (ServiceException se) {
                    this.getLogger().severe(se.toString());
                    this.getStatusMessage().error(se);
                }
                if (reader != null) {
                    String id = reader.getId();
                    try {
                        token = this.getProvider().getTokenFromReader(id);
                        if (token == null || token.length() == 0) {
                            this.getStatusMessage().error("tokens_alert_read", "tokens_no_smart_card_found");
                        }
                    }
                    catch (ServiceException se) {
                        this.getLogger().severe(se.toString());
                        if (reader.getServer() != null) {
                            this.getStatusMessage().error("tokens_alert_read", se);
                            break block9;
                        }
                        Object[] args = new String[]{reader.getId()};
                        String summary = I18N.getResource("tokens_alert_summary_read", args);
                        this.getStatusMessage().error("tokens_alert_read", summary);
                    }
                } else {
                    Object[] args = new String[]{selectedReader};
                    String summary = I18N.getResource("tokens_alert_summary_read", args);
                    this.getStatusMessage().error("tokens_alert_read", summary);
                }
            }
        }
        return token;
    }

    public String addUser() {
        try {
            Object[] args;
            String auditUser;
            if (this.description == null) {
                this.description = "";
            }
            if (this.getIsReadFromReader()) {
                String token = this.getTokenFromReader(this.tokenReader);
                if (token == null || token.length() == 0) {
                    return "";
                }
                this.setTokenId(token);
            }
            String userId = this.getProvider().addUser(this.userName, this.description, this.tokenId);
            if (!"default".equals(this.sessionType)) {
                String logicalToken = this.getLogicalToken(userId);
                if (this.sessionType.equals("regular")) {
                    this.getProvider().setSessionType(logicalToken, 2);
                } else {
                    this.getProvider().setSessionType(logicalToken, 1);
                }
            }
            if ((auditUser = this.getUserName()) == null) {
                auditUser = "";
            }
            String enabledString = this.getAuditService().getMessage("token_status_enabled");
            if (this.isKioskInstalled()) {
                args = new Object[]{this.tokenId, auditUser, this.description, enabledString, this.sessionType};
                this.getAuditService().publishEvent("Users", "token_added", args, 0);
            } else {
                args = new Object[]{this.tokenId, auditUser, this.description, enabledString};
                this.getAuditService().publishEvent("Users", "token_added_no_session", args, 0);
            }
            Object[] tokenIdArgs = new Object[]{this.tokenId};
            this.getStatusMessage().info("alert_stored_changes", I18N.getResource("tokens_add", tokenIdArgs), true);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            Object[] args = new Object[]{this.tokenId};
            String alert = I18N.getResource("tokens_alert_add", args);
            this.getStatusMessage().error(alert, se);
            return "";
        }
        return "viewTokens";
    }

    public String addToken() {
        try {
            if (this.getIsReadFromReader()) {
                String token = this.getTokenFromReader(this.tokenReader);
                if (token == null || token.length() == 0) {
                    return "";
                }
                this.setTokenId(token);
            }
            String userId = (String)Context.getSessionAttribute("selectedUserId");
            this.getProvider().addToken(this.tokenId, userId, true);
            Object[] tokenIdArgs = new Object[]{this.tokenId};
            this.getStatusMessage().info("alert_stored_changes", I18N.getResource("tokens_add", tokenIdArgs), true);
            this.userName = this.getProvider().getUser(userId).getUserName();
            String auditUser = this.getUserName();
            if (auditUser == null) {
                auditUser = "";
            }
            Object[] args = new Object[]{this.tokenId, auditUser};
            this.getAuditService().publishEvent("Users", "token_added_alias", args, 0);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            Object[] args = new Object[]{this.tokenId};
            String alert = I18N.getResource("tokens_alert_add", args);
            this.getStatusMessage().error(alert, se);
            return "";
        }
        return "viewTokenDetails";
    }

    public Option[] getSessionTypeOptions() {
        return this.sessionTypeOptions;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(String type) {
        this.sessionType = type;
    }

    public String getLogicalToken(String userId) {
        return LOGICAL_TOKEN_PREFIX + userId;
    }

    public boolean isKioskInstalled() {
        if (!this.checkedKioskInstalled) {
            this.isKioskInstalled = this.getProvider().isKioskInstalled();
            this.checkedKioskInstalled = true;
        }
        return this.isKioskInstalled;
    }
}

