/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.sdk.Utils;
import auth.utauthd.Configuration;
import auth.utauthd.DeviceManager;
import auth.utauthd.SessionManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public abstract class DaemonManager
implements EventListener {
    protected String cookie;
    protected String hostname = "localhost";
    protected int port;
    protected Socket socket = null;
    protected static String DEVICE_MANAGER = "utdevmgrd";
    protected static String SESSION_MANAGER = "utsessiond";
    protected Object waitMonitor = new Object();
    protected BufferedWriter mout = null;
    protected BufferedReader min = null;
    protected String managerName;
    protected String managerId;
    protected static Hashtable managers = new Hashtable(2);

    public String getName() {
        return this.managerName;
    }

    public static synchronized DaemonManager getManager(String string) {
        return (DaemonManager)managers.get(string);
    }

    public static synchronized void removeManager(String string) {
        managers.remove(string);
    }

    public static synchronized void addManager(String string, DaemonManager daemonManager) {
        Log.debug((String)("DaemonManager.addManager(): manager = " + daemonManager));
        try {
            managers.put(string, daemonManager);
        }
        catch (NullPointerException nullPointerException) {
            Log.debug((String)("DaemonManager.addManager(): exception e = " + nullPointerException));
        }
    }

    protected DaemonManager(String string, String string2, String string3, int n) {
        this.managerName = string;
        this.managerId = string2;
        this.hostname = string3;
        this.port = n;
        if (string2 != null) {
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            String string5 = stringTokenizer.nextToken();
            if (string5 != null) {
                this.hostname = string5;
            }
            if ((string4 = stringTokenizer.nextToken()) != null) {
                this.port = Integer.valueOf(string4);
            }
        } else {
            this.managerId = this.hostname + ":" + this.port;
        }
        this.cookie = Utils.makeCookie();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initiateCallback() {
        String string;
        String string2;
        String string3 = "localhost";
        int n = Configuration.cbport;
        String string4 = this.cookie;
        Socket socket = null;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        Log.debug((String)(this.managerName + ".initiateCallback(): open socket : hostname= " + this.hostname + "; port= " + this.port));
        try {
            socket = new Socket(this.hostname, this.port);
        }
        catch (IOException iOException) {
            Log.unexpectedError((String)(this.managerName + ".initiateCallBack: " + "Socket failed:" + iOException));
            return false;
        }
        Log.debug((String)"set timeout & get input , output streams");
        try {
            socket.setSoTimeout(5000);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "8859_1"));
            string2 = "callback " + string3 + " " + n + " " + string4;
            Log.debug((String)("Sending request: \"" + string2 + "\" to " + this.hostname + ":" + this.port));
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "8859_1"));
            Log.debug((String)"Waiting for response");
            string = bufferedReader.readLine();
            Log.debug((String)("Received response: \"" + string + "\""));
        }
        catch (IOException iOException) {
            bufferedReader = null;
            bufferedWriter = null;
            Log.unexpectedError((String)(this.managerName + ".initiateCallback: during send: " + iOException));
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanup(socket);
        }
        Log.debug((String)(this.managerName + ".initiateCallback: response: \"" + string + "\" "));
        string2 = this.managerName + ".initiateCallback " + this.hostname + ":" + n + " ";
        if (string.equals("OK/callback")) {
            Log.notice((String)(string2 + "established communication"));
            return true;
        }
        if (string.equals("ERR/NotPermitted")) {
            Log.unexpectedError((String)(string2 + "is not configured to talk to this utauthd"));
            return false;
        }
        if (string.equals("ERR/Duplicate")) {
            Log.configError((String)(string2 + "claims to be already connected"));
            return false;
        }
        if (string.equals("ERR/ConnectFail")) {
            Log.unexpectedError((String)(string2 + "was not able to talk to this utauthd"));
            return false;
        }
        Log.unexpectedError((String)(string2 + "unknown response: \"" + string + "\""));
        return false;
    }

    public abstract void setSocket(Socket var1);

    protected boolean isConnected() {
        return this.socket != null;
    }

    public String toString() {
        return "{managerName=" + this.managerName + "," + "managerId=" + this.managerId + "," + "hostname=" + this.hostname + "," + "port=" + this.port + "," + "cookie=" + this.cookie + "," + "socket=" + this.socket + "," + "min=" + this.min + "," + "mout=" + this.mout + "," + "}";
    }

    public static void wakeup(String string, String string2) {
        int n;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            string3 = stringTokenizer.nextToken();
            n2 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            Log.unexpectedError((String)("wakeup: malformed daemon Id name: " + noSuchElementException));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            Log.unexpectedError((String)("wakeup: malformed daemon Id name: " + numberFormatException));
            return;
        }
        Log.debug((String)("wakeup: tmpHostName = " + string3 + ", port = " + n2));
        if (string2.equals(DEVICE_MANAGER)) {
            string5 = Configuration.deviceManagerHost;
            n = Configuration.deviceManagerPort;
        } else if (string2.equals(SESSION_MANAGER)) {
            string5 = Configuration.sessionHost;
            n = Configuration.sessionPort;
        } else {
            Log.unexpectedError((String)("wakeup:Unknown server: " + string2));
            return;
        }
        Log.debug((String)("configHostName = " + string5 + ", configPort = " + n));
        if (n2 != n) {
            Log.unexpectedError((String)("wakeup:Unknown server port: " + n2));
            return;
        }
        string4 = string3.equals(string5) ? string3 : DaemonManager.checkHostName(string3, string5);
        if (string4 == null) {
            return;
        }
        string = string4 + ":" + n2;
        Log.debug((String)("wakeup: hostName = " + string4));
        DaemonManager daemonManager = DaemonManager.getManager(string);
        Log.debug((String)("DaemonManager.wakeup(): found Mgr = " + daemonManager));
        if (daemonManager != null) {
            if (daemonManager.isConnected()) {
                Log.debug((String)("daemon " + string2 + " exits"));
                return;
            }
            daemonManager.socket = null;
            DaemonManager.removeManager(string);
        }
        if (string2.equals(DEVICE_MANAGER)) {
            Log.debug((String)("call DevMgr daemon " + string2 + " init "));
            DeviceManager.init(string);
        } else if (string2.equals(SESSION_MANAGER)) {
            Log.debug((String)("call Session daemon " + string2 + " init "));
            SessionManager.init(string);
        } else {
            Log.unexpectedError((String)("Unknown server: " + string2));
        }
    }

    private static String checkHostName(String string, String string2) {
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        InetAddress inetAddress3 = null;
        try {
            inetAddress = InetAddress.getByName(string);
            inetAddress2 = InetAddress.getLocalHost();
            inetAddress3 = InetAddress.getByName(string2);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("wakeup: cannot check host name" + string + ", error = " + exception));
            return null;
        }
        if (string2.equals("localhost")) {
            if (inetAddress.equals(inetAddress2)) {
                return "localhost";
            }
            Log.unexpectedError((String)("wakeup: unknown hostName: " + string));
        } else if (string.equals("localhost")) {
            if (inetAddress3.equals(inetAddress2)) {
                return string2;
            }
        } else {
            Log.unexpectedError((String)("wakeup: unknown hostName: " + string));
        }
        return null;
    }

    private void cleanup(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            socket = null;
        }
    }
}

