/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;

public class MonitorTimings {
    private static final String SCCS_ID = "@(#)MonitorTimings.java\t1.3\t09/11/16 SMI";
    private static final int NO_MENU_POSITION_FOR_INDEX = -42;
    private static final String RB_KEY_STANDARD = "GUI.Display.ResRefresh.Standard";
    private static final String RB_KEY_MONITOR = "GUI.Display.ResRefresh.Monitor";
    private static final String RB_KEY_SITE_DEFINED = "GUI.Display.ResRefresh.SiteDefined";
    private static final String CANONICAL_STANDARD = "standard";
    private static final String CANONICAL_MONITOR = "monitor";
    private static final String CANONICAL_SITE_DEFINED = "custom";
    private static Object canonicalTimingListLock = new Object();
    private static CanonicalTimingList canonicalTimingList = null;
    private String localisedStandard = "Standard";
    private String localisedMonitor = "Monitor";
    private String localisedSiteDefined = "Site-Defined";
    private Timing[] timingArray;
    private int[] timingIndexToMenuPos;
    private static final Pattern AT_REGEX = Pattern.compile("@");
    private static final Pattern DHZ_REGEX = Pattern.compile("d Hz");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorTimings(ResourceBundle resourceBundle) {
        int n;
        try {
            this.localisedStandard = resourceBundle.getString(RB_KEY_STANDARD);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("no translation for GUI.Display.ResRefresh.Standard");
        }
        try {
            this.localisedMonitor = resourceBundle.getString(RB_KEY_MONITOR);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("no translation for GUI.Display.ResRefresh.Monitor");
        }
        try {
            this.localisedSiteDefined = resourceBundle.getString(RB_KEY_SITE_DEFINED);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("no translation for GUI.Display.ResRefresh.SiteDefined");
        }
        Vector<Timing> vector = canonicalTimingListLock;
        synchronized (vector) {
            if (null == canonicalTimingList) {
                canonicalTimingList = new CanonicalTimingList();
            }
        }
        vector = new Vector<Timing>(40);
        int n2 = 0;
        Iterator iterator = canonicalTimingList.iterator();
        while (iterator.hasNext()) {
            CanonicalTiming canonicalTiming = (CanonicalTiming)iterator.next();
            String string = canonicalTiming.getName();
            String string2 = this.canonToGui(string);
            vector.add(new Timing(string, string2, canonicalTiming.getIndex()));
            if (!Character.isLetter(string.charAt(0))) continue;
            n2 = vector.size();
        }
        vector.insertElementAt(new Timing(CANONICAL_SITE_DEFINED, this.canonToGui(CANONICAL_SITE_DEFINED), 16), n2);
        this.timingArray = vector.toArray(new Timing[vector.size()]);
        int n3 = this.timingArray[0].timingIndex;
        for (n = 1; n < this.timingArray.length; ++n) {
            if (this.timingArray[n].timingIndex <= n3) continue;
            n3 = this.timingArray[n].timingIndex;
        }
        this.timingIndexToMenuPos = new int[1 + n3];
        for (n = 0; n < this.timingArray.length; ++n) {
            this.timingIndexToMenuPos[n] = -42;
        }
        for (n = 0; n < this.timingArray.length; ++n) {
            this.timingIndexToMenuPos[this.timingArray[n].timingIndex] = n;
        }
    }

    private String canonToGui(String string) {
        String string2;
        if (string.equals(CANONICAL_MONITOR)) {
            string2 = this.localisedMonitor;
        } else if (string.equals(CANONICAL_STANDARD)) {
            string2 = this.localisedStandard;
        } else if (string.equals(CANONICAL_SITE_DEFINED)) {
            string2 = this.localisedSiteDefined;
        } else {
            string2 = string + " Hz";
            string2 = AT_REGEX.matcher(string2).replaceFirst(" @ ");
            string2 = DHZ_REGEX.matcher(string2).replaceFirst(" Hz [D]");
        }
        return string2;
    }

    public void addItems(Choice choice) {
        for (int i = 0; i < this.timingArray.length; ++i) {
            choice.addItem(this.timingArray[i].timingGuiName);
        }
    }

    public int getMenuPositionForTimingIndex(int n) throws SettingsBoundsException {
        int n2 = -42;
        try {
            n2 = this.timingIndexToMenuPos[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SettingsBoundsException("Timing index " + n + " out of bounds", arrayIndexOutOfBoundsException);
        }
        if (-42 == n2) {
            throw new SettingsBoundsException("Timing index " + n + " unknown");
        }
        return n2;
    }

    public int getTimingIndexForMenuPosition(int n) throws SettingsBoundsException {
        try {
            Timing timing = this.timingArray[n];
            return timing.timingIndex;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SettingsBoundsException("Menu position " + n + " out of bounds", arrayIndexOutOfBoundsException);
        }
    }

    public String getResNameForTimingIndex(int n) throws SettingsBoundsException {
        Timing timing = this.timingArray[this.getMenuPositionForTimingIndex(n)];
        return timing.timingCliName;
    }

    private class Timing {
        String timingCliName;
        String timingGuiName;
        int timingIndex;

        Timing(String string, String string2, int n) {
            this.timingCliName = string;
            this.timingGuiName = string2;
            this.timingIndex = n;
        }
    }

    private class CanonicalTimingList {
        private static final String GET_CANONICAL_CMD = "/etc/opt/SUNWut/basedir/sbin/utresdef -x";
        private static final String ERROR_PREFIX = "CanonicalTimingList: ERROR; ";
        private Vector ctv = new Vector(40);

        CanonicalTimingList() {
            try {
                String string;
                Process process = Runtime.getRuntime().exec(GET_CANONICAL_CMD);
                InputStream inputStream = process.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (stringTokenizer.countTokens() != 2) {
                        System.err.println("CanonicalTimingList: ERROR; too many fields, " + string);
                        continue;
                    }
                    try {
                        int n = Integer.parseInt(stringTokenizer.nextToken());
                        String string2 = stringTokenizer.nextToken();
                        this.ctv.add(new CanonicalTiming(string2, n));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("CanonicalTimingList: ERROR; bad number, " + string);
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println(ERROR_PREFIX + iOException);
            }
        }

        Iterator iterator() {
            return this.ctv.iterator();
        }
    }

    private class CanonicalTiming {
        private String cName;
        private int cIndex;

        CanonicalTiming(String string, int n) {
            this.cName = string;
            this.cIndex = n;
        }

        String getName() {
            return this.cName;
        }

        int getIndex() {
            return this.cIndex;
        }
    }
}

