/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.console.advanced;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.ut.console.BaseHandler;
import com.sun.ut.console.Context;
import com.sun.ut.console.I18N;
import com.sun.ut.console.KioskApplicationWrapper;
import com.sun.ut.console.SelectHelper;
import com.sun.ut.service.Kiosk;
import com.sun.ut.service.KioskApplication;
import com.sun.ut.service.KioskDescriptor;
import com.sun.ut.service.ServiceException;
import com.sun.web.ui.component.TableRowGroup;
import com.sun.web.ui.model.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KioskHandler
extends BaseHandler {
    private static final int MODE_OPTION_NUMBER = 3;
    private static final String DELETE_ACTION = "DeleteAction";
    private boolean sessionDescriptorsInstalled;
    private boolean configured;
    private boolean installed;
    private boolean notSaved;
    private boolean kioskBroken;
    private boolean deleteAlert;
    private String kioskBrokenSummary;
    private Kiosk kiosk;
    private KioskApplication selectedApplication;
    private Option[] sessionOptions;
    private boolean predefined = true;
    private boolean custom = false;
    private Option[] applicationOptions;
    private Option[] typeOptions;
    private Option[] modeOptions;
    private String session;
    private String hiddenKiosk;
    private String application;
    private String path;
    private String type = "desc";
    private String mode = "user";
    private String args;
    private File selectedPath;
    private TableRowGroup tableRowGroup;
    private SelectHelper selectHelper = new SelectHelper("#{kioskRowGroup.tableRow}");

    public KioskHandler() {
        this.typeOptions = new Option[2];
        this.typeOptions[0] = new Option((Object)"desc", I18N.getResource("kiosk_type_descriptor"));
        this.typeOptions[0].setTooltip(I18N.getResource("kiosk_type_descriptor_tooltip"));
        this.typeOptions[1] = new Option((Object)"exec", I18N.getResource("kiosk_type_executable"));
        this.typeOptions[1].setTooltip(I18N.getResource("kiosk_type_executable_tooltip"));
        this.modeOptions = new Option[3];
        this.modeOptions[0] = new Option((Object)"user", I18N.getResource("kiosk_mode_user") + " - " + I18N.getResource("kiosk_mode_user_help"));
        this.modeOptions[0].setTooltip(I18N.getResource("kiosk_mode_user_tooltip"));
        this.modeOptions[1] = new Option((Object)"auto", I18N.getResource("kiosk_mode_auto") + " - " + I18N.getResource("kiosk_mode_auto_help"));
        this.modeOptions[1].setTooltip(I18N.getResource("kiosk_mode_auto_tooltip"));
        this.modeOptions[2] = new Option((Object)"critical", I18N.getResource("kiosk_mode_critical") + " - " + I18N.getResource("kiosk_mode_critical_help"));
        this.modeOptions[2].setTooltip(I18N.getResource("kiosk_mode_critical_tooltip"));
        this.getKiosk();
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public boolean isSessionDescriptorsInstalled() {
        return this.sessionDescriptorsInstalled;
    }

    public boolean isNotSaved() {
        return this.notSaved;
    }

    public boolean isKioskBroken() {
        return this.kioskBroken;
    }

    public String getAlert() {
        String alert = "";
        if (!this.installed) {
            alert = I18N.getResource("kiosk_not_installed_alert");
        } else if (!this.sessionDescriptorsInstalled) {
            alert = I18N.getResource("kiosk_no_descriptors_alert");
        } else if (!this.configured) {
            alert = I18N.getResource("kiosk_unconfigured_alert");
        } else if (this.deleteAlert) {
            alert = I18N.getResource("kiosk_alert_delete_warn");
        } else if (this.notSaved) {
            alert = I18N.getResource("kiosk_no_settings_alert");
        } else if (this.kioskBroken) {
            alert = I18N.getResource("kiosk_alert_get");
        }
        return alert;
    }

    public String getAlertSummary() {
        String summary = "";
        if (!this.installed) {
            summary = I18N.getResource("kiosk_not_installed_summary");
        } else if (!this.sessionDescriptorsInstalled) {
            summary = I18N.getResource("kiosk_no_descriptors_summary");
        } else if (!this.configured) {
            summary = I18N.getResource("kiosk_unconfigured_summary");
        } else if (this.deleteAlert) {
            summary = I18N.getResource("kiosk_alert_restart_required");
            summary = summary + "<br>";
            summary = summary + I18N.getResource("kiosk_new_settings_summary");
        } else if (this.notSaved) {
            summary = I18N.getResource("kiosk_no_settings_summary");
        } else if (this.kioskBroken) {
            if (this.kioskBrokenSummary != null) {
                summary = this.kioskBrokenSummary;
                summary = summary + "<br>";
            }
            summary = summary + I18N.getResource("kiosk_unstable_state_summary");
        }
        return summary;
    }

    public boolean isAlertRendered() {
        return !this.installed || !this.sessionDescriptorsInstalled || !this.configured || this.deleteAlert || this.notSaved || this.kioskBroken;
    }

    public boolean isEditButtonRendered() {
        return this.installed && this.sessionDescriptorsInstalled && this.configured;
    }

    public Kiosk getKiosk() {
        if (this.kiosk == null && this.getProvider().isKioskInstalled()) {
            this.installed = true;
            KioskDescriptor sessionDescriptor = new KioskDescriptor(null, null, false, null, null, null);
            List sessionDescriptors = this.getProvider().getKioskSessionDescriptors();
            if (sessionDescriptors != null && sessionDescriptors.size() > 0) {
                this.sessionDescriptorsInstalled = true;
                sessionDescriptor = (KioskDescriptor)sessionDescriptors.get(0);
            }
            this.kiosk = new Kiosk(sessionDescriptor, "12000", null, null, null, null, null, null, null);
            try {
                if (this.getProvider().isKioskConfigured()) {
                    this.configured = true;
                    if (this.sessionDescriptorsInstalled) {
                        this.kiosk = this.getProvider().getKiosk();
                    }
                }
            }
            catch (ServiceException se) {
                if (se.getErrorCode() == -4) {
                    this.notSaved = true;
                    String deleteAction = (String)Context.getSessionAttribute(DELETE_ACTION);
                    if (deleteAction != null && deleteAction.equals("true")) {
                        this.deleteAlert = true;
                        Context.setSessionAttribute(DELETE_ACTION, null);
                    }
                }
                this.kioskBroken = true;
                String errorKey = se.getMessageKey();
                Object[] errorKeyArgs = se.getMessageArgs();
                this.kioskBrokenSummary = errorKeyArgs != null ? I18N.getResource(errorKey, errorKeyArgs) : I18N.getResource(errorKey);
                this.getLogger().severe(se.toString());
                this.getStatusMessage().error("kiosk_alert_get", se);
            }
        }
        return this.kiosk;
    }

    public String getHiddenKiosk() {
        if (this.hiddenKiosk == null) {
            if (this.notSaved) {
                this.hiddenKiosk = "";
            } else {
                StringBuffer b = new StringBuffer();
                b.append(this.getSession()).append(" ").append(this.kiosk.getTimeout()).append(" ").append(this.kiosk.getMaxCPU()).append(" ").append(this.kiosk.getMaxVM()).append(" ").append(this.kiosk.getMaxFiles()).append(" ").append(this.kiosk.getMaxFileSize()).append(" ").append(this.kiosk.getLocale()).append(" ").append(this.kiosk.getArgs());
                this.hiddenKiosk = b.toString();
            }
        }
        return this.hiddenKiosk;
    }

    public void setHiddenKiosk(String newHiddenKiosk) {
        this.hiddenKiosk = newHiddenKiosk;
    }

    public Option[] getSessionOptions() {
        if (this.sessionOptions == null) {
            List list = this.getProvider().getKioskSessionDescriptors();
            this.sessionOptions = new Option[list.size()];
            Iterator it = list.iterator();
            for (int i = 0; i < this.sessionOptions.length; ++i) {
                KioskDescriptor descriptor = (KioskDescriptor)it.next();
                this.sessionOptions[i] = new Option((Object)descriptor.getId(), descriptor.getLabel());
            }
        }
        return this.sessionOptions;
    }

    public void setPredefined(boolean predefined) {
        this.predefined = predefined;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public Option[] getApplicationOptions() {
        if (this.applicationOptions == null) {
            this.applicationOptions = this.getApplicationOptions(false);
        }
        return this.applicationOptions;
    }

    public Option[] getEditApplicationOptions() {
        if (this.applicationOptions == null) {
            this.applicationOptions = this.getApplicationOptions(true);
        }
        return this.applicationOptions;
    }

    public Option[] getTypeOptions() {
        return this.typeOptions;
    }

    public Option[] getModeOptions() {
        return this.modeOptions;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplication() {
        return this.application;
    }

    public void setPath(String path) {
        if (path != null && (path = path.trim()).length() == 0) {
            path = null;
        }
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getArgs() {
        return this.args;
    }

    public boolean isPathSpecified() {
        String appPath;
        return this.getSelectedApplication() != null && (appPath = this.selectedApplication.getPath()) != null && appPath.startsWith("/");
    }

    public void setSession(String session) {
        this.session = session;
        KioskDescriptor descriptor = this.kiosk.getDescriptor();
        if (!session.equals(descriptor.getId())) {
            List list = this.getProvider().getKioskSessionDescriptors();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                KioskDescriptor d = (KioskDescriptor)it.next();
                if (!session.equals(d.getId())) continue;
                this.kiosk.setDescriptor(d);
                break;
            }
        }
    }

    public String getSession() {
        KioskDescriptor descriptor;
        if (this.session == null && (descriptor = this.kiosk.getDescriptor()) != null) {
            this.session = descriptor.getId();
        }
        return this.session;
    }

    public ObjectListDataProvider getApplications() {
        List apps;
        ArrayList<KioskApplicationWrapper> applications = new ArrayList<KioskApplicationWrapper>();
        if (this.kiosk != null && (apps = this.kiosk.getApplications()) != null) {
            for (int i = 0; i < apps.size(); ++i) {
                applications.add(new KioskApplicationWrapper((KioskApplication)apps.get(i)));
            }
        }
        return new ObjectListDataProvider(applications);
    }

    public String selectApplication() {
        String selectedId = Context.getRequestParameter("selectedId");
        Context.setSessionAttribute("selectedId", selectedId);
        return "kioskApplicationEdit";
    }

    public KioskApplication getSelectedApplication() {
        if (this.selectedApplication == null) {
            String selectedId = (String)Context.getSessionAttribute("selectedId");
            List applications = this.kiosk.getApplications();
            if (applications != null) {
                for (int i = 0; i < applications.size(); ++i) {
                    KioskApplication a = (KioskApplication)applications.get(i);
                    if (!selectedId.equals(a.getId())) continue;
                    this.selectedApplication = a;
                    break;
                }
            }
        }
        return this.selectedApplication;
    }

    public KioskApplication addApplication(boolean isNew) {
        KioskApplication newApplication = null;
        if (this.application == null && this.path == null) {
            this.getStatusMessage().warning("kiosk_alert_application", "kiosk_alert_application_details");
            return null;
        }
        if (this.custom && (this.path == null || !this.path.startsWith("/"))) {
            this.getStatusMessage().warning("kiosk_alert_path", "kiosk_alert_path_details");
            return null;
        }
        if (this.custom) {
            File applicationFile = new File(this.path);
            if (!applicationFile.exists()) {
                this.getStatusMessage().warning("kiosk_alert_no_path", "kiosk_alert_no_path_details");
                return null;
            }
            if (applicationFile.isDirectory()) {
                this.getStatusMessage().warning("kiosk_alert_dir_path", "kiosk_alert_no_path_details");
                return null;
            }
            newApplication = new KioskApplication(this.path, this.type, this.mode, this.args);
        } else {
            List list = this.getProvider().getKioskApplicationDescriptors();
            for (int i = 0; i < list.size(); ++i) {
                KioskDescriptor descriptor = (KioskDescriptor)list.get(i);
                if (!this.application.equals(descriptor.getId())) continue;
                newApplication = new KioskApplication(descriptor, this.mode, this.args);
                break;
            }
        }
        if (isNew) {
            ArrayList<KioskApplication> applications = this.kiosk.getApplications();
            if (applications == null) {
                applications = new ArrayList<KioskApplication>();
                this.kiosk.setApplications(applications);
            }
            applications.add(newApplication);
        } else {
            this.selectedApplication.setApplication(newApplication);
        }
        try {
            this.getProvider().saveKiosk(this.kiosk);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("kiosk_alert_save", se);
            return null;
        }
        return newApplication;
    }

    public String addApplication() {
        KioskApplication addedApp = this.addApplication(true);
        if (addedApp == null) {
            return "kioskApplicationNew";
        }
        String addedAppLabel = this.getApplicationLabel(addedApp);
        Object[] auditArgs = new Object[]{addedAppLabel, addedApp.getType(), addedApp.getMode(), addedApp.getArgs()};
        this.getAuditService().publishEvent("Kiosk", "kiosk_new_app", auditArgs, 0);
        this.getStatusMessage().info("kiosk_alert_application_add", "kiosk_alert_restart_required", true);
        return "kiosk";
    }

    public String modifyApplication() {
        this.getSelectedApplication();
        this.application = this.selectedApplication.getDescriptorId();
        this.path = this.selectedApplication.getPath();
        this.custom = this.selectedApplication.isCustomPath();
        this.type = this.selectedApplication.getType();
        this.mode = this.selectedApplication.getMode();
        this.args = this.selectedApplication.getArgs();
        String originalName = this.getApplicationLabel(this.selectedApplication);
        KioskApplication editedApp = this.addApplication(false);
        if (editedApp == null) {
            return "kioskApplicationEdit";
        }
        String editedAppLabel = this.getApplicationLabel(editedApp);
        Object[] auditArgs = new Object[]{originalName, editedAppLabel, editedApp.getType(), editedApp.getMode(), editedApp.getArgs()};
        this.getAuditService().publishEvent("Kiosk", "kiosk_edit_app", auditArgs, 0);
        this.getStatusMessage().info("kiosk_alert_application_modify", "kiosk_alert_restart_required", true);
        return "kiosk";
    }

    public String deleteApplication() {
        RowKey[] rowKeys = this.tableRowGroup.getRenderedSelectedRowKeys();
        if (rowKeys == null) {
            return "success";
        }
        ObjectListDataProvider oldp = this.getApplications();
        String label = null;
        ArrayList<KioskApplication> deletedApps = new ArrayList<KioskApplication>();
        for (int i = 0; i < rowKeys.length; ++i) {
            RowKey rowKey = rowKeys[i];
            KioskApplication kioskApplication = (KioskApplication)oldp.getObject(rowKey);
            String id = kioskApplication.getId();
            deletedApps.add(kioskApplication);
            List applications = this.kiosk.getApplications();
            for (int j = 0; j < applications.size(); ++j) {
                KioskApplication a = (KioskApplication)applications.get(j);
                if (!id.equals(a.getId())) continue;
                applications.remove(a);
                break;
            }
            if (i != 0) continue;
            label = kioskApplication.getLabel();
        }
        try {
            this.getProvider().saveKiosk(this.kiosk);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("kiosk_alert_save", se);
            return "success";
        }
        this.kiosk = null;
        this.selectHelper.clear();
        Object[] auditArgs = new Object[]{this.getApplicationsString(deletedApps)};
        this.getAuditService().publishEvent("Kiosk", "kiosk_delete_app", auditArgs, 0);
        this.getStatusMessage().info("kiosk_alert_application_delete", "kiosk_alert_restart_required");
        return "success";
    }

    public String delete() {
        try {
            Object[] auditArgs = new Object[]{this.getSession(), this.kiosk.getTimeout(), this.kiosk.getMaxCPU(), this.kiosk.getMaxVM(), this.kiosk.getMaxFiles(), this.kiosk.getMaxFileSize(), this.kiosk.getLocale(), this.kiosk.getArgs(), this.getApplicationsString(this.kiosk.getApplications())};
            this.getProvider().deleteKiosk();
            Context.setSessionAttribute(DELETE_ACTION, "true");
            this.getAuditService().publishEvent("Kiosk", "kiosk_delete", auditArgs, 0);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("kiosk_alert_delete", se);
        }
        return "kiosk";
    }

    public String modify() {
        if (!(this.isValidNumeric(I18N.getResource("kiosk_timeoutLabel"), this.kiosk.getTimeout()) && this.isValidNumeric(I18N.getResource("kiosk_maxCPULabel"), this.kiosk.getMaxCPU()) && this.isValidNumeric(I18N.getResource("kiosk_maxVMLabel"), this.kiosk.getMaxVM()) && this.isValidNumeric(I18N.getResource("kiosk_maxFilesLabel"), this.kiosk.getMaxFiles()) && this.isValidNumeric(I18N.getResource("kiosk_maxFileSizeLabel"), this.kiosk.getMaxFileSize()))) {
            return "";
        }
        try {
            this.getProvider().saveKiosk(this.kiosk);
        }
        catch (ServiceException se) {
            this.getLogger().severe(se.toString());
            this.getStatusMessage().error("kiosk_alert_save", se);
            return "edit";
        }
        Object[] auditArgs = new Object[]{this.getSession(), this.kiosk.getTimeout(), this.kiosk.getMaxCPU(), this.kiosk.getMaxVM(), this.kiosk.getMaxFiles(), this.kiosk.getMaxFileSize(), this.kiosk.getLocale(), this.kiosk.getArgs(), this.getApplicationsString(this.kiosk.getApplications())};
        this.getAuditService().publishEvent("Kiosk", "kiosk_save", auditArgs, 0);
        this.getStatusMessage().info("kiosk_alert_modify", "kiosk_alert_restart_required", true);
        return "kiosk";
    }

    public boolean isValidNumeric(String label, String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        try {
            int i = Integer.parseInt(value);
            if (i <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.getStatusMessage().error(I18N.getResource("kiosk_alert_invalid_summary"), label + " " + I18N.getResource("kiosk_alert_invalid_detail"));
            return false;
        }
        return true;
    }

    public String getBrowseOnClick() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("javascript:setCustomPath('").append(System.getProperty("file.separator")).append("');top.window.close(); return false;");
        return buffer.toString();
    }

    public String getDeleteOnClick() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("javascript:return confirm(\"").append(I18N.getResource("kiosk_confirm_delete")).append("\");");
        return buffer.toString();
    }

    public TableRowGroup getTableRowGroup() {
        return this.tableRowGroup;
    }

    public void setTableRowGroup(TableRowGroup tableRowGroup) {
        this.tableRowGroup = tableRowGroup;
    }

    public SelectHelper getSelectHelper() {
        return this.selectHelper;
    }

    private Option[] getApplicationOptions(boolean includeSelected) {
        List list = this.getProvider().getKioskApplicationDescriptors();
        List applications = this.kiosk.getApplications();
        KioskApplication editedApp = null;
        if (includeSelected) {
            editedApp = this.getSelectedApplication();
        }
        if (applications != null) {
            block0: for (int i = 0; i < applications.size(); ++i) {
                KioskApplication a = (KioskApplication)applications.get(i);
                String id = a.getId();
                for (int j = 0; j < list.size(); ++j) {
                    KioskDescriptor d = (KioskDescriptor)list.get(j);
                    if (!id.equals(d.getId()) || editedApp != null && includeSelected && id.equals(editedApp.getId())) continue;
                    list.remove(d);
                    continue block0;
                }
            }
        }
        Option[] options = new Option[list.size()];
        Iterator it = list.iterator();
        for (int i = 0; i < options.length; ++i) {
            KioskDescriptor descriptor = (KioskDescriptor)it.next();
            options[i] = new Option((Object)descriptor.getId(), descriptor.getLabel());
        }
        return options;
    }

    private String getApplicationsString(List appsList) {
        String apps = "";
        if (appsList != null && appsList.size() != 0) {
            apps = apps + "[";
            for (int i = 0; i < appsList.size(); ++i) {
                KioskApplication app = (KioskApplication)appsList.get(i);
                apps = i == 0 ? apps + app.getLabel() : apps + ", " + app.getLabel();
            }
            apps = apps + "]";
        }
        return apps;
    }

    private String getApplicationLabel(KioskApplication app) {
        String label = app.getPath();
        if (app.getDescriptor() != null) {
            label = app.getDescriptor().getLabel();
        }
        return label;
    }
}

