/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service;

import com.sun.ut.service.AdminContext;
import com.sun.ut.service.DesktopUnit;
import com.sun.ut.service.Devices;
import com.sun.ut.service.Host;
import com.sun.ut.service.Kiosk;
import com.sun.ut.service.LogicalToken;
import com.sun.ut.service.MultiheadGroup;
import com.sun.ut.service.Package;
import com.sun.ut.service.Policy;
import com.sun.ut.service.RawToken;
import com.sun.ut.service.ReplicationListener;
import com.sun.ut.service.Security;
import com.sun.ut.service.ServiceException;
import com.sun.ut.service.SmartCard;
import com.sun.ut.service.User;
import com.sun.ut.service.command.KioskDesc;
import com.sun.ut.service.command.KioskStatus;
import com.sun.ut.service.command.UtDevadm;
import com.sun.ut.service.command.UtKiosk;
import com.sun.ut.service.command.UtProdinfo;
import com.sun.ut.service.command.UtReader;
import com.sun.ut.service.command.UtRelease;
import com.sun.ut.service.command.UtReplica;
import com.sun.ut.service.command.UtRestart;
import com.sun.ut.service.command.UtSession;
import com.sun.ut.service.jni.Datastore;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class Provider {
    private static final String SCCS_ID = "@(#)$Id$ Oracle";
    public static final int SESSTYPE_DEFAULT = 0;
    public static final int SESSTYPE_KIOSK = 1;
    public static final int SESSTYPE_REGULAR = 2;
    public static final int UNKNOWN = 0;
    public static final int STANDALONE_SERVER = 1;
    public static final int PRIMARY_SERVER = 2;
    public static final int SECONDARY_SERVER = 4;
    private static final int ONE_MINUTE = 60000;
    private static final int MAX_RESTART_WAIT_TIME = 180000;
    private static final int RESTART_WAIT_TIME = 100;
    private AdminContext ctx;

    public void init(AdminContext context) {
        this.ctx = context;
    }

    public void release() {
        this.ctx = null;
    }

    public boolean hasAdminPrivileges(String username) throws ServiceException {
        boolean result = false;
        String admins = this.ctx.getDatastore().getAdminUsers();
        StringTokenizer tokenizer = new StringTokenizer(admins);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null || !token.equals(username)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isSecondaryServer() {
        String isSecondaryServer = (String)this.ctx.getEnvironment().get("isSecondaryServer");
        if (isSecondaryServer == null || !isSecondaryServer.equalsIgnoreCase("true") && !isSecondaryServer.equalsIgnoreCase("false")) {
            try {
                this.setSecondaryServer();
                isSecondaryServer = (String)this.ctx.getEnvironment().get("isSecondaryServer");
            }
            catch (ServiceException se) {
                isSecondaryServer = "false";
            }
        }
        return Boolean.valueOf(isSecondaryServer);
    }

    public void setSecondaryServer() throws ServiceException {
        String currentHost = this.getCurrentHostName();
        if (this.getReplicationRole(currentHost) == 4) {
            this.ctx.getEnvironment().put("isSecondaryServer", "true");
        } else {
            this.ctx.getEnvironment().put("isSecondaryServer", "false");
        }
    }

    public List getHosts() throws ServiceException {
        this.ctx.getLogger().info("Retrieving failover group servers");
        List hosts = this.ctx.getDatastore().getHosts();
        return hosts;
    }

    public List getHostsWithInterfaces(String hostname) throws ServiceException {
        List hosts = this.ctx.getDatastore().getHostsWithInterfaces(hostname);
        return hosts;
    }

    public String getCurrentHostName() {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            hostname = "localhost";
        }
        return hostname;
    }

    public String getPrimaryHostName() throws ServiceException {
        UtReplica cmd = new UtReplica();
        if (cmd.isReplicated()) {
            return this.ctx.getDatastore().getPrimaryHostname();
        }
        return null;
    }

    public int getReplicationRole(String hostname) throws ServiceException {
        this.ctx.getLogger().info("Detecting replication role");
        UtReplica cmd = new UtReplica();
        return cmd.getReplicationRole(hostname);
    }

    public long[] getDiskSpace(String path) throws ServiceException {
        return this.ctx.getDatastore().getDiskSpace(path);
    }

    public long[] getSwapSpace() throws ServiceException {
        return this.ctx.getDatastore().getSwapSpace();
    }

    public int[] getStartTimes(String hostname) throws ServiceException {
        return this.ctx.getDatastore().getHostStartTimes(hostname, false);
    }

    public List getPackages() {
        this.ctx.getLogger().info("Retrieving packages");
        ArrayList<Package> packages = new ArrayList<Package>();
        UtProdinfo cmd = new UtProdinfo();
        String[] opts = new String[]{"NAME", "VERSION", "PSTAMP"};
        try {
            String[] pkgNames = cmd.getAllPackageNames();
            for (int i = 0; i < pkgNames.length; ++i) {
                String[] pkgInfo = cmd.getPackageInfo(pkgNames[i], opts);
                packages.add(new Package(pkgNames[i], pkgInfo[0], pkgInfo[1], pkgInfo[2]));
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return packages;
    }

    public String getUmbrellaProductName() {
        String productName = "";
        UtRelease releaseCmd = new UtRelease();
        try {
            productName = releaseCmd.getProductName();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return productName;
    }

    public String getUmbrellaProductVersion() {
        String productVersion = "";
        UtRelease releaseCmd = new UtRelease();
        try {
            productVersion = releaseCmd.getProductVersion();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return productVersion;
    }

    public String getUmbrellaProductInfo() {
        String productInfo = "";
        UtRelease releaseCmd = new UtRelease();
        try {
            productInfo = releaseCmd.getProductInfo();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return productInfo;
    }

    public String getSoftwareVersion() {
        String version = "";
        UtProdinfo cmd = new UtProdinfo();
        String[] opts = new String[]{"PRODVERS"};
        try {
            String[] info = cmd.getPackageInfo("SUNWuto", opts);
            if (info.length > 0) {
                version = info[0];
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return version;
    }

    public void restartHost(String hostname, boolean coldRestart) throws ServiceException {
        try {
            Datastore ds = this.ctx.getDatastore();
            int[] oldStartTimes = ds.getHostStartTimes(hostname, false);
            UtRestart cmd = new UtRestart();
            cmd.restart(hostname, coldRestart);
            int numberOfSleeps = 0;
            int maxNumOfSleeps = 1800;
            while (true) {
                block7: {
                    if (!cmd.isRunning()) {
                        try {
                            int[] currentStartTimes = ds.getHostStartTimes(hostname, true);
                            if (!(coldRestart ? currentStartTimes[0] != oldStartTimes[0] && currentStartTimes[1] != oldStartTimes[1] : currentStartTimes[0] != oldStartTimes[0])) break block7;
                            break;
                        }
                        catch (ServiceException ignore) {
                            // empty catch block
                        }
                    }
                }
                if (numberOfSleeps >= maxNumOfSleeps) {
                    throw new ServiceException("com.sun.ut.service.Provider.restartHost", -1);
                }
                Thread.currentThread();
                Thread.sleep(100L);
                ++numberOfSleeps;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public List getSessions(String token, String hostname) throws ServiceException {
        ArrayList list = new ArrayList();
        if (hostname == null) {
            Iterator it = this.ctx.getDatastore().getHosts().iterator();
            while (it.hasNext()) {
                Host host = (Host)it.next();
                this.ctx.getLogger().info("Retrieving sessions of " + host.getName());
                List sessions = this.ctx.getDatastore().getSessions(token, host.getName());
                if (sessions == null) continue;
                list.addAll(sessions);
            }
        } else {
            this.ctx.getLogger().info("Retrieving sessions of " + hostname);
            List sessions = this.ctx.getDatastore().getSessions(token, hostname);
            if (sessions != null) {
                list.addAll(sessions);
            }
        }
        return list;
    }

    public void terminateSession(String server, String display, String token) throws ServiceException {
        this.ctx.getLogger().info("Terminating sessions");
        UtSession cmd = new UtSession();
        cmd.terminateSession(server, display, token);
    }

    public int[] getSessionNumbers(String hostname) throws ServiceException {
        return this.ctx.getDatastore().getSessionNumbers(hostname);
    }

    public DesktopUnit getDTU(String id) throws ServiceException {
        this.ctx.getLogger().info("Retrieving data for DTU " + id);
        DesktopUnit dtu = this.ctx.getDatastore().getDTU(id, false);
        return dtu;
    }

    public DesktopUnit getDTU(String id, boolean includeRuntimeInfo) throws ServiceException {
        this.ctx.getLogger().info("Retrieving data for DTU " + id);
        DesktopUnit dtu = this.ctx.getDatastore().getDTU(id, includeRuntimeInfo);
        return dtu;
    }

    public void modifyDTU(String id, String location, String description) throws ServiceException {
        this.ctx.getLogger().info("Modified DTU with id " + id);
        this.ctx.getDatastore().modifyDTU(id, location, description);
        if (this.isSecondaryServer()) {
            String[] args = new String[]{id, location, description};
            ReplicationListener listener = new ReplicationListener(args){

                public boolean isReplicated() throws ServiceException {
                    String[] expected = (String[])this.getData();
                    DesktopUnit dtu = Provider.this.ctx.getDatastore().getDTU(expected[0], false);
                    return dtu.getLocation().equals(expected[1]) && dtu.getDescription().equals(expected[2]);
                }
            };
            listener.waitForReplication();
        }
    }

    public void deleteDTU(String id) throws ServiceException {
        this.ctx.getLogger().info("Delete DTU with id " + id);
        this.ctx.getDatastore().deleteDTU(id);
        if (this.isSecondaryServer()) {
            ReplicationListener listener = new ReplicationListener(id){

                public boolean isReplicated() throws ServiceException {
                    return Provider.this.ctx.getDatastore().getDTU((String)this.getData(), false) == null;
                }
            };
            listener.waitForReplication();
        }
    }

    public void addDTU(String id, String location, String description) throws ServiceException {
        this.ctx.getLogger().info("Added DTU with id " + id);
        this.ctx.getDatastore().addDTU(id, location, description);
        if (this.isSecondaryServer()) {
            ReplicationListener listener = new ReplicationListener(id){

                public boolean isReplicated() throws ServiceException {
                    return Provider.this.ctx.getDatastore().getDTU((String)this.getData(), false) != null;
                }
            };
            listener.waitForReplication();
        }
    }

    public List getDTUs() throws ServiceException {
        this.ctx.getLogger().info("Retrieving list of all DTUs");
        return this.performSearch(null);
    }

    public int getCurrentDTUsNumber(String hostname) {
        return this.ctx.getDatastore().getNumberOfConnectedDTUs(hostname);
    }

    public String getTokenFromDTU(String servername, String dtuId) throws ServiceException {
        return this.ctx.getDatastore().getTokenFromDTU(servername, dtuId);
    }

    public List getCurrentDTUs() throws ServiceException {
        this.ctx.getLogger().info("Retrieving list of current DTUs");
        ArrayList list = new ArrayList();
        Iterator it = this.ctx.getDatastore().getHosts().iterator();
        while (it.hasNext()) {
            Host host = (Host)it.next();
            List dtus = this.ctx.getDatastore().getConnectedDTUs(host.getName());
            list.addAll(dtus);
        }
        return list;
    }

    public List searchDTUs(String searchCriteria) throws ServiceException {
        this.ctx.getLogger().info("Performing DTU search for " + searchCriteria);
        if (searchCriteria.equals("*")) {
            return this.performSearch(null);
        }
        StringBuffer filter = new StringBuffer();
        filter.append("(|(utlocation=*");
        filter.append(searchCriteria);
        filter.append("*)(utotherinfo=*");
        filter.append(searchCriteria);
        filter.append("*)(utid=*");
        filter.append(searchCriteria);
        filter.append("*))");
        return this.performSearch(filter.toString());
    }

    private List performSearch(String searchCriteria) throws ServiceException {
        return this.ctx.getDatastore().getDTUs(searchCriteria);
    }

    public List getTokenReaders() throws ServiceException {
        ArrayList<DesktopUnit> readers = new ArrayList<DesktopUnit>();
        Policy policy = new Policy(this.ctx.getDatastore().getPolicy());
        List readerIds = policy.getTerminalReaders();
        Iterator it = readerIds.iterator();
        while (it.hasNext()) {
            DesktopUnit dtu;
            String readerId = (String)it.next();
            if (readerId.startsWith("IEEE802")) {
                readerId = readerId.substring("IEEE802".length() + 1);
            }
            if ((dtu = this.getDTU(readerId)) != null) {
                readers.add(dtu);
                continue;
            }
            readers.add(new DesktopUnit(readerId, true, "", "", false));
        }
        return readers;
    }

    public void addTokenReader(String dtuId) {
        UtReader task = new UtReader();
        try {
            task.addReader(dtuId);
            if (this.isSecondaryServer()) {
                ReplicationListener listener = new ReplicationListener(dtuId){

                    public boolean isReplicated() throws ServiceException {
                        List readers = Provider.this.getTokenReaders();
                        Iterator it = readers.iterator();
                        while (it.hasNext()) {
                            DesktopUnit reader = (DesktopUnit)it.next();
                            if (!reader.getId().equals((String)this.getData())) continue;
                            return true;
                        }
                        return false;
                    }
                };
                listener.waitForReplication();
            }
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
        }
    }

    public void removeTokenReader(String dtuId) {
        UtReader task = new UtReader();
        try {
            task.removeReader(dtuId);
            if (this.isSecondaryServer()) {
                ReplicationListener listener = new ReplicationListener(dtuId){

                    public boolean isReplicated() throws ServiceException {
                        List readers = Provider.this.getTokenReaders();
                        Iterator it = readers.iterator();
                        while (it.hasNext()) {
                            DesktopUnit reader = (DesktopUnit)it.next();
                            if (!reader.getId().equals((String)this.getData())) continue;
                            return false;
                        }
                        return true;
                    }
                };
                listener.waitForReplication();
            }
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
        }
    }

    public String getTokenFromReader(String readerId) throws ServiceException {
        return this.ctx.getDatastore().getTokenFromReader(readerId);
    }

    public List getMultiheadGroups() throws ServiceException {
        this.ctx.getLogger().info("Retrieving data for all multihead group");
        return this.ctx.getDatastore().getMultiheadGroups();
    }

    public MultiheadGroup getMultiheadGroup(String name) throws ServiceException {
        int index = name.indexOf("MULTIHEAD:");
        if (index == 0) {
            name = name.substring(index + "MULTIHEAD:".length());
        }
        return this.ctx.getDatastore().getMultiheadGroup(name);
    }

    public void confirmClientKey(String clientKeyId, String dtuId) throws ServiceException {
        this.ctx.getDatastore().confirmClientKey(clientKeyId, dtuId, this.ctx.getUserName());
    }

    public void deleteClientKeys(List clientKeyIds, String dtuId) throws ServiceException {
        this.ctx.getDatastore().deleteClientKeys(clientKeyIds, dtuId);
    }

    public List getUsers(String searchCriteria) throws ServiceException {
        this.ctx.getLogger().info("Retrieving users");
        return this.ctx.getDatastore().getUsers(searchCriteria);
    }

    public List searchUsers(String searchCriteria) throws ServiceException {
        this.ctx.getLogger().info("Performing Users search for " + searchCriteria);
        if (searchCriteria.equals("*")) {
            return this.getUsers(null);
        }
        StringBuffer filter = new StringBuffer();
        filter.append("(|(utname=*");
        filter.append(searchCriteria);
        filter.append("*)(utotherinfo=*");
        filter.append(searchCriteria);
        filter.append("*))");
        return this.getUsers(filter.toString());
    }

    public List getCurrentTokens() throws ServiceException {
        this.ctx.getLogger().info("Retrieving current tokens");
        return this.ctx.getDatastore().getCurrentTokens();
    }

    public User getUser(String id) throws ServiceException {
        this.ctx.getLogger().info("Retrieving data for user: id=" + id);
        return this.ctx.getDatastore().getUser(id);
    }

    public String addUser(String name, String description, String tokenId) throws ServiceException {
        this.ctx.getLogger().info("Adding new user: name=" + name + " description=" + description + " tokenId=" + tokenId);
        String userId = this.ctx.getDatastore().addUser(name, description, tokenId);
        if (this.isSecondaryServer()) {
            ReplicationListener listener = new ReplicationListener(userId){

                public boolean isReplicated() throws ServiceException {
                    User user = Provider.this.getUser((String)this.getData());
                    return user != null;
                }
            };
            listener.waitForReplication();
        }
        return userId;
    }

    public void deleteUser(String id) throws ServiceException {
        this.ctx.getLogger().info("Deleting user: id=" + id);
        this.ctx.getDatastore().deleteUser(id);
        if (this.isSecondaryServer()) {
            ReplicationListener listener = new ReplicationListener(id){

                public boolean isReplicated() throws ServiceException {
                    User user = Provider.this.ctx.getDatastore().getUser((String)this.getData());
                    return user == null;
                }
            };
            listener.waitForReplication();
        }
    }

    public void modifyUser(String id, String name, String description) throws ServiceException {
        this.ctx.getLogger().info("Modifying user: id=" + id + " name=" + name + " description=" + description);
        this.ctx.getDatastore().modifyUser(id, name, description);
        if (this.isSecondaryServer()) {
            String[] args = new String[]{id, name, description};
            ReplicationListener listener = new ReplicationListener(args){

                public boolean isReplicated() throws ServiceException {
                    String[] expected = (String[])this.getData();
                    User user = Provider.this.getUser(expected[0]);
                    return user.getUserName().equals(expected[1]) && user.getDescription().equals(expected[2]);
                }
            };
            listener.waitForReplication();
        }
    }

    public String getUnixUserComment(String id) {
        return this.ctx.getDatastore().getUserComment(id);
    }

    public void deleteToken(String id) throws ServiceException {
        this.ctx.getLogger().info("Deleting token: id=" + id);
        this.ctx.getDatastore().deleteToken(id);
        if (this.isSecondaryServer()) {
            ReplicationListener listener = new ReplicationListener(id){

                public boolean isReplicated() throws ServiceException {
                    String rawTokenId = (String)this.getData();
                    List users = Provider.this.getUsers(null);
                    Iterator it = users.iterator();
                    while (it.hasNext()) {
                        User user = (User)it.next();
                        List logicalTokens = user.getLogicalTokens();
                        Iterator logicals = logicalTokens.iterator();
                        while (logicals.hasNext()) {
                            LogicalToken logical = (LogicalToken)logicals.next();
                            List rawTokens = logical.getRawTokens();
                            Iterator raws = rawTokens.iterator();
                            while (raws.hasNext()) {
                                RawToken raw = (RawToken)raws.next();
                                if (!raw.getId().equals(rawTokenId)) continue;
                                return false;
                            }
                        }
                    }
                    return true;
                }
            };
            listener.waitForReplication();
        }
    }

    public void addToken(String tokenId, String userId, boolean enabled) throws ServiceException {
        this.ctx.getLogger().info("Adding token " + tokenId + " to user " + userId);
        this.ctx.getDatastore().addToken(tokenId, userId, enabled);
        if (this.isSecondaryServer()) {
            String[] args = new String[]{tokenId, userId};
            ReplicationListener listener = new ReplicationListener(args){

                public boolean isReplicated() throws ServiceException {
                    String[] expected = (String[])this.getData();
                    User user = Provider.this.getUser(expected[1]);
                    List logicalTokens = user.getLogicalTokens();
                    Iterator logicals = logicalTokens.iterator();
                    while (logicals.hasNext()) {
                        LogicalToken logical = (LogicalToken)logicals.next();
                        List rawTokens = logical.getRawTokens();
                        Iterator raws = rawTokens.iterator();
                        while (raws.hasNext()) {
                            RawToken raw = (RawToken)raws.next();
                            if (!raw.getId().equals(expected[0])) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
            listener.waitForReplication();
        }
    }

    public void modifyToken(String id, boolean enabled) throws ServiceException {
        this.ctx.getLogger().info("Modifying token: id=" + id + ", enabled=" + enabled);
        this.ctx.getDatastore().modifyToken(id, enabled);
        if (this.isSecondaryServer()) {
            ArrayList<Object> expected = new ArrayList<Object>();
            expected.add(id);
            expected.add(new Boolean(enabled));
            ReplicationListener listener = new ReplicationListener(expected){

                public boolean isReplicated() throws ServiceException {
                    ArrayList data = (ArrayList)this.getData();
                    String rawTokenId = (String)data.get(0);
                    boolean state = (Boolean)data.get(1);
                    List users = Provider.this.getUsers(null);
                    Iterator it = users.iterator();
                    while (it.hasNext()) {
                        User user = (User)it.next();
                        List logicalTokens = user.getLogicalTokens();
                        Iterator logicals = logicalTokens.iterator();
                        while (logicals.hasNext()) {
                            LogicalToken logical = (LogicalToken)logicals.next();
                            List rawTokens = logical.getRawTokens();
                            Iterator raws = rawTokens.iterator();
                            while (raws.hasNext()) {
                                RawToken raw = (RawToken)raws.next();
                                if (!raw.getId().equals(rawTokenId) || raw.isEnabled() != state) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                }
            };
            listener.waitForReplication();
        }
    }

    public void setSessionType(String token, int type) throws ServiceException {
        this.ctx.getDatastore().setSessionType(token, type);
        if (this.isSecondaryServer()) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(token);
            args.add(new Integer(type));
            ReplicationListener listener = new ReplicationListener(args){

                public boolean isReplicated() throws ServiceException {
                    ArrayList expected = (ArrayList)this.getData();
                    String id = (String)expected.get(0);
                    int expectedType = (Integer)expected.get(1);
                    return Provider.this.getSessionType(id) == expectedType;
                }
            };
            listener.waitForReplication();
        }
    }

    public int getSessionType(String token) throws ServiceException {
        return this.ctx.getDatastore().getSessionType(token);
    }

    public boolean isNscmSupported() {
        String os = System.getProperty("os.name");
        return os.indexOf("SunOS") >= 0;
    }

    public Policy getPolicy() throws ServiceException {
        this.ctx.getLogger().info("Retrieving policy");
        Policy policy = new Policy(this.ctx.getDatastore().getPolicy());
        this.ctx.getLogger().info("Current policy is " + policy.getContent());
        return policy;
    }

    public void modifyPolicy(Policy policy) throws ServiceException {
        this.ctx.getLogger().info("Modifying policy to: " + policy.getContent());
        this.ctx.getDatastore().modifyPolicy(policy.getContent());
        if (this.isSecondaryServer()) {
            ReplicationListener listener = new ReplicationListener(policy.getContent()){

                public boolean isReplicated() throws ServiceException {
                    return Provider.this.getPolicy().getContent().equals((String)this.getData());
                }
            };
            listener.waitForReplication();
        }
    }

    public void modifyPassword(String password, String newPassword) throws ServiceException {
        this.ctx.getLogger().info("Modifying password");
        this.ctx.getDatastore().modifyPassword(password, newPassword);
    }

    public Security getSecurity() throws ServiceException {
        this.ctx.getLogger().info("Retrieving security");
        String contents = this.ctx.getDatastore().getSecurity();
        Security security = new Security(contents);
        return security;
    }

    public void saveSecurity(Security security) throws ServiceException {
        this.ctx.getLogger().info("Modifying security: " + security);
        this.ctx.getDatastore().saveSecurity(security.getContent());
        if (this.isSecondaryServer()) {
            ReplicationListener listener = new ReplicationListener(security.getContent()){

                public boolean isReplicated() throws ServiceException {
                    return Provider.this.getSecurity().getContent().equals((String)this.getData());
                }
            };
            listener.waitForReplication();
        }
    }

    public Devices getDevices() throws ServiceException {
        this.ctx.getLogger().info("Retrieving devices");
        Devices devices = new Devices();
        UtDevadm cmd = new UtDevadm();
        Object[][] services = cmd.getServicesStatus();
        for (int i = 0; i < services.length; ++i) {
            Object[] serviceInfo = services[i];
            String name = (String)serviceInfo[0];
            Boolean status = (Boolean)serviceInfo[1];
            if (name.equals("internal_serial")) {
                devices.setInternalSerialEnabled(status);
            }
            if (name.equals("internal_smartcard_reader")) {
                devices.setInternalSmartCardReaderEnabled(status);
            }
            if (!name.equals("usb")) continue;
            devices.setUsbEnabled(status);
        }
        return devices;
    }

    public void saveDevices(Devices devices) throws ServiceException {
        this.ctx.getLogger().info("Modifying devices");
        UtDevadm cmd = new UtDevadm();
        cmd.setServiceStatus("internal_serial", devices.isInternalSerialEnabled());
        cmd.setServiceStatus("internal_smartcard_reader", devices.isInternalSmartCardReaderEnabled());
        cmd.setServiceStatus("usb", devices.isUsbEnabled());
    }

    public List getAvailableSmartCards() throws ServiceException {
        List registeredSmartCards;
        this.ctx.getLogger().info("Retrieving available smart cards");
        Datastore datastore = this.ctx.getDatastore();
        ArrayList<SmartCard> smartCards = new ArrayList<SmartCard>();
        List availableSmartCards = datastore.getAvailableSmartCards();
        if (availableSmartCards != null) {
            for (int i = 0; i < availableSmartCards.size(); ++i) {
                SmartCard smartCard = (SmartCard)availableSmartCards.get(i);
                smartCards.add(smartCard);
            }
        }
        if ((registeredSmartCards = datastore.getRegisteredSmartCards()) != null) {
            for (int i = 0; i < registeredSmartCards.size(); ++i) {
                SmartCard smartCard = (SmartCard)registeredSmartCards.get(i);
                smartCards.add(smartCard);
            }
        }
        return smartCards;
    }

    public List getRegisteredSmartCards() throws ServiceException {
        this.ctx.getLogger().info("Retrieving registered smart cards");
        return this.ctx.getDatastore().getRegisteredSmartCards();
    }

    public void saveSmartCards(List smartCards) throws ServiceException {
        this.ctx.getLogger().info("Saving smart cards");
        this.ctx.getDatastore().saveSmartCards(smartCards);
    }

    public boolean isKioskConfigured() {
        KioskStatus ks = new KioskStatus();
        return ks.isKioskConfigured();
    }

    public boolean isKioskInstalled() {
        String isKioskInstalled = (String)this.ctx.getEnvironment().get("isKioskInstalled");
        if (isKioskInstalled == null || !isKioskInstalled.equalsIgnoreCase("true") && !isKioskInstalled.equalsIgnoreCase("false")) {
            this.ctx.getLogger().info("Check for Kiosk Mode installed");
            UtProdinfo prodinfo = new UtProdinfo();
            boolean installed = prodinfo.isInstalled("SUNWkio");
            if (installed) {
                this.ctx.getEnvironment().put("isKioskInstalled", "true");
            } else {
                this.ctx.getEnvironment().put("isKioskInstalled", "false");
            }
            isKioskInstalled = (String)this.ctx.getEnvironment().get("isKioskInstalled");
        }
        return Boolean.valueOf(isKioskInstalled);
    }

    public void deleteKiosk() throws ServiceException {
        this.ctx.getLogger().info("Deleting Kiosk Mode configuration");
        UtKiosk utkiosk = new UtKiosk();
        utkiosk.deleteKiosk();
        if (this.isSecondaryServer()) {
            ReplicationListener listener = new ReplicationListener(){

                public boolean isReplicated() throws ServiceException {
                    return !Provider.this.isKioskSaved();
                }
            };
            listener.waitForReplication();
        }
    }

    public Kiosk getKiosk() throws ServiceException {
        this.ctx.getLogger().info("Retrieving Kiosk Mode configuration");
        Datastore datastore = this.ctx.getDatastore();
        String contents = datastore.getKiosk();
        KioskDesc kd = new KioskDesc();
        return kd.getKiosk(contents);
    }

    public boolean isKioskSaved() {
        block2: {
            this.ctx.getLogger().info("Checking for saved Kiosk Mode configuration");
            Datastore datastore = this.ctx.getDatastore();
            try {
                datastore.getKiosk();
            }
            catch (ServiceException se) {
                if (se.getErrorCode() != -4) break block2;
                return false;
            }
        }
        return true;
    }

    public void saveKiosk(Kiosk kiosk) throws ServiceException {
        this.ctx.getLogger().info("Saving Kiosk Mode configuration");
        this.ctx.getDatastore().saveKiosk(kiosk.getContents());
        if (this.isSecondaryServer()) {
            ReplicationListener listener = new ReplicationListener(kiosk.getContents()){

                public boolean isReplicated() throws ServiceException {
                    String contents = "";
                    String expected = (String)this.getData();
                    if (Provider.this.isKioskSaved()) {
                        contents = Provider.this.ctx.getDatastore().getKiosk();
                    }
                    return expected.equals(contents);
                }
            };
            listener.waitForReplication();
        }
    }

    public List getKioskSessionDescriptors() {
        this.ctx.getLogger().info("Retrieving Kiosk Mode session descriptors");
        KioskDesc kd = new KioskDesc();
        return kd.getKioskDescriptors("-s");
    }

    public List getKioskApplicationDescriptors() {
        this.ctx.getLogger().info("Retrieving Kiosk Mode application descriptors");
        KioskDesc kd = new KioskDesc();
        return kd.getKioskDescriptors("-a");
    }
}

