/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.service.command;

import com.sun.ut.service.ServiceException;
import com.sun.ut.service.command.Task;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class UtProdinfo
extends Task {
    private static final String UT_PRODINFO_CMD = "/etc/opt/SUNWut/basedir/lib/utprodinfo";
    public static final String BASEDIR = "BASEDIR";
    public static final String VERSION = "VERSION";
    public static final String PSTAMP = "PSTAMP";
    public static final String NAME = "NAME";
    public static final String PRODVERS = "PRODVERS";
    public static final String PKGNAME = "PKGNAME";
    public static final String INSTDATE = "INSTDATE";
    public static final String PATCHLIST = "PATCHLIST";
    public static final String PRINT_OPTION = "-p";
    public static final String RELOCATE_OPTION = "-r";
    public static final String TEST_OPTION = "-t installed";
    private String pkgname;
    private String option;
    private String[] params;

    public UtProdinfo() {
    }

    public UtProdinfo(String pkgname, String option, String[] params) {
        this.pkgname = pkgname;
        this.option = option;
        this.params = params;
    }

    public void setPackageName(String pkgName) {
        this.pkgname = pkgName;
    }

    public String getPackageName() {
        return this.pkgname;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getOption() {
        return this.option;
    }

    public void setParameters(String[] parameters) {
        this.params = parameters;
    }

    public String[] getParameters() {
        return this.params;
    }

    public String[] getElements() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(UT_PRODINFO_CMD);
        if (this.option != null) {
            list.add(this.option);
        }
        if (this.pkgname != null) {
            list.add(this.pkgname);
        }
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                list.add(this.params[i]);
            }
        }
        String[] command = new String[list.size()];
        command = list.toArray(command);
        return command;
    }

    public String[] getAllPackageNames() throws ServiceException {
        this.pkgname = null;
        this.option = null;
        this.params = null;
        this.run();
        if (this.getExitCode() != 0) {
            throw new ServiceException(this.getSyntax(), this.getExitCode());
        }
        ArrayList<String> pkgList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.getOutputMsg(), "\n");
        while (tokenizer.hasMoreTokens()) {
            int separatorIndex;
            String token = tokenizer.nextToken();
            if (token == null || (separatorIndex = token.indexOf(" ")) <= 0) continue;
            pkgList.add(token.substring(0, separatorIndex));
        }
        String[] list = new String[pkgList.size()];
        return pkgList.toArray(list);
    }

    public String getBaseDirectory(String pkgName) throws ServiceException {
        this.pkgname = pkgName;
        this.option = RELOCATE_OPTION;
        this.params = null;
        this.run();
        if (this.getExitCode() != 0) {
            throw new ServiceException(this.getSyntax(), this.getExitCode());
        }
        String result = this.getOutputMsg();
        return result.substring(0, result.length() - 1);
    }

    public String[] getPackageInfo(String pkgName, String[] parameters) throws ServiceException {
        this.pkgname = pkgName;
        this.params = parameters;
        this.option = PRINT_OPTION;
        this.run();
        if (this.getExitCode() != 0) {
            throw new ServiceException(this.getSyntax(), this.getExitCode());
        }
        ArrayList<String> pkgInfo = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.getOutputMsg(), "\n");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null) continue;
            int separatorIndex = token.indexOf("=");
            if (separatorIndex > 0) {
                pkgInfo.add(token.substring(separatorIndex + 1, token.length()));
                continue;
            }
            pkgInfo.add(token);
        }
        String[] info = new String[pkgInfo.size()];
        return pkgInfo.toArray(info);
    }

    public boolean isInstalled(String pkgName) {
        this.pkgname = pkgName;
        this.option = TEST_OPTION;
        this.params = null;
        this.run();
        return this.getExitCode() == 0;
    }
}

