/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Observable;
import java.util.StringTokenizer;

public class Session
extends Observable {
    private String server_name = null;
    private int server_port = -1;
    private String session_id = null;
    private String desktop_ip_addr = null;
    private InetAddress desktop_in_addr = null;
    private int desktop_port = -1;
    private boolean got_session_info = this.get_session_info();
    private boolean joined_session = false;
    private boolean session_connected = false;
    private long connect_time = 0L;
    private PrintWriter pw;
    private BufferedReader br;

    public static void main(String[] stringArray) {
        Debug.set_debug_string("yes");
        Session session = new Session();
        session.print();
    }

    public Session() {
        if (!this.got_session_info) {
            return;
        }
        if (!this.joined_session) {
            return;
        }
    }

    public boolean got_session_info() {
        return this.got_session_info;
    }

    public boolean joined_session() {
        return this.joined_session;
    }

    public synchronized boolean session_connected() {
        return this.session_connected;
    }

    public synchronized String desktop_ip_addr() {
        return this.desktop_ip_addr;
    }

    public synchronized InetAddress desktop_inet_addr() {
        return this.desktop_in_addr;
    }

    public synchronized void setPort(int n) {
        this.desktop_port = n;
    }

    public synchronized int desktop_port() {
        return this.desktop_port;
    }

    public void print() {
        Debug.printme("  got_session_info  = " + this.got_session_info);
        Debug.printme("  joined_session    = " + this.joined_session);
        Debug.printme("  session_connected = " + this.session_connected);
        Debug.printme("  connect_time      = " + this.connect_time);
        Debug.printme("  server_name       = " + this.server_name);
        Debug.printme("  server_port       = " + this.server_port);
        Debug.printme("  session_id        = " + this.session_id);
        Debug.printme("  desktop_ip_addr   = " + this.desktop_ip_addr);
        Debug.printme("  desktop_in_addr   = " + this.desktop_in_addr);
        Debug.printme("  desktop_port      = " + this.desktop_port);
        Debug.printme("  num observers     = " + this.countObservers());
    }

    public long get_connect_time() {
        return this.connect_time;
    }

    private boolean get_session_info() {
        String string = "/etc/opt/SUNWut/basedir/lib/utxprop -s";
        try {
            String string2;
            Process process = Runtime.getRuntime().exec(string);
            InputStream inputStream = process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                if (stringTokenizer.countTokens() != 3) continue;
                this.server_name = stringTokenizer.nextToken();
                this.server_port = Integer.decode(stringTokenizer.nextToken());
                this.session_id = stringTokenizer.nextToken();
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return false;
        }
    }

    public boolean connect_and_join() {
        this.joined_session = false;
        try {
            Socket socket = new Socket(this.server_name, this.server_port);
            OutputStream outputStream = socket.getOutputStream();
            InputStream inputStream = socket.getInputStream();
            this.pw = new PrintWriter(outputStream, true);
            this.br = new BufferedReader(new InputStreamReader(inputStream));
            this.send_message("join " + this.session_id);
            String string = this.receive_message();
            if (!string.equalsIgnoreCase("OK/join")) {
                Debug.printme("could not join.");
                return false;
            }
            while (this.br.ready()) {
                string = this.receive_message();
                this.parse_message(string);
            }
            ReaderThread readerThread = new ReaderThread();
            readerThread.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.joined_session = true;
        return true;
    }

    private String inetToHex(InetAddress inetAddress) {
        String string = new String("");
        if (inetAddress == null) {
            return "0";
        }
        byte[] byArray = inetAddress.getAddress();
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xF0) == 0) {
                string = string + "0";
            }
            string = string + Integer.toHexString(byArray[i] & 0xFF);
        }
        return string;
    }

    public void send_callme(InetAddress inetAddress, int n, int n2, String string) {
        try {
            String string2 = "callme " + this.session_id + " ip=" + this.inetToHex(inetAddress) + " port=" + n + " key=" + n2 + " name=" + string;
            Debug.printme("send_callme: " + string2);
            this.send_message(string2);
            string2 = this.receive_message();
            if (!string2.equalsIgnoreCase("OK/callme")) {
                Debug.printme("callme error");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void send_message(String string) throws IOException {
        this.pw.println(string);
    }

    private String receive_message() throws IOException {
        return this.br.readLine();
    }

    private void parse_message(String string) {
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = 0;
        for (n = 0; n < 3; ++n) {
            stringArray[n] = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        }
        if (stringArray[0].equals("connect")) {
            Debug.printme("SESSION CONNECTED");
            this.session_connected = true;
            this.desktop_ip_addr = stringArray[1];
            try {
                this.desktop_in_addr = InetAddress.getByName(this.desktop_ip_addr);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            this.desktop_port = Integer.decode(stringArray[2]);
            this.connect_time = System.currentTimeMillis();
            this.setChanged();
            this.notifyObservers("connect");
        } else if (stringArray[0].equals("disconnect")) {
            Debug.printme("SESSION DISCONNECTED");
            this.session_connected = false;
            this.desktop_ip_addr = null;
            this.desktop_in_addr = null;
            this.desktop_port = -1;
            this.connect_time = 0L;
            this.setChanged();
            this.notifyObservers("disconnect");
        }
    }

    class ReaderThread
    extends Thread {
        ReaderThread() {
        }

        public void run() {
            Thread thread = Thread.currentThread();
            thread.setName("Session ReaderThread");
            try {
                String string;
                String[] stringArray = new String[3];
                while ((string = Session.this.br.readLine()) != null) {
                    Session.this.parse_message(string);
                    Debug.printme("rt: " + string);
                }
                Debug.printme("finishing read loop");
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }
}

