/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.sdk.Utils;
import auth.utauthd.CallBack;
import auth.utauthd.Configuration;
import auth.utauthd.DaemonManager;
import auth.utauthd.GroupManager;
import auth.utauthd.SessionId;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DeviceManager
extends DaemonManager
implements Runnable {
    private static int dmcount = 0;
    protected static Hashtable sidTbl = new Hashtable(4);

    public static String getDefaultId() {
        String string = Configuration.deviceManagerHost + ":" + Configuration.deviceManagerPort;
        return string;
    }

    protected static synchronized boolean existsSid(SessionId sessionId) {
        return sidTbl.get(sessionId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DeviceManager getDeviceManager(String string) {
        DeviceManager deviceManager = null;
        Log.debug((String)("DeviceMnager.getDeviceManager: managers = " + DaemonManager.managers));
        deviceManager = (DeviceManager)DaemonManager.getManager(string);
        Log.debug((String)("DeviceManager.getDeviceManager(): devMgr from Hashtbl = " + deviceManager));
        if (deviceManager == null) {
            try {
                deviceManager = new DeviceManager(string);
            }
            catch (Exception exception) {
                return null;
            }
            DeviceManager deviceManager2 = deviceManager;
            synchronized (deviceManager2) {
                Log.notice((String)("DeviceManager.getDeviceManager: Initiate callback to utdevMgrd at " + string));
                CallBack.setupCallBack(deviceManager);
                if (!deviceManager.initiateCallback()) {
                    Log.debug((String)"DeviceManager.getDeviceManager: InitiateCallBack failed.");
                    CallBack.clearCallBack(deviceManager);
                    return null;
                }
                try {
                    deviceManager.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    Log.notice((String)("DeviceManager.getDeviceManager: " + interruptedException));
                }
                if (deviceManager.isConnected()) {
                    DaemonManager.addManager(string, deviceManager);
                    try {
                        Log.debug((String)"DeviceManger.getDeviceManager(): get gstaus");
                        GroupManager.status(deviceManager.socket.getOutputStream());
                    }
                    catch (IOException iOException) {
                        Log.debug((String)("DeviceManger.getDeviceManager(): get gstaus : " + iOException));
                    }
                } else {
                    CallBack.clearCallBack(deviceManager);
                }
            }
        }
        if (!deviceManager.isConnected()) {
            return null;
        }
        return deviceManager;
    }

    public static void init(String string) {
        DeviceManager deviceManager = new DeviceManager(string);
        new Thread((Runnable)deviceManager, "deviceManager" + dmcount++).start();
    }

    private DeviceManager(String string) {
        super("DeviceManager", string, Configuration.deviceManagerHost, Configuration.deviceManagerPort);
    }

    public synchronized void setSocket(Socket socket) {
        Log.debug((String)("DeviceManager.setSocket: s=" + Utils.addr_normalize((String)socket.getInetAddress().getHostAddress()) + "/" + socket.getPort()));
        this.socket = socket;
        try {
            if (this.socket != null) {
                this.mout = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "8859_1"));
                Log.debug((String)("DeviceManager.setSocket:  socket working: " + this.socket));
            }
        }
        catch (IOException iOException) {
            Log.unexpectedError((String)("Cannot derive BufferedOutputStream: " + iOException));
            try {
                this.socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        Log.debug((String)("DeviceManager.setSocket ready: " + socket));
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsg(String string) {
        if (this.isConnected()) {
            BufferedWriter bufferedWriter = this.mout;
            synchronized (bufferedWriter) {
                Log.debug((String)("DeviceManager.request: \"" + string + "\""));
                try {
                    this.mout.write(string);
                    this.mout.newLine();
                    this.mout.flush();
                    Log.debug((String)"DeviceManager.request: done sending msg to mout.");
                    return;
                }
                catch (Exception exception) {
                    Log.notice((String)("Connection dropped. " + exception));
                }
            }
        }
    }

    protected static synchronized void addSidToTbl(SessionId sessionId, String string) {
        try {
            sidTbl.put(sessionId, string);
        }
        catch (NullPointerException nullPointerException) {
            Log.debug((String)("DeviceManager.addSidToTbl() e = " + nullPointerException));
        }
    }

    protected static void rmSidFromTbl(SessionId sessionId) {
        sidTbl.remove(sessionId);
    }

    protected boolean isConnected() {
        if (this.socket == null) {
            return false;
        }
        try {
            int n = this.socket.getSoTimeout();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.socket.getInputStream());
            this.socket.setSoTimeout(1);
            int n2 = bufferedInputStream.read();
            if (n2 != -1) {
                Log.debug((String)"socket still good");
                this.socket.setSoTimeout(n);
                return true;
            }
            Log.debug((String)"Socket is bad. End of stream");
            this.socket.setSoTimeout(n);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.socket = null;
            return false;
        }
        catch (InterruptedIOException interruptedIOException) {
            return true;
        }
        catch (Exception exception) {
            Log.debug((String)("DeviceManager.isConnected(): not connected; error = " + exception));
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.socket = null;
            return false;
        }
    }

    public void run() {
        DeviceManager deviceManager = null;
        String string = this.hostname + ":" + this.port;
        deviceManager = this.getDeviceManager(string);
        Log.debug((String)("DeviceManager.run(): return from getDM: devMgr = " + deviceManager));
        if (deviceManager == null) {
            Log.debug((String)"DevMgr not available");
            return;
        }
        Log.debug((String)("DeviceManager.run() devMgr dump sidTbl: " + sidTbl));
        Enumeration enumeration = sidTbl.keys();
        while (enumeration.hasMoreElements()) {
            SessionId sessionId = (SessionId)enumeration.nextElement();
            String string2 = (String)sidTbl.get(sessionId);
            Log.debug((String)("DeviceManager.run(): sid = " + sessionId + " msg=" + string2));
            try {
                deviceManager.sendMsg(string2);
            }
            catch (Exception exception) {
                Log.debug((String)"DeviceManager.run(): exception when request");
            }
        }
        Log.debug((String)"DevMgr done, thread exits...");
    }
}

