/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.admin.Admin;
import auth.protocol.AuthWriter;
import auth.protocol.ClientCommand;
import auth.protocol.Protocol;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import auth.sdk.Task;
import auth.sdk.TaskListener;
import auth.sdk.Utils;
import auth.utauthd.AuthModule;
import auth.utauthd.AuthRecord;
import auth.utauthd.Configuration;
import auth.utauthd.Crypto;
import auth.utauthd.DeadlockException;
import auth.utauthd.GroupManager;
import auth.utauthd.Mutex;
import auth.utauthd.SmartCardID;
import auth.utauthd.SmartCardIDException;
import auth.utauthd.WatchIO;
import auth.utauthd.WatchIOListener;
import auth.utauthd.WatchIORequest;
import auth.utauthd.Worker;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;

public final class Terminal
implements WatchIOListener,
TaskListener {
    private boolean valid = false;
    private int tagCtr = 0;
    private String msgTag;
    private boolean protocolErrorPending = false;
    private AuthRecord ar = null;
    private SmartCardID scId = null;
    private boolean scDone = false;
    private AuthWriter out = null;
    private BufferedInputStream in;
    private Socket s;
    private String address;
    private InetAddress localAddr;
    private InetAddress ipAddress;
    private InetAddress realIP;
    private int ipPort;
    private String lastInsertToken = null;
    private String buffer = null;
    private String useReal;
    private WatchIORequest wior = null;
    private int tokenSeq = 0;
    private int savedTokenSeq = 0;
    private long aliveCheckExpiryTime = 0L;
    private int aliveCheckTimeout = 0;
    private int mtu = 0;
    private String model = null;
    private String sn = null;
    private String namespace = null;
    private long pktCount = 0L;
    private long lossCount = 0L;
    private float connTime = 0.0f;
    private float idleTime = 0.0f;
    private long byteCount = 0L;
    private long latency = 0L;
    private String startRes = null;
    private String ddcInfo = null;
    private String initState = null;
    private String barrierLevel = null;
    private ClientCommand curInsertCommand = null;
    private Hashtable storedParams = new Hashtable();
    private boolean actionPending = false;
    private static Object connectionCounterLock = new Object();
    private static int connectionCounter = 0;
    private String debugName = null;
    private int keepAliveState = 0;
    private static final int KEEPALIVE_OK = 0;
    private static final int KEEPALIVE_QUICKCHECK = 1;
    private static final int KEEPALIVE_PENDING = 2;
    private static final int KEEPALIVE_ERROR = 3;
    int errorCount = 0;
    static final int MAXERRORS = 1000;
    private Mutex mutex = new Mutex();
    private Crypto crypto = new Crypto();
    private StringBuffer tokenSet = null;
    private String firstServer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal(Socket socket, String string) throws Exception {
        if (socket == null) {
            throw new Exception("Terminal instantiated with null");
        }
        this.msgTag = string;
        this.s = socket;
        this.ipAddress = socket.getInetAddress();
        this.localAddr = socket.getLocalAddress();
        this.ipPort = socket.getPort();
        this.address = Utils.addr_normalize((String)this.ipAddress.getHostAddress());
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.out = new AuthWriter(this.s.getOutputStream());
        Log.debug((String)"Terminal:: creating terminal object .. getting lock");
        this.lock();
        try {
            socket.setTcpNoDelay(true);
            this.s.setSoTimeout(Configuration.timeout);
            if (!Terminal.isNetworkAllowed(this.ipAddress)) {
                Log.unexpectedError((String)("Connection from " + this.address + " is not allowed"));
                this.protocolError("networkNotAllowed");
            } else {
                this.valid = true;
                this.debugName = "Terminal" + ++connectionCounter;
                this.wior = new WatchIORequest(this.s, 1, this, true, this.debugName);
                this.wior.setTimeout(Configuration.timeout);
                WatchIO.add(this.wior);
            }
            this.resetAliveCheck();
        }
        catch (SocketException socketException) {
            Log.unexpectedError((String)(this.s + " Cannot set socket timeout: " + socketException));
            this.close();
            return;
        }
        finally {
            Log.debug((String)"Terminal:: releasing lock after create terminal");
            this.unlock();
        }
    }

    public String toString() {
        String string;
        if (this.ar != null) {
            string = this.ar.toString();
            if (string.length() > 40) {
                string = string.substring(0, 40) + "...";
            }
        } else {
            string = "null";
        }
        return this.debugName + "(valid:" + this.valid + ", s:" + this.address + ", ar:" + string + ")";
    }

    public void lock() {
        try {
            this.mutex.lock();
        }
        catch (DeadlockException deadlockException) {
            Log.unexpectedError((String)deadlockException.getMessage());
            deadlockException.printStackTrace();
            Log.notice((String)"System error !!! Server exiting.");
            System.exit(1);
        }
    }

    public void unlock() {
        this.mutex.unlock();
    }

    void resetAliveCheck() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"resetAliveCheck:: Does not have required locks!");
        }
        this.aliveCheckExpiryTime = 0L;
        this.aliveCheckTimeout = Configuration.quickTimeout;
        if (this.keepAliveState == 1) {
            this.keepAliveState = 0;
        }
    }

    int startAliveCheck(boolean bl) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"startAliveCheck:: Does not have required locks!");
            return -2;
        }
        if (!this.valid) {
            return 0;
        }
        int n = this.aliveCheckTimeout;
        if (n <= 0) {
            if (n == 0) {
                Log.debug((String)"startAliveCheck:: live-check timeout disabled.");
            } else {
                Log.debug((String)("startAliveCheck:: Invalid timeout: " + n));
            }
            return -3;
        }
        if (!this.write("keepAliveInf", null)) {
            return -4;
        }
        long l = System.currentTimeMillis();
        long l2 = l + (long)n;
        if (l2 <= 0L) {
            Log.unexpectedError((String)("startAliveCheck: negative expiry time: " + l2));
            return -1;
        }
        if (this.aliveCheckExpiryTime > 0L) {
            if (this.keepAliveState == 0) {
                if (bl) {
                    this.aliveCheckExpiryTime = 0L;
                    int n2 = this.aliveCheckTimeout + this.aliveCheckTimeout / 2;
                    if (n2 < Configuration.timeout) {
                        this.aliveCheckTimeout = n2;
                    }
                }
                return -1;
            }
            if (l >= this.aliveCheckExpiryTime) {
                return 0;
            }
            if (l2 < this.aliveCheckExpiryTime) {
                this.aliveCheckExpiryTime = l2;
            } else {
                n = (int)(this.aliveCheckExpiryTime - l);
            }
        } else {
            this.aliveCheckExpiryTime = l2;
            if (this.keepAliveState == 0) {
                this.keepAliveState = 1;
            }
        }
        return n;
    }

    public boolean watchIOEvent(short s, Object object) {
        Worker.begin(new Task((TaskListener)this, (Object)new Short(s), true));
        return false;
    }

    void addTokenSeq(Hashtable hashtable, boolean bl) {
        hashtable.put("tokenSeq", String.valueOf(this.tokenSeq));
        if (bl) {
            this.savedTokenSeq = this.tokenSeq;
        }
    }

    boolean write(String string, Hashtable hashtable) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"write:: Does not have required locks!");
            System.exit(1);
        }
        if (this.valid) {
            if (string.equals("connInf") || string.equals("redirectInf")) {
                this.addTokenSeq(hashtable, string.equals("connInf"));
            }
            String string2 = this.out.write(string, hashtable);
            if (this.crypto != null && (string.equals("connInf") || string.equals("redirectInf") || string.equals("keyInf") || string.equals("controlSmartCard"))) {
                this.crypto.collectMessage(string2);
            }
            return string2 != null;
        }
        return false;
    }

    private void setStoredParams(Hashtable hashtable) {
        this.storedParams = hashtable;
    }

    public Hashtable getStoredParams() {
        return this.storedParams;
    }

    public String getStoredParam(String string) {
        return (String)this.storedParams.get(string);
    }

    void putStoredParam(String string, String string2) {
        this.storedParams.put(string, string2);
    }

    public String getResolution() {
        return this.startRes;
    }

    public String getDdcInfo() {
        return this.ddcInfo;
    }

    public String getInitialState() {
        return this.initState;
    }

    public String getTerminalStats() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"getTerminalStats:: Does not have required locks!");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("terminalPackets=" + this.pktCount);
        stringBuffer.append("\nterminalLostPackets=" + this.lossCount);
        stringBuffer.append("\nterminalConnectTime=" + this.connTime);
        stringBuffer.append("\nterminalIdleTime=" + this.idleTime);
        stringBuffer.append("\nterminalBytes=" + this.byteCount);
        stringBuffer.append("\nterminalLatency=" + this.latency);
        stringBuffer.append("\nterminalBarrierLevel=" + this.barrierLevel);
        return stringBuffer.toString();
    }

    public String getIPAddressString() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"getIPAddressString:: Does not have required locks!");
            return null;
        }
        if (this.valid) {
            return this.address;
        }
        return null;
    }

    public String getRealIPString() {
        return Utils.addr_normalize((String)this.realIP.getHostAddress());
    }

    public String getUseReal() {
        return this.useReal;
    }

    public String getAuthPortString() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"getAuthPortString:: Does not have required locks!");
            return null;
        }
        if (this.valid) {
            return Integer.toString(this.ipPort);
        }
        return null;
    }

    public String getAuthIPAandPortString() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"getAuthIPAandPortString:: Does not have required locks!");
            return null;
        }
        if (this.valid) {
            return this.address + "/" + this.ipPort;
        }
        return null;
    }

    public InetAddress renderIpa() {
        return this.ipAddress;
    }

    public int renderPort() {
        return this.ipPort;
    }

    public InetAddress authIpa() {
        return this.ipAddress;
    }

    public int authPort() {
        return this.ipPort;
    }

    public void disable() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"disable:: Does not have required locks!");
            System.exit(1);
        }
        WatchIO.remove(this.wior);
    }

    public void enable() {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"enable:: Does not have required locks!");
            System.exit(1);
        }
        WatchIO.add(this.wior);
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNumber() {
        return this.sn;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static String getTerminalCID(ClientCommand clientCommand) {
        String string = clientCommand.getParam("sn");
        String string2 = clientCommand.getParam("namespace");
        if (string != null && string2 != null) {
            return string2 + "." + string;
        }
        return null;
    }

    public String getTerminalCID() {
        if (this.sn != null && this.namespace != null) {
            return this.namespace + "." + this.sn;
        }
        return Terminal.getTerminalCID(this.curInsertCommand);
    }

    public String getFirstString() {
        if (this.firstServer != null) {
            return Utils.addr_normalize((String)Terminal.HexstrToInet(this.firstServer).getHostAddress());
        }
        return null;
    }

    public boolean isActionPending() {
        return this.actionPending;
    }

    public void setActionPending(boolean bl) {
        this.actionPending = bl;
    }

    public void close() {
        Log.debug((String)"Terminal.close: BEGIN");
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"close:: Does not have required locks!");
            System.exit(1);
        }
        if (this.ar != null) {
            this.ar.destroy();
            this.ar = null;
        }
        this.valid = false;
        if (this.s != null) {
            this.disable();
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                Log.unexpectedError((String)("Terminal.close: " + iOException));
                System.exit(1);
            }
            this.s = null;
        }
        this.in = null;
        this.out = null;
        this.address = null;
        this.wior = null;
    }

    private static boolean isNetworkAllowed(InetAddress inetAddress) {
        boolean bl = false;
        if (Configuration.allowLANConnections) {
            return true;
        }
        String string = Utils.addr_normalize((String)inetAddress.getHostAddress());
        return GroupManager.isNetworkAllowed(string);
    }

    private static int NetworkFamily(String string) {
        if (string.indexOf(58) == -1) {
            return 4;
        }
        return 6;
    }

    private static InetAddress HexstrToInet(String string) {
        InetAddress inetAddress;
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[4];
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '-') {
                int n4 = 16 - (n - ++n2) / 2;
                while (n3 < n4) {
                    byArray[n3++] = 0;
                }
                if (n3 == 16) break;
            }
            int n5 = Integer.parseInt(string.substring(n2, n2 + 2), 16);
            byArray[n3] = (byte)n5;
            n2 += 2;
            ++n3;
        }
        if (n3 != 4 && n3 != 16) {
            return null;
        }
        try {
            if (n3 == 16) {
                inetAddress = InetAddress.getByAddress(byArray);
            } else {
                for (n2 = 0; n2 < 4; ++n2) {
                    byArray2[n2] = byArray[n2];
                }
                inetAddress = InetAddress.getByAddress(byArray2);
            }
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        return inetAddress;
    }

    public String getLocalAddr() {
        return Utils.addr_normalize((String)this.localAddr.getHostAddress());
    }

    public void protocolError(String string) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"protocolError:: Does not have required locks!");
            return;
        }
        Log.unexpectedError((String)(this.address + " protocolError: " + string));
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
            hashtable.put("state", "disconnected");
            hashtable.put("error", string);
            this.write("protocolErrorInf", hashtable);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)(this.address + " Error while processing protocolError: " + exception));
            Thread.currentThread();
            Thread.dumpStack();
        }
        this.close();
    }

    private void denySession(String string) {
        if (!this.mutex.assertOwner()) {
            Log.unexpectedError((String)"protocolError:: Does not have required locks!");
            return;
        }
        Log.notice((String)("Denying " + this.address + ": " + string));
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
            hashtable.put("access", "denied");
            hashtable.put("cause", string);
            this.write("discInf", hashtable);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)(this.address + " Error while processing discInf: " + exception));
            Thread.currentThread();
            Thread.dumpStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskEvent(Object object) {
        block37: {
            this.lock();
            try {
                String string;
                boolean bl = true;
                Task task = (Task)object;
                short s = (Short)task.param;
                if ((s & 1) != 0) {
                    s = (short)(s & 0xFFFFFFFE);
                    if (!this.readMessages()) {
                        this.close();
                    } else {
                        this.keepAliveState = 0;
                    }
                }
                if ((s & 8) != 0) {
                    s = (short)(s & 0xFFFFFFF7);
                    Log.unexpectedError((String)"Terminal.taskEvent: POLLERR");
                    this.close();
                    return;
                }
                if ((s & 0x10) != 0) {
                    s = (short)(s & 0xFFFFFFEF);
                    Log.unexpectedError((String)"Terminal.taskEvent: POLLHUP");
                    this.close();
                    return;
                }
                if ((s & 4) != 0) {
                    s = (short)(s & 0xFFFFFFFB);
                    Log.unexpectedError((String)"Terminal.taskEvent: POLLOUT");
                    this.close();
                    return;
                }
                if ((s & 0x20) != 0) {
                    s = (short)(s & 0xFFFFFFDF);
                    Log.unexpectedError((String)"Terminal.taskEvent: POLLNVAL");
                    this.close();
                    return;
                }
                if ((s & 0x1000) != 0) {
                    s = (short)(s & 0xFFFFEFFF);
                    switch (this.keepAliveState) {
                        case 0: {
                            try {
                                if (this.write("keepAliveInf", null)) {
                                    this.keepAliveState = 2;
                                    break;
                                }
                                this.keepAliveState = 3;
                            }
                            catch (Exception exception) {
                                Log.unexpectedError((String)"cannot send keepAliveInf");
                                this.keepAliveState = 3;
                            }
                            break;
                        }
                        case 1: {
                            this.keepAliveState = 2;
                            break;
                        }
                        case 2: {
                            this.keepAliveState = 3;
                            break;
                        }
                        case 3: {
                            this.keepAliveState = 3;
                        }
                    }
                    if (this.keepAliveState == 3) {
                        this.close();
                    }
                }
                if (s != 0) {
                    Log.unexpectedError((String)("Terminal.taskEvent: ignored events: " + s));
                    s = 0;
                    return;
                }
                if (!this.actionPending) break block37;
                String string2 = (String)this.storedParams.get("savedType");
                String string3 = (String)this.storedParams.get("savedId");
                if (string2 != null) {
                    string = (String)this.storedParams.get("username");
                    if (!string2.equals("auth") || string != null && !string.equals("")) {
                        this.storedParams.put("type", string2);
                        if (string3 != null) {
                            this.storedParams.put("id", string3);
                        }
                    }
                }
                try {
                    string = new ClientCommand(this.curInsertCommand.getCommand(), this.storedParams, false);
                    bl = this.continueProcess((ClientCommand)string, null);
                    this.actionPending = false;
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("Failed in process: " + exception));
                    exception.printStackTrace();
                    bl = false;
                }
                if (!bl) {
                    this.close();
                    if (this.ar != null) {
                        this.ar.destroy();
                        this.ar = null;
                    }
                }
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("Terminal.taskEvent: failed with exception " + exception));
                exception.printStackTrace();
                System.out.println("Worker thread recovered from error. Continuing..");
                Log.notice((String)"Worker thread recovered from error. Continuing..");
            }
            finally {
                this.unlock();
            }
        }
        if (this.valid) {
            WatchIO.add(this.wior);
        }
    }

    private boolean readMessages() {
        boolean bl = true;
        block12: while (this.valid) {
            int n;
            int n2;
            try {
                n2 = this.in.available();
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("Terminal.readMesages: " + exception));
                return false;
            }
            if (bl && n2 < 1) {
                ++this.errorCount;
                if (this.errorCount > 1000) {
                    Log.notice((String)"readMessage::socket looping limit exceeded.Close it.");
                    return false;
                }
            } else {
                this.errorCount = 0;
            }
            if (n2 <= 0) {
                if (!Configuration.nonBlockRead || !bl) break;
                try {
                    int n3 = this.s.getSoTimeout();
                    this.s.setSoTimeout(1);
                    int n4 = this.in.read();
                    if (n4 == -1) {
                        Log.debug((String)"end of file. Close socket.");
                        return false;
                    }
                    Log.notice((String)("Read a byte after av was <=0 : " + (char)n4));
                    this.buffer = this.buffer + (char)n4;
                    this.s.setSoTimeout(n3);
                    break;
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("Terminal.readMessages: " + exception));
                    return false;
                }
            }
            byte[] byArray = new byte[n2];
            int n5 = 0;
            try {
                n5 = this.in.read(byArray, 0, n2);
                bl = false;
            }
            catch (IOException iOException) {
                Log.unexpectedError((String)("Terminal.readMessages: in.read: " + iOException));
                return false;
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("Terminal.readMessages: catchall-2" + exception));
                return false;
            }
            if (n5 != n2) {
                Log.unexpectedError((String)("Terminal.readMessages: expected " + n2 + " bytes, got " + n5));
            }
            if (n5 > 0) {
                String string = "";
                try {
                    string = new String(byArray, "8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.configError((String)"Terminal.readMessages: impossible");
                    System.exit(1);
                }
                this.buffer = this.buffer != null ? this.buffer + string : string;
            } else if (n5 <= 0) {
                Log.unexpectedError((String)"Terminal.readMessages: end of stream; socket closed.");
                return false;
            }
            while ((n = this.buffer.indexOf(10)) != -1) {
                String string = this.buffer.substring(0, n);
                Log.debug((String)("Terminal.processCompleteCommands: msg=\"" + string + "\""));
                this.buffer = this.buffer.substring(n + 1);
                Hashtable hashtable = Protocol.parse((String)string);
                if (hashtable == null) {
                    this.protocolError("does_not_parse");
                    if (this.buffer != null && this.buffer.length() > 0) {
                        Log.debug((String)("Terminal.readMessages: discard_a " + this.buffer.length() + "<" + this.buffer + ">"));
                    }
                    this.buffer = null;
                    continue block12;
                }
                String string2 = (String)hashtable.get("_command");
                if (string2 == null) {
                    this.protocolError("missing command");
                    Log.debug((String)("Terminal.readMessages: discard_b " + this.buffer.length() + "<" + this.buffer + ">"));
                    this.buffer = null;
                    continue block12;
                }
                hashtable.remove("_command");
                ClientCommand clientCommand = new ClientCommand(string2, hashtable);
                clientCommand.setFullMessage(string);
                if (!clientCommand.isValid()) {
                    this.protocolError("invalid command or parameter");
                    Log.debug((String)("Terminal.readMessages: discard_d " + this.buffer.length() + "<" + this.buffer + ">"));
                    this.buffer = null;
                    continue block12;
                }
                boolean bl2 = false;
                try {
                    bl2 = this.process(clientCommand, hashtable);
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("Terminal.readMessages: process() failed with exception " + exception));
                    exception.printStackTrace();
                    System.out.println("Worker thread recovered from error. Continuing..");
                    Log.notice((String)"Worker thread recovered from error. Continuing..");
                    bl2 = false;
                }
                if (!bl2) {
                    Log.debug((String)("Terminal.readMessages: discard_c " + this.buffer.length() + "<" + this.buffer + ">"));
                    this.buffer = null;
                    this.close();
                    continue block12;
                }
                if (this.buffer.length() <= 0) continue;
                Log.debug((String)("Terminal.readMessages: iOfNL=" + this.buffer.indexOf(10) + ", remainder=\"" + this.buffer + "\""));
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean process(ClientCommand var1_1, Hashtable var2_2) {
        Log.debug((String)("PROCESS: " + var1_1));
        Log.debug((String)("PROCESS: Full message:[" + var1_1.getFullMessage() + "]"));
        if (!Configuration.enableIPv6 && Terminal.NetworkFamily(this.address) == 6) {
            Log.unexpectedError((String)("Connection from " + this.address + " is not allowed, enableIPv6 is disabled"));
            try {
                Thread.sleep(Configuration.ipctimeout);
            }
            catch (InterruptedException var3_3) {
                // empty catch block
            }
            this.protocolError("enableIPv6 is disabled");
            return false;
        }
        if (!Configuration.enableIPv4 && Terminal.NetworkFamily(this.address) == 4) {
            Log.unexpectedError((String)("Connection from " + this.address + " is not allowed, enableIPv4 is disabled"));
            try {
                Thread.sleep(Configuration.ipctimeout);
            }
            catch (InterruptedException var3_4) {
                // empty catch block
            }
            this.protocolError("enableIPv4 is disabled");
            return false;
        }
        var3_5 = var1_1.getCommandType();
        switch (var3_5) {
            case 6: {
                this.startSmartCardIDTimer();
                if (!this.write("keepAliveCnf", null)) {
                    Log.unexpectedError((String)"cannot send keepAliveCnf");
                    return false;
                }
                if (!this.checkConsistency(var1_1)) {
                    Log.clientError((String)"Inconsistent keepAlive message - discarding data");
                    return true;
                }
                if (var1_1.hasParam("pktCount")) {
                    this.pktCount = Long.parseLong(var1_1.getParam("pktCount"));
                }
                if (var1_1.hasParam("lossCount")) {
                    this.lossCount = Long.parseLong(var1_1.getParam("lossCount"));
                }
                if (var1_1.hasParam("byteCount")) {
                    this.byteCount = Long.parseLong(var1_1.getParam("byteCount"));
                }
                if (var1_1.hasParam("idleTime")) {
                    this.idleTime = Float.parseFloat(var1_1.getParam("idleTime"));
                }
                if (var1_1.hasParam("connTime")) {
                    this.connTime = Float.parseFloat(var1_1.getParam("connTime"));
                }
                if (var1_1.hasParam("latency")) {
                    this.latency = Long.parseLong(var1_1.getParam("latency"));
                }
                return true;
            }
            case 7: {
                if (!this.checkConsistency(var1_1)) {
                    Log.clientError((String)"Inconsistent keepAlive message - discarding");
                }
                return true;
            }
            case 0: {
                if (!var1_1.getParam("event").equals("insert")) ** GOTO lbl63
                Log.debug((String)("Processing insert message: '" + var1_1.getFullMessage() + "'"));
                if (!this.checkConsistency(var1_1)) {
                    Log.notice((String)"Inconsistent client identification on insert - continuing with new data");
                }
                var1_1.setParam("terminalIPA", this.address);
                this.curInsertCommand = var1_1;
                var4_6 = var1_1.getParam("tokenSeq");
                if (var4_6 != null) {
                    this.tokenSeq = Integer.parseInt(var4_6);
                }
                var1_1.setRawTokenFromToken();
                var5_9 = var1_1.isLegacyClient();
                if (!this.crypto.processInsertReq(var1_1, var5_9)) {
                    return false;
                }
                ** GOTO lbl67
lbl63:
                // 1 sources

                if (!this.checkConsistency(var1_1)) {
                    Log.unexpectedError((String)"Inconsistent client identification on token remove");
                    this.protocolError("inconsistent client identification");
                    return false;
                }
            }
lbl67:
            // 4 sources

            case 1: {
                if (var1_1.is(1)) {
                    if (!this.checkConsistency(var1_1)) {
                        Log.unexpectedError((String)"Inconsistent client identification in smartcard processing");
                        this.protocolError("inconsistent client identification");
                        return false;
                    }
                    if (!this.crypto.collectMessage(var1_1)) {
                        return false;
                    }
                }
                try {
                    if (this.checkSmartCardMsg(var1_1, var2_2)) {
                        Log.debug((String)"Terminal.process: Still processing smartcard");
                        return true;
                    }
                }
                catch (Exception var4_7) {
                    return false;
                }
                var1_1 = this.finishSmartCardProcessing(var1_1);
                if (this.crypto.needsClientKey()) {
                    if (!this.sendKeyRequest()) {
                        Log.unexpectedError((String)"Failed to send request for client key");
                        return false;
                    }
                    return true;
                }
            }
            case 2: {
                if (var1_1.is(2)) {
                    if (!this.checkConsistency(var1_1)) {
                        Log.unexpectedError((String)"Inconsistent client identification in key response processing");
                        this.protocolError("inconsistent client identification");
                        return false;
                    }
                    if (!this.crypto.processKeyRsp(var1_1)) {
                        this.denySession("key validation failed");
                        return false;
                    }
                    var1_1 = this.curInsertCommand;
                }
                if (this.crypto.hasClientKey()) {
                    var1_1.setParam("clientKeyStatus", this.crypto.getClientKeyStatus());
                }
                if (var4_8 = this.insertRemove(var1_1)) {
                    this.startRes = var1_1.getParam("startRes");
                    this.ddcInfo = var1_1.getParam("ddcconfig");
                    this.initState = var1_1.getParam("initState");
                    this.barrierLevel = var1_1.getParam("barrierLevel");
                    if (this.barrierLevel == null) {
                        this.barrierLevel = "0";
                    }
                    this.mtu = (var5_10 = var1_1.getParam("MTU")) != null ? Integer.parseInt(var5_10) : 1500;
                    var5_10 = var1_1.getParam("realIP");
                    this.realIP = null;
                    if (var5_10 != null) {
                        this.realIP = Terminal.HexstrToInet(var5_10);
                    }
                    if (this.realIP == null) {
                        this.realIP = this.ipAddress;
                    }
                    this.useReal = this.realIP.equals(this.ipAddress) != false ? "true" : "false";
                    var1_1.setParam("useReal", this.useReal);
                }
                if (!var1_1.hasParam("doamgh")) {
                    var5_11 = var1_1.getParam("cause");
                    if (var5_11 != null && var5_11.equals("insert")) {
                        var6_12 = var1_1.getParam("forceInsert");
                        if (var6_12 != null && var6_12.equals("true")) {
                            var1_1.setParam("doamgh", "false");
                            if (!var1_1.hasParam("subcause")) {
                                var1_1.setParam("subcause", "utswitch");
                            }
                        } else {
                            var1_1.setParam("doamgh", "true");
                        }
                    } else {
                        var1_1.setParam("doamgh", "false");
                        if (!var1_1.hasParam("subcause")) {
                            var1_1.setParam("subcause", "utswitch");
                        }
                    }
                }
                this.setStoredParams(var1_1.getParams());
                this.clearTokenSet();
                break;
            }
            default: {
                if (this.checkConsistency(var1_1)) break;
                Log.unexpectedError((String)("Inconsistent client identification in " + var1_1.getCommand()));
                this.protocolError("inconsistent client identification");
                return false;
            }
        }
        return this.continueProcess(var1_1, var2_2);
    }

    private boolean continueProcess(ClientCommand clientCommand, Hashtable hashtable) {
        boolean bl = true;
        if (this.ar != null && this.ar.isTerminated()) {
            this.ar = null;
        }
        if (this.ar == null) {
            bl = this.requireNewAR(clientCommand, hashtable);
            return bl;
        }
        bl = this.alreadyHasAR(clientCommand, hashtable);
        return bl;
    }

    private boolean insertRemove(ClientCommand clientCommand) {
        String string = clientCommand.getParam("event");
        if (string == null) {
            return false;
        }
        boolean bl = string.equals("insert");
        String string2 = clientCommand.getRawTokenId();
        Admin admin = Admin.getAdmin();
        if (admin == null) {
            this.lastInsertToken = string2;
            return bl;
        }
        String string3 = Terminal.getTerminalCID(clientCommand);
        if (string3 == null) {
            string3 = "unknown.unknown";
        }
        if (string.equals("insert")) {
            admin.userEvent(string2, string3, "n/a", -1, "insert", System.currentTimeMillis());
        } else if (string.equals("remove")) {
            if (string2.equals("card.0") && this.lastInsertToken != null) {
                string2 = this.lastInsertToken;
            }
            admin.userEvent(string2, string3, "n/a", -1, "remove", System.currentTimeMillis());
            string2 = null;
        } else {
            admin.userEvent(string2, string3, "n/a", -1, "unknown", System.currentTimeMillis());
        }
        this.lastInsertToken = string2;
        return bl;
    }

    private boolean requireNewAR(ClientCommand clientCommand, Hashtable hashtable) {
        Log.debug((String)("In require newAR, this: " + this + " actionPending: " + this.actionPending));
        switch (clientCommand.getCommandType()) {
            case 5: {
                if (this.actionPending) {
                    return true;
                }
                return !this.scDone;
            }
            case 4: {
                return false;
            }
            case 8: 
            case 9: {
                return true;
            }
            case 3: {
                return false;
            }
            case 0: {
                break;
            }
            default: {
                this.protocolError("incorrect state");
                return false;
            }
        }
        if (!this.setupAR(clientCommand)) {
            return false;
        }
        this.addToTokenSet(clientCommand.getParam("type") + "." + clientCommand.getParam("id"));
        if (this.actionPending) {
            this.actionPending = false;
        }
        AuthenticationClient authenticationClient = AuthModule.select(clientCommand.getParams(), this.ar);
        if (clientCommand.hasParam("stealProtected")) {
            this.storedParams.put("stealProtected", clientCommand.getParam("stealProtected"));
        }
        Log.debug((String)("Client = " + authenticationClient));
        if (authenticationClient == null) {
            return this.cleanup(clientCommand);
        }
        this.ar.setClient(authenticationClient);
        if (authenticationClient.getModuleName().startsWith("TerminalId")) {
            this.ar.insertToken = authenticationClient.getLocalName();
            this.clearTokenSet();
            this.addToTokenSet(this.ar.insertToken);
            this.addToTokenSet(authenticationClient.getGlobalName());
        } else {
            this.ar.insertToken = this.lastInsertToken;
            this.addToTokenSet(clientCommand.getParam("type") + "." + clientCommand.getParam("id"));
        }
        this.recordTokenState(clientCommand);
        Log.debug((String)"Terminal.requireNewAR(): calling ar.connReq");
        if (clientCommand.hasParam("savedType")) {
            this.storedParams.put("savedType", clientCommand.getParam("savedType"));
            this.storedParams.put("savedId", clientCommand.getParam("savedId"));
        }
        if (clientCommand.hasParam("altuid")) {
            this.storedParams.put("altuid", clientCommand.getParam("altuid"));
        }
        if (clientCommand.hasParam("altlocale")) {
            this.storedParams.put("altlocale", clientCommand.getParam("altlocale"));
        }
        if (!this.ar.connReq(clientCommand.getParams())) {
            this.protocolError("connReq failed: " + this.address);
            return false;
        }
        return true;
    }

    private boolean alreadyHasAR(ClientCommand clientCommand, Hashtable hashtable) {
        Log.debug((String)"In already hasAR");
        if (this.ar.isTerminated()) {
            if (this.ar != null) {
                Hashtable hashtable2 = (Hashtable)clientCommand.getParams().clone();
                ClientCommand clientCommand2 = new ClientCommand("discReq", hashtable2, false);
                clientCommand2.setParam("cause", "terminated");
                if (!this.ar.message(clientCommand2)) {
                    this.ar = null;
                }
            }
            return false;
        }
        switch (clientCommand.getCommandType()) {
            case 8: {
                this.ar.controlRsp(clientCommand, hashtable);
                break;
            }
            case 3: {
                int n;
                String string = clientCommand.getParam("tokenSeq");
                if (string != null && (n = Integer.parseInt(string)) != this.savedTokenSeq) {
                    return true;
                }
                if (!this.crypto.processConnRsp(clientCommand)) {
                    this.denySession("Signature validation failed");
                    return false;
                }
                return this.ar.connRsp(clientCommand);
            }
            case 5: {
                break;
            }
            case 0: {
                if (this.ar.message(clientCommand)) break;
                this.ar = null;
                break;
            }
            case 4: {
                if (!this.ar.message(clientCommand)) {
                    this.ar = null;
                }
                return false;
            }
            default: {
                this.protocolError("invalid message: " + clientCommand);
                return false;
            }
        }
        return true;
    }

    private boolean setupAR(ClientCommand clientCommand) {
        Log.debug((String)"In setupAR");
        this.model = clientCommand.getParam("hw");
        this.sn = clientCommand.getParam("sn");
        this.namespace = clientCommand.getParam("namespace");
        this.firstServer = clientCommand.getParam("firstServer");
        String string = clientCommand.getParam("fw");
        String string2 = clientCommand.getParam("sw");
        String string3 = this.getTerminalCID();
        if (string3 == null) {
            this.protocolError("terminal must supply unique namespace.sn params");
            return false;
        }
        clientCommand.setParam("terminalCID", string3);
        this.resetAliveCheck();
        try {
            this.ar = new AuthRecord(this, string3, string, string2, this.address, this.mutex, this.crypto);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)(this.address + "Handleclient, AuthRecord: " + exception));
            exception.printStackTrace();
            this.close();
            return false;
        }
        return true;
    }

    private boolean cleanup(ClientCommand clientCommand) {
        String string = clientCommand.getParam("event");
        if (!clientCommand.is(0) || string == null || !string.equals("insert")) {
            this.ar.destroy();
            this.ar = null;
            return true;
        }
        String string2 = "unclaimed token from: " + this.address + " sent: " + clientCommand.getParams();
        this.protocolError(string2);
        return false;
    }

    private void recordTokenState(ClientCommand clientCommand) {
        if (clientCommand.is(0)) {
            String string = clientCommand.getParam("event");
            if (string.equals("insert")) {
                this.ar.setTokenState(true);
            } else {
                this.ar.setTokenState(false);
            }
        }
    }

    private boolean checkConsistency(ClientCommand clientCommand) {
        if (clientCommand.isConsistentWith(this.curInsertCommand)) {
            return true;
        }
        Log.notice((String)("Inconsistent ALP command. Found: [" + clientCommand + "], last insert: [" + this.curInsertCommand + "]"));
        return false;
    }

    boolean sendKeyRequest() {
        Hashtable hashtable = new Hashtable();
        if (!this.crypto.fillKeyRequest(hashtable)) {
            return false;
        }
        this.addTokenSeq(hashtable, true);
        this.crypto.keyInfSent(hashtable);
        return this.write("keyInf", hashtable);
    }

    private boolean checkSmartCardMsg(ClientCommand clientCommand, Hashtable hashtable) throws Exception {
        if (clientCommand.is(0)) {
            String string = clientCommand.getParam("event");
            if (string.equals("insert")) {
                if (this.scId == null) {
                    this.createSmartCardID(this, Configuration.scConfigData, Configuration.terminalTokens);
                }
                this.scDone = this.processSmartCardMessage(clientCommand, hashtable);
            }
            if (string.equals("remove")) {
                boolean bl = true;
                if (this.scId != null) {
                    bl = this.processSmartCardMessage(clientCommand, hashtable);
                }
                this.scDone = bl;
            }
        } else if (clientCommand.is(1)) {
            if (this.scId == null) {
                Log.unexpectedError((String)"Terminal.checkSmartCardMsg:(1): SmartCardID is null");
                this.scDone = false;
                throw new Exception("Unexpected infoSmartCard message");
            }
            this.scDone = this.processSmartCardMessage(clientCommand, hashtable);
        }
        return !this.scDone;
    }

    private ClientCommand finishSmartCardProcessing(ClientCommand clientCommand) {
        ClientCommand clientCommand2 = clientCommand;
        if (this.scId != null) {
            if (clientCommand.is(1)) {
                clientCommand2 = this.curInsertCommand;
            } else {
                String string = clientCommand.getParam("event");
                if (string.equals("remove")) {
                    this.scId = null;
                }
            }
            clientCommand2.setRawTokenFromToken();
            Log.debug((String)"Terminal.process: Done processing smartcard");
        } else {
            Log.debug((String)"Terminal.process: No smartcard processing done.");
        }
        return clientCommand2;
    }

    private void createSmartCardID(Terminal terminal, Vector vector, Vector vector2) throws Exception {
        try {
            this.scId = new SmartCardID(terminal, vector, vector2, this.getUniqueTag());
            Log.debug((String)("Terminal.createSmartCardID(): SmartCard object created: " + this.scId));
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("Terminal.createSmartCardID(): new SmartCardId() failed " + exception));
            throw exception;
        }
    }

    void setInsertParam(String string, String string2) {
        this.curInsertCommand.setParam(string, string2);
    }

    private void startSmartCardIDTimer() {
        if (this.scId != null) {
            this.scId.tick();
        }
    }

    private boolean processSmartCardMessage(ClientCommand clientCommand, Hashtable hashtable) throws SmartCardIDException {
        Log.debug((String)"Terminal.processSmartCardMessage(): process smartcard");
        try {
            this.scDone = this.scId.process(clientCommand.getCommand(), clientCommand.mergeParams(hashtable));
            Log.debug((String)("Terminal.processSmartCardMessage: SmartCard.process() returns : " + this.scDone));
        }
        catch (SmartCardIDException smartCardIDException) {
            Log.unexpectedError((String)("Cannot obtain SmartCard ID: " + smartCardIDException.getMessage()));
            this.scId = null;
            this.scDone = false;
            throw smartCardIDException;
        }
        return this.scDone;
    }

    public synchronized String getUniqueTag() {
        return this.msgTag + ":" + Integer.toHexString(this.tagCtr++);
    }

    public void addToTokenSet(String string) {
        if (this.tokenSet == null || this.tokenSet.length() == 0) {
            this.tokenSet = new StringBuffer(string);
        } else if (this.tokenSet.toString().indexOf(string) == -1) {
            this.tokenSet.append("," + string);
        }
    }

    public String getTokenSet() {
        return this.tokenSet.toString();
    }

    public void clearTokenSet() {
        this.tokenSet = new StringBuffer("");
    }

    public int getMTU() {
        return this.mtu;
    }
}

