/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.AuthModule;
import auth.utauthd.CallBack;
import auth.utauthd.Configuration;
import auth.utauthd.Crypto;
import auth.utauthd.DeviceManager;
import auth.utauthd.GroupManager;
import auth.utauthd.SmartCardConfigData;
import auth.utauthd.Terminal;
import auth.utauthd.WatchIO;
import auth.utauthd.WatchIOListener;
import auth.utauthd.WatchIORequest;
import auth.utauthd.Worker;
import java.io.IOException;
import java.net.ServerSocket;

class utauthd
implements WatchIOListener {
    private ServerSocket ss;
    private static int tagCtr = 0;
    private static utauthd server;
    private static long startTime;
    public static boolean attachInProgress;

    public static void main(String[] stringArray) {
        Configuration.options(stringArray);
        if (!SmartCardConfigData.init(Configuration.scConfigData, Configuration.smartcardConfigSource)) {
            Configuration.scConfigData.clear();
            Log.notice((String)"Server side smartcard identification disabled");
        }
        if (!AuthModule.loadAllModules(Configuration.modules)) {
            Log.configError((String)"Invalid configuration. Exiting");
            System.exit(1);
        }
        Worker.init();
        CallBack.init(Configuration.cbport);
        Crypto.init();
        if (Configuration.waitFlag) {
            CallBack.waitForDebugger();
        }
        GroupManager.init();
        DeviceManager.init(null);
        startTime = System.currentTimeMillis();
        server = new utauthd(Configuration.port);
    }

    public static long startTime() {
        return startTime;
    }

    private utauthd(int n) {
        try {
            this.ss = new ServerSocket(Configuration.port);
        }
        catch (IOException iOException) {
            Log.unexpectedError((String)("Cannot open socket: " + iOException));
            return;
        }
        WatchIO.add(new WatchIORequest(this.ss, 1, this, false, "ss"));
    }

    public boolean watchIOEvent(short s, Object object) {
        Log.debug((String)("utauthd.watchIOEvent revent=x" + Integer.toHexString(s)));
        try {
            new Terminal(this.ss.accept(), utauthd.getUniqueTag());
        }
        catch (IOException iOException) {
            Log.unexpectedError((String)("utauthd.watchIOEvent: " + iOException));
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("utauthd.watchIOEvent: " + exception));
        }
        return true;
    }

    private static synchronized String getUniqueTag() {
        return Integer.toHexString(tagCtr++);
    }

    static {
        startTime = 0L;
        attachInProgress = false;
    }
}

