/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm;

import com.sun.ut.vdm.ChangePasswordDialog;
import com.sun.ut.vdm.DesktopPicker;
import com.sun.ut.vdm.Dialog;
import com.sun.ut.vdm.I18N;
import com.sun.ut.vdm.LoginDialog;
import com.sun.ut.vdm.Settings;
import com.sun.ut.vdm.StatusWindow;
import com.sun.ut.vdm.VdmClient;
import com.sun.ut.vdm.api.Desktop;
import com.sun.ut.vdm.util.Utils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Background
extends JFrame {
    static final Color BG_COLOR = new Color(53, 85, 107);
    static final String IMAGE_FILE = "/oracle_logo.png";
    private VdmClient vdmclient;
    private Settings settings;
    private Dialog currentWindow;
    private JPanel mainDialog;
    private JPanel uiPanels;
    private LoginDialog loginDialog;
    private ChangePasswordDialog changePasswordDialog;
    private DesktopPicker desktopPicker;
    private StatusWindow statusWindow;

    public Background(VdmClient vdmclient, Settings settings) {
        this.vdmclient = vdmclient;
        this.settings = settings;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.setDefaultCloseOperation(3);
        this.setUndecorated(true);
        this.setResizable(false);
        final Dimension d = toolkit.getScreenSize();
        this.setLocationRelativeTo(null);
        this.setSize(d);
        this.setBounds(0, 0, d.width, d.height);
        JPanel backpanel = new JPanel(){

            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(143, 158, 170), 0.0f, d.height, new Color(95, 108, 120), false));
                g2d.fill(new Rectangle(d));
            }
        };
        backpanel.setOpaque(false);
        this.mainDialog = new JPanel(new BorderLayout());
        this.mainDialog.setBorder(new SoftBevelBorder(0));
        this.mainDialog.setSize(520, 410);
        Utils.centerFirstMonitor(this.mainDialog);
        this.uiPanels = this.createPanels();
        this.mainDialog.add((Component)this.uiPanels, "Center");
        backpanel.add(this.mainDialog);
        this.mainDialog.setVisible(false);
        this.setContentPane(backpanel);
        this.getContentPane().setLayout(null);
        ImageIcon icon = new ImageIcon(Utils.load(IMAGE_FILE));
        JLabel imageLabel = new JLabel(icon);
        imageLabel.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.getContentPane().add(imageLabel);
        this.enableEvents(4L);
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.enableEvents(131072L);
    }

    private JPanel createPanels() {
        JPanel p = new JPanel(new CardLayout());
        this.loginDialog = new LoginDialog(this.settings.username, this.settings.password, this.settings.domains, this.settings.domain, this.vdmclient);
        this.changePasswordDialog = new ChangePasswordDialog(this.vdmclient);
        this.desktopPicker = new DesktopPicker(this.vdmclient, new LinkedList<Desktop>(), 180);
        p.add((Component)this.loginDialog, "login");
        p.add((Component)this.changePasswordDialog, "change");
        p.add((Component)this.desktopPicker, "picker");
        return p;
    }

    private void showMainDialog() {
        if (!this.mainDialog.isVisible()) {
            this.mainDialog.setVisible(true);
            this.toFront();
        }
    }

    protected void showLoginDialog(String username, String password, List<String> domains, String domain) {
        CardLayout cl = (CardLayout)this.uiPanels.getLayout();
        cl.show(this.uiPanels, "login");
        this.currentWindow = this.loginDialog;
        this.showMainDialog();
        this.loginDialog.update(username, password, domains, domain);
    }

    protected void showChangePasswordDialog(String username) {
        CardLayout cl = (CardLayout)this.uiPanels.getLayout();
        cl.show(this.uiPanels, "change");
        this.currentWindow = this.changePasswordDialog;
        this.showMainDialog();
        this.changePasswordDialog.setUsername(username);
    }

    protected void showDesktopPicker(String msg, List<Desktop> desktops, int timeout) {
        CardLayout cl = (CardLayout)this.uiPanels.getLayout();
        cl.show(this.uiPanels, "picker");
        this.currentWindow = this.desktopPicker;
        this.showMainDialog();
        this.desktopPicker.update(msg, desktops, timeout);
    }

    protected boolean showDisclaimer(String message) {
        boolean result = true;
        this.statusWindow.setVisible(false);
        Object[] options = new Object[]{I18N.get("ACCEPT"), I18N.get("LOGOUT")};
        int resp = Utils.showWordWrappedOptionDialog(null, message, I18N.get("DISCLAIMER"), -1, 1, null, options, options[0], 80);
        if (resp != 0) {
            result = false;
        }
        this.statusWindow.setVisible(true);
        return result;
    }

    protected void disableChangePasswordOk() {
        this.changePasswordDialog.disableOk();
    }

    public void setWaitDialog(URL imgPath, String message) {
        this.statusWindow = new StatusWindow(imgPath, message);
        this.statusWindow.setVisible(true);
    }

    public void closeWaitDialog() {
        if (this.statusWindow != null) {
            this.statusWindow.setVisible(false);
        }
    }

    public void showError(String mesg) {
        if (this.currentWindow != null) {
            this.currentWindow.showError(mesg);
        } else {
            Utils.showWordWrappedMessageDialog(null, mesg, I18N.get("ERROR"), 0, 80);
        }
    }

    public void clearText() {
        if (this.currentWindow != null) {
            this.currentWindow.clearText();
        }
    }
}

