/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm;

import com.sun.ut.vdm.I18N;
import com.sun.ut.vdm.api.ClientException;
import com.sun.ut.vdm.util.Utils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

class Settings {
    public String username = "";
    public String password = "";
    public String server = "";
    public int port = 443;
    public String protocol = "https";
    public int timeOut = 180;
    public String uttsc = "/opt/SUNWuttsc/bin/uttsc";
    public String domain = "";
    public List<String> domains = new LinkedList<String>();
    public List<String> uttscArgs = new LinkedList<String>();
    public URL url = null;
    public String token = null;
    public boolean autoPickDesktop = true;

    public Settings(String[] args) throws ClientException {
        int i;
        boolean portSet = false;
        for (i = 0; i < args.length; ++i) {
            if ("-http".equals(args[i])) {
                this.protocol = "http";
                continue;
            }
            if ("-https".equals(args[i])) {
                this.protocol = "https";
                continue;
            }
            if ("-no-auto-login".equals(args[i])) {
                this.autoPickDesktop = false;
                continue;
            }
            if ("-w".equals(args[i])) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                    String s = reader.readLine();
                    if (s == null || s.equals("")) {
                        throw new ClientException("Error reading in password");
                    }
                    this.password = s;
                    reader.close();
                    continue;
                }
                catch (Exception e) {
                    throw new ClientException("Error reading in password");
                }
            }
            if ("--".equals(args[i])) {
                ++i;
                break;
            }
            if (i >= args.length - 1) continue;
            if ("-s".equals(args[i])) {
                String name = args[++i];
                String ip = null;
                try {
                    InetAddress addr = InetAddress.getByName(name);
                    ip = addr.getHostAddress();
                }
                catch (Exception e) {
                    ip = name;
                }
                this.server = ip;
                continue;
            }
            if ("-m".equals(args[i])) {
                this.username = args[++i];
                continue;
            }
            if ("-d".equals(args[i])) {
                this.domain = args[++i];
                continue;
            }
            if ("-uttsc".equals(args[i])) {
                this.uttsc = args[++i];
                continue;
            }
            if ("-t".equals(args[i])) {
                try {
                    this.timeOut = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ClientException(I18N.get("INVALID_TIMEOUT") + args[i]);
                }
            }
            if (!"-p".equals(args[i])) continue;
            try {
                this.port = Integer.parseInt(args[++i]);
                portSet = true;
                continue;
            }
            catch (NumberFormatException e) {
                throw new ClientException(I18N.get("INVALID_PORT_NUMBER") + args[i]);
            }
        }
        while (i < args.length) {
            this.uttscArgs.add(args[i]);
            ++i;
        }
        if (!portSet) {
            if ("http".equals(this.protocol)) {
                this.port = 80;
            } else if ("https".equals(this.protocol)) {
                this.port = 443;
            }
        }
        if (!Utils.empty(Utils.getEnv("SUN_SUNRAY_TOKEN"))) {
            this.token = Utils.getEnv("SUN_SUNRAY_TOKEN");
        }
        if (Utils.empty(this.server)) {
            throw new ClientException(I18N.get("NO_VDM_SERVER_CONFIGURED"));
        }
        try {
            this.url = new URL(this.protocol, this.server, this.port, "/");
        }
        catch (MalformedURLException e) {
            throw new ClientException(I18N.get("INVALID_URL") + e.getMessage());
        }
    }
}

