/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm.api;

import com.sun.ut.vdm.util.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationResponse {
    private AuthType type;
    private AuthResult result;
    private String errorCode;
    private String errorMessage;
    private String userMessage;
    public static final String ERROR = "error";
    public static final String DISCLAIMER = "text";
    public static final String DOMAIN = "domain";
    private Map<String, List<String>> params = new HashMap<String, List<String>>();

    public AuthenticationResponse(AuthType type, AuthResult result, Map<String, List<String>> params) {
        this.type = type;
        this.result = result;
        this.params = params;
    }

    public AuthenticationResponse(AuthType type, AuthResult result) {
        this.type = type;
        this.result = result;
    }

    public AuthenticationResponse(AuthResult result, String errorCode, String errorMessage, String userMessage) {
        this.result = result;
        this.type = AuthType.NONE;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.userMessage = userMessage;
    }

    public AuthResult getResult() {
        return this.result;
    }

    public AuthType getType() {
        return this.type;
    }

    public List<String> getParam(String key) {
        List<String> l = this.params.get(key);
        if (l != null) {
            return l;
        }
        return new LinkedList<String>();
    }

    public String getErrorMessage() {
        if (!Utils.empty(this.userMessage)) {
            return this.userMessage;
        }
        if (!Utils.empty(this.errorMessage)) {
            return this.errorMessage;
        }
        return this.errorCode;
    }

    public void addParam(String key, String value) {
        List<String> vals = this.params.get(key);
        if (vals == null) {
            vals = new LinkedList<String>();
            this.params.put(key, vals);
        }
        vals.add(value);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Authentication response: '");
        s.append((Object)this.type);
        s.append("' result: ");
        s.append((Object)this.result);
        for (String k : this.params.keySet()) {
            s.append("\r\n");
            s.append("\t");
            s.append(k);
            s.append(" -> ");
            s.append(Utils.join((Collection<String>)this.params.get(k), ", "));
        }
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthResult {
        NO_RESULT,
        DONE,
        PARTIAL,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthType {
        NONE,
        DISCLAIMER,
        WINDOWS_PASSWORD,
        WINDOWS_PASSWORD_EXPIRED;

    }
}

