/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm.api;

import com.sun.ut.vdm.I18N;
import com.sun.ut.vdm.api.AuthenticationResponse;
import com.sun.ut.vdm.api.ClientException;
import com.sun.ut.vdm.api.Desktop;
import com.sun.ut.vdm.api.DesktopConnection;
import com.sun.ut.vdm.api.Tunnel;
import com.sun.ut.vdm.api.VDMException;
import com.sun.ut.vdm.api.Xml;
import com.sun.ut.vdm.util.Utils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VdmAPI {
    public static final String RDP = "RDP";
    public static final String DISCLAIMER = "disclaimer";
    public static final String WINDOWS_PASSWORD = "windows-password";
    public static final String WINDOWS_PASSWORD_EXPIRED = "windows-password-expired";
    public static final String ERR_CODE_NOT_AUTHENTICATED = "NOT_AUTHENTICATED";
    private static final String WINDOWS_USERNAME_ILLEGAL_CHARS = "/\\[]:;|=+*?<>@";
    private static final char WINDOWS_USERNAME_REPLACEMENT_CHARS = '_';
    private static final String API_VERSION = "2.1";
    private static final String API_PATH = "/broker/xml";
    private String cookie;
    private URL url;
    private static boolean DEBUG = false;
    private static final String GET_CONFIGURATION = "<get-configuration/>";
    private static final String ACCEPT_DISCLAIMER = "<do-submit-authentication><screen><name>disclaimer</name><params><param><name>accept</name><values><value>true</value></values></param></params></screen></do-submit-authentication>";
    private static final String DO_SUBMIT_AUTHENTICATION = "<do-submit-authentication><screen><name>windows-password</name><params><param><name>username</name><values><value>%s</value></values></param><param><name>password</name><values><value xml:space=\"preserve\">%s</value></values></param><param><name>domain</name><values><value>%s</value></values></param></params></screen></do-submit-authentication>";
    private static final String DO_SUBMIT_NEW_PASSWORD = "<do-submit-authentication><screen><name>windows-password-expired</name><params><param><name>oldPassword</name><values><value>%s</value></values></param><param><name>newPassword1</name><values><value>%s</value></values></param><param><name>newPassword2</name><values><value>%s</value></values></param></params></screen></do-submit-authentication>";
    private static final String GET_DESKTOPS = "<get-desktops/><get-tunnel-connection/>";
    private static final String GET_DESKTOP_CONNECTION = "<get-desktop-connection><desktop-id>%s</desktop-id></get-desktop-connection>";
    private static final String LOGOUT = "<do-logout/>";
    private static final String SET_LOCALE = "<set-locale><locale>%s</locale></set-locale>";
    private static final String BROKER_REQUEST_XML = "<?xml version=\"1.0\"?><broker version=\"2.1\">%s</broker>";

    public VdmAPI(URL url) throws ClientException {
        try {
            this.url = new URL(url.toString() + API_PATH);
        }
        catch (MalformedURLException e) {
            throw new ClientException(I18N.get("INVALID_URL") + e.getMessage());
        }
    }

    public AuthenticationResponse getAuthConfiguration() throws ClientException, VDMException {
        return Xml.toAuthResponse(this.makeXMLRequest(GET_CONFIGURATION));
    }

    public AuthenticationResponse submitDisclaimer() throws ClientException, VDMException {
        return Xml.toAuthResponse(this.makeXMLRequest(ACCEPT_DISCLAIMER));
    }

    public AuthenticationResponse doSubmitWindowsAuth(String username, String password, String domain) throws ClientException, VDMException {
        return Xml.toAuthResponse(this.makeXMLRequest(String.format(DO_SUBMIT_AUTHENTICATION, Utils.xmlEscape(VdmAPI.replaceUsernameChars(username)), Utils.xmlEscape(password), Utils.xmlEscape(domain))));
    }

    public AuthenticationResponse doSubmitNewPassword(String password, String newPass1, String newPass2) throws ClientException, VDMException {
        return Xml.toAuthResponse(this.makeXMLRequest(String.format(DO_SUBMIT_NEW_PASSWORD, Utils.xmlEscape(password), Utils.xmlEscape(newPass1), Utils.xmlEscape(newPass2))));
    }

    public List<Desktop> getDesktopList() throws ClientException, VDMException {
        Document resp = this.makeXMLRequest(GET_DESKTOPS);
        Tunnel tunnel = Xml.toTunnel(resp);
        if (!tunnel.bypass) {
            throw new ClientException(I18N.get("CONNECTION_TUNNELING_UNSUPPORTED"));
        }
        return Xml.toDesktops(resp);
    }

    public DesktopConnection getDesktopConnection(Desktop desktop) throws ClientException, VDMException {
        return Xml.toDesktopConnection(this.makeXMLRequest(String.format(GET_DESKTOP_CONNECTION, Utils.xmlEscape(desktop.id))));
    }

    public void logout() throws ClientException, VDMException {
        this.makeXMLRequest(LOGOUT);
    }

    public void setLocale(String code) throws ClientException, VDMException {
        this.makeXMLRequest(String.format(SET_LOCALE, code));
    }

    public static String wrap(String s) {
        return String.format(BROKER_REQUEST_XML, s);
    }

    private Document makeXMLRequest(String content) throws ClientException, VDMException {
        String result;
        String xml = VdmAPI.wrap(content);
        String resp = this.makePOSTRequest(xml);
        resp = VdmAPI.fixXML(resp);
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(resp)));
            result = Utils.XPathEvaluateStr(Xml.getXPath(), doc, "//result");
        }
        catch (Exception e) {
            throw new ClientException(I18N.get("ERROR_PARSING_RESPONSE") + e.getMessage());
        }
        if ("error".equals(result)) {
            throw new VDMException(Utils.getElementText(doc, "error-code"), Utils.getElementText(doc, "error-message"), Utils.getElementText(doc, "user-message"));
        }
        if ("notexecuted".equals(result)) {
            throw new ClientException(I18N.get("COMMAND_NOT_EXECUTED") + content);
        }
        return doc;
    }

    private String makePOSTRequest(String data) throws ClientException {
        HttpURLConnection conn = null;
        String resp = "";
        try {
            if (this.url.getProtocol().equalsIgnoreCase("https")) {
                HttpsURLConnection httpscon = (HttpsURLConnection)this.url.openConnection();
                httpscon.setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                conn = httpscon;
            } else {
                conn = (HttpURLConnection)this.url.openConnection();
            }
            conn.setRequestProperty("Accept", "text/xml");
            conn.setRequestProperty("Content-type", "text/xml");
            if (!Utils.empty(this.cookie)) {
                conn.setRequestProperty("Cookie", this.cookie);
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (DEBUG) {
                System.out.println("|" + data + "|");
            }
            out.writeBytes(data);
            out.flush();
            out.close();
            if (conn.getResponseCode() == 307) {
                this.url = new URL(conn.getHeaderField("Location"));
                return this.makePOSTRequest(data);
            }
            List<String> cookies = conn.getHeaderFields().get("Set-Cookie");
            if (cookies != null) {
                for (String value : cookies) {
                    if (this.cookie == null) {
                        this.cookie = value;
                        continue;
                    }
                    this.cookie = this.cookie + ";" + value;
                }
            }
            BufferedReader pStdout = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = pStdout.readLine();
            while (line != null) {
                resp = resp + line;
                if (DEBUG && !Utils.empty(line.trim())) {
                    System.out.println(line.trim());
                }
                line = pStdout.readLine();
            }
        }
        catch (IOException e) {
            String message = I18N.get("ERROR_CONNECTING_TO_VDM") + e.toString();
            if (conn != null) {
                try {
                    message = message + ": " + conn.getResponseCode();
                    message = message + ": " + conn.getResponseMessage();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            throw new ClientException(message);
        }
        return resp;
    }

    public static String fixXML(String xml) {
        StringBuilder result = new StringBuilder();
        int pos = 0;
        int amp = 0;
        while ((amp = xml.indexOf(38, pos)) > -1) {
            result.append(xml.substring(pos, amp));
            if (xml.regionMatches(amp, "&amp;", 0, "&amp;".length()) | xml.regionMatches(amp, "&gt;", 0, "&gt;".length()) | xml.regionMatches(amp, "&lt;", 0, "&lt;".length())) {
                result.append('&');
            } else {
                result.append("&amp;");
            }
            pos = amp + 1;
        }
        result.append(xml.substring(pos));
        return result.toString();
    }

    public static String replaceUsernameChars(String s) {
        for (char c : WINDOWS_USERNAME_ILLEGAL_CHARS.toCharArray()) {
            s = s.replace(c, '_');
        }
        return s;
    }
}

