/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm.api;

import com.sun.ut.vdm.I18N;
import com.sun.ut.vdm.api.AuthenticationResponse;
import com.sun.ut.vdm.api.ClientException;
import com.sun.ut.vdm.api.Desktop;
import com.sun.ut.vdm.api.DesktopConnection;
import com.sun.ut.vdm.api.Tunnel;
import com.sun.ut.vdm.util.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Xml {
    private static XPathFactory factory = XPathFactory.newInstance();
    private static XPath xpath = factory.newXPath();

    Xml() {
    }

    public static AuthenticationResponse toAuthResponse(Document doc) throws ClientException {
        try {
            AuthenticationResponse.AuthType type;
            String authType;
            AuthenticationResponse.AuthResult result = AuthenticationResponse.AuthResult.NO_RESULT;
            if (Utils.toList(Utils.XPathEvaluateSet(xpath, doc, "/broker/configuration")).size() == 0) {
                String res = Utils.XPathEvaluateStr(xpath, doc, "/broker/submit-authentication/result");
                if ("ok".equals(res)) {
                    result = AuthenticationResponse.AuthResult.DONE;
                } else {
                    if ("error".equals(res)) {
                        result = AuthenticationResponse.AuthResult.FAILED;
                        String errorCode = Utils.XPathEvaluateStr(xpath, doc, "/broker/submit-authentication/error-code");
                        String errorMessage = Utils.XPathEvaluateStr(xpath, doc, "/broker/submit-authentication/error-message");
                        String userMessage = Utils.XPathEvaluateStr(xpath, doc, "/broker/submit-authentication/user-message");
                        return new AuthenticationResponse(result, errorCode, errorMessage, userMessage);
                    }
                    if ("partial".equals(res)) {
                        result = AuthenticationResponse.AuthResult.PARTIAL;
                    } else {
                        throw new ClientException(I18N.get("ERROR_PARSING_AUTH_RESULT") + res);
                    }
                }
            }
            if ("disclaimer".equals(authType = Utils.XPathEvaluateStr(xpath, doc, "//screen/name"))) {
                type = AuthenticationResponse.AuthType.DISCLAIMER;
            } else if ("windows-password".equals(authType)) {
                type = AuthenticationResponse.AuthType.WINDOWS_PASSWORD;
            } else if ("windows-password-expired".equals(authType)) {
                type = AuthenticationResponse.AuthType.WINDOWS_PASSWORD_EXPIRED;
            } else if (Utils.empty(authType)) {
                type = AuthenticationResponse.AuthType.NONE;
            } else {
                throw new ClientException(I18N.get("UNSUPPORTED_AUTH_TYPE") + authType);
            }
            AuthenticationResponse authResp = new AuthenticationResponse(type, result);
            NodeList paramNodes = Utils.XPathEvaluateSet(xpath, doc, "//screen/params/param");
            for (Node param : Utils.toList(paramNodes)) {
                String paramName = Utils.XpathEvaluateStr(xpath, param, "name");
                NodeList valueNodes = Utils.XPathEvaluateSet(xpath, param, "values/value");
                for (Node value : Utils.toList(valueNodes)) {
                    authResp.addParam(paramName, value.getTextContent().trim());
                }
            }
            return authResp;
        }
        catch (XPathExpressionException e) {
            throw new ClientException(I18N.get("ERROR_PARSING_RESPONSE") + e.getMessage());
        }
    }

    public static List<Desktop> toDesktops(Document doc) throws ClientException {
        try {
            LinkedList<Desktop> desktops = new LinkedList<Desktop>();
            for (Node n : Utils.toList(Utils.XPathEvaluateSet(xpath, doc, "//desktop"))) {
                Desktop desktop = new Desktop();
                desktops.add(desktop);
                desktop.id = Utils.getElementText(n, "id");
                desktop.name = Utils.getElementText(n, "name");
                desktop.sessionId = Utils.getElementText(n, "session-id");
                String type = Utils.getElementText(n, "type");
                if ("free".equals(type)) {
                    desktop.type = 0;
                } else if ("auto".equals(type)) {
                    desktop.type = 1;
                } else if ("sticky".equals(type)) {
                    desktop.type = 2;
                }
                desktop.session = 0;
                String state = Utils.getElementText(n, "state");
                if ("disconnected".equals(state)) {
                    desktop.session = 1;
                } else if ("connected".equals(state)) {
                    desktop.session = 2;
                }
                desktop.resetAllowed = Utils.toBool(Utils.getElementText(n, "reset-allowed"));
                desktop.resetAllowedOnSession = Utils.toBool(Utils.getElementText(n, "reset-allowed-on-session"));
            }
            return desktops;
        }
        catch (XPathExpressionException e) {
            throw new ClientException(I18N.get("ERROR_PARSING_RESPONSE") + e.getMessage());
        }
    }

    public static DesktopConnection toDesktopConnection(Document doc) {
        Node n = Utils.getElement(doc, "desktop-connection");
        if (n == null) {
            return null;
        }
        DesktopConnection desktop = new DesktopConnection();
        desktop.id = Utils.getElementText(n, "id");
        desktop.address = Utils.getElementText(n, "address");
        desktop.port = Utils.toInt(Utils.getElementText(n, "port"));
        desktop.protocol = Utils.getElementText(n, "protocol");
        desktop.username = Utils.getElementText(n, "user-name");
        desktop.password = Utils.getElementText(n, "password");
        desktop.domain = Utils.getElementText(n, "domain-name");
        desktop.enableUsb = Utils.toBool(Utils.getElementText(n, "enable-usb"));
        return desktop;
    }

    public static Tunnel toTunnel(Document doc) throws ClientException {
        Node n = Utils.getElement(doc, "tunnel-connection");
        if (n == null) {
            return null;
        }
        Tunnel tunnel = new Tunnel();
        if (Utils.getElement(n, "bypass-tunnel") != null) {
            tunnel.bypass = true;
        } else {
            tunnel.bypass = false;
            tunnel.id = Utils.getElementText(n, "connection-id");
            tunnel.statusPort = Utils.toInt(Utils.getElementText(n, "status-port"));
            tunnel.generation = Utils.toInt(Utils.getElementText(n, "generation"));
            try {
                String server1 = Utils.getElementText(n, "server1");
                String server2 = Utils.getElementText(n, "server2");
                if (!Utils.empty(server1)) {
                    tunnel.server1 = new URL(server1);
                }
                if (!Utils.empty(server2)) {
                    tunnel.server2 = new URL(server2);
                }
            }
            catch (MalformedURLException e) {
                throw new ClientException(I18N.get("ERROR_PARSING_URL_RESPONSE") + e.getMessage());
            }
        }
        return tunnel;
    }

    public static XPath getXPath() {
        return xpath;
    }
}

