/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm.util;

import com.sun.ut.vdm.util.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class TimedLabel
extends JPanel
implements ActionListener {
    public static final int NONE = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    private Timer t;
    private int delay = 15000;
    private boolean useTimer = true;
    private final String[] images = new String[]{"/blank.png", "/info.gif", "/stop.gif", "/stop.gif"};
    private final Icon[] icons = new Icon[this.images.length];
    private JLabel txtlabel;
    private JLabel iconlabel;

    public TimedLabel(JPanel panel, GridBagConstraints c, Insets iconInsets, Insets textInsets) {
        for (int i = 0; i < this.images.length; ++i) {
            this.icons[i] = new ImageIcon(Utils.load(this.images[i]));
        }
        this.txtlabel = new JLabel(" ");
        this.iconlabel = new JLabel(this.icons[0]);
        c.fill = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.anchor = 22;
        c.insets = iconInsets;
        panel.add((Component)this.iconlabel, c);
        c.fill = 1;
        c.gridx = 1;
        c.gridwidth = 0;
        c.anchor = 21;
        c.insets = textInsets;
        panel.add((Component)this.txtlabel, c);
    }

    public TimedLabel() {
        for (int i = 0; i < this.images.length; ++i) {
            this.icons[i] = new ImageIcon(Utils.load(this.images[i]));
        }
        this.txtlabel = new JLabel(" ");
        this.iconlabel = new JLabel(this.icons[0]);
        BoxLayout layout = new BoxLayout(this, 0);
        this.setLayout(layout);
        this.add(this.iconlabel);
        this.add(Box.createRigidArea(new Dimension(10, 1)));
        this.add(this.txtlabel);
    }

    public void clear() {
        if (this.t != null) {
            this.t.stop();
            this.t = null;
        }
        this.txtlabel.setText("   ");
        this.iconlabel.setIcon(this.icons[0]);
    }

    public void setText(String text, int type) {
        this.useTimer = true;
        this._setText(text, type);
    }

    public void setPermanentText(String text, int type) {
        this.useTimer = false;
        this._setText(text, type);
    }

    private void _setText(String text, int type) {
        if (type < 0 || type >= this.icons.length) {
            throw new IllegalArgumentException("Invalid message type");
        }
        text = "<html>" + text + "</html>";
        if (this.t != null) {
            this.t.stop();
        }
        this.txtlabel.setText(text);
        this.iconlabel.setIcon(this.icons[type]);
        if (this.useTimer) {
            this.t = new Timer(this.delay, this);
            this.t.setRepeats(false);
            if (this.isVisible()) {
                this.t.start();
            }
        }
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setVisible(boolean flag) {
        if (this.t != null) {
            if (flag) {
                this.t.start();
            } else {
                this.t.stop();
            }
        }
        super.setVisible(flag);
    }

    public void actionPerformed(ActionEvent e) {
        this.t = null;
        this.clear();
    }
}

