/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ut.vdm;

import com.sun.ut.vdm.Dialog;
import com.sun.ut.vdm.I18N;
import com.sun.ut.vdm.VdmClient;
import com.sun.ut.vdm.api.ClientException;
import com.sun.ut.vdm.api.VDMException;
import com.sun.ut.vdm.util.TimedLabel;
import com.sun.ut.vdm.util.Utils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class ChangePasswordDialog
extends JPanel
implements Dialog,
I18N.LocaleListener {
    VdmClient vdmclient;
    TimedLabel statusLabel;
    private JButton Bcancel;
    private JButton Bok;
    private JPasswordField TFpassword1;
    private JPasswordField TFpassword2;
    private JLabel label1;
    private JLabel label2;
    private JLabel LNewPass1;
    private JLabel LNewPass2;
    private boolean okDisabled = false;

    ChangePasswordDialog(VdmClient vdmclient) {
        super(new GridBagLayout());
        this.vdmclient = vdmclient;
        GridBagConstraints c = new GridBagConstraints();
        JLabel Lbanner = new JLabel();
        Lbanner.setIcon(new ImageIcon(this.getClass().getResource("/aurelia12-banner2.png")));
        Lbanner.setVerticalAlignment(3);
        c.fill = 2;
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        this.add((Component)Lbanner, c);
        JLabel Lvdmlogo = new JLabel();
        Lvdmlogo.setIcon(new ImageIcon(this.getClass().getResource("/aurelia12-vdm_logo.png")));
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.insets = new Insets(10, 20, 10, 0);
        this.add((Component)Lvdmlogo, c);
        Insets labelInsets = new Insets(5, 10, 5, 10);
        Insets fieldInsets = new Insets(5, 20, 5, 100);
        JPanel titlePanel = new JPanel(new GridLayout(2, 1));
        this.label1 = new JLabel(I18N.get("RESET_MSG"));
        this.label2 = new JLabel(I18N.get("RESET_MSG2"));
        titlePanel.add(this.label1);
        titlePanel.add(this.label2);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.insets = labelInsets;
        this.add((Component)titlePanel, c);
        this.LNewPass1 = new JLabel(I18N.get("NEW_PASSWORD"));
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.insets = (Insets)labelInsets.clone();
        c.insets.top = 40;
        this.add((Component)this.LNewPass1, c);
        this.TFpassword1 = new JPasswordField();
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 1;
        c.insets = (Insets)fieldInsets.clone();
        c.insets.top = 40;
        this.add((Component)this.TFpassword1, c);
        this.LNewPass2 = new JLabel(I18N.get("CONFIRM_PASSWORD"));
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.insets = labelInsets;
        this.add((Component)this.LNewPass2, c);
        this.TFpassword2 = new JPasswordField();
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.insets = fieldInsets;
        this.add((Component)this.TFpassword2, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weighty = 1.0;
        this.statusLabel = new TimedLabel(this, c, labelInsets, labelInsets);
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        this.Bok = new JButton(I18N.get("OK"));
        bottomPanel.add(this.Bok);
        this.Bcancel = new JButton(I18N.get("LOGOUT"));
        bottomPanel.add(this.Bcancel);
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.insets = (Insets)labelInsets.clone();
        c.insets.bottom = 10;
        this.add((Component)bottomPanel, c);
        this.initListeners();
        I18N.addLocaleListener(this);
    }

    public void localeChanged() {
        this.label1.setText(I18N.get("RESET_MSG"));
        this.label2.setText(I18N.get("RESET_MSG2"));
        this.LNewPass1.setText(I18N.get("NEW_PASSWORD"));
        this.LNewPass2.setText(I18N.get("CONFIRM_PASSWORD"));
        this.Bok.setText(I18N.get("OK"));
        this.Bcancel.setText(I18N.get("LOGOUT"));
    }

    public String getPassword1() {
        return new String(this.TFpassword1.getPassword());
    }

    public String getPassword2() {
        return new String(this.TFpassword2.getPassword());
    }

    public void setUsername(String username) {
        this.label1.setText(String.format(I18N.get("RESET_MSG"), username));
        this.TFpassword1.requestFocus();
    }

    private void initListeners() {
        this.Bok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.BokActionPerformed(evt);
            }
        });
        this.Bok.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ChangePasswordDialog.this.BokKeyPressed(evt);
            }
        });
        this.Bcancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.BcancelActionPerformed(evt);
            }
        });
        this.Bcancel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ChangePasswordDialog.this.BcancelKeyPressed(evt);
            }
        });
        this.TFpassword2.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ChangePasswordDialog.this.TFpassword2FocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                ChangePasswordDialog.this.TFpassword2FocusLost(evt);
            }
        });
        this.TFpassword2.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ChangePasswordDialog.this.TFpassword2KeyPressed(evt);
            }
        });
        this.TFpassword1.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ChangePasswordDialog.this.TFpassword1FocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                ChangePasswordDialog.this.TFpassword1FocusLost(evt);
            }
        });
        this.TFpassword1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ChangePasswordDialog.this.TFpassword1KeyPressed(evt);
            }
        });
    }

    private void ok() {
        final String pass1 = this.getPassword1();
        final String pass2 = this.getPassword2();
        if (pass1 == null || pass2 == null || !pass1.equals(pass2)) {
            this.showError(I18N.get("PASSWORD_DO_NOT_MATCH"));
        } else {
            this.showText(I18N.get("CONNECTING"));
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ChangePasswordDialog.this.disableForm();
                    Utils.useWaitCursor(ChangePasswordDialog.this);
                    try {
                        ChangePasswordDialog.this.vdmclient.changePassword(pass1, pass2);
                    }
                    catch (ClientException ex) {
                        ChangePasswordDialog.this.showError(ex.getMessage());
                    }
                    catch (VDMException ex) {
                        ChangePasswordDialog.this.showError(ex.getMessage());
                    }
                    catch (Exception ex) {
                        ChangePasswordDialog.this.showError(ex.toString() + ": " + ex.getMessage());
                    }
                    Utils.useDefaultCursor(ChangePasswordDialog.this);
                    ChangePasswordDialog.this.enableForm();
                }
            });
        }
    }

    private void cancel() {
        Utils.logout(this, this.vdmclient);
    }

    public void disableForm() {
        this.Bok.setEnabled(false);
        this.Bcancel.setEnabled(false);
    }

    public void enableForm() {
        if (!this.okDisabled) {
            this.Bok.setEnabled(true);
        }
        this.Bcancel.setEnabled(true);
    }

    public void disableOk() {
        this.Bok.setEnabled(false);
        this.TFpassword1.setEnabled(false);
        this.TFpassword2.setEnabled(false);
        this.okDisabled = true;
    }

    public void showError(String mesg) {
        this.statusLabel.setText(mesg, 3);
        this.TFpassword1.requestFocus();
    }

    public void showText(String mesg) {
        this.statusLabel.setText(mesg, 0);
    }

    public void clearText() {
        this.statusLabel.setText("", 0);
    }

    private void TFpassword2KeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 10) {
            this.ok();
        }
    }

    private void TFpassword1KeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 10) {
            this.TFpassword2.requestFocus();
        }
    }

    private void BokActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void BokKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.ok();
        }
    }

    private void BcancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void BcancelKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 27 || keyCode == 10) {
            this.cancel();
        }
    }

    private void TFpassword1FocusGained(FocusEvent evt) {
        this.TFpassword1.selectAll();
    }

    private void TFpassword1FocusLost(FocusEvent evt) {
        this.TFpassword1.select(0, 0);
    }

    private void TFpassword2FocusGained(FocusEvent evt) {
        this.TFpassword2.selectAll();
    }

    private void TFpassword2FocusLost(FocusEvent evt) {
        this.TFpassword2.select(0, 0);
    }
}

